package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddASMIntegration invokes the arms.AddASMIntegration API synchronously
func (client *Client) AddASMIntegration(request *AddASMIntegrationRequest) (response *AddASMIntegrationResponse, err error) {
	response = CreateAddASMIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// AddASMIntegrationWithChan invokes the arms.AddASMIntegration API asynchronously
func (client *Client) AddASMIntegrationWithChan(request *AddASMIntegrationRequest) (<-chan *AddASMIntegrationResponse, <-chan error) {
	responseChan := make(chan *AddASMIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddASMIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddASMIntegrationWithCallback invokes the arms.AddASMIntegration API asynchronously
func (client *Client) AddASMIntegrationWithCallback(request *AddASMIntegrationRequest, callback func(response *AddASMIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddASMIntegrationResponse
		var err error
		defer close(result)
		response, err = client.AddASMIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddASMIntegrationRequest is the request struct for api AddASMIntegration
type AddASMIntegrationRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// AddASMIntegrationResponse is the response struct for api AddASMIntegration
type AddASMIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	State     bool   `json:"State" xml:"State"`
}

// CreateAddASMIntegrationRequest creates a request to invoke AddASMIntegration API
func CreateAddASMIntegrationRequest() (request *AddASMIntegrationRequest) {
	request = &AddASMIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "AddASMIntegration", "", "")
	request.Method = requests.POST
	return
}

// CreateAddASMIntegrationResponse creates a response to parse from AddASMIntegration response
func CreateAddASMIntegrationResponse() (response *AddASMIntegrationResponse) {
	response = &AddASMIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
