package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateListener invokes the alb.CreateListener API synchronously
func (client *Client) CreateListener(request *CreateListenerRequest) (response *CreateListenerResponse, err error) {
	response = CreateCreateListenerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateListenerWithChan invokes the alb.CreateListener API asynchronously
func (client *Client) CreateListenerWithChan(request *CreateListenerRequest) (<-chan *CreateListenerResponse, <-chan error) {
	responseChan := make(chan *CreateListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateListenerWithCallback invokes the alb.CreateListener API asynchronously
func (client *Client) CreateListenerWithCallback(request *CreateListenerRequest, callback func(response *CreateListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateListenerResponse
		var err error
		defer close(result)
		response, err = client.CreateListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateListenerRequest is the request struct for api CreateListener
type CreateListenerRequest struct {
	*requests.RpcRequest
	ClientToken         string                            `position:"Query" name:"ClientToken"`
	GzipEnabled         requests.Boolean                  `position:"Query" name:"GzipEnabled"`
	QuicConfig          CreateListenerQuicConfig          `position:"Query" name:"QuicConfig"  type:"Struct"`
	Http2Enabled        requests.Boolean                  `position:"Query" name:"Http2Enabled"`
	DefaultActions      *[]CreateListenerDefaultActions   `position:"Query" name:"DefaultActions"  type:"Repeated"`
	ListenerPort        requests.Integer                  `position:"Query" name:"ListenerPort"`
	DryRun              requests.Boolean                  `position:"Query" name:"DryRun"`
	RequestTimeout      requests.Integer                  `position:"Query" name:"RequestTimeout"`
	CaCertificates      *[]CreateListenerCaCertificates   `position:"Query" name:"CaCertificates"  type:"Repeated"`
	XForwardedForConfig CreateListenerXForwardedForConfig `position:"Query" name:"XForwardedForConfig"  type:"Struct"`
	ListenerProtocol    string                            `position:"Query" name:"ListenerProtocol"`
	SecurityPolicyId    string                            `position:"Query" name:"SecurityPolicyId"`
	IdleTimeout         requests.Integer                  `position:"Query" name:"IdleTimeout"`
	LoadBalancerId      string                            `position:"Query" name:"LoadBalancerId"`
	Certificates        *[]CreateListenerCertificates     `position:"Query" name:"Certificates"  type:"Repeated"`
	ListenerDescription string                            `position:"Query" name:"ListenerDescription"`
	CaEnabled           requests.Boolean                  `position:"Query" name:"CaEnabled"`
}

// CreateListenerDefaultActions is a repeated param struct in CreateListenerRequest
type CreateListenerDefaultActions struct {
	ForwardGroupConfig CreateListenerDefaultActionsForwardGroupConfig `name:"ForwardGroupConfig" type:"Struct"`
	Type               string                                         `name:"Type"`
}

// CreateListenerCaCertificates is a repeated param struct in CreateListenerRequest
type CreateListenerCaCertificates struct {
	CertificateId string `name:"CertificateId"`
}

// CreateListenerCertificates is a repeated param struct in CreateListenerRequest
type CreateListenerCertificates struct {
	CertificateId string `name:"CertificateId"`
}

// CreateListenerDefaultActionsForwardGroupConfig is a repeated param struct in CreateListenerRequest
type CreateListenerDefaultActionsForwardGroupConfig struct {
	ServerGroupTuples *[]CreateListenerDefaultActionsForwardGroupConfigServerGroupTuplesItem `name:"ServerGroupTuples" type:"Repeated"`
}

// CreateListenerDefaultActionsForwardGroupConfigServerGroupTuplesItem is a repeated param struct in CreateListenerRequest
type CreateListenerDefaultActionsForwardGroupConfigServerGroupTuplesItem struct {
	ServerGroupId string `name:"ServerGroupId"`
}

// CreateListenerQuicConfig is a repeated param struct in CreateListenerRequest
type CreateListenerQuicConfig struct {
	QuicUpgradeEnabled string `name:"QuicUpgradeEnabled"`
	QuicListenerId     string `name:"QuicListenerId"`
}

// CreateListenerXForwardedForConfig is a repeated param struct in CreateListenerRequest
type CreateListenerXForwardedForConfig struct {
	XForwardedForClientCertSubjectDNAlias      string `name:"XForwardedForClientCertSubjectDNAlias"`
	XForwardedForClientCertIssuerDNEnabled     string `name:"XForwardedForClientCertIssuerDNEnabled"`
	XForwardedForClientCertFingerprintEnabled  string `name:"XForwardedForClientCertFingerprintEnabled"`
	XForwardedForClientCertIssuerDNAlias       string `name:"XForwardedForClientCertIssuerDNAlias"`
	XForwardedForProtoEnabled                  string `name:"XForwardedForProtoEnabled"`
	XForwardedForClientCertFingerprintAlias    string `name:"XForwardedForClientCertFingerprintAlias"`
	XForwardedForClientCertClientVerifyEnabled string `name:"XForwardedForClientCertClientVerifyEnabled"`
	XForwardedForSLBPortEnabled                string `name:"XForwardedForSLBPortEnabled"`
	XForwardedForClientCertSubjectDNEnabled    string `name:"XForwardedForClientCertSubjectDNEnabled"`
	XForwardedForClientCertClientVerifyAlias   string `name:"XForwardedForClientCertClientVerifyAlias"`
	XForwardedForClientSrcPortEnabled          string `name:"XForwardedForClientSrcPortEnabled"`
	XForwardedForEnabled                       string `name:"XForwardedForEnabled"`
	XForwardedForSLBIdEnabled                  string `name:"XForwardedForSLBIdEnabled"`
}

// CreateListenerResponse is the response struct for api CreateListener
type CreateListenerResponse struct {
	*responses.BaseResponse
	JobId      string `json:"JobId" xml:"JobId"`
	ListenerId string `json:"ListenerId" xml:"ListenerId"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateListenerRequest creates a request to invoke CreateListener API
func CreateCreateListenerRequest() (request *CreateListenerRequest) {
	request = &CreateListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "CreateListener", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateListenerResponse creates a response to parse from CreateListener response
func CreateCreateListenerResponse() (response *CreateListenerResponse) {
	response = &CreateListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
