// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/kms/v1/ekm_service.proto

package kmspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// [KeyManagementMode][google.cloud.kms.v1.EkmConnection.KeyManagementMode]
// describes who can perform control plane cryptographic operations using this
// [EkmConnection][google.cloud.kms.v1.EkmConnection].
type EkmConnection_KeyManagementMode int32

const (
	// Not specified.
	EkmConnection_KEY_MANAGEMENT_MODE_UNSPECIFIED EkmConnection_KeyManagementMode = 0
	// EKM-side key management operations on
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] created with this
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] must be initiated from
	// the EKM directly and cannot be performed from Cloud KMS. This means that:
	// * When creating a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] associated with
	// this
	//   [EkmConnection][google.cloud.kms.v1.EkmConnection], the caller must
	//   supply the key path of pre-existing external key material that will be
	//   linked to the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	// * Destruction of external key material cannot be requested via the
	//   Cloud KMS API and must be performed directly in the EKM.
	// * Automatic rotation of key material is not supported.
	EkmConnection_MANUAL EkmConnection_KeyManagementMode = 1
	// All [CryptoKeys][google.cloud.kms.v1.CryptoKey] created with this
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] use EKM-side key
	// management operations initiated from Cloud KMS. This means that:
	// * When a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// associated with this [EkmConnection][google.cloud.kms.v1.EkmConnection]
	// is
	//   created, the EKM automatically generates new key material and a new
	//   key path. The caller cannot supply the key path of pre-existing
	//   external key material.
	// * Destruction of external key material associated with this
	//   [EkmConnection][google.cloud.kms.v1.EkmConnection] can be requested by
	//   calling [DestroyCryptoKeyVersion][EkmService.DestroyCryptoKeyVersion].
	// * Automatic rotation of key material is supported.
	EkmConnection_CLOUD_KMS EkmConnection_KeyManagementMode = 2
)

// Enum value maps for EkmConnection_KeyManagementMode.
var (
	EkmConnection_KeyManagementMode_name = map[int32]string{
		0: "KEY_MANAGEMENT_MODE_UNSPECIFIED",
		1: "MANUAL",
		2: "CLOUD_KMS",
	}
	EkmConnection_KeyManagementMode_value = map[string]int32{
		"KEY_MANAGEMENT_MODE_UNSPECIFIED": 0,
		"MANUAL":                          1,
		"CLOUD_KMS":                       2,
	}
)

func (x EkmConnection_KeyManagementMode) Enum() *EkmConnection_KeyManagementMode {
	p := new(EkmConnection_KeyManagementMode)
	*p = x
	return p
}

func (x EkmConnection_KeyManagementMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EkmConnection_KeyManagementMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_ekm_service_proto_enumTypes[0].Descriptor()
}

func (EkmConnection_KeyManagementMode) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_ekm_service_proto_enumTypes[0]
}

func (x EkmConnection_KeyManagementMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EkmConnection_KeyManagementMode.Descriptor instead.
func (EkmConnection_KeyManagementMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{8, 0}
}

// Request message for
// [EkmService.ListEkmConnections][google.cloud.kms.v1.EkmService.ListEkmConnections].
type ListEkmConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location associated with the
	// [EkmConnections][google.cloud.kms.v1.EkmConnection] to list, in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Optional limit on the number of
	// [EkmConnections][google.cloud.kms.v1.EkmConnection] to include in the
	// response. Further [EkmConnections][google.cloud.kms.v1.EkmConnection] can
	// subsequently be obtained by including the
	// [ListEkmConnectionsResponse.next_page_token][google.cloud.kms.v1.ListEkmConnectionsResponse.next_page_token]
	// in a subsequent request. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Optional pagination token, returned earlier via
	// [ListEkmConnectionsResponse.next_page_token][google.cloud.kms.v1.ListEkmConnectionsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Only include resources that match the filter in the response. For
	// more information, see
	// [Sorting and filtering list
	// results](https://cloud.google.com/kms/docs/sorting-and-filtering).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.  For more information, see
	// [Sorting and filtering list
	// results](https://cloud.google.com/kms/docs/sorting-and-filtering).
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEkmConnectionsRequest) Reset() {
	*x = ListEkmConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEkmConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEkmConnectionsRequest) ProtoMessage() {}

func (x *ListEkmConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEkmConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListEkmConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListEkmConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEkmConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEkmConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEkmConnectionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEkmConnectionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [EkmService.ListEkmConnections][google.cloud.kms.v1.EkmService.ListEkmConnections].
type ListEkmConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of [EkmConnections][google.cloud.kms.v1.EkmConnection].
	EkmConnections []*EkmConnection `protobuf:"bytes,1,rep,name=ekm_connections,json=ekmConnections,proto3" json:"ekm_connections,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListEkmConnectionsRequest.page_token][google.cloud.kms.v1.ListEkmConnectionsRequest.page_token]
	// to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [EkmConnections][google.cloud.kms.v1.EkmConnection]
	// that matched the query.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListEkmConnectionsResponse) Reset() {
	*x = ListEkmConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEkmConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEkmConnectionsResponse) ProtoMessage() {}

func (x *ListEkmConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEkmConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListEkmConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListEkmConnectionsResponse) GetEkmConnections() []*EkmConnection {
	if x != nil {
		return x.EkmConnections
	}
	return nil
}

func (x *ListEkmConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEkmConnectionsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for
// [EkmService.GetEkmConnection][google.cloud.kms.v1.EkmService.GetEkmConnection].
type GetEkmConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [name][google.cloud.kms.v1.EkmConnection.name] of the
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEkmConnectionRequest) Reset() {
	*x = GetEkmConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEkmConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEkmConnectionRequest) ProtoMessage() {}

func (x *GetEkmConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEkmConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetEkmConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetEkmConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [EkmService.CreateEkmConnection][google.cloud.kms.v1.EkmService.CreateEkmConnection].
type CreateEkmConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location associated with the
	// [EkmConnection][google.cloud.kms.v1.EkmConnection], in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a location and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`.
	EkmConnectionId string `protobuf:"bytes,2,opt,name=ekm_connection_id,json=ekmConnectionId,proto3" json:"ekm_connection_id,omitempty"`
	// Required. An [EkmConnection][google.cloud.kms.v1.EkmConnection] with
	// initial field values.
	EkmConnection *EkmConnection `protobuf:"bytes,3,opt,name=ekm_connection,json=ekmConnection,proto3" json:"ekm_connection,omitempty"`
}

func (x *CreateEkmConnectionRequest) Reset() {
	*x = CreateEkmConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEkmConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEkmConnectionRequest) ProtoMessage() {}

func (x *CreateEkmConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEkmConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreateEkmConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateEkmConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEkmConnectionRequest) GetEkmConnectionId() string {
	if x != nil {
		return x.EkmConnectionId
	}
	return ""
}

func (x *CreateEkmConnectionRequest) GetEkmConnection() *EkmConnection {
	if x != nil {
		return x.EkmConnection
	}
	return nil
}

// Request message for
// [EkmService.UpdateEkmConnection][google.cloud.kms.v1.EkmService.UpdateEkmConnection].
type UpdateEkmConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. [EkmConnection][google.cloud.kms.v1.EkmConnection] with updated
	// values.
	EkmConnection *EkmConnection `protobuf:"bytes,1,opt,name=ekm_connection,json=ekmConnection,proto3" json:"ekm_connection,omitempty"`
	// Required. List of fields to be updated in this request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEkmConnectionRequest) Reset() {
	*x = UpdateEkmConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEkmConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEkmConnectionRequest) ProtoMessage() {}

func (x *UpdateEkmConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEkmConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateEkmConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateEkmConnectionRequest) GetEkmConnection() *EkmConnection {
	if x != nil {
		return x.EkmConnection
	}
	return nil
}

func (x *UpdateEkmConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [EkmService.GetEkmConfig][google.cloud.kms.v1.EkmService.GetEkmConfig].
type GetEkmConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [name][google.cloud.kms.v1.EkmConfig.name] of the
	// [EkmConfig][google.cloud.kms.v1.EkmConfig] to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEkmConfigRequest) Reset() {
	*x = GetEkmConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEkmConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEkmConfigRequest) ProtoMessage() {}

func (x *GetEkmConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEkmConfigRequest.ProtoReflect.Descriptor instead.
func (*GetEkmConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetEkmConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [EkmService.UpdateEkmConfig][google.cloud.kms.v1.EkmService.UpdateEkmConfig].
type UpdateEkmConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. [EkmConfig][google.cloud.kms.v1.EkmConfig] with updated values.
	EkmConfig *EkmConfig `protobuf:"bytes,1,opt,name=ekm_config,json=ekmConfig,proto3" json:"ekm_config,omitempty"`
	// Required. List of fields to be updated in this request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEkmConfigRequest) Reset() {
	*x = UpdateEkmConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEkmConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEkmConfigRequest) ProtoMessage() {}

func (x *UpdateEkmConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEkmConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateEkmConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateEkmConfigRequest) GetEkmConfig() *EkmConfig {
	if x != nil {
		return x.EkmConfig
	}
	return nil
}

func (x *UpdateEkmConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A [Certificate][google.cloud.kms.v1.Certificate] represents an X.509
// certificate used to authenticate HTTPS connections to EKM replicas.
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The raw certificate bytes in DER format.
	RawDer []byte `protobuf:"bytes,1,opt,name=raw_der,json=rawDer,proto3" json:"raw_der,omitempty"`
	// Output only. True if the certificate was parsed successfully.
	Parsed bool `protobuf:"varint,2,opt,name=parsed,proto3" json:"parsed,omitempty"`
	// Output only. The issuer distinguished name in RFC 2253 format. Only present
	// if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	Issuer string `protobuf:"bytes,3,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// Output only. The subject distinguished name in RFC 2253 format. Only
	// present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	Subject string `protobuf:"bytes,4,opt,name=subject,proto3" json:"subject,omitempty"`
	// Output only. The subject Alternative DNS names. Only present if
	// [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	SubjectAlternativeDnsNames []string `protobuf:"bytes,5,rep,name=subject_alternative_dns_names,json=subjectAlternativeDnsNames,proto3" json:"subject_alternative_dns_names,omitempty"`
	// Output only. The certificate is not valid before this time. Only present if
	// [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	NotBeforeTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=not_before_time,json=notBeforeTime,proto3" json:"not_before_time,omitempty"`
	// Output only. The certificate is not valid after this time. Only present if
	// [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	NotAfterTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=not_after_time,json=notAfterTime,proto3" json:"not_after_time,omitempty"`
	// Output only. The certificate serial number as a hex string. Only present if
	// [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	SerialNumber string `protobuf:"bytes,8,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	// Output only. The SHA-256 certificate fingerprint as a hex string. Only
	// present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
	Sha256Fingerprint string `protobuf:"bytes,9,opt,name=sha256_fingerprint,json=sha256Fingerprint,proto3" json:"sha256_fingerprint,omitempty"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{7}
}

func (x *Certificate) GetRawDer() []byte {
	if x != nil {
		return x.RawDer
	}
	return nil
}

func (x *Certificate) GetParsed() bool {
	if x != nil {
		return x.Parsed
	}
	return false
}

func (x *Certificate) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *Certificate) GetSubject() string {
	if x != nil {
		return x.Subject
	}
	return ""
}

func (x *Certificate) GetSubjectAlternativeDnsNames() []string {
	if x != nil {
		return x.SubjectAlternativeDnsNames
	}
	return nil
}

func (x *Certificate) GetNotBeforeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NotBeforeTime
	}
	return nil
}

func (x *Certificate) GetNotAfterTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NotAfterTime
	}
	return nil
}

func (x *Certificate) GetSerialNumber() string {
	if x != nil {
		return x.SerialNumber
	}
	return ""
}

func (x *Certificate) GetSha256Fingerprint() string {
	if x != nil {
		return x.Sha256Fingerprint
	}
	return ""
}

// An [EkmConnection][google.cloud.kms.v1.EkmConnection] represents an
// individual EKM connection. It can be used for creating
// [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] with a
// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
// [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], as well as
// performing cryptographic operations using keys created within the
// [EkmConnection][google.cloud.kms.v1.EkmConnection].
type EkmConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for the
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
	// `projects/*/locations/*/ekmConnections/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// A list of
	// [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
	// the EKM can be reached. There should be one ServiceResolver per EKM
	// replica. Currently, only a single
	// [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
	// supported.
	ServiceResolvers []*EkmConnection_ServiceResolver `protobuf:"bytes,3,rep,name=service_resolvers,json=serviceResolvers,proto3" json:"service_resolvers,omitempty"`
	// Optional. Etag of the currently stored
	// [EkmConnection][google.cloud.kms.v1.EkmConnection].
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Describes who can perform control plane operations on the EKM. If
	// unset, this defaults to
	// [MANUAL][google.cloud.kms.v1.EkmConnection.KeyManagementMode.MANUAL].
	KeyManagementMode EkmConnection_KeyManagementMode `protobuf:"varint,6,opt,name=key_management_mode,json=keyManagementMode,proto3,enum=google.cloud.kms.v1.EkmConnection_KeyManagementMode" json:"key_management_mode,omitempty"`
	// Optional. Identifies the EKM Crypto Space that this
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] maps to. Note: This
	// field is required if
	// [KeyManagementMode][google.cloud.kms.v1.EkmConnection.KeyManagementMode] is
	// [CLOUD_KMS][google.cloud.kms.v1.EkmConnection.KeyManagementMode.CLOUD_KMS].
	CryptoSpacePath string `protobuf:"bytes,7,opt,name=crypto_space_path,json=cryptoSpacePath,proto3" json:"crypto_space_path,omitempty"`
}

func (x *EkmConnection) Reset() {
	*x = EkmConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EkmConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EkmConnection) ProtoMessage() {}

func (x *EkmConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EkmConnection.ProtoReflect.Descriptor instead.
func (*EkmConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{8}
}

func (x *EkmConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EkmConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EkmConnection) GetServiceResolvers() []*EkmConnection_ServiceResolver {
	if x != nil {
		return x.ServiceResolvers
	}
	return nil
}

func (x *EkmConnection) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *EkmConnection) GetKeyManagementMode() EkmConnection_KeyManagementMode {
	if x != nil {
		return x.KeyManagementMode
	}
	return EkmConnection_KEY_MANAGEMENT_MODE_UNSPECIFIED
}

func (x *EkmConnection) GetCryptoSpacePath() string {
	if x != nil {
		return x.CryptoSpacePath
	}
	return ""
}

// An [EkmConfig][google.cloud.kms.v1.EkmConfig] is a singleton resource that
// represents configuration parameters that apply to all
// [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] with a
// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
// [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC] in a given
// project and location.
type EkmConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for the
	// [EkmConfig][google.cloud.kms.v1.EkmConfig] in the format
	// `projects/*/locations/*/ekmConfig`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Resource name of the default
	// [EkmConnection][google.cloud.kms.v1.EkmConnection]. Setting this field to
	// the empty string removes the default.
	DefaultEkmConnection string `protobuf:"bytes,2,opt,name=default_ekm_connection,json=defaultEkmConnection,proto3" json:"default_ekm_connection,omitempty"`
}

func (x *EkmConfig) Reset() {
	*x = EkmConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EkmConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EkmConfig) ProtoMessage() {}

func (x *EkmConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EkmConfig.ProtoReflect.Descriptor instead.
func (*EkmConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{9}
}

func (x *EkmConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EkmConfig) GetDefaultEkmConnection() string {
	if x != nil {
		return x.DefaultEkmConnection
	}
	return ""
}

// Request message for
// [EkmService.VerifyConnectivity][google.cloud.kms.v1.EkmService.VerifyConnectivity].
type VerifyConnectivityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [name][google.cloud.kms.v1.EkmConnection.name] of the
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] to verify.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *VerifyConnectivityRequest) Reset() {
	*x = VerifyConnectivityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyConnectivityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyConnectivityRequest) ProtoMessage() {}

func (x *VerifyConnectivityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyConnectivityRequest.ProtoReflect.Descriptor instead.
func (*VerifyConnectivityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{10}
}

func (x *VerifyConnectivityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for
// [EkmService.VerifyConnectivity][google.cloud.kms.v1.EkmService.VerifyConnectivity].
type VerifyConnectivityResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VerifyConnectivityResponse) Reset() {
	*x = VerifyConnectivityResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyConnectivityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyConnectivityResponse) ProtoMessage() {}

func (x *VerifyConnectivityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyConnectivityResponse.ProtoReflect.Descriptor instead.
func (*VerifyConnectivityResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{11}
}

// A [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver]
// represents an EKM replica that can be reached within an
// [EkmConnection][google.cloud.kms.v1.EkmConnection].
type EkmConnection_ServiceResolver struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Service Directory service pointing to
	// an EKM replica, in the format
	// `projects/*/locations/*/namespaces/*/services/*`.
	ServiceDirectoryService string `protobuf:"bytes,1,opt,name=service_directory_service,json=serviceDirectoryService,proto3" json:"service_directory_service,omitempty"`
	// Optional. The filter applied to the endpoints of the resolved service. If
	// no filter is specified, all endpoints will be considered. An endpoint
	// will be chosen arbitrarily from the filtered list for each request.
	//
	// For endpoint filter syntax and examples, see
	// https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
	EndpointFilter string `protobuf:"bytes,2,opt,name=endpoint_filter,json=endpointFilter,proto3" json:"endpoint_filter,omitempty"`
	// Required. The hostname of the EKM replica used at TLS and HTTP layers.
	Hostname string `protobuf:"bytes,3,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Required. A list of leaf server certificates used to authenticate HTTPS
	// connections to the EKM replica. Currently, a maximum of 10
	// [Certificate][google.cloud.kms.v1.Certificate] is supported.
	ServerCertificates []*Certificate `protobuf:"bytes,4,rep,name=server_certificates,json=serverCertificates,proto3" json:"server_certificates,omitempty"`
}

func (x *EkmConnection_ServiceResolver) Reset() {
	*x = EkmConnection_ServiceResolver{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EkmConnection_ServiceResolver) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EkmConnection_ServiceResolver) ProtoMessage() {}

func (x *EkmConnection_ServiceResolver) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_ekm_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EkmConnection_ServiceResolver.ProtoReflect.Descriptor instead.
func (*EkmConnection_ServiceResolver) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP(), []int{8, 0}
}

func (x *EkmConnection_ServiceResolver) GetServiceDirectoryService() string {
	if x != nil {
		return x.ServiceDirectoryService
	}
	return ""
}

func (x *EkmConnection_ServiceResolver) GetEndpointFilter() string {
	if x != nil {
		return x.EndpointFilter
	}
	return ""
}

func (x *EkmConnection_ServiceResolver) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *EkmConnection_ServiceResolver) GetServerCertificates() []*Certificate {
	if x != nil {
		return x.ServerCertificates
	}
	return nil
}

var File_google_cloud_kms_v1_ekm_service_proto protoreflect.FileDescriptor

var file_google_cloud_kms_v1_ekm_service_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6b,
	0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6b, 0x6d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xe1, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb0, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0f, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0e, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x5c, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe0, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x65, 0x6b, 0x6d,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x6b, 0x6d, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x0e, 0x65, 0x6b,
	0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x65, 0x6b, 0x6d,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x1a, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0e, 0x65, 0x6b, 0x6d,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x65, 0x6b, 0x6d, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x54, 0x0a, 0x13, 0x47,
	0x65, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x9e, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x0a,
	0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xba, 0x03, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x61, 0x77, 0x5f, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x61, 0x77, 0x44, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70, 0x61, 0x72, 0x73, 0x65, 0x64, 0x12, 0x1b, 0x0a,
	0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x75,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x46, 0x0a, 0x1d, 0x73, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x12, 0x47, 0x0a, 0x0f, 0x6e, 0x6f, 0x74, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x6f, 0x74,
	0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0e, 0x6e, 0x6f,
	0x74, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x12, 0x73,
	0x68, 0x61, 0x32, 0x35, 0x36, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x68,
	0x61, 0x32, 0x35, 0x36, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22,
	0xf2, 0x06, 0x0a, 0x0d, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x11,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b,
	0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x52, 0x10, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x69, 0x0a, 0x13, 0x6b, 0x65, 0x79, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x6b, 0x65, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x2f, 0x0a, 0x11, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x1a, 0xa5, 0x02, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x12, 0x6b, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x29, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x17, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x56, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x22, 0x53, 0x0a, 0x11, 0x4b, 0x65,
	0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x23, 0x0a, 0x1f, 0x4b, 0x45, 0x59, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4b, 0x4d, 0x53, 0x10, 0x02, 0x3a,
	0x73, 0xea, 0x41, 0x70, 0x0a, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6b,
	0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xe4, 0x01, 0x0a, 0x09, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x16, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6b, 0x6d,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x59, 0xea, 0x41, 0x56, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5e, 0x0a, 0x19, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xdc, 0x0b, 0x0a, 0x0a, 0x45, 0x6b,
	0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xba, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x45, 0x6b, 0x6d,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6b,
	0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xe0, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xda, 0x41,
	0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x2c, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e,
	0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x32,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xe2, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x76, 0xda, 0x41, 0x1a, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x53, 0x3a, 0x0e, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6b, 0x6d, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x94, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x45,
	0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0xc3,
	0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x63, 0xda, 0x41, 0x16, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x3a, 0x0a, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x12, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6b,
	0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x1a, 0x74, 0xca, 0x41, 0x17, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x42, 0x85, 0x02, 0xea, 0x41, 0x7c, 0x0a, 0x27,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x42, 0x0f, 0x45, 0x6b, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6b, 0x6d, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6b, 0x6d, 0x73, 0x70, 0x62, 0x3b, 0x6b, 0x6d, 0x73, 0x70,
	0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4b, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4b, 0x6d, 0x73, 0x5c, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_kms_v1_ekm_service_proto_rawDescOnce sync.Once
	file_google_cloud_kms_v1_ekm_service_proto_rawDescData = file_google_cloud_kms_v1_ekm_service_proto_rawDesc
)

func file_google_cloud_kms_v1_ekm_service_proto_rawDescGZIP() []byte {
	file_google_cloud_kms_v1_ekm_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_kms_v1_ekm_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_kms_v1_ekm_service_proto_rawDescData)
	})
	return file_google_cloud_kms_v1_ekm_service_proto_rawDescData
}

var file_google_cloud_kms_v1_ekm_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_kms_v1_ekm_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_kms_v1_ekm_service_proto_goTypes = []interface{}{
	(EkmConnection_KeyManagementMode)(0),  // 0: google.cloud.kms.v1.EkmConnection.KeyManagementMode
	(*ListEkmConnectionsRequest)(nil),     // 1: google.cloud.kms.v1.ListEkmConnectionsRequest
	(*ListEkmConnectionsResponse)(nil),    // 2: google.cloud.kms.v1.ListEkmConnectionsResponse
	(*GetEkmConnectionRequest)(nil),       // 3: google.cloud.kms.v1.GetEkmConnectionRequest
	(*CreateEkmConnectionRequest)(nil),    // 4: google.cloud.kms.v1.CreateEkmConnectionRequest
	(*UpdateEkmConnectionRequest)(nil),    // 5: google.cloud.kms.v1.UpdateEkmConnectionRequest
	(*GetEkmConfigRequest)(nil),           // 6: google.cloud.kms.v1.GetEkmConfigRequest
	(*UpdateEkmConfigRequest)(nil),        // 7: google.cloud.kms.v1.UpdateEkmConfigRequest
	(*Certificate)(nil),                   // 8: google.cloud.kms.v1.Certificate
	(*EkmConnection)(nil),                 // 9: google.cloud.kms.v1.EkmConnection
	(*EkmConfig)(nil),                     // 10: google.cloud.kms.v1.EkmConfig
	(*VerifyConnectivityRequest)(nil),     // 11: google.cloud.kms.v1.VerifyConnectivityRequest
	(*VerifyConnectivityResponse)(nil),    // 12: google.cloud.kms.v1.VerifyConnectivityResponse
	(*EkmConnection_ServiceResolver)(nil), // 13: google.cloud.kms.v1.EkmConnection.ServiceResolver
	(*fieldmaskpb.FieldMask)(nil),         // 14: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),         // 15: google.protobuf.Timestamp
}
var file_google_cloud_kms_v1_ekm_service_proto_depIdxs = []int32{
	9,  // 0: google.cloud.kms.v1.ListEkmConnectionsResponse.ekm_connections:type_name -> google.cloud.kms.v1.EkmConnection
	9,  // 1: google.cloud.kms.v1.CreateEkmConnectionRequest.ekm_connection:type_name -> google.cloud.kms.v1.EkmConnection
	9,  // 2: google.cloud.kms.v1.UpdateEkmConnectionRequest.ekm_connection:type_name -> google.cloud.kms.v1.EkmConnection
	14, // 3: google.cloud.kms.v1.UpdateEkmConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 4: google.cloud.kms.v1.UpdateEkmConfigRequest.ekm_config:type_name -> google.cloud.kms.v1.EkmConfig
	14, // 5: google.cloud.kms.v1.UpdateEkmConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	15, // 6: google.cloud.kms.v1.Certificate.not_before_time:type_name -> google.protobuf.Timestamp
	15, // 7: google.cloud.kms.v1.Certificate.not_after_time:type_name -> google.protobuf.Timestamp
	15, // 8: google.cloud.kms.v1.EkmConnection.create_time:type_name -> google.protobuf.Timestamp
	13, // 9: google.cloud.kms.v1.EkmConnection.service_resolvers:type_name -> google.cloud.kms.v1.EkmConnection.ServiceResolver
	0,  // 10: google.cloud.kms.v1.EkmConnection.key_management_mode:type_name -> google.cloud.kms.v1.EkmConnection.KeyManagementMode
	8,  // 11: google.cloud.kms.v1.EkmConnection.ServiceResolver.server_certificates:type_name -> google.cloud.kms.v1.Certificate
	1,  // 12: google.cloud.kms.v1.EkmService.ListEkmConnections:input_type -> google.cloud.kms.v1.ListEkmConnectionsRequest
	3,  // 13: google.cloud.kms.v1.EkmService.GetEkmConnection:input_type -> google.cloud.kms.v1.GetEkmConnectionRequest
	4,  // 14: google.cloud.kms.v1.EkmService.CreateEkmConnection:input_type -> google.cloud.kms.v1.CreateEkmConnectionRequest
	5,  // 15: google.cloud.kms.v1.EkmService.UpdateEkmConnection:input_type -> google.cloud.kms.v1.UpdateEkmConnectionRequest
	6,  // 16: google.cloud.kms.v1.EkmService.GetEkmConfig:input_type -> google.cloud.kms.v1.GetEkmConfigRequest
	7,  // 17: google.cloud.kms.v1.EkmService.UpdateEkmConfig:input_type -> google.cloud.kms.v1.UpdateEkmConfigRequest
	11, // 18: google.cloud.kms.v1.EkmService.VerifyConnectivity:input_type -> google.cloud.kms.v1.VerifyConnectivityRequest
	2,  // 19: google.cloud.kms.v1.EkmService.ListEkmConnections:output_type -> google.cloud.kms.v1.ListEkmConnectionsResponse
	9,  // 20: google.cloud.kms.v1.EkmService.GetEkmConnection:output_type -> google.cloud.kms.v1.EkmConnection
	9,  // 21: google.cloud.kms.v1.EkmService.CreateEkmConnection:output_type -> google.cloud.kms.v1.EkmConnection
	9,  // 22: google.cloud.kms.v1.EkmService.UpdateEkmConnection:output_type -> google.cloud.kms.v1.EkmConnection
	10, // 23: google.cloud.kms.v1.EkmService.GetEkmConfig:output_type -> google.cloud.kms.v1.EkmConfig
	10, // 24: google.cloud.kms.v1.EkmService.UpdateEkmConfig:output_type -> google.cloud.kms.v1.EkmConfig
	12, // 25: google.cloud.kms.v1.EkmService.VerifyConnectivity:output_type -> google.cloud.kms.v1.VerifyConnectivityResponse
	19, // [19:26] is the sub-list for method output_type
	12, // [12:19] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_kms_v1_ekm_service_proto_init() }
func file_google_cloud_kms_v1_ekm_service_proto_init() {
	if File_google_cloud_kms_v1_ekm_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEkmConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEkmConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEkmConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEkmConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEkmConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEkmConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEkmConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EkmConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EkmConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyConnectivityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyConnectivityResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kms_v1_ekm_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EkmConnection_ServiceResolver); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_kms_v1_ekm_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_kms_v1_ekm_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_kms_v1_ekm_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_kms_v1_ekm_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_kms_v1_ekm_service_proto_msgTypes,
	}.Build()
	File_google_cloud_kms_v1_ekm_service_proto = out.File
	file_google_cloud_kms_v1_ekm_service_proto_rawDesc = nil
	file_google_cloud_kms_v1_ekm_service_proto_goTypes = nil
	file_google_cloud_kms_v1_ekm_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EkmServiceClient is the client API for EkmService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EkmServiceClient interface {
	// Lists [EkmConnections][google.cloud.kms.v1.EkmConnection].
	ListEkmConnections(ctx context.Context, in *ListEkmConnectionsRequest, opts ...grpc.CallOption) (*ListEkmConnectionsResponse, error)
	// Returns metadata for a given
	// [EkmConnection][google.cloud.kms.v1.EkmConnection].
	GetEkmConnection(ctx context.Context, in *GetEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error)
	// Creates a new [EkmConnection][google.cloud.kms.v1.EkmConnection] in a given
	// Project and Location.
	CreateEkmConnection(ctx context.Context, in *CreateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error)
	// Updates an [EkmConnection][google.cloud.kms.v1.EkmConnection]'s metadata.
	UpdateEkmConnection(ctx context.Context, in *UpdateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error)
	// Returns the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	GetEkmConfig(ctx context.Context, in *GetEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error)
	// Updates the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	UpdateEkmConfig(ctx context.Context, in *UpdateEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error)
	// Verifies that Cloud KMS can successfully connect to the external key
	// manager specified by an [EkmConnection][google.cloud.kms.v1.EkmConnection].
	// If there is an error connecting to the EKM, this method returns a
	// FAILED_PRECONDITION status containing structured information as described
	// at https://cloud.google.com/kms/docs/reference/ekm_errors.
	VerifyConnectivity(ctx context.Context, in *VerifyConnectivityRequest, opts ...grpc.CallOption) (*VerifyConnectivityResponse, error)
}

type ekmServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEkmServiceClient(cc grpc.ClientConnInterface) EkmServiceClient {
	return &ekmServiceClient{cc}
}

func (c *ekmServiceClient) ListEkmConnections(ctx context.Context, in *ListEkmConnectionsRequest, opts ...grpc.CallOption) (*ListEkmConnectionsResponse, error) {
	out := new(ListEkmConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/ListEkmConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) GetEkmConnection(ctx context.Context, in *GetEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error) {
	out := new(EkmConnection)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/GetEkmConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) CreateEkmConnection(ctx context.Context, in *CreateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error) {
	out := new(EkmConnection)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/CreateEkmConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) UpdateEkmConnection(ctx context.Context, in *UpdateEkmConnectionRequest, opts ...grpc.CallOption) (*EkmConnection, error) {
	out := new(EkmConnection)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/UpdateEkmConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) GetEkmConfig(ctx context.Context, in *GetEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error) {
	out := new(EkmConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/GetEkmConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) UpdateEkmConfig(ctx context.Context, in *UpdateEkmConfigRequest, opts ...grpc.CallOption) (*EkmConfig, error) {
	out := new(EkmConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/UpdateEkmConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ekmServiceClient) VerifyConnectivity(ctx context.Context, in *VerifyConnectivityRequest, opts ...grpc.CallOption) (*VerifyConnectivityResponse, error) {
	out := new(VerifyConnectivityResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.EkmService/VerifyConnectivity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EkmServiceServer is the server API for EkmService service.
type EkmServiceServer interface {
	// Lists [EkmConnections][google.cloud.kms.v1.EkmConnection].
	ListEkmConnections(context.Context, *ListEkmConnectionsRequest) (*ListEkmConnectionsResponse, error)
	// Returns metadata for a given
	// [EkmConnection][google.cloud.kms.v1.EkmConnection].
	GetEkmConnection(context.Context, *GetEkmConnectionRequest) (*EkmConnection, error)
	// Creates a new [EkmConnection][google.cloud.kms.v1.EkmConnection] in a given
	// Project and Location.
	CreateEkmConnection(context.Context, *CreateEkmConnectionRequest) (*EkmConnection, error)
	// Updates an [EkmConnection][google.cloud.kms.v1.EkmConnection]'s metadata.
	UpdateEkmConnection(context.Context, *UpdateEkmConnectionRequest) (*EkmConnection, error)
	// Returns the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	GetEkmConfig(context.Context, *GetEkmConfigRequest) (*EkmConfig, error)
	// Updates the [EkmConfig][google.cloud.kms.v1.EkmConfig] singleton resource
	// for a given project and location.
	UpdateEkmConfig(context.Context, *UpdateEkmConfigRequest) (*EkmConfig, error)
	// Verifies that Cloud KMS can successfully connect to the external key
	// manager specified by an [EkmConnection][google.cloud.kms.v1.EkmConnection].
	// If there is an error connecting to the EKM, this method returns a
	// FAILED_PRECONDITION status containing structured information as described
	// at https://cloud.google.com/kms/docs/reference/ekm_errors.
	VerifyConnectivity(context.Context, *VerifyConnectivityRequest) (*VerifyConnectivityResponse, error)
}

// UnimplementedEkmServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEkmServiceServer struct {
}

func (*UnimplementedEkmServiceServer) ListEkmConnections(context.Context, *ListEkmConnectionsRequest) (*ListEkmConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEkmConnections not implemented")
}
func (*UnimplementedEkmServiceServer) GetEkmConnection(context.Context, *GetEkmConnectionRequest) (*EkmConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEkmConnection not implemented")
}
func (*UnimplementedEkmServiceServer) CreateEkmConnection(context.Context, *CreateEkmConnectionRequest) (*EkmConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEkmConnection not implemented")
}
func (*UnimplementedEkmServiceServer) UpdateEkmConnection(context.Context, *UpdateEkmConnectionRequest) (*EkmConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEkmConnection not implemented")
}
func (*UnimplementedEkmServiceServer) GetEkmConfig(context.Context, *GetEkmConfigRequest) (*EkmConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEkmConfig not implemented")
}
func (*UnimplementedEkmServiceServer) UpdateEkmConfig(context.Context, *UpdateEkmConfigRequest) (*EkmConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEkmConfig not implemented")
}
func (*UnimplementedEkmServiceServer) VerifyConnectivity(context.Context, *VerifyConnectivityRequest) (*VerifyConnectivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyConnectivity not implemented")
}

func RegisterEkmServiceServer(s *grpc.Server, srv EkmServiceServer) {
	s.RegisterService(&_EkmService_serviceDesc, srv)
}

func _EkmService_ListEkmConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEkmConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).ListEkmConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/ListEkmConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).ListEkmConnections(ctx, req.(*ListEkmConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_GetEkmConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEkmConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).GetEkmConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/GetEkmConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).GetEkmConnection(ctx, req.(*GetEkmConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_CreateEkmConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEkmConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).CreateEkmConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/CreateEkmConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).CreateEkmConnection(ctx, req.(*CreateEkmConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_UpdateEkmConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEkmConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).UpdateEkmConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/UpdateEkmConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).UpdateEkmConnection(ctx, req.(*UpdateEkmConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_GetEkmConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEkmConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).GetEkmConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/GetEkmConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).GetEkmConfig(ctx, req.(*GetEkmConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_UpdateEkmConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEkmConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).UpdateEkmConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/UpdateEkmConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).UpdateEkmConfig(ctx, req.(*UpdateEkmConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EkmService_VerifyConnectivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyConnectivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EkmServiceServer).VerifyConnectivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.EkmService/VerifyConnectivity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EkmServiceServer).VerifyConnectivity(ctx, req.(*VerifyConnectivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EkmService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.EkmService",
	HandlerType: (*EkmServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEkmConnections",
			Handler:    _EkmService_ListEkmConnections_Handler,
		},
		{
			MethodName: "GetEkmConnection",
			Handler:    _EkmService_GetEkmConnection_Handler,
		},
		{
			MethodName: "CreateEkmConnection",
			Handler:    _EkmService_CreateEkmConnection_Handler,
		},
		{
			MethodName: "UpdateEkmConnection",
			Handler:    _EkmService_UpdateEkmConnection_Handler,
		},
		{
			MethodName: "GetEkmConfig",
			Handler:    _EkmService_GetEkmConfig_Handler,
		},
		{
			MethodName: "UpdateEkmConfig",
			Handler:    _EkmService_UpdateEkmConfig_Handler,
		},
		{
			MethodName: "VerifyConnectivity",
			Handler:    _EkmService_VerifyConnectivity_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/ekm_service.proto",
}
