/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.aarch64;

import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.CodeCache;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.aarch64.AARCH64ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.aarch64.AARCH64Frame;

public class AARCH64CurrentFrameGuess {
    private AARCH64ThreadContext context;
    private JavaThread thread;
    private Address spFound;
    private Address fpFound;
    private Address pcFound;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.aarch64.AARCH64Frame.DEBUG") != null;

    public AARCH64CurrentFrameGuess(AARCH64ThreadContext context, JavaThread thread) {
        this.context = context;
        this.thread = thread;
    }

    public boolean run(long regionInBytesToSearch) {
        CodeCache cc;
        Address sp = this.context.getRegisterAsAddress(31);
        Address pc = this.context.getRegisterAsAddress(32);
        Address fp = this.context.getRegisterAsAddress(29);
        if (sp == null) {
            if (this.thread.getLastJavaSP() != null) {
                this.setValues(this.thread.getLastJavaSP(), this.thread.getLastJavaFP(), null);
                return true;
            }
            return false;
        }
        Address end = sp.addOffsetTo(regionInBytesToSearch);
        VM vm = VM.getVM();
        this.setValues(null, null, null);
        if (vm.isJavaPCDbg(pc)) {
            if (vm.isClientCompiler()) {
                this.setValues(sp, fp, pc);
                return true;
            }
            if (vm.getInterpreter().contains(pc)) {
                if (DEBUG) {
                    System.out.println("CurrentFrameGuess: choosing interpreter frame: sp = " + sp + ", fp = " + fp + ", pc = " + pc);
                }
                this.setValues(sp, fp, pc);
                return true;
            }
            for (long offset = 0L; offset < regionInBytesToSearch; offset += vm.getAddressSize()) {
                try {
                    Address curSP = sp.addOffsetTo(offset);
                    RegisterMap map = this.thread.newRegisterMap(false);
                    for (Frame frame = new AARCH64Frame(curSP, null, pc); frame != null; frame = frame.sender(map)) {
                        if (!frame.isEntryFrame() || !frame.entryFrameIsFirst()) continue;
                        if (DEBUG) {
                            System.out.println("CurrentFrameGuess: Choosing sp = " + curSP + ", pc = " + pc);
                        }
                        this.setValues(curSP, null, pc);
                        return true;
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    System.out.println("CurrentFrameGuess: Exception " + e + " at offset " + offset);
                }
            }
            return false;
        }
        if (DEBUG) {
            System.out.println("CurrentFrameGuess: choosing last Java frame: sp = " + this.thread.getLastJavaSP() + ", fp = " + this.thread.getLastJavaFP());
        }
        if (this.thread.getLastJavaSP() == null) {
            return false;
        }
        pc = this.thread.getLastJavaPC();
        fp = this.thread.getLastJavaFP();
        sp = this.thread.getLastJavaSP();
        if (fp == null && (cc = vm.getCodeCache()).contains(pc)) {
            long link_offset;
            CodeBlob cb = cc.findBlob(pc);
            if (DEBUG) {
                System.out.println("FP is null.  Found blob frame size " + cb.getFrameSize());
            }
            if ((link_offset = cb.getFrameSize() - 2L * VM.getVM().getAddressSize()) >= 0L) {
                fp = sp.addOffsetTo(link_offset);
            }
        }
        if (vm.isJavaPCDbg(pc)) {
            this.setValues(sp, fp, pc);
        } else {
            this.setValues(sp, fp, null);
        }
        return true;
    }

    public Address getSP() {
        return this.spFound;
    }

    public Address getFP() {
        return this.fpFound;
    }

    public Address getPC() {
        return this.pcFound;
    }

    private void setValues(Address sp, Address fp, Address pc) {
        this.spFound = sp;
        this.fpFound = fp;
        this.pcFound = pc;
    }
}

