/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.opto.JVMState;
import sun.jvm.hotspot.opto.MultiNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class SafePointNode
extends MultiNode {
    private static AddressField jvmsField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("SafePointNode");
        jvmsField = type.getAddressField("_jvms");
    }

    public SafePointNode(Address addr) {
        super(addr);
    }

    public JVMState jvms() {
        return JVMState.create(jvmsField.getValue(this.getAddress()));
    }

    @Override
    public void dumpSpec(PrintStream out) {
        JVMState jvms = this.jvms();
        if (jvms != null) {
            out.print(" !");
        }
        while (jvms != null) {
            Method m = jvms.method().method();
            int bci = jvms.bci();
            out.print(" " + m.getMethodHolder().getName().asString().replace('/', '.') + "::" + m.getName().asString() + " @ bci:" + bci);
            jvms = jvms.caller();
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                SafePointNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

