# Code of conduct

This document is a close copy of <https://nextcloud.com/contribute/code-of-conduct/>, adapted only to speak to and of the Roundcube community. Roundcube is part of the bigger Nextcloud community since 2023, but deserves to be addressed directly.

## Preamble

In the Roundcube community, participants from all over the world come together to create Free Software for a free internet. This is made possible by the support, hard work and enthusiasm of thousands of people, including those who create and use Roundcube software.

This document offers some guidance to ensure Roundcube participants can cooperate effectively in a positive and inspiring atmosphere, and to explain how together we can strengthen and support each other.

This Code of Conduct is shared by all contributors and users who engage with the Roundcube team and its community services.

If you ever experience an uncomfortable or threatening situation, please speak up: conduct@nextcloud.com. The team behind that address also cares for the Roundcube community.

## Overview

This Code of Conduct presents a summary of the shared values and “common sense” thinking in our community. The basic social ingredients that hold our project together include:

* Be considerate
* Be respectful
* Be collaborative
* Be pragmatic
* Support others in the community
* Get support from others in the community

### Our community

Our community is made up of several groups of individuals and organizations which can roughly be divided into two groups:

* Contributors, or those who add value to the project through improving Roundcube software and its services
* Users, or those who add value to the project through their support as consumers of Roundcube software

This Code of Conduct reflects the agreed standards of behavior for members of the Roundcube community, in any forum, mailing list, wiki, web site, IRC channel, public meeting or private correspondence within the context of the Roundcube team and its services.

The community acts according to the standards written down in this Code of Conduct and will defend these standards for the benefit of the community. Leaders of any group, such as moderators of mailing lists, IRC channels, forums, etc., will exercise the right to suspend access to any person who persistently breaks our shared Code of Conduct.

## Be considerate

Your actions and work will affect and be used by other people and you in turn will depend on the work and actions of others. Any decision you take will affect other community members, and we expect you to take those consequences into account when making decisions.

As a contributor, ensure that you give full credit for the work of others and bear in mind how your changes affect others. It is also expected that you try to follow the development schedule and guidelines.

As a user, remember that contributors work hard on their part of Roundcube and take great pride in it. If you are frustrated your problems are more likely to be resolved if you can give accurate and well-mannered information to all concerned.

## Be respectful

In order for the Roundcube community to stay healthy its members must feel comfortable and accepted. Treating one another with respect is absolutely necessary for this. In a disagreement, in the first instance assume that people mean well.

We do not tolerate personal attacks, racism, sexism or any other form of discrimination. Disagreement is inevitable, from time to time, but respect for the views of others will go a long way to winning respect for your own view.

Respecting other people, their work, their contributions and assuming well-meaning motivation will make community members feel comfortable and safe and will result in motivation and productivity.

We expect members of our community to be respectful when dealing with other contributors, users and communities. Remember that Roundcube is an international project and that you may be unaware of important aspects of other cultures.

## Be collaborative

The Free Software Movement depends on collaboration: it helps limit duplication of effort while improving the quality of the software produced. In order to avoid misunderstanding, try to be clear and concise when requesting help or giving it. Remember it is easy to misunderstand emails (especially when they are not written in your mother tongue). Ask for clarifications if unsure how something is meant; remember the first rule - assume in the first instance that people mean well.

As a contributor, you should aim to collaborate with other community members, as well as with other communities that are interested in or depend on the work you do. Your work should be transparent and be fed back into the community when available, not just when Roundcube releases. If you wish to work on something new in existing projects, keep those projects informed of your ideas and progress.

It may not always be possible to reach consensus on the implementation of an idea, so dont feel obliged to achieve this before you begin. However, always ensure that you keep the outside world informed of your work, and publish it in a way that allows outsiders to test, discuss and contribute to your efforts.

Contributors on every project come and go. When you leave or disengage from the project, in whole or in part, you should do so with pride about what you have achieved and by acting responsibly towards others who come after you to continue the project.

As a user, your feedback is important, as is its form. Poorly thought out comments can cause pain and the demotivation of other community members, but considerate discussion of problems can bring positive results. An encouraging word works wonders.

## Be pragmatic

Roundcube is a pragmatic community. We value tangible results over having the last word in a discussion. We defend our core values like freedom and respectful collaboration, but we dont let arguments about minor issues get in the way of achieving more important results.

We are open to suggestions and welcome solutions regardless of their origin. When in doubt support a solution which helps getting things done over one which has theoretical merits, but isnt being worked on. Use the tools and methods which help getting the job done. Let decisions be taken by those who do the work.

## Support others in the community

Our community is made strong by mutual respect, collaboration and pragmatic, responsible behavior. Sometimes there are situations where this has to be defended and other community members need help.

If you witness others being attacked, think first about how you can offer them personal support. If you feel that the situation is beyond your ability to help individually, go privately to the victim and ask if some form of official intervention is needed.

Similarly you should support anyone who appears to be in danger of burning out, either through work-related stress or personal problems.

When problems do arise, consider respectfully reminding those involved of our shared Code of Conduct as a first action. Leaders are defined by their actions, and can help set a good example by working to resolve issues in the spirit of this Code of Conduct before they escalate.

## Get support from others in the community

Disagreements, both political and technical, happen all the time. Our community is no exception to the rule. The goal is not to avoid disagreements or differing views but to resolve them constructively. You should turn to the community to seek advice and to resolve disagreements and where possible consult the team most directly involved.

Think deeply before turning a disagreement into a public dispute. If necessary request mediation, trying to resolve differences in a less highly-emotional medium. If you do feel that you or your work is being attacked, take your time to breathe through before writing heated replies. Consider a 24 hour moratorium if emotional language is being used - a cooling off period is sometimes all that is needed. If you really want to go a different way, then we encourage you to publish your ideas and your work, so that it can be tried and tested.

This document is licensed under the Creative Commons Attribution - Share Alike 3.0 License.

The authors of this document would like to thank the Roundcube and the Nextcloud community and those who have worked to create such a dynamic environment to share in and who offered their thoughts and wisdom in the authoring of this document. We would also like to thank other vibrant communities that have helped shape this document with their own examples, especially KDE.
