#
# Widgets...
#
# $Id: widgets.tcl,v 1.14 2011/01/31 14:44:43 rader Exp $
#

proc InitWidgets { } { 
  global font rows cols height width
  global color_fg color_bg color_fg_header color_fg_footer
  global color_fg_command_line global color_fg_entry_text global color_fg_feedback
  global line_padding

  frame .t -background $color_bg -highlightbackground $color_bg -highlightcolor $color_bg \
    -highlightthickness 6

  text .t.lb -bd 0 -setgrid true -exportselection false -highlightthickness 0 \
    -background $color_bg -foreground $color_fg -font $font -width $cols -height $rows \
    -spacing1 $line_padding -spacing3 $line_padding -state disabled

  label .t.pro -relief flat -bd 0 -background $color_bg -foreground $color_fg_command_line \
    -font $font -textvariable prompt

  entry .t.ent -bd 0 -highlightthickness 0 -background $color_bg -foreground $color_fg_entry_text \
    -disabledbackground $color_bg -disabledforeground $color_fg_feedback \
    -insertbackground $color_fg_entry_text -font $font 

  pack .t.lb -fill both -padx 0 -pady 0 -expand 1
  pack .t.pro -side left -padx 0 -pady 0 -expand 0
  pack .t.ent -fill x -padx 0 -pady 0 -expand 0
  pack .t -side top -fill both -padx 0 -pady 0 -expand 1
  
  .t.ent configure -state disabled
  set height [winfo height .t.lb]
  set width [winfo width .t.lb]
  focus .t.lb

  .t.lb tag configure ctag_header -foreground $color_fg_header -background $color_bg 
  .t.lb tag configure ctag_footer -foreground $color_fg_footer -background $color_bg
  .t.lb tag configure tag_overstrike -foreground $color_fg_header -background $color_bg -overstrike 1

}

