/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.uv;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerProvider;
import com.jetbrains.python.sdk.uv.UvExtKt;
import com.jetbrains.python.sdk.uv.UvLowLevel;
import com.jetbrains.python.sdk.uv.UvPackageManager;
import com.jetbrains.python.sdk.uv.UvSdkAdditionalData;
import com.jetbrains.python.sdk.uv.impl.UvCliKt;
import com.jetbrains.python.sdk.uv.impl.UvLowLevelKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/sdk/uv/UvPackageManagerProvider;", "Lcom/jetbrains/python/packaging/management/PythonPackageManagerProvider;", "<init>", "()V", "createPackageManagerForSdk", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.python.community.impl"})
public final class UvPackageManagerProvider
implements PythonPackageManagerProvider {
    @Override
    @Nullable
    public PythonPackageManager createPackageManagerForSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (!UvExtKt.isUv(sdk2)) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.sdk.uv.UvSdkAdditionalData");
        Path path2 = ((UvSdkAdditionalData)sdkAdditionalData).getUvWorkingDirectory();
        if (path2 == null) {
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            path2 = Path.of(string, new String[0]);
        }
        Path uvWorkingDirectory = path2;
        Intrinsics.checkNotNull((Object)uvWorkingDirectory);
        UvLowLevel uv = UvLowLevelKt.createUvLowLevel(uvWorkingDirectory, UvCliKt.createUvCli$default(null, null, 3, null));
        return new UvPackageManager(project, sdk2, uv);
    }
}

