/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.packaging.PyPIPackageRanking;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUI;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUiExtensionsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.statistics.PyPackagesUsageCollector;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\rJ2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\r\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/packaging/PyPackageInstallUtils;", "", "<init>", "()V", "getConfirmedPackages", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "packageNames", "", "project", "Lcom/intellij/openapi/project/Project;", "getConfirmedPackages$intellij_python_community_impl", "offeredPackageForNotFoundModule", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "moduleName", "checkShouldToInstallSnapshot", "", "checkIsInstalledSnapshot", "packageName", "confirmAndInstall", "", "versionSpec", "Lcom/jetbrains/python/packaging/requirement/PyRequirementVersionSpec;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lcom/jetbrains/python/packaging/requirement/PyRequirementVersionSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmInstall", "ConfirmPackageInstallationDoNotAskOption", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PyPackageInstallUtils {
    @NotNull
    public static final PyPackageInstallUtils INSTANCE = new PyPackageInstallUtils();

    private PyPackageInstallUtils() {
    }

    @NotNull
    public final Set<PyRequirement> getConfirmedPackages$intellij_python_community_impl(@NotNull List<? extends PyRequirement> packageNames, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean confirmationEnabled = PropertiesComponent.getInstance().getBoolean("python.confirm.package.installation", true);
        if (!confirmationEnabled || packageNames.isEmpty()) {
            return CollectionsKt.toSet((Iterable)packageNames);
        }
        PyChooseRequirementsDialog<? extends PyRequirement> dialog2 = new PyChooseRequirementsDialog<PyRequirement>(project, packageNames, PyPackageInstallUtils::getConfirmedPackages$lambda$0);
        if (!dialog2.showAndGet()) {
            PyPackagesUsageCollector.installAllCanceledEvent.log();
            return SetsKt.emptySet();
        }
        return CollectionsKt.toSet((Iterable)dialog2.getMarkedElements());
    }

    @Nullable
    public final String offeredPackageForNotFoundModule(@NotNull Project project, @NotNull Sdk sdk2, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        boolean shouldToInstall = this.checkShouldToInstallSnapshot(project, sdk2, moduleName);
        if (!shouldToInstall) {
            return null;
        }
        return PyPsiPackageUtil.moduleToPackageName$default(PyPsiPackageUtil.INSTANCE, moduleName, null, 2, null);
    }

    public final boolean checkShouldToInstallSnapshot(@NotNull Project project, @NotNull Sdk sdk2, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        String packageName = PyPsiPackageUtil.moduleToPackageName$default(PyPsiPackageUtil.INSTANCE, moduleName, null, 2, null);
        return !this.checkIsInstalledSnapshot(project, sdk2, packageName) && PyPIPackageUtil.INSTANCE.isInPyPI(packageName);
    }

    public final boolean checkIsInstalledSnapshot(@NotNull Project project, @NotNull Sdk sdk2, @NotNull String packageName) {
        boolean isStdLib;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Set<String> set = PyStdlibUtil.getPackages();
        boolean bl = isStdLib = set != null ? set.contains(packageName) : false;
        if (isStdLib) {
            return true;
        }
        PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk2);
        return PythonPackageManagerExt.hasInstalledPackageSnapshot$default(packageManager, packageName, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object confirmAndInstall(@NotNull Project project, @NotNull Sdk sdk, @NotNull String packageName, @Nullable PyRequirementVersionSpec versionSpec, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof confirmAndInstall.1)) ** GOTO lbl-1000
        var8_6 = $completion;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ PyPackageInstallUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.confirmAndInstall(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = project;
                $continuation.L$1 = sdk;
                $continuation.L$2 = packageName;
                $continuation.L$3 = versionSpec;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, packageName, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $packageName;
                    {
                        this.$project = $project;
                        this.$packageName = $packageName;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((boolean)PyPackageInstallUtils.INSTANCE.confirmInstall(this.$project, this.$packageName));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl28
            }
            case 1: {
                versionSpec = (PyRequirementVersionSpec)$continuation.L$3;
                packageName = (String)$continuation.L$2;
                sdk = (Sdk)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (!(isConfirmed = ((Boolean)v0).booleanValue())) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)sdk);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)packageName);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)versionSpec);
                $continuation.Z$0 = isConfirmed;
                $continuation.label = 2;
                v1 = PythonPackageManagerUiExtensionsKt.installPackageBackground$default(PythonPackageManagerUI.Companion.forSdk$default(PythonPackageManagerUI.Companion, project, sdk, null, 4, null), packageName, versionSpec, null, (Continuation)$continuation, 4, null);
                if (v1 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl48
            }
            case 2: {
                isConfirmed = $continuation.Z$0;
                versionSpec = (PyRequirementVersionSpec)$continuation.L$3;
                packageName = (String)$continuation.L$2;
                sdk = (Sdk)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object confirmAndInstall$default(PyPackageInstallUtils pyPackageInstallUtils, Project project, Sdk sdk2, String string, PyRequirementVersionSpec pyRequirementVersionSpec, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            pyRequirementVersionSpec = null;
        }
        return pyPackageInstallUtils.confirmAndInstall(project, sdk2, string, pyRequirementVersionSpec, (Continuation<? super Unit>)continuation);
    }

    public final boolean confirmInstall(@NotNull Project project, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        boolean isWellKnownPackage = ((PyPIPackageRanking)ApplicationManager.getApplication().getService(PyPIPackageRanking.class)).getPackageRank().containsKey(packageName);
        boolean confirmationEnabled = PropertiesComponent.getInstance().getBoolean("python.confirm.package.installation", true);
        if (!isWellKnownPackage && confirmationEnabled) {
            String string = PyBundle.message("python.packaging.dialog.title.install.package.confirmation", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{packageName};
            String string2 = PyBundle.message("python.packaging.dialog.message.install.package.confirmation", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            boolean confirmed = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(AllIcons.General.WarningDialog)).doNotAsk((DoNotAskOption)new ConfirmPackageInstallationDoNotAskOption())).ask(project);
            if (!confirmed) {
                return false;
            }
        }
        return true;
    }

    private static final String getConfirmedPackages$lambda$0(PyRequirement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentableTextWithoutVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableTextWithoutVersion(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/packaging/PyPackageInstallUtils$ConfirmPackageInstallationDoNotAskOption;", "Lcom/intellij/openapi/ui/DoNotAskOption$Adapter;", "<init>", "()V", "rememberChoice", "", "isSelected", "", "exitCode", "", "intellij.python.community.impl"})
    private static final class ConfirmPackageInstallationDoNotAskOption
    extends DoNotAskOption.Adapter {
        public void rememberChoice(boolean isSelected, int exitCode) {
            if (isSelected && exitCode == 0) {
                PropertiesComponent.getInstance().setValue("python.confirm.package.installation", false, true);
            }
        }
    }
}

