/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.completion.JupyterRuntimeProcessListener;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStateListener;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanel;
import com.intellij.jupyter.core.jupyter.variables.common.NotebookVarsToolWindowPanelProvider;
import com.intellij.jupyter.py.variables.JupyterVariableViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u00010B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0002J\b\u0010%\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\u0012H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u001bH\u0002J\u001e\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+H\u0002J\u0012\u0010,\u001a\u00020-2\b\b\u0001\u0010.\u001a\u00020/H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterCellExecutionListener;", "Lcom/intellij/jupyter/core/jupyter/editor/completion/JupyterRuntimeProcessListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;", "currentState", "setCurrentState", "(Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;)V", "dispose", "", "executionStarted", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "executionFinished", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "notebookSessionEnvironmentUpdated", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "values", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "isDebugging", "", "initVariableView", "clearVariables", "updateView", "refreshVariablesView", "getCurrentFile", "addServerFinishedListener", "file", "onFinished", "Lkotlin/Function0;", "createEmptyPlaceholder", "Ljavax/swing/JComponent;", "text", "", "VariableViewState", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterVariableViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVariableViewPanel.kt\ncom/intellij/jupyter/py/variables/JupyterVariableViewPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class JupyterVariableViewPanel
extends SimpleToolWindowPanel
implements FileEditorManagerListener,
JupyterCellExecutionListener,
JupyterRuntimeProcessListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private VariableViewState currentState;

    public JupyterVariableViewPanel(@NotNull Project project) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, true);
        this.project = project;
        this.currentState = VariableViewState.Loading.INSTANCE;
        MessageBusConnection $this$_init__u24lambda_u240 = messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        $this$_init__u24lambda_u240.subscribe(topic, (Object)this);
        $this$_init__u24lambda_u240.subscribe(JupyterCellExecutionListener.Companion.getTOPIC(), (Object)this);
        $this$_init__u24lambda_u240.subscribe(JupyterRuntimeProcessListener.Companion.getTOPIC(), (Object)this);
        Topic topic2 = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        $this$_init__u24lambda_u240.subscribe(topic2, (Object)new XDebuggerManagerListener(this){
            final /* synthetic */ JupyterVariableViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void currentSessionChanged(XDebugSession previousSession, XDebugSession currentSession) {
                ActionsKt.runInEdt$default(null, () -> 1.1.currentSessionChanged$lambda$0(this.this$0), (int)1, null);
            }

            private static final Unit currentSessionChanged$lambda$0(JupyterVariableViewPanel this$0) {
                if (JupyterVariableViewPanel.access$isDebugging(this$0)) {
                    JupyterVariableViewPanel.access$setCurrentState(this$0, VariableViewState.Debugging.INSTANCE);
                } else {
                    JupyterVariableViewPanel.access$refreshVariablesView(this$0);
                }
                return Unit.INSTANCE;
            }
        });
        this.initVariableView();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void setCurrentState(VariableViewState value) {
        this.currentState = value;
        this.updateView();
    }

    public void dispose() {
        VariableViewState state = this.currentState;
        if (state instanceof VariableViewState.Content) {
            Disposer.dispose((Disposable)((Disposable)((VariableViewState.Content)state).getPanel()));
        }
    }

    public void executionStarted(@NotNull JupyterExecutionTask task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> JupyterVariableViewPanel.executionStarted$lambda$1(this), (int)1, null);
    }

    public void executionFinished(@NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> JupyterVariableViewPanel.executionFinished$lambda$2(this), (int)1, null);
    }

    public void notebookSessionEnvironmentUpdated(@NotNull VirtualFile virtualFile, @Nullable XValueChildrenList values) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> JupyterVariableViewPanel.notebookSessionEnvironmentUpdated$lambda$3(this), (int)1, null);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VariableViewState variableViewState = this.currentState;
        VariableViewState.Content content = variableViewState instanceof VariableViewState.Content ? (VariableViewState.Content)variableViewState : null;
        if (content != null) {
            VariableViewState.Content state = content;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)state.getPanel()));
        }
        this.initVariableView();
    }

    private final boolean isDebugging() {
        return XDebuggerManager.getInstance((Project)this.project).getCurrentSession() != null;
    }

    private final void initVariableView() {
        BackedNotebookVirtualFile file;
        VirtualFile virtualFile;
        if (this.isDebugging()) {
            this.setCurrentState(VariableViewState.Debugging.INSTANCE);
            return;
        }
        VirtualFile virtualFile2 = this.getCurrentFile();
        if (virtualFile2 != null) {
            virtualFile = virtualFile2;
            BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
            VirtualFile p0 = virtualFile;
            boolean bl = false;
            v1 = companion.takeIfBacked(p0);
        } else {
            v1 = file = null;
        }
        if (file == null) {
            this.setCurrentState(new VariableViewState.Error(JupyterBundle.message((String)"jupyter.variables.view.not.a.notebook.file", (Object[])new Object[0])));
            return;
        }
        if (JupyterRuntimeService.Companion.getInstance(this.project).getRuntime(file.getFile()) == null) {
            this.setCurrentState(new VariableViewState.Error(JupyterBundle.message((String)"jupyter.variables.no.jupyter.session.for.file", (Object[])new Object[0])));
            return;
        }
        this.addServerFinishedListener(file.getFile(), (Function0<Unit>)((Function0)() -> JupyterVariableViewPanel.initVariableView$lambda$5(this)));
        VirtualFile it = virtualFile = NotebookVarsToolWindowPanelProvider.Companion.getAvailableToolWindowPanel(this.project, file);
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        it.rebuildView();
        VirtualFile toolWindowPanel = virtualFile;
        this.setCurrentState(new VariableViewState.Content((JupyterVarsToolWindowPanel)toolWindowPanel));
    }

    private final void clearVariables() {
        this.setCurrentState(new VariableViewState.Error(JupyterBundle.message((String)"jupyter.variables.no.jupyter.session.for.file", (Object[])new Object[0])));
    }

    private final void updateView() {
        JComponent jComponent;
        this.removeAll();
        VariableViewState state = this.currentState;
        if (state instanceof VariableViewState.Loading) {
            jComponent = this.createEmptyPlaceholder(JupyterBundle.message((String)"jupyter.variables.loading", (Object[])new Object[0]));
        } else if (state instanceof VariableViewState.Debugging) {
            jComponent = this.createEmptyPlaceholder(JupyterBundle.message((String)"jupyter.variables.debugging", (Object[])new Object[0]));
        } else if (state instanceof VariableViewState.Content) {
            jComponent = (JComponent)((VariableViewState.Content)state).getPanel();
        } else if (state instanceof VariableViewState.Error) {
            String message2 = ((VariableViewState.Error)state).getMessage();
            jComponent = this.createEmptyPlaceholder(message2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JComponent view = jComponent;
        this.setContent(view);
        view.requestFocusInWindow();
    }

    private final void refreshVariablesView() {
        if (this.isDebugging()) {
            this.setCurrentState(VariableViewState.Debugging.INSTANCE);
            return;
        }
        VariableViewState state = this.currentState;
        if (state instanceof VariableViewState.Content) {
            JupyterVarsToolWindowPanel jupyterVarsToolWindowPanel;
            JupyterVarsToolWindowPanel $this$refreshVariablesView_u24lambda_u247 = jupyterVarsToolWindowPanel = ((VariableViewState.Content)state).getPanel();
            boolean bl = false;
            $this$refreshVariablesView_u24lambda_u247.rebuildView();
            $this$refreshVariablesView_u24lambda_u247.setToolbar(null);
        } else {
            this.initVariableView();
        }
    }

    private final VirtualFile getCurrentFile() {
        if (this.project.isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        FileEditor fileEditor = fileEditorManager != null ? fileEditorManager.getSelectedEditor() : null;
        JupyterFileEditor jupyterFileEditor = fileEditor instanceof JupyterFileEditor ? (JupyterFileEditor)fileEditor : null;
        if (jupyterFileEditor == null) {
            return null;
        }
        JupyterFileEditor fileEditor2 = jupyterFileEditor;
        return fileEditor2.getNotebookFile();
    }

    private final void addServerFinishedListener(VirtualFile file, Function0<Unit> onFinished) {
        JupyterNotebookRuntimeSettings settings = JupyterRuntimeService.Companion.getInstance(this.project).getRuntime(file);
        if (!(settings instanceof ManagedJupyterServerNotebookSessionSettings)) {
            return;
        }
        ((ManagedJupyterServerNotebookSessionSettings)settings).getJupyterServerExecution().addStateListener(new JupyterServerStateListener(onFinished){
            final /* synthetic */ Function0<Unit> $onFinished;
            {
                this.$onFinished = $onFinished;
            }

            public void stateChanged(JupyterServerState newState) {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                if (!(newState instanceof JupyterServerFinished)) {
                    return;
                }
                ActionsKt.runInEdt((ModalityState)ModalityState.defaultModalityState(), () -> addServerFinishedListener.1.stateChanged$lambda$0(this.$onFinished));
            }

            private static final Unit stateChanged$lambda$0(Function0 $onFinished) {
                $onFinished.invoke();
                return Unit.INSTANCE;
            }
        });
    }

    private final JComponent createEmptyPlaceholder(@Nls String text) {
        BorderLayout borderLayout = new BorderLayout();
        return new JPanel(text, borderLayout){
            {
                this.setFocusable(true);
                JBLabel label = new JBLabel($text);
                label.setHorizontalAlignment(0);
                label.setFontColor(UIUtil.FontColor.BRIGHTER);
                this.add((Component)label, "Center");
                this.setBorder(null);
            }
        };
    }

    private static final Unit executionStarted$lambda$1(JupyterVariableViewPanel this$0) {
        if (this$0.currentState instanceof VariableViewState.Content) {
            return Unit.INSTANCE;
        }
        this$0.initVariableView();
        return Unit.INSTANCE;
    }

    private static final Unit executionFinished$lambda$2(JupyterVariableViewPanel this$0) {
        this$0.refreshVariablesView();
        return Unit.INSTANCE;
    }

    private static final Unit notebookSessionEnvironmentUpdated$lambda$3(JupyterVariableViewPanel this$0) {
        this$0.refreshVariablesView();
        return Unit.INSTANCE;
    }

    private static final Unit initVariableView$lambda$5(JupyterVariableViewPanel this$0) {
        this$0.clearVariables();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isDebugging(JupyterVariableViewPanel $this) {
        return $this.isDebugging();
    }

    public static final /* synthetic */ void access$setCurrentState(JupyterVariableViewPanel $this, VariableViewState value) {
        $this.setCurrentState(value);
    }

    public static final /* synthetic */ void access$refreshVariablesView(JupyterVariableViewPanel $this) {
        $this.refreshVariablesView();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;", "", "<init>", "()V", "Loading", "Debugging", "Error", "Content", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Content;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Debugging;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Error;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Loading;", "intellij.jupyter.py"})
    private static abstract class VariableViewState {
        private VariableViewState() {
        }

        public /* synthetic */ VariableViewState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Content;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;", "panel", "Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;)V", "getPanel", "()Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.jupyter.py"})
        public static final class Content
        extends VariableViewState {
            @NotNull
            private final JupyterVarsToolWindowPanel panel;

            public Content(@NotNull JupyterVarsToolWindowPanel panel) {
                Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                super(null);
                this.panel = panel;
            }

            @NotNull
            public final JupyterVarsToolWindowPanel getPanel() {
                return this.panel;
            }

            @NotNull
            public final JupyterVarsToolWindowPanel component1() {
                return this.panel;
            }

            @NotNull
            public final Content copy(@NotNull JupyterVarsToolWindowPanel panel) {
                Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                return new Content(panel);
            }

            public static /* synthetic */ Content copy$default(Content content, JupyterVarsToolWindowPanel jupyterVarsToolWindowPanel, int n, Object object) {
                if ((n & 1) != 0) {
                    jupyterVarsToolWindowPanel = content.panel;
                }
                return content.copy(jupyterVarsToolWindowPanel);
            }

            @NotNull
            public String toString() {
                return "Content(panel=" + this.panel + ")";
            }

            public int hashCode() {
                return this.panel.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Content)) {
                    return false;
                }
                Content content = (Content)other;
                return Intrinsics.areEqual((Object)this.panel, (Object)content.panel);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Debugging;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;", "<init>", "()V", "intellij.jupyter.py"})
        public static final class Debugging
        extends VariableViewState {
            @NotNull
            public static final Debugging INSTANCE = new Debugging();

            private Debugging() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Error;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.jupyter.py"})
        public static final class Error
        extends VariableViewState {
            @NotNull
            private final String message;

            public Error(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                super(null);
                this.message = message2;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new Error(message2);
            }

            public static /* synthetic */ Error copy$default(Error error, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error.message;
                }
                return error.copy(string);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState$Loading;", "Lcom/intellij/jupyter/py/variables/JupyterVariableViewPanel$VariableViewState;", "<init>", "()V", "intellij.jupyter.py"})
        public static final class Loading
        extends VariableViewState {
            @NotNull
            public static final Loading INSTANCE = new Loading();

            private Loading() {
                super(null);
            }
        }
    }
}

