/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.diff.editor.DiffViewerVirtualFile;
import com.intellij.diff.editor.DiffVirtualFileWithTabName;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.impl.DiffEditorViewerListener;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.platform.vcs.backend.split.diff.BackendServerDiffManagerKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeDynamicControlContainer;
import com.jetbrains.rd.ide.model.diffViewer.DiffBeFileEditorModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/vcs/backend/split/DiffRequestDirectTransferModelHandler;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "file", "Lcom/intellij/diff/editor/DiffViewerVirtualFile;", "processor", "Lcom/intellij/diff/impl/DiffEditorViewer;", "beContainer", "Lcom/jetbrains/ide/model/uiautomation/BeDynamicControlContainer;", "chainModel", "Lcom/jetbrains/rd/ide/model/diffViewer/DiffBeFileEditorModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/diff/editor/DiffViewerVirtualFile;Lcom/intellij/diff/impl/DiffEditorViewer;Lcom/jetbrains/ide/model/uiautomation/BeDynamicControlContainer;Lcom/jetbrains/rd/ide/model/diffViewer/DiffBeFileEditorModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getFileEditor", "()Lcom/intellij/openapi/fileEditor/FileEditor;", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getFile", "()Lcom/intellij/diff/editor/DiffViewerVirtualFile;", "updateDiffTitle", "", "MyProcessorListener", "intellij.platform.vcs.backend.split"})
public final class DiffRequestDirectTransferModelHandler {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FileEditor fileEditor;
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final DiffViewerVirtualFile file;
    @NotNull
    private final DiffEditorViewer processor;
    @NotNull
    private final DiffBeFileEditorModel chainModel;

    public DiffRequestDirectTransferModelHandler(@NotNull Lifetime lifetime, @NotNull FileEditor fileEditor, @NotNull ClientProjectSession session, @NotNull DiffViewerVirtualFile file, @NotNull DiffEditorViewer processor, @NotNull BeDynamicControlContainer beContainer, @NotNull DiffBeFileEditorModel chainModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)beContainer, (String)"beContainer");
        Intrinsics.checkNotNullParameter((Object)chainModel, (String)"chainModel");
        this.lifetime = lifetime;
        this.fileEditor = fileEditor;
        this.session = session;
        this.file = file;
        this.processor = processor;
        this.chainModel = chainModel;
        UIUtil.markAsShowing((JComponent)this.processor.getComponent(), (boolean)true);
        UiNotifyConnector.Companion.forceNotifyIsShown((Component)this.processor.getComponent());
        this.lifetime.onTermination(() -> DiffRequestDirectTransferModelHandler._init_$lambda$0(this));
        BeControl content = ConverterRegistryKt.toBeModel((Component)this.processor.getComponent(), (TrackOptions)new TrackOptions(this.session.getAppSession(), false, null, null, false, null, null, null, false, null, null, 2046, null), (Lifetime)this.lifetime);
        beContainer.getContent().set((Object)content);
        this.processor.addListener((DiffEditorViewerListener)new MyProcessorListener(), null);
        this.updateDiffTitle();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final FileEditor getFileEditor() {
        return this.fileEditor;
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final DiffViewerVirtualFile getFile() {
        return this.file;
    }

    private final void updateDiffTitle() {
        String string;
        if (this.file instanceof PreviewDiffVirtualFile && this.processor instanceof DiffRequestProcessor) {
            string = ((PreviewDiffVirtualFile)this.file).getProvider().getEditorTabName((DiffRequestProcessor)this.processor);
        } else if (this.file instanceof DiffVirtualFileWithTabName) {
            String title = ((DiffVirtualFileWithTabName)this.file).getEditorTabName(this.session.getProject(), CollectionsKt.listOf((Object)this.fileEditor));
            String string2 = title;
            if (string2 == null) {
                String string3 = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            string = BackendServerDiffManagerKt.getDiffEditorTabName(string2);
        } else {
            String string4 = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            string = BackendServerDiffManagerKt.getDiffEditorTabName(string4);
        }
        String tabName = string;
        this.chainModel.getTabTitle().set((Object)tabName);
    }

    private static final Unit _init_$lambda$0(DiffRequestDirectTransferModelHandler this$0) {
        UIUtil.markAsShowing((JComponent)this$0.processor.getComponent(), (boolean)false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/vcs/backend/split/DiffRequestDirectTransferModelHandler$MyProcessorListener;", "Lcom/intellij/diff/impl/DiffEditorViewerListener;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/DiffRequestDirectTransferModelHandler;)V", "onActiveFileChanged", "", "intellij.platform.vcs.backend.split"})
    private final class MyProcessorListener
    implements DiffEditorViewerListener {
        public void onActiveFileChanged() {
            DiffRequestDirectTransferModelHandler.this.updateDiffTitle();
        }
    }
}

