/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.qt.clion.actions.newFile;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.qt.common.QTCommonIcons;
import com.intellij.qt.common.QtBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.ui.OCListWithEmptyItemHintRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPQtUiClassAction
extends OCNewFileWithSelectedExtensionAction<MyCreateClassDialog> {
    @NonNls
    protected static final String QT_CLASS_TEMPLATE_NAME = "Qt Class.cpp";
    @NonNls
    protected static final String QT_CLASS_HEADER_TEMPLATE_NAME = "Qt Class Header.h";
    @NonNls
    protected static final String QT_FORM_UI_TEMPLATE_NAME = "Qt Designer Form.ui";
    @NonNls
    protected static final String QT_PARENT_CLASS_PROPERTY = "PARENT_CLASS";
    @NonNls
    protected static final String QT_USER_BEGIN_NAMESPACE_PROPERTY = "USER_BEGIN_NAMESPACE";
    @NonNls
    protected static final String QT_USER_END_NAMESPACE_PROPERTY = "USER_END_NAMESPACE";
    @NonNls
    protected static final String QT_NAMESPACE_SPECIFIER_PROPERTY = "NAMESPACE_SPECIFIER";
    @NonNls
    protected static final String QT_UI_HEADER_FILENAME_TEMPLATE_PROPERTY = "UI_HEADER_FILENAME";
    @NonNls
    protected static final String QT_CLASS_DEPENDENT_CONTENT = "CLASS_DEPENDENT_CONTENT";
    @NonNls
    private static final String NEW_QT_CLASS_HELP_TOPIC_ID = "dialogs.newqtuiclass";
    @NonNls
    protected String myFilename = "";
    @NonNls
    protected Ref<String> myParentClass = new Ref((Object)"");
    @NonNls
    protected Ref<String> myEnclosingNamespace = new Ref((Object)"");

    public CPPQtUiClassAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), QtBundle.message("create.cpp.qt.ui.class.title", new Object[0]), QtBundle.message("create.cpp.qt.ui.class.description", new Object[0]), QTCommonIcons.QT);
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        LOG.assertTrue(this.getState() != null, (Object)"state");
        LOG.assertTrue(this.myFilename != null, (Object)"name");
        return CPPQtUiClassAction.getNewNames(this.myFilename, this.getExtensions(this.getState().project).get(0));
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(this.myFilename != null, (Object)"name");
        return CPPQtUiClassAction.getNewNames(this.myFilename, this.getExtensions(this.getState().project).get(0));
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewNames(@NotNull String selectedName, FileExtensionPair pair) {
        if (selectedName == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(1);
        }
        return new OCNewFileActionBase.NewFileNames(selectedName + "." + pair.mySourceExt, selectedName + "." + pair.myHeaderExt, Collections.singletonList(selectedName + ".ui"));
    }

    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(2);
        }
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        String headerName;
        properties.setProperty(QT_PARENT_CLASS_PROPERTY, (String)this.myParentClass.get());
        if (!((String)this.myEnclosingNamespace.get()).isEmpty()) {
            String enclosingNamespace = (String)this.myEnclosingNamespace.get();
            properties.setProperty(QT_NAMESPACE_SPECIFIER_PROPERTY, enclosingNamespace + "::");
            properties.setProperty(QT_USER_BEGIN_NAMESPACE_PROPERTY, "namespace " + enclosingNamespace + " {");
            properties.setProperty(QT_USER_END_NAMESPACE_PROPERTY, "} // " + enclosingNamespace);
        } else {
            properties.setProperty(QT_NAMESPACE_SPECIFIER_PROPERTY, "");
            properties.setProperty(QT_USER_BEGIN_NAMESPACE_PROPERTY, "");
            properties.setProperty(QT_USER_END_NAMESPACE_PROPERTY, "");
        }
        if (this.getState() != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        String uiHeaderName = this.mySelectedName.equalsIgnoreCase(this.myFilename) ? "ui_" + this.mySelectedName + ".h" : "ui_" + this.myFilename + ".h";
        properties.setProperty(QT_UI_HEADER_FILENAME_TEMPLATE_PROPERTY, uiHeaderName);
        properties.setProperty(QT_CLASS_DEPENDENT_CONTENT, ((String)this.myParentClass.get()).equals("QMainWindow") ? "\n    <widget class=\"QWidget\" name=\"centralwidget\"/>\n    <widget class=\"QMenuBar\" name=\"menubar\">\n      <property name=\"geometry\">\n        <rect>\n          <x>0</x>\n          <y>0</y>\n          <width>400</width>\n          <height>17</height>\n        </rect>\n      </property>\n    </widget>\n    <widget class=\"QStatusBar\" name=\"statusbar\"/>" : "");
    }

    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return QT_CLASS_TEMPLATE_NAME;
        }
        if (OCFileTypeHelpers.isHeaderFile((String)fileName)) {
            return QT_CLASS_HEADER_TEMPLATE_NAME;
        }
        if (fileName.endsWith(".ui")) {
            return QT_FORM_UI_TEMPLATE_NAME;
        }
        assert (false);
        return null;
    }

    @NotNull
    protected MyCreateClassDialog createDialog(@NlsContexts.Label @NotNull String defaultName) {
        if (defaultName == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(3);
        }
        return new MyCreateClassDialog(defaultName, this.getHelpId());
    }

    @NotNull
    protected List<FileExtensionPair> getExtensions(@NotNull Project project) {
        FileExtensionPair extensionPair;
        if (project == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(4);
        }
        if ((extensionPair = (FileExtensionPair)ContainerUtil.find((Iterable)super.getExtensions(project), pair -> OCNewFileLangBackendHandlerProvider.getHandler().isCppFileExtension("." + pair.mySourceExt, project))) == null) {
            extensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
        }
        List<FileExtensionPair> list = Collections.singletonList(extensionPair);
        if (list == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected void selectResult(@NotNull IdeView view, PsiFile @NotNull [] createdElements) {
        if (view == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(6);
        }
        if (createdElements == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(7);
        }
        ContainerUtil.sort((Object[])createdElements, Comparator.comparing(psiFile -> psiFile.getName().endsWith(".h")));
        super.selectResult(view, createdElements);
    }

    @NotNull
    @NonNls
    protected String getHelpId() {
        return NEW_QT_CLASS_HELP_TOPIC_ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/qt/clion/actions/newFile/CPPQtUiClassAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/qt/clion/actions/newFile/CPPQtUiClassAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNewNames";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        @NlsSafe
        private static final String DUMMY = "Dummy";
        private JTextField myFilenameBaseField;
        private final @NlsContexts.Label @NotNull String myFilenameBaseFieldTitle;
        @NlsSafe
        private static final String myMainWindowClass = "QMainWindow";
        @NlsSafe
        private final String[] myAllowedParentClasses;
        @NlsSafe
        private static final String myMainWindowSpecialContent = "\n    <widget class=\"QWidget\" name=\"centralwidget\"/>\n    <widget class=\"QMenuBar\" name=\"menubar\">\n      <property name=\"geometry\">\n        <rect>\n          <x>0</x>\n          <y>0</y>\n          <width>400</width>\n          <height>17</height>\n        </rect>\n      </property>\n    </widget>\n    <widget class=\"QStatusBar\" name=\"statusbar\"/>";
        private boolean mySyncFilename;
        private boolean myChangedFromCode;

        public MyCreateClassDialog(@Nullable String defaultName, String helpId) {
            super((OCNewFileWithSelectedExtensionAction)CPPQtUiClassAction.this, QtBundle.message("create.cpp.qt.ui.class.title", new Object[0]), defaultName, helpId);
            this.myAllowedParentClasses = new String[]{"QWidget", myMainWindowClass, "QDialog"};
            this.mySyncFilename = true;
            this.myChangedFromCode = false;
            this.myFilenameBaseFieldTitle = QtBundle.message("create.cpp.qt.filename.base.title", new Object[0]);
            CPPQtUiClassAction.this.myEnclosingNamespace.set((Object)"");
        }

        @Nullable
        protected String collectOkActionErrors() {
            if (StringUtil.isEmptyOrSpaces((String)this.myFilenameBaseField.getText())) {
                return "";
            }
            String parent = (String)CPPQtUiClassAction.this.myParentClass.get();
            if (!StringUtil.isJavaIdentifier((String)parent)) {
                return QtBundle.message("create.cpp.qt.ui.invalid.parent.message", new Object[0]);
            }
            if (!OCNewFileHelperUtil.isValidNamespaceName((String)((String)CPPQtUiClassAction.this.myEnclosingNamespace.get()))) {
                return CidrLangBundle.message((String)"create.cpp.invalid.namespace.name.message", (Object[])new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.addFilenameField(formBuilder);
            this.addParentCombobox(formBuilder);
            OCNewFileHelperUtil.addTextEdit((OCNewFileActionBase.CreateFileDialogBase)this, (FormBuilder)formBuilder, CPPQtUiClassAction.this.myEnclosingNamespace, (String)"", (String)CidrLangBundle.message((String)"create.cpp.enclosing.namespace.title", (Object[])new Object[0]));
        }

        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, false);
        }

        private void addFilenameField(FormBuilder formBuilder) {
            this.myFilenameBaseField = new JTextField();
            this.myFilenameBaseField.setText(this.myNameField.getText());
            this.myFilenameBaseField.setMinimumSize(new Dimension(250, this.myNameField.getPreferredSize().height));
            this.myFilenameBaseField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    MyCreateClassDialog.this.validateOkAction();
                    if (!MyCreateClassDialog.this.myChangedFromCode && MyCreateClassDialog.this.mySyncFilename) {
                        MyCreateClassDialog.this.mySyncFilename = false;
                    }
                    CPPQtUiClassAction.this.myFilename = MyCreateClassDialog.this.myFilenameBaseField.getText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
            JTextField nameFieldComponent = this.myFilenameBaseField;
            formBuilder.addLabeledComponent(this.myFilenameBaseFieldTitle, (JComponent)nameFieldComponent);
            this.myFilenameBaseField.setEnabled(this.isNameFieldEnabled());
            this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    if (MyCreateClassDialog.this.mySyncFilename) {
                        try {
                            MyCreateClassDialog.this.myChangedFromCode = true;
                            MyCreateClassDialog.this.myFilenameBaseField.setText(MyCreateClassDialog.this.myNameField.getText().toLowerCase(Locale.ENGLISH));
                        }
                        finally {
                            MyCreateClassDialog.this.myChangedFromCode = false;
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
        }

        private void addParentCombobox(FormBuilder formBuilder) {
            ComboBox combo = new ComboBox();
            FixedComboBoxEditor comboEditor = new FixedComboBoxEditor();
            combo.setEditor((ComboBoxEditor)comboEditor);
            combo.setEditable(true);
            combo.setRenderer((ListCellRenderer)new OCListWithEmptyItemHintRenderer(QtBundle.message("create.cpp.qt.custom.class.title", new Object[0])));
            for (String parentClass : this.myAllowedParentClasses) {
                combo.addItem((Object)parentClass);
            }
            combo.addItem((Object)"");
            JTextField textEdit = (JTextField)comboEditor.getEditorComponent();
            OCNewFileHelperUtil.initPropertyField((OCNewFileActionBase.CreateFileDialogBase)this, (JTextField)textEdit, CPPQtUiClassAction.this.myParentClass);
            combo.setSelectedIndex(0);
            CPPQtUiClassAction.this.myParentClass.set((Object)((String)combo.getItem()));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)combo);
            formBuilder.addLabeledComponent(QtBundle.message("create.cpp.qt.parent.class.title", new Object[0]), (JComponent)panel);
        }

        protected void createFileTypesCombo(FormBuilder formBuilder) {
            this.myKindCombo = new TemplateKindCombo();
            this.myKindCombo.addItem(DUMMY, null, DUMMY);
        }

        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            if (pair == null) {
                MyCreateClassDialog.$$$reportNull$$$0(0);
            }
            String name = super.getPresentableName(pair);
            NamingConventionStyle nc = pair.myFileNamingConvention;
            Object object = nc == NamingConventionStyle.NONE ? name : name + "  [" + String.valueOf(nc) + "]";
            if (object == null) {
                MyCreateClassDialog.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/qt/clion/actions/newFile/CPPQtUiClassAction$MyCreateClassDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/qt/clion/actions/newFile/CPPQtUiClassAction$MyCreateClassDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

