#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <sys/time.h>
#include <scsi/scsi_ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

static volatile int stop = 0;

void usage(void)
{
	fprintf(stderr, "httping, (C) 2003 folkert@vanheusden.com\n\n");
	fprintf(stderr, "-d device	device (e.g. /dev/sdb)\n");
	fprintf(stderr, "-c count	how many times to connect\n");
	fprintf(stderr, "-i interval	delay between each connect\n");
	fprintf(stderr, "-f		flood connect (no delays)\n");
	fprintf(stderr, "-q		quiet, only returncode\n\n");
}

void handler(int sig)
{
	stop = 1;
}

int main(int argc, char *argv[])
{
	char *device = NULL;
	int c;
	int count = -1, curncount = 0;
	int wait = 1, quiet = 0;
	int ok = 0, err = 0;
	double min = 999999999999999.0, avg = 0.0, max = 0.0;

        while((c = getopt(argc, argv, "d:hc:i:fq?")) != -1)
        {
                switch(c)
                {
		case 'd':
			device = optarg;
			break;

		case 'c':
			count = atoi(optarg);
			break;

		case 'i':
			wait = atoi(optarg);
			break;

		case 'f':
			wait = 0;
			break;

		case 'q':
			quiet = 1;
			break;

		case 'h':
		case '?':
		default:
			usage();
			return 0;
		}
	}

	if (device == NULL)
	{
		fprintf(stderr, "No device given! (use -d)\n");
		usage();
		return 1;
	}

	if (!quiet)
		printf("PING %s:\n", device);

	signal(SIGINT, handler);
	signal(SIGTERM, handler);

	while((curncount < count || count == -1) && stop == 0)
	{
		double ms;
		double dstart, dend;
		struct timeval start, end;
        	struct timezone tz;
		int fd;
		int rc;

		if (gettimeofday(&start, &tz) == -1)
			perror("gettimeofday");

		fd = open(device, O_RDONLY);
		if (fd == -1)
		{
			fprintf(stderr, "Cannot open device %s: %s\n", device, strerror(errno));
			return 2;
		}

		rc = ioctl(fd, SCSI_IOCTL_TEST_UNIT_READY);
		if (rc == -1)
		{
			printf("error: %s\n", strerror(errno));
			err++;
		}
		else
		{
			ok++;

			if (gettimeofday(&end, &tz) == -1)
				perror("gettimeofday");

			dstart = (((double)start.tv_sec) + ((double)start.tv_usec)/1000000.0);
			dend = (((double)end.tv_sec) + ((double)end.tv_usec)/1000000.0);
			ms = (dend - dstart) * 1000.0;
			avg += ms;
			min = min > ms ? ms : min;
			max = max < ms ? ms : max;

			printf("reply from to %s, seq=%d time=%.2f ms\n", device, curncount++, (dend - dstart) * 1000.0);
		}

		close(fd);

		if (curncount != count)
			sleep(wait);
	}

	if (!quiet)
	{
		printf("--- %s ping statistics ---\n", device);
		printf("%d test units, %d ok, %3.2f%% failed\n", curncount, ok, (((double)err) / ((double)count)) * 100.0);
		printf("round-trip min/avg/max = %.1f/%.1f/%.1f ms\n", min, avg / (double)ok, max);
	}

	if (ok)
		return 0;
	else
		return 127;
}
