package frontdoor

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAllow ...
	ActionTypeAllow ActionType = "Allow"
	// ActionTypeBlock ...
	ActionTypeBlock ActionType = "Block"
	// ActionTypeLog ...
	ActionTypeLog ActionType = "Log"
	// ActionTypeRedirect ...
	ActionTypeRedirect ActionType = "Redirect"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAllow, ActionTypeBlock, ActionTypeLog, ActionTypeRedirect}
}

// AggregationInterval enumerates the values for aggregation interval.
type AggregationInterval string

const (
	// AggregationIntervalDaily ...
	AggregationIntervalDaily AggregationInterval = "Daily"
	// AggregationIntervalHourly ...
	AggregationIntervalHourly AggregationInterval = "Hourly"
)

// PossibleAggregationIntervalValues returns an array of possible values for the AggregationInterval const type.
func PossibleAggregationIntervalValues() []AggregationInterval {
	return []AggregationInterval{AggregationIntervalDaily, AggregationIntervalHourly}
}

// Availability enumerates the values for availability.
type Availability string

const (
	// AvailabilityAvailable ...
	AvailabilityAvailable Availability = "Available"
	// AvailabilityUnavailable ...
	AvailabilityUnavailable Availability = "Unavailable"
)

// PossibleAvailabilityValues returns an array of possible values for the Availability const type.
func PossibleAvailabilityValues() []Availability {
	return []Availability{AvailabilityAvailable, AvailabilityUnavailable}
}

// BackendEnabledState enumerates the values for backend enabled state.
type BackendEnabledState string

const (
	// BackendEnabledStateDisabled ...
	BackendEnabledStateDisabled BackendEnabledState = "Disabled"
	// BackendEnabledStateEnabled ...
	BackendEnabledStateEnabled BackendEnabledState = "Enabled"
)

// PossibleBackendEnabledStateValues returns an array of possible values for the BackendEnabledState const type.
func PossibleBackendEnabledStateValues() []BackendEnabledState {
	return []BackendEnabledState{BackendEnabledStateDisabled, BackendEnabledStateEnabled}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceFrontDoor ...
	CertificateSourceFrontDoor CertificateSource = "FrontDoor"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceFrontDoor}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// CertificateTypeDedicated ...
	CertificateTypeDedicated CertificateType = "Dedicated"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{CertificateTypeDedicated}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// CustomHTTPSProvisioningStateDisabled ...
	CustomHTTPSProvisioningStateDisabled CustomHTTPSProvisioningState = "Disabled"
	// CustomHTTPSProvisioningStateDisabling ...
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = "Disabling"
	// CustomHTTPSProvisioningStateEnabled ...
	CustomHTTPSProvisioningStateEnabled CustomHTTPSProvisioningState = "Enabled"
	// CustomHTTPSProvisioningStateEnabling ...
	CustomHTTPSProvisioningStateEnabling CustomHTTPSProvisioningState = "Enabling"
	// CustomHTTPSProvisioningStateFailed ...
	CustomHTTPSProvisioningStateFailed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{CustomHTTPSProvisioningStateDisabled, CustomHTTPSProvisioningStateDisabling, CustomHTTPSProvisioningStateEnabled, CustomHTTPSProvisioningStateEnabling, CustomHTTPSProvisioningStateFailed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CustomHTTPSProvisioningSubstateCertificateDeleted ...
	CustomHTTPSProvisioningSubstateCertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CustomHTTPSProvisioningSubstateCertificateDeployed ...
	CustomHTTPSProvisioningSubstateCertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// CustomHTTPSProvisioningSubstateDeletingCertificate ...
	CustomHTTPSProvisioningSubstateDeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// CustomHTTPSProvisioningSubstateDeployingCertificate ...
	CustomHTTPSProvisioningSubstateDeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved ...
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected ...
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut ...
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// CustomHTTPSProvisioningSubstateIssuingCertificate ...
	CustomHTTPSProvisioningSubstateIssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval ...
	CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest ...
	CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CustomHTTPSProvisioningSubstateCertificateDeleted, CustomHTTPSProvisioningSubstateCertificateDeployed, CustomHTTPSProvisioningSubstateDeletingCertificate, CustomHTTPSProvisioningSubstateDeployingCertificate, CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved, CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected, CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut, CustomHTTPSProvisioningSubstateIssuingCertificate, CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval, CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest}
}

// CustomRuleEnabledState enumerates the values for custom rule enabled state.
type CustomRuleEnabledState string

const (
	// CustomRuleEnabledStateDisabled ...
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	// CustomRuleEnabledStateEnabled ...
	CustomRuleEnabledStateEnabled CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns an array of possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{CustomRuleEnabledStateDisabled, CustomRuleEnabledStateEnabled}
}

// DynamicCompressionEnabled enumerates the values for dynamic compression enabled.
type DynamicCompressionEnabled string

const (
	// DynamicCompressionEnabledDisabled ...
	DynamicCompressionEnabledDisabled DynamicCompressionEnabled = "Disabled"
	// DynamicCompressionEnabledEnabled ...
	DynamicCompressionEnabledEnabled DynamicCompressionEnabled = "Enabled"
)

// PossibleDynamicCompressionEnabledValues returns an array of possible values for the DynamicCompressionEnabled const type.
func PossibleDynamicCompressionEnabledValues() []DynamicCompressionEnabled {
	return []DynamicCompressionEnabled{DynamicCompressionEnabledDisabled, DynamicCompressionEnabledEnabled}
}

// EnabledState enumerates the values for enabled state.
type EnabledState string

const (
	// EnabledStateDisabled ...
	EnabledStateDisabled EnabledState = "Disabled"
	// EnabledStateEnabled ...
	EnabledStateEnabled EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns an array of possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{EnabledStateDisabled, EnabledStateEnabled}
}

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// EndpointTypeAFD ...
	EndpointTypeAFD EndpointType = "AFD"
	// EndpointTypeATM ...
	EndpointTypeATM EndpointType = "ATM"
	// EndpointTypeAzureRegion ...
	EndpointTypeAzureRegion EndpointType = "AzureRegion"
	// EndpointTypeCDN ...
	EndpointTypeCDN EndpointType = "CDN"
)

// PossibleEndpointTypeValues returns an array of possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{EndpointTypeAFD, EndpointTypeATM, EndpointTypeAzureRegion, EndpointTypeCDN}
}

// EnforceCertificateNameCheckEnabledState enumerates the values for enforce certificate name check enabled
// state.
type EnforceCertificateNameCheckEnabledState string

const (
	// EnforceCertificateNameCheckEnabledStateDisabled ...
	EnforceCertificateNameCheckEnabledStateDisabled EnforceCertificateNameCheckEnabledState = "Disabled"
	// EnforceCertificateNameCheckEnabledStateEnabled ...
	EnforceCertificateNameCheckEnabledStateEnabled EnforceCertificateNameCheckEnabledState = "Enabled"
)

// PossibleEnforceCertificateNameCheckEnabledStateValues returns an array of possible values for the EnforceCertificateNameCheckEnabledState const type.
func PossibleEnforceCertificateNameCheckEnabledStateValues() []EnforceCertificateNameCheckEnabledState {
	return []EnforceCertificateNameCheckEnabledState{EnforceCertificateNameCheckEnabledStateDisabled, EnforceCertificateNameCheckEnabledStateEnabled}
}

// ForwardingProtocol enumerates the values for forwarding protocol.
type ForwardingProtocol string

const (
	// ForwardingProtocolHTTPOnly ...
	ForwardingProtocolHTTPOnly ForwardingProtocol = "HttpOnly"
	// ForwardingProtocolHTTPSOnly ...
	ForwardingProtocolHTTPSOnly ForwardingProtocol = "HttpsOnly"
	// ForwardingProtocolMatchRequest ...
	ForwardingProtocolMatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns an array of possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{ForwardingProtocolHTTPOnly, ForwardingProtocolHTTPSOnly, ForwardingProtocolMatchRequest}
}

// HeaderActionType enumerates the values for header action type.
type HeaderActionType string

const (
	// HeaderActionTypeAppend ...
	HeaderActionTypeAppend HeaderActionType = "Append"
	// HeaderActionTypeDelete ...
	HeaderActionTypeDelete HeaderActionType = "Delete"
	// HeaderActionTypeOverwrite ...
	HeaderActionTypeOverwrite HeaderActionType = "Overwrite"
)

// PossibleHeaderActionTypeValues returns an array of possible values for the HeaderActionType const type.
func PossibleHeaderActionTypeValues() []HeaderActionType {
	return []HeaderActionType{HeaderActionTypeAppend, HeaderActionTypeDelete, HeaderActionTypeOverwrite}
}

// HealthProbeEnabled enumerates the values for health probe enabled.
type HealthProbeEnabled string

const (
	// HealthProbeEnabledDisabled ...
	HealthProbeEnabledDisabled HealthProbeEnabled = "Disabled"
	// HealthProbeEnabledEnabled ...
	HealthProbeEnabledEnabled HealthProbeEnabled = "Enabled"
)

// PossibleHealthProbeEnabledValues returns an array of possible values for the HealthProbeEnabled const type.
func PossibleHealthProbeEnabledValues() []HealthProbeEnabled {
	return []HealthProbeEnabled{HealthProbeEnabledDisabled, HealthProbeEnabledEnabled}
}

// HealthProbeMethod enumerates the values for health probe method.
type HealthProbeMethod string

const (
	// HealthProbeMethodGET ...
	HealthProbeMethodGET HealthProbeMethod = "GET"
	// HealthProbeMethodHEAD ...
	HealthProbeMethodHEAD HealthProbeMethod = "HEAD"
)

// PossibleHealthProbeMethodValues returns an array of possible values for the HealthProbeMethod const type.
func PossibleHealthProbeMethodValues() []HealthProbeMethod {
	return []HealthProbeMethod{HealthProbeMethodGET, HealthProbeMethodHEAD}
}

// LatencyScorecardAggregationInterval enumerates the values for latency scorecard aggregation interval.
type LatencyScorecardAggregationInterval string

const (
	// LatencyScorecardAggregationIntervalDaily ...
	LatencyScorecardAggregationIntervalDaily LatencyScorecardAggregationInterval = "Daily"
	// LatencyScorecardAggregationIntervalMonthly ...
	LatencyScorecardAggregationIntervalMonthly LatencyScorecardAggregationInterval = "Monthly"
	// LatencyScorecardAggregationIntervalWeekly ...
	LatencyScorecardAggregationIntervalWeekly LatencyScorecardAggregationInterval = "Weekly"
)

// PossibleLatencyScorecardAggregationIntervalValues returns an array of possible values for the LatencyScorecardAggregationInterval const type.
func PossibleLatencyScorecardAggregationIntervalValues() []LatencyScorecardAggregationInterval {
	return []LatencyScorecardAggregationInterval{LatencyScorecardAggregationIntervalDaily, LatencyScorecardAggregationIntervalMonthly, LatencyScorecardAggregationIntervalWeekly}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// ManagedRuleExclusionMatchVariable enumerates the values for managed rule exclusion match variable.
type ManagedRuleExclusionMatchVariable string

const (
	// ManagedRuleExclusionMatchVariableQueryStringArgNames ...
	ManagedRuleExclusionMatchVariableQueryStringArgNames ManagedRuleExclusionMatchVariable = "QueryStringArgNames"
	// ManagedRuleExclusionMatchVariableRequestBodyJSONArgNames ...
	ManagedRuleExclusionMatchVariableRequestBodyJSONArgNames ManagedRuleExclusionMatchVariable = "RequestBodyJsonArgNames"
	// ManagedRuleExclusionMatchVariableRequestBodyPostArgNames ...
	ManagedRuleExclusionMatchVariableRequestBodyPostArgNames ManagedRuleExclusionMatchVariable = "RequestBodyPostArgNames"
	// ManagedRuleExclusionMatchVariableRequestCookieNames ...
	ManagedRuleExclusionMatchVariableRequestCookieNames ManagedRuleExclusionMatchVariable = "RequestCookieNames"
	// ManagedRuleExclusionMatchVariableRequestHeaderNames ...
	ManagedRuleExclusionMatchVariableRequestHeaderNames ManagedRuleExclusionMatchVariable = "RequestHeaderNames"
)

// PossibleManagedRuleExclusionMatchVariableValues returns an array of possible values for the ManagedRuleExclusionMatchVariable const type.
func PossibleManagedRuleExclusionMatchVariableValues() []ManagedRuleExclusionMatchVariable {
	return []ManagedRuleExclusionMatchVariable{ManagedRuleExclusionMatchVariableQueryStringArgNames, ManagedRuleExclusionMatchVariableRequestBodyJSONArgNames, ManagedRuleExclusionMatchVariableRequestBodyPostArgNames, ManagedRuleExclusionMatchVariableRequestCookieNames, ManagedRuleExclusionMatchVariableRequestHeaderNames}
}

// ManagedRuleExclusionSelectorMatchOperator enumerates the values for managed rule exclusion selector match
// operator.
type ManagedRuleExclusionSelectorMatchOperator string

const (
	// ManagedRuleExclusionSelectorMatchOperatorContains ...
	ManagedRuleExclusionSelectorMatchOperatorContains ManagedRuleExclusionSelectorMatchOperator = "Contains"
	// ManagedRuleExclusionSelectorMatchOperatorEndsWith ...
	ManagedRuleExclusionSelectorMatchOperatorEndsWith ManagedRuleExclusionSelectorMatchOperator = "EndsWith"
	// ManagedRuleExclusionSelectorMatchOperatorEquals ...
	ManagedRuleExclusionSelectorMatchOperatorEquals ManagedRuleExclusionSelectorMatchOperator = "Equals"
	// ManagedRuleExclusionSelectorMatchOperatorEqualsAny ...
	ManagedRuleExclusionSelectorMatchOperatorEqualsAny ManagedRuleExclusionSelectorMatchOperator = "EqualsAny"
	// ManagedRuleExclusionSelectorMatchOperatorStartsWith ...
	ManagedRuleExclusionSelectorMatchOperatorStartsWith ManagedRuleExclusionSelectorMatchOperator = "StartsWith"
)

// PossibleManagedRuleExclusionSelectorMatchOperatorValues returns an array of possible values for the ManagedRuleExclusionSelectorMatchOperator const type.
func PossibleManagedRuleExclusionSelectorMatchOperatorValues() []ManagedRuleExclusionSelectorMatchOperator {
	return []ManagedRuleExclusionSelectorMatchOperator{ManagedRuleExclusionSelectorMatchOperatorContains, ManagedRuleExclusionSelectorMatchOperatorEndsWith, ManagedRuleExclusionSelectorMatchOperatorEquals, ManagedRuleExclusionSelectorMatchOperatorEqualsAny, ManagedRuleExclusionSelectorMatchOperatorStartsWith}
}

// ManagedRuleSetActionType enumerates the values for managed rule set action type.
type ManagedRuleSetActionType string

const (
	// ManagedRuleSetActionTypeBlock ...
	ManagedRuleSetActionTypeBlock ManagedRuleSetActionType = "Block"
	// ManagedRuleSetActionTypeLog ...
	ManagedRuleSetActionTypeLog ManagedRuleSetActionType = "Log"
	// ManagedRuleSetActionTypeRedirect ...
	ManagedRuleSetActionTypeRedirect ManagedRuleSetActionType = "Redirect"
)

// PossibleManagedRuleSetActionTypeValues returns an array of possible values for the ManagedRuleSetActionType const type.
func PossibleManagedRuleSetActionTypeValues() []ManagedRuleSetActionType {
	return []ManagedRuleSetActionType{ManagedRuleSetActionTypeBlock, ManagedRuleSetActionTypeLog, ManagedRuleSetActionTypeRedirect}
}

// MatchProcessingBehavior enumerates the values for match processing behavior.
type MatchProcessingBehavior string

const (
	// MatchProcessingBehaviorContinue ...
	MatchProcessingBehaviorContinue MatchProcessingBehavior = "Continue"
	// MatchProcessingBehaviorStop ...
	MatchProcessingBehaviorStop MatchProcessingBehavior = "Stop"
)

// PossibleMatchProcessingBehaviorValues returns an array of possible values for the MatchProcessingBehavior const type.
func PossibleMatchProcessingBehaviorValues() []MatchProcessingBehavior {
	return []MatchProcessingBehavior{MatchProcessingBehaviorContinue, MatchProcessingBehaviorStop}
}

// MatchVariable enumerates the values for match variable.
type MatchVariable string

const (
	// MatchVariableCookies ...
	MatchVariableCookies MatchVariable = "Cookies"
	// MatchVariablePostArgs ...
	MatchVariablePostArgs MatchVariable = "PostArgs"
	// MatchVariableQueryString ...
	MatchVariableQueryString MatchVariable = "QueryString"
	// MatchVariableRemoteAddr ...
	MatchVariableRemoteAddr MatchVariable = "RemoteAddr"
	// MatchVariableRequestBody ...
	MatchVariableRequestBody MatchVariable = "RequestBody"
	// MatchVariableRequestHeader ...
	MatchVariableRequestHeader MatchVariable = "RequestHeader"
	// MatchVariableRequestMethod ...
	MatchVariableRequestMethod MatchVariable = "RequestMethod"
	// MatchVariableRequestURI ...
	MatchVariableRequestURI MatchVariable = "RequestUri"
	// MatchVariableSocketAddr ...
	MatchVariableSocketAddr MatchVariable = "SocketAddr"
)

// PossibleMatchVariableValues returns an array of possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{MatchVariableCookies, MatchVariablePostArgs, MatchVariableQueryString, MatchVariableRemoteAddr, MatchVariableRequestBody, MatchVariableRequestHeader, MatchVariableRequestMethod, MatchVariableRequestURI, MatchVariableSocketAddr}
}

// MinimumTLSVersion enumerates the values for minimum tls version.
type MinimumTLSVersion string

const (
	// MinimumTLSVersionOneFullStopTwo ...
	MinimumTLSVersionOneFullStopTwo MinimumTLSVersion = "1.2"
	// MinimumTLSVersionOneFullStopZero ...
	MinimumTLSVersionOneFullStopZero MinimumTLSVersion = "1.0"
)

// PossibleMinimumTLSVersionValues returns an array of possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{MinimumTLSVersionOneFullStopTwo, MinimumTLSVersionOneFullStopZero}
}

// NetworkExperimentResourceState enumerates the values for network experiment resource state.
type NetworkExperimentResourceState string

const (
	// NetworkExperimentResourceStateCreating ...
	NetworkExperimentResourceStateCreating NetworkExperimentResourceState = "Creating"
	// NetworkExperimentResourceStateDeleting ...
	NetworkExperimentResourceStateDeleting NetworkExperimentResourceState = "Deleting"
	// NetworkExperimentResourceStateDisabled ...
	NetworkExperimentResourceStateDisabled NetworkExperimentResourceState = "Disabled"
	// NetworkExperimentResourceStateDisabling ...
	NetworkExperimentResourceStateDisabling NetworkExperimentResourceState = "Disabling"
	// NetworkExperimentResourceStateEnabled ...
	NetworkExperimentResourceStateEnabled NetworkExperimentResourceState = "Enabled"
	// NetworkExperimentResourceStateEnabling ...
	NetworkExperimentResourceStateEnabling NetworkExperimentResourceState = "Enabling"
)

// PossibleNetworkExperimentResourceStateValues returns an array of possible values for the NetworkExperimentResourceState const type.
func PossibleNetworkExperimentResourceStateValues() []NetworkExperimentResourceState {
	return []NetworkExperimentResourceState{NetworkExperimentResourceStateCreating, NetworkExperimentResourceStateDeleting, NetworkExperimentResourceStateDisabled, NetworkExperimentResourceStateDisabling, NetworkExperimentResourceStateEnabled, NetworkExperimentResourceStateEnabling}
}

// NetworkOperationStatus enumerates the values for network operation status.
type NetworkOperationStatus string

const (
	// NetworkOperationStatusFailed ...
	NetworkOperationStatusFailed NetworkOperationStatus = "Failed"
	// NetworkOperationStatusInProgress ...
	NetworkOperationStatusInProgress NetworkOperationStatus = "InProgress"
	// NetworkOperationStatusSucceeded ...
	NetworkOperationStatusSucceeded NetworkOperationStatus = "Succeeded"
)

// PossibleNetworkOperationStatusValues returns an array of possible values for the NetworkOperationStatus const type.
func PossibleNetworkOperationStatusValues() []NetworkOperationStatus {
	return []NetworkOperationStatus{NetworkOperationStatusFailed, NetworkOperationStatusInProgress, NetworkOperationStatusSucceeded}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorForwardingConfiguration ...
	OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorForwardingConfiguration OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration"
	// OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorRedirectConfiguration ...
	OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorRedirectConfiguration OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration"
	// OdataTypeRouteConfiguration ...
	OdataTypeRouteConfiguration OdataType = "RouteConfiguration"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorForwardingConfiguration, OdataTypeMicrosoftAzureFrontDoorModelsFrontdoorRedirectConfiguration, OdataTypeRouteConfiguration}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorAny ...
	OperatorAny Operator = "Any"
	// OperatorBeginsWith ...
	OperatorBeginsWith Operator = "BeginsWith"
	// OperatorContains ...
	OperatorContains Operator = "Contains"
	// OperatorEndsWith ...
	OperatorEndsWith Operator = "EndsWith"
	// OperatorEqual ...
	OperatorEqual Operator = "Equal"
	// OperatorGeoMatch ...
	OperatorGeoMatch Operator = "GeoMatch"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorIPMatch ...
	OperatorIPMatch Operator = "IPMatch"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
	// OperatorRegEx ...
	OperatorRegEx Operator = "RegEx"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorAny, OperatorBeginsWith, OperatorContains, OperatorEndsWith, OperatorEqual, OperatorGeoMatch, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorIPMatch, OperatorLessThan, OperatorLessThanOrEqual, OperatorRegEx}
}

// PolicyEnabledState enumerates the values for policy enabled state.
type PolicyEnabledState string

const (
	// PolicyEnabledStateDisabled ...
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	// PolicyEnabledStateEnabled ...
	PolicyEnabledStateEnabled PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns an array of possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{PolicyEnabledStateDisabled, PolicyEnabledStateEnabled}
}

// PolicyMode enumerates the values for policy mode.
type PolicyMode string

const (
	// PolicyModeDetection ...
	PolicyModeDetection PolicyMode = "Detection"
	// PolicyModePrevention ...
	PolicyModePrevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns an array of possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{PolicyModeDetection, PolicyModePrevention}
}

// PolicyRequestBodyCheck enumerates the values for policy request body check.
type PolicyRequestBodyCheck string

const (
	// PolicyRequestBodyCheckDisabled ...
	PolicyRequestBodyCheckDisabled PolicyRequestBodyCheck = "Disabled"
	// PolicyRequestBodyCheckEnabled ...
	PolicyRequestBodyCheckEnabled PolicyRequestBodyCheck = "Enabled"
)

// PossiblePolicyRequestBodyCheckValues returns an array of possible values for the PolicyRequestBodyCheck const type.
func PossiblePolicyRequestBodyCheckValues() []PolicyRequestBodyCheck {
	return []PolicyRequestBodyCheck{PolicyRequestBodyCheckDisabled, PolicyRequestBodyCheckEnabled}
}

// PolicyResourceState enumerates the values for policy resource state.
type PolicyResourceState string

const (
	// PolicyResourceStateCreating ...
	PolicyResourceStateCreating PolicyResourceState = "Creating"
	// PolicyResourceStateDeleting ...
	PolicyResourceStateDeleting PolicyResourceState = "Deleting"
	// PolicyResourceStateDisabled ...
	PolicyResourceStateDisabled PolicyResourceState = "Disabled"
	// PolicyResourceStateDisabling ...
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	// PolicyResourceStateEnabled ...
	PolicyResourceStateEnabled PolicyResourceState = "Enabled"
	// PolicyResourceStateEnabling ...
	PolicyResourceStateEnabling PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns an array of possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{PolicyResourceStateCreating, PolicyResourceStateDeleting, PolicyResourceStateDisabled, PolicyResourceStateDisabling, PolicyResourceStateEnabled, PolicyResourceStateEnabling}
}

// PrivateEndpointStatus enumerates the values for private endpoint status.
type PrivateEndpointStatus string

const (
	// PrivateEndpointStatusApproved ...
	PrivateEndpointStatusApproved PrivateEndpointStatus = "Approved"
	// PrivateEndpointStatusDisconnected ...
	PrivateEndpointStatusDisconnected PrivateEndpointStatus = "Disconnected"
	// PrivateEndpointStatusPending ...
	PrivateEndpointStatusPending PrivateEndpointStatus = "Pending"
	// PrivateEndpointStatusRejected ...
	PrivateEndpointStatusRejected PrivateEndpointStatus = "Rejected"
	// PrivateEndpointStatusTimeout ...
	PrivateEndpointStatusTimeout PrivateEndpointStatus = "Timeout"
)

// PossiblePrivateEndpointStatusValues returns an array of possible values for the PrivateEndpointStatus const type.
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return []PrivateEndpointStatus{PrivateEndpointStatusApproved, PrivateEndpointStatusDisconnected, PrivateEndpointStatusPending, PrivateEndpointStatusRejected, PrivateEndpointStatusTimeout}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolHTTP ...
	ProtocolHTTP Protocol = "Http"
	// ProtocolHTTPS ...
	ProtocolHTTPS Protocol = "Https"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolHTTP, ProtocolHTTPS}
}

// Query enumerates the values for query.
type Query string

const (
	// QueryStripAll ...
	QueryStripAll Query = "StripAll"
	// QueryStripAllExcept ...
	QueryStripAllExcept Query = "StripAllExcept"
	// QueryStripNone ...
	QueryStripNone Query = "StripNone"
	// QueryStripOnly ...
	QueryStripOnly Query = "StripOnly"
)

// PossibleQueryValues returns an array of possible values for the Query const type.
func PossibleQueryValues() []Query {
	return []Query{QueryStripAll, QueryStripAllExcept, QueryStripNone, QueryStripOnly}
}

// RedirectProtocol enumerates the values for redirect protocol.
type RedirectProtocol string

const (
	// RedirectProtocolHTTPOnly ...
	RedirectProtocolHTTPOnly RedirectProtocol = "HttpOnly"
	// RedirectProtocolHTTPSOnly ...
	RedirectProtocolHTTPSOnly RedirectProtocol = "HttpsOnly"
	// RedirectProtocolMatchRequest ...
	RedirectProtocolMatchRequest RedirectProtocol = "MatchRequest"
)

// PossibleRedirectProtocolValues returns an array of possible values for the RedirectProtocol const type.
func PossibleRedirectProtocolValues() []RedirectProtocol {
	return []RedirectProtocol{RedirectProtocolHTTPOnly, RedirectProtocolHTTPSOnly, RedirectProtocolMatchRequest}
}

// RedirectType enumerates the values for redirect type.
type RedirectType string

const (
	// RedirectTypeFound ...
	RedirectTypeFound RedirectType = "Found"
	// RedirectTypeMoved ...
	RedirectTypeMoved RedirectType = "Moved"
	// RedirectTypePermanentRedirect ...
	RedirectTypePermanentRedirect RedirectType = "PermanentRedirect"
	// RedirectTypeTemporaryRedirect ...
	RedirectTypeTemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns an array of possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{RedirectTypeFound, RedirectTypeMoved, RedirectTypePermanentRedirect, RedirectTypeTemporaryRedirect}
}

// ResourceState enumerates the values for resource state.
type ResourceState string

const (
	// ResourceStateCreating ...
	ResourceStateCreating ResourceState = "Creating"
	// ResourceStateDeleting ...
	ResourceStateDeleting ResourceState = "Deleting"
	// ResourceStateDisabled ...
	ResourceStateDisabled ResourceState = "Disabled"
	// ResourceStateDisabling ...
	ResourceStateDisabling ResourceState = "Disabling"
	// ResourceStateEnabled ...
	ResourceStateEnabled ResourceState = "Enabled"
	// ResourceStateEnabling ...
	ResourceStateEnabling ResourceState = "Enabling"
)

// PossibleResourceStateValues returns an array of possible values for the ResourceState const type.
func PossibleResourceStateValues() []ResourceState {
	return []ResourceState{ResourceStateCreating, ResourceStateDeleting, ResourceStateDisabled, ResourceStateDisabling, ResourceStateEnabled, ResourceStateEnabling}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// ResourceTypeMicrosoftNetworkfrontDoors ...
	ResourceTypeMicrosoftNetworkfrontDoors ResourceType = "Microsoft.Network/frontDoors"
	// ResourceTypeMicrosoftNetworkfrontDoorsfrontendEndpoints ...
	ResourceTypeMicrosoftNetworkfrontDoorsfrontendEndpoints ResourceType = "Microsoft.Network/frontDoors/frontendEndpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{ResourceTypeMicrosoftNetworkfrontDoors, ResourceTypeMicrosoftNetworkfrontDoorsfrontendEndpoints}
}

// RoutingRuleEnabledState enumerates the values for routing rule enabled state.
type RoutingRuleEnabledState string

const (
	// RoutingRuleEnabledStateDisabled ...
	RoutingRuleEnabledStateDisabled RoutingRuleEnabledState = "Disabled"
	// RoutingRuleEnabledStateEnabled ...
	RoutingRuleEnabledStateEnabled RoutingRuleEnabledState = "Enabled"
)

// PossibleRoutingRuleEnabledStateValues returns an array of possible values for the RoutingRuleEnabledState const type.
func PossibleRoutingRuleEnabledStateValues() []RoutingRuleEnabledState {
	return []RoutingRuleEnabledState{RoutingRuleEnabledStateDisabled, RoutingRuleEnabledStateEnabled}
}

// RulesEngineMatchVariable enumerates the values for rules engine match variable.
type RulesEngineMatchVariable string

const (
	// RulesEngineMatchVariableIsMobile ...
	RulesEngineMatchVariableIsMobile RulesEngineMatchVariable = "IsMobile"
	// RulesEngineMatchVariablePostArgs ...
	RulesEngineMatchVariablePostArgs RulesEngineMatchVariable = "PostArgs"
	// RulesEngineMatchVariableQueryString ...
	RulesEngineMatchVariableQueryString RulesEngineMatchVariable = "QueryString"
	// RulesEngineMatchVariableRemoteAddr ...
	RulesEngineMatchVariableRemoteAddr RulesEngineMatchVariable = "RemoteAddr"
	// RulesEngineMatchVariableRequestBody ...
	RulesEngineMatchVariableRequestBody RulesEngineMatchVariable = "RequestBody"
	// RulesEngineMatchVariableRequestFilename ...
	RulesEngineMatchVariableRequestFilename RulesEngineMatchVariable = "RequestFilename"
	// RulesEngineMatchVariableRequestFilenameExtension ...
	RulesEngineMatchVariableRequestFilenameExtension RulesEngineMatchVariable = "RequestFilenameExtension"
	// RulesEngineMatchVariableRequestHeader ...
	RulesEngineMatchVariableRequestHeader RulesEngineMatchVariable = "RequestHeader"
	// RulesEngineMatchVariableRequestMethod ...
	RulesEngineMatchVariableRequestMethod RulesEngineMatchVariable = "RequestMethod"
	// RulesEngineMatchVariableRequestPath ...
	RulesEngineMatchVariableRequestPath RulesEngineMatchVariable = "RequestPath"
	// RulesEngineMatchVariableRequestScheme ...
	RulesEngineMatchVariableRequestScheme RulesEngineMatchVariable = "RequestScheme"
	// RulesEngineMatchVariableRequestURI ...
	RulesEngineMatchVariableRequestURI RulesEngineMatchVariable = "RequestUri"
)

// PossibleRulesEngineMatchVariableValues returns an array of possible values for the RulesEngineMatchVariable const type.
func PossibleRulesEngineMatchVariableValues() []RulesEngineMatchVariable {
	return []RulesEngineMatchVariable{RulesEngineMatchVariableIsMobile, RulesEngineMatchVariablePostArgs, RulesEngineMatchVariableQueryString, RulesEngineMatchVariableRemoteAddr, RulesEngineMatchVariableRequestBody, RulesEngineMatchVariableRequestFilename, RulesEngineMatchVariableRequestFilenameExtension, RulesEngineMatchVariableRequestHeader, RulesEngineMatchVariableRequestMethod, RulesEngineMatchVariableRequestPath, RulesEngineMatchVariableRequestScheme, RulesEngineMatchVariableRequestURI}
}

// RulesEngineOperator enumerates the values for rules engine operator.
type RulesEngineOperator string

const (
	// RulesEngineOperatorAny ...
	RulesEngineOperatorAny RulesEngineOperator = "Any"
	// RulesEngineOperatorBeginsWith ...
	RulesEngineOperatorBeginsWith RulesEngineOperator = "BeginsWith"
	// RulesEngineOperatorContains ...
	RulesEngineOperatorContains RulesEngineOperator = "Contains"
	// RulesEngineOperatorEndsWith ...
	RulesEngineOperatorEndsWith RulesEngineOperator = "EndsWith"
	// RulesEngineOperatorEqual ...
	RulesEngineOperatorEqual RulesEngineOperator = "Equal"
	// RulesEngineOperatorGeoMatch ...
	RulesEngineOperatorGeoMatch RulesEngineOperator = "GeoMatch"
	// RulesEngineOperatorGreaterThan ...
	RulesEngineOperatorGreaterThan RulesEngineOperator = "GreaterThan"
	// RulesEngineOperatorGreaterThanOrEqual ...
	RulesEngineOperatorGreaterThanOrEqual RulesEngineOperator = "GreaterThanOrEqual"
	// RulesEngineOperatorIPMatch ...
	RulesEngineOperatorIPMatch RulesEngineOperator = "IPMatch"
	// RulesEngineOperatorLessThan ...
	RulesEngineOperatorLessThan RulesEngineOperator = "LessThan"
	// RulesEngineOperatorLessThanOrEqual ...
	RulesEngineOperatorLessThanOrEqual RulesEngineOperator = "LessThanOrEqual"
)

// PossibleRulesEngineOperatorValues returns an array of possible values for the RulesEngineOperator const type.
func PossibleRulesEngineOperatorValues() []RulesEngineOperator {
	return []RulesEngineOperator{RulesEngineOperatorAny, RulesEngineOperatorBeginsWith, RulesEngineOperatorContains, RulesEngineOperatorEndsWith, RulesEngineOperatorEqual, RulesEngineOperatorGeoMatch, RulesEngineOperatorGreaterThan, RulesEngineOperatorGreaterThanOrEqual, RulesEngineOperatorIPMatch, RulesEngineOperatorLessThan, RulesEngineOperatorLessThanOrEqual}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// RuleTypeMatchRule ...
	RuleTypeMatchRule RuleType = "MatchRule"
	// RuleTypeRateLimitRule ...
	RuleTypeRateLimitRule RuleType = "RateLimitRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{RuleTypeMatchRule, RuleTypeRateLimitRule}
}

// SessionAffinityEnabledState enumerates the values for session affinity enabled state.
type SessionAffinityEnabledState string

const (
	// SessionAffinityEnabledStateDisabled ...
	SessionAffinityEnabledStateDisabled SessionAffinityEnabledState = "Disabled"
	// SessionAffinityEnabledStateEnabled ...
	SessionAffinityEnabledStateEnabled SessionAffinityEnabledState = "Enabled"
)

// PossibleSessionAffinityEnabledStateValues returns an array of possible values for the SessionAffinityEnabledState const type.
func PossibleSessionAffinityEnabledStateValues() []SessionAffinityEnabledState {
	return []SessionAffinityEnabledState{SessionAffinityEnabledStateDisabled, SessionAffinityEnabledStateEnabled}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameClassicAzureFrontDoor ...
	SkuNameClassicAzureFrontDoor SkuName = "Classic_AzureFrontDoor"
	// SkuNamePremiumAzureFrontDoor ...
	SkuNamePremiumAzureFrontDoor SkuName = "Premium_AzureFrontDoor"
	// SkuNameStandardAzureFrontDoor ...
	SkuNameStandardAzureFrontDoor SkuName = "Standard_AzureFrontDoor"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameClassicAzureFrontDoor, SkuNamePremiumAzureFrontDoor, SkuNameStandardAzureFrontDoor}
}

// State enumerates the values for state.
type State string

const (
	// StateDisabled ...
	StateDisabled State = "Disabled"
	// StateEnabled ...
	StateEnabled State = "Enabled"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateDisabled, StateEnabled}
}

// TimeseriesAggregationInterval enumerates the values for timeseries aggregation interval.
type TimeseriesAggregationInterval string

const (
	// TimeseriesAggregationIntervalDaily ...
	TimeseriesAggregationIntervalDaily TimeseriesAggregationInterval = "Daily"
	// TimeseriesAggregationIntervalHourly ...
	TimeseriesAggregationIntervalHourly TimeseriesAggregationInterval = "Hourly"
)

// PossibleTimeseriesAggregationIntervalValues returns an array of possible values for the TimeseriesAggregationInterval const type.
func PossibleTimeseriesAggregationIntervalValues() []TimeseriesAggregationInterval {
	return []TimeseriesAggregationInterval{TimeseriesAggregationIntervalDaily, TimeseriesAggregationIntervalHourly}
}

// TimeseriesType enumerates the values for timeseries type.
type TimeseriesType string

const (
	// TimeseriesTypeLatencyP50 ...
	TimeseriesTypeLatencyP50 TimeseriesType = "LatencyP50"
	// TimeseriesTypeLatencyP75 ...
	TimeseriesTypeLatencyP75 TimeseriesType = "LatencyP75"
	// TimeseriesTypeLatencyP95 ...
	TimeseriesTypeLatencyP95 TimeseriesType = "LatencyP95"
	// TimeseriesTypeMeasurementCounts ...
	TimeseriesTypeMeasurementCounts TimeseriesType = "MeasurementCounts"
)

// PossibleTimeseriesTypeValues returns an array of possible values for the TimeseriesType const type.
func PossibleTimeseriesTypeValues() []TimeseriesType {
	return []TimeseriesType{TimeseriesTypeLatencyP50, TimeseriesTypeLatencyP75, TimeseriesTypeLatencyP95, TimeseriesTypeMeasurementCounts}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// TransformLowercase ...
	TransformLowercase Transform = "Lowercase"
	// TransformRemoveNulls ...
	TransformRemoveNulls Transform = "RemoveNulls"
	// TransformTrim ...
	TransformTrim Transform = "Trim"
	// TransformUppercase ...
	TransformUppercase Transform = "Uppercase"
	// TransformURLDecode ...
	TransformURLDecode Transform = "UrlDecode"
	// TransformURLEncode ...
	TransformURLEncode Transform = "UrlEncode"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{TransformLowercase, TransformRemoveNulls, TransformTrim, TransformUppercase, TransformURLDecode, TransformURLEncode}
}

// TransformType enumerates the values for transform type.
type TransformType string

const (
	// TransformTypeLowercase ...
	TransformTypeLowercase TransformType = "Lowercase"
	// TransformTypeRemoveNulls ...
	TransformTypeRemoveNulls TransformType = "RemoveNulls"
	// TransformTypeTrim ...
	TransformTypeTrim TransformType = "Trim"
	// TransformTypeUppercase ...
	TransformTypeUppercase TransformType = "Uppercase"
	// TransformTypeURLDecode ...
	TransformTypeURLDecode TransformType = "UrlDecode"
	// TransformTypeURLEncode ...
	TransformTypeURLEncode TransformType = "UrlEncode"
)

// PossibleTransformTypeValues returns an array of possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{TransformTypeLowercase, TransformTypeRemoveNulls, TransformTypeTrim, TransformTypeUppercase, TransformTypeURLDecode, TransformTypeURLEncode}
}
