## RabbitMQ 4.0.5

RabbitMQ `4.0.5` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `27.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).

### Core Broker

#### Bug Fixes

 * Reintroduced transient flow control between classic queue replicas and AMQP 0-9-1 channels,
   MQTT connections.

   Flow control between these specific parts of the core were unintentionally
   removed in `4.0.0` together with classic queue mirroring.

   Contributed by @gomoripeti.

   GitHub issue: [#12907](https://github.com/rabbitmq/rabbitmq-server/pull/12907)

 * The feature that warns when deprecated features are used in the cluster had a false positive that treated (and reported) any queue
   as a "transient non-exclusive classic queue", even if the queue was of a different type, was not transient, and so on.

   GitHub issue: [#12802](https://github.com/rabbitmq/rabbitmq-server/issues/12802)

 * AMQP 1.0 clients with close to peak consumption rates with a high `max_link_creadit` setting could run into an exception because RabbitMQ could set the incoming window size to a negative value.

   GitHub issues: [#12816](https://github.com/rabbitmq/rabbitmq-server/issues/12816), [#12904](https://github.com/rabbitmq/rabbitmq-server/pull/12904)

 * AMQP 0-9-1 channel exception generator could not handle entity names (say, queue or stream names)
   that contained non-ASCII characters.

   This affected applications that use passive queue declarations, such as the Shovel plugin.

   Contributed by @bpint.

   GitHub issue: [#12888](https://github.com/rabbitmq/rabbitmq-server/pull/12888)

 * Peer discovery resilience improvements.

   GitHub issues: [#12801](https://github.com/rabbitmq/rabbitmq-server/pull/12801), [#12809](https://github.com/rabbitmq/rabbitmq-server/pull/12809)

 * Deadlettering of some messages could result in an exception.

   GitHub issue: [#12933](https://github.com/rabbitmq/rabbitmq-server/issues/12933), [#12938](https://github.com/rabbitmq/rabbitmq-server/pull/12938)

#### Enhancements

 * For virtual hosts that have a [default queue type](https://www.rabbitmq.com/docs/vhosts#default-queue-type) configured,
   the DQT value is now injected into queue definitions in exported definition documents.

   GitHub issue: [#12776](https://github.com/rabbitmq/rabbitmq-server/issues/12776)

 * Definition export files now have an additional "type" markers that help distinguish a cluster-wide definition file from
   that of a single virtual host.

   GitHub issue: [#12835](https://github.com/rabbitmq/rabbitmq-server/issues/12835)


### Prometheus Plugin and Grafana Dashboards

#### Enhancements

 * Two new stream metrics for streams.

   Contributed by @gomoripeti and @markus812498.

   GitHub issue: [#12765](https://github.com/rabbitmq/rabbitmq-server/pull/12765)


### Management Plugin

#### Bug Fixes

 * Fixes a false positive that incorrectly reported deprecated feature use, specifically
   the use of non-exclusive transient classic queues.

   GitHub issue: [#12840](https://github.com/rabbitmq/rabbitmq-server/pull/12840)

 * `GET /api/overview` did not format empty cluster and node list tags as an empty JSON object,
   which was problematic for HTTP API clients with statically typed response data structures.

   GitHub issue: [#12797](https://github.com/rabbitmq/rabbitmq-server/pull/12797)

 * When a logged in user's JWT token was refreshed, the user identity displayed in the UI was changed.

   GitHub issue: [#12818](https://github.com/rabbitmq/rabbitmq-server/pull/12818)


### OAuth 2 Plugin

#### Bug Fixes

* When a logged in user's JWT token was refreshed, the user identity displayed in the UI was changed.

   GitHub issue: [#12818](https://github.com/rabbitmq/rabbitmq-server/pull/12818)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * Avoids an exception during automatic removal of cluster members that are
   no longer returned by peer discovery (an [opt-in feature](https://www.rabbitmq.com/docs/cluster-formation#node-health-checks-and-cleanup)).

   GitHub issue: [#12809](https://github.com/rabbitmq/rabbitmq-server/pull/12809)


### Kubernetes Peer Discovery Plugin

#### Bug Fixes

 * Avoids an exception during automatic removal of cluster members that are
   no longer returned by peer discovery (an [opt-in feature](https://www.rabbitmq.com/docs/cluster-formation#node-health-checks-and-cleanup)).

   GitHub issue: [#12809](https://github.com/rabbitmq/rabbitmq-server/pull/12809)


### Consul Peer Discovery Plugin

#### Bug Fixes

 * Avoids an exception during automatic removal of cluster members that are
   no longer returned by peer discovery (an [opt-in feature](https://www.rabbitmq.com/docs/cluster-formation#node-health-checks-and-cleanup)).

   GitHub issue: [#12809](https://github.com/rabbitmq/rabbitmq-server/pull/12809)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * Avoids an exception during automatic removal of cluster members that are
   no longer returned by peer discovery (an [opt-in feature](https://www.rabbitmq.com/docs/cluster-formation#node-health-checks-and-cleanup)).

   GitHub issue: [#12809](https://github.com/rabbitmq/rabbitmq-server/pull/12809)


### Dependency Changes

 * `osiris` was upgraded to [`1.8.5`](https://github.com/rabbitmq/osiris/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.5.tar.xz`
instead of the source tarball produced by GitHub.
