# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: sigstore_verification.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import (
    List,
    Optional,
)

import betterproto

from ...bundle import v1 as __bundle_v1__
from ...common import v1 as __common_v1__
from ...trustroot import v1 as __trustroot_v1__


@dataclass(eq=False, repr=False)
class CertificateIdentity(betterproto.Message):
    """The identity of a X.509 Certificate signer."""

    issuer: str = betterproto.string_field(1)
    """The X.509v3 issuer extension (OID 1.3.6.1.4.1.57264.1.1)"""

    san: "__common_v1__.SubjectAlternativeName" = betterproto.message_field(2)
    oids: List["__common_v1__.ObjectIdentifierValuePair"] = betterproto.message_field(3)
    """
    An unordered list of OIDs that must be verified. All OID/values provided in
    this list MUST exactly match against the values in the certificate for
    verification to be successful.
    """


@dataclass(eq=False, repr=False)
class CertificateIdentities(betterproto.Message):
    identities: List["CertificateIdentity"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class PublicKeyIdentities(betterproto.Message):
    public_keys: List["__common_v1__.PublicKey"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ArtifactVerificationOptions(betterproto.Message):
    """
    A light-weight set of options/policies for identifying trusted signers,
    used during verification of a single artifact.
    """

    certificate_identities: "CertificateIdentities" = betterproto.message_field(
        1, group="signers"
    )
    public_keys: "PublicKeyIdentities" = betterproto.message_field(2, group="signers")
    """
    To simplify verification implementation, the logic for bundle verification
    should be implemented as a higher-order function, where one of argument
    should be an interface over the set of trusted public keys, like this:
    `Verify(bytes artifact, bytes signature, string key_id)`. This way the
    caller is in full control of mapping the identified (or hinted) key in the
    bundle to one of the trusted keys, as this process is inherently
    application specific.
    """

    tlog_options: Optional["ArtifactVerificationOptionsTlogOptions"] = (
        betterproto.message_field(3, optional=True, group="_tlog_options")
    )
    """
    Optional options for artifact transparency log verification. If none is
    provided, the default verification options are: Threshold: 1 Online
    verification: false Disable: false
    """

    ctlog_options: Optional["ArtifactVerificationOptionsCtlogOptions"] = (
        betterproto.message_field(4, optional=True, group="_ctlog_options")
    )
    """
    Optional options for certificate transparency log verification. If none is
    provided, the default verification options are: Threshold: 1 Disable: false
    """

    tsa_options: Optional["ArtifactVerificationOptionsTimestampAuthorityOptions"] = (
        betterproto.message_field(5, optional=True, group="_tsa_options")
    )
    """
    Optional options for certificate signed timestamp verification. If none is
    provided, the default verification options are: Threshold: 0 Disable: true
    """

    integrated_ts_options: Optional[
        "ArtifactVerificationOptionsTlogIntegratedTimestampOptions"
    ] = betterproto.message_field(6, optional=True, group="_integrated_ts_options")
    """
    Optional options for integrated timestamp verification. If none is
    provided, the default verification options are: Threshold: 0 Disable: true
    """

    observer_options: Optional[
        "ArtifactVerificationOptionsObserverTimestampOptions"
    ] = betterproto.message_field(7, optional=True, group="_observer_options")
    """
    Optional options for observed timestamp verification. If none is provided,
    the default verification options are: Threshold 1 Disable: false
    """


@dataclass(eq=False, repr=False)
class ArtifactVerificationOptionsTlogOptions(betterproto.Message):
    threshold: int = betterproto.int32_field(1)
    """Number of transparency logs the entry must appear on."""

    perform_online_verification: bool = betterproto.bool_field(2)
    """Perform an online inclusion proof."""

    disable: bool = betterproto.bool_field(3)
    """Disable verification for transparency logs."""


@dataclass(eq=False, repr=False)
class ArtifactVerificationOptionsCtlogOptions(betterproto.Message):
    threshold: int = betterproto.int32_field(1)
    """The number of ct transparency logs the certificate must appear on."""

    disable: bool = betterproto.bool_field(3)
    """Disable ct transparency log verification"""


@dataclass(eq=False, repr=False)
class ArtifactVerificationOptionsTimestampAuthorityOptions(betterproto.Message):
    threshold: int = betterproto.int32_field(1)
    """The number of signed timestamps that are expected."""

    disable: bool = betterproto.bool_field(2)
    """Disable signed timestamp verification."""


@dataclass(eq=False, repr=False)
class ArtifactVerificationOptionsTlogIntegratedTimestampOptions(betterproto.Message):
    threshold: int = betterproto.int32_field(1)
    """The number of integrated timestamps that are expected."""

    disable: bool = betterproto.bool_field(2)
    """Disable integrated timestamp verification."""


@dataclass(eq=False, repr=False)
class ArtifactVerificationOptionsObserverTimestampOptions(betterproto.Message):
    threshold: int = betterproto.int32_field(1)
    """
    The number of external observers of the timestamp. This is a union of
    RFC3161 signed timestamps, and integrated timestamps from a transparency
    log, that could include additional timestamp sources in the future.
    """

    disable: bool = betterproto.bool_field(2)
    """Disable observer timestamp verification."""


@dataclass(eq=False, repr=False)
class Artifact(betterproto.Message):
    artifact_uri: str = betterproto.string_field(1, group="data")
    """Location of the artifact"""

    artifact: bytes = betterproto.bytes_field(2, group="data")
    """The raw bytes of the artifact"""


@dataclass(eq=False, repr=False)
class Input(betterproto.Message):
    """
    Input captures all that is needed to call the bundle verification method,
    to verify a single artifact referenced by the bundle.
    """

    artifact_trust_root: "__trustroot_v1__.TrustedRoot" = betterproto.message_field(1)
    """
    The verification materials provided during a bundle verification. The
    running process is usually preloaded with a "global"
    dev.sisgtore.trustroot.TrustedRoot.v1 instance. Prior to verifying an
    artifact (i.e a bundle), and/or based on current policy, some selection is
    expected to happen, to filter out the exact certificate authority to use,
    which transparency logs are relevant etc. The result should b ecaptured in
    the `artifact_trust_root`.
    """

    artifact_verification_options: "ArtifactVerificationOptions" = (
        betterproto.message_field(2)
    )
    bundle: "__bundle_v1__.Bundle" = betterproto.message_field(3)
    artifact: Optional["Artifact"] = betterproto.message_field(
        4, optional=True, group="_artifact"
    )
    """
    If the bundle contains a message signature, the artifact must be provided.
    """
