/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ce extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Гринвичица юкъара хан",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "стандартан хан Апиа, Самоа",
               "",
               "аьхкенан хан Апиа, Самоа",
               "",
               "хан Апиа, Самоа",
               "",
            };
        final String[] Cook = new String[] {
               "Кукан, гӀ-наш, стандартан хан",
               "",
               "Кукан, гӀ-наш, аьхкенан хан",
               "",
               "Кукан, гӀ-наш",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба, стандартан хан",
               "CST",
               "Куба, аьхкенан хан",
               "CDT",
               "Куба",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фиджи, стандартан хан",
               "",
               "Фиджи, аьхкенан хан",
               "",
               "Фиджи",
               "",
            };
        final String[] Gulf = new String[] {
               "ГӀажарийн айма",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд, стандартан хан",
               "",
               "Ховд, аьхкенан хан",
               "",
               "Ховд",
               "",
            };
        final String[] Iran = new String[] {
               "ГӀажарийчоь, стандартан хан",
               "",
               "ГӀажарийчоь, аьхкенан хан",
               "",
               "ГӀажарийчоь",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуэ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск, стандартан хан",
               "",
               "Омск, аьхкенан хан",
               "",
               "Омск",
               "",
            };
        final String[] Peru = new String[] {
               "Перу, стандартан хан",
               "",
               "Перу, аьхкенан хан",
               "",
               "Перу",
               "",
            };
        final String[] Truk = new String[] {
               "Чуук",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Уэйк, гӀ-е",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чили, стандартан хан",
               "",
               "Чили, аьхкенан хан",
               "",
               "Чили",
               "",
            };
        final String[] China = new String[] {
               "Цийчоьнан, стандартан хан",
               "CST",
               "Цийчоьнан, аьхкенан хан",
               "CDT",
               "Цийчоь",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокосийн, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дейвис",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ХӀинди",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Япон, стандартан хан",
               "JST",
               "Япон, аьхкенан хан",
               "JDT",
               "Япон",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корей, стандартан хан",
               "KST",
               "Корей, аьхкенан хан",
               "KST",
               "Корей",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа, стандартан хан",
               "SST",
               "Самоа, аьхкенан хан",
               "SST",
               "Самоа",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Сёва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга, стандартан хан",
               "",
               "Тонга, аьхкенан хан",
               "",
               "Тонга",
               "",
            };
        final String[] Alaska = new String[] {
               "Аляска, стандартан хан",
               "AKST",
               "Аляска, аьхкенан хан",
               "AKDT",
               "Аляска",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазонка, стандартан хан",
               "",
               "Амазонка, аьхкенан хан",
               "",
               "Амазонка",
               "",
            };
        final String[] Azores = new String[] {
               "Азоран гӀайренаш, стандартан хан",
               "",
               "Азоран гӀайренаш, аьхкенан хан",
               "",
               "Азоран гӀайренаш",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней-Даруссалам",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Мархин гӀайре, стандартан хан",
               "",
               "Мархин гӀайре, аьхкенан хан",
               "",
               "Мархин гӀайре",
               "",
            };
        final String[] Guyana = new String[] {
               "Гайана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Гавайн-алеутийн стандартан хан",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Израиль, стандартан хан",
               "IST",
               "Израиль, аьхкенан хан",
               "IDT",
               "Израиль",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Косраэ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моусон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москва, стандартан хан",
               "MSK",
               "Москва, аьхкенан хан",
               "MSK",
               "Москва",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понапе, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таити, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайвань, стандартан хан",
               "CST",
               "Тайвань, аьхкенан хан",
               "CDT",
               "Тайвань",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уоллис а, Футуна а",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "СаӀудийн Ӏаьрбийчоьнан стандартан хан",
               "",
               "СаӀудийн Ӏаьрбийчоьнан, аьхкенан хан",
               "",
               "СаӀудийн Ӏаьрбийчоь",
               "",
            };
        final String[] Armenia = new String[] {
               "Эрмалойчоь, стандартан хан",
               "",
               "Эрмалойчоь, аьхкенан хан",
               "",
               "Эрмалойчоь",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливи",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатем, стандартан хан",
               "",
               "Чатем, аьхкенан хан",
               "",
               "Чатем",
               "",
            };
        final String[] Ecuador = new String[] {
               "Эквадор",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбье",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Гуьржийчоь, стандартан хан",
               "",
               "Гуьржийчоь, аьхкенан хан",
               "",
               "Гуьржийчоь",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркутск, стандартан хан",
               "",
               "Иркутск, аьхкенан хан",
               "",
               "Иркутск",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан, стандартан хан",
               "",
               "Магадан, аьхкенан хан",
               "",
               "Магадан",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мьянма",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк, стандартан хан",
               "",
               "Норфолк, аьхкенан хан",
               "",
               "Норфолк",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернанду-ди-Норонья, стандартан хан",
               "",
               "Фернанду-ди-Норонья, аьхкенан хан",
               "",
               "Фернанду-ди-Норонья",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюньон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломонан, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвай, стандартан хан",
               "",
               "Уругвай, аьхкенан хан",
               "",
               "Уругвай",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату, стандартан хан",
               "",
               "Вануату, аьхкенан хан",
               "",
               "Вануату",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутск, стандартан хан",
               "",
               "Якутск, аьхкенан хан",
               "",
               "Якутск",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантикан стандартан хан",
               "AST",
               "Атлантикан аьхкенан хан",
               "AST",
               "Атлантикан хан",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразили, стандартан хан",
               "",
               "Бразили, аьхкенан хан",
               "",
               "Бразили",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморро",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумби, стандартан хан",
               "",
               "Колумби, аьхкенан хан",
               "",
               "Колумби",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолклендан гӀайренаш, стандартан хан",
               "",
               "Фолклендан гӀайренаш, аьхкенан хан",
               "",
               "Фолклендан гӀайренаш",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзи",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Мальдиваш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан-Батор, стандартан хан",
               "",
               "Улан-Батор, аьхкенан хан",
               "",
               "Улан-Батор",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистан, стандартан хан",
               "PKT",
               "Пакистан, аьхкенан хан",
               "PKST",
               "Пакистан",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвай, стандартан хан",
               "",
               "Парагвай, аьхкенан хан",
               "",
               "Парагвай",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкэрн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринам",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина, стандартан хан",
               "",
               "Аргентина, аьхкенан хан",
               "",
               "Аргентина",
               "",
            };
        final String[] Christmas = new String[] {
               "Ӏийса пайхамар винчу ден гӀайре",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагосан гӀайренаш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Гонконг, стандартан хан",
               "HKT",
               "Гонконг, аьхкенан хан",
               "HKST",
               "Гонконг",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокитай",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргизи",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд-Хау, стандартан хан",
               "",
               "Лорд-Хау, аьхкенан хан",
               "",
               "Лорд-Хау",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркизан, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маврики, стандартан хан",
               "",
               "Маврики, аьхкенан хан",
               "",
               "Маврики",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэла",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Азербайджан, стандартан хан",
               "",
               "Азербайджан, аьхкенан хан",
               "",
               "Азербайджан",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш, стандартан хан",
               "",
               "Бангладеш, аьхкенан хан",
               "",
               "Бангладеш",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Кабо-Верде, стандартан хан",
               "",
               "Кабо-Верде, аьхкенан хан",
               "",
               "Кабо-Верде",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Малхбален Тимор",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшелан гӀайренаш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Таджикистан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистанан стандартан хан",
               "",
               "Узбекистанан аьхкенан хан",
               "",
               "Узбекистан",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ОвхӀан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярск, стандартан хан",
               "",
               "Красноярск, аьхкенан хан",
               "",
               "Красноярск",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Керла Зеланди, стандартан хан",
               "NZST",
               "Керла Зеланди, аьхкенан хан",
               "NZDT",
               "Керла Зеланди",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Филиппинаш, стандартан хан",
               "PST",
               "Филиппинаш, аьхкенан хан",
               "PDT",
               "Филиппинаш",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток, стандартан хан",
               "",
               "Владивосток, аьхкенан хан",
               "",
               "Владивосток",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Индин океан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Лайн, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ньюфаундленд, стандартан хан",
               "NST",
               "Ньюфаундленд, аьхкенан хан",
               "NDT",
               "Ньюфаундленд",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменин стандартан хан",
               "",
               "Туркменин аьхкенан хан",
               "",
               "Туркмени",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Французийн Гвиана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Керла Каледони, стандартан хан",
               "",
               "Керла Каледони, аьхкенан хан",
               "",
               "Керла Каледони",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Къилба Георги",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбург, стандартан хан",
               "",
               "Екатеринбург, аьхкенан хан",
               "",
               "Екатеринбург",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Юккъера Африка",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Малхбален Африка",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Малхбузен Африка",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Дюмон-д’Юрвиль",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Юккъера Европа, стандартан хан",
               "CET",
               "Юккъера Европа, аьхкенан хан",
               "CEST",
               "Юккъера Европа",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Малхбален Европа, стандартан хан",
               "EET",
               "Малхбален Европа, аьхкенан хан",
               "EEST",
               "Малхбален Европа",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Малхбузен Европа, стандартан хан",
               "WET",
               "Малхбузен Европа, аьхкенан хан",
               "WEST",
               "Малхбузен Европа",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Тийна океанан Мексикан стандартан хан",
               "MST",
               "Тийна океанан Мексикан аьхкенан хан",
               "MDT",
               "Тийна океанан Мексикан хан",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Къилба Африка",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Юккъера Америка, стандартан хан",
               "CST",
               "Юккъера Америка, аьхкенан хан",
               "CDT",
               "Юккъера Америка",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Малхбален Америка, стандартан хан",
               "EST",
               "Малхбален Америка, аьхкенан хан",
               "EST",
               "Малхбален Америка",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Тийна океанан стандартан хан",
               "PST",
               "Тийна океанан аьхкенан хан",
               "PDT",
               "Тийна океанан хан",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Французийн къилба а, Антарктидан а хан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гилбертан, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Гавайн-алеутийн стандартан хан",
               "HST",
               "Гавайн-алеутийн аьхкенан хан",
               "HDT",
               "Гавайн-алеутийн хан",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс, гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен-Пьер а, Микелон а, стандартан хан",
               "",
               "Сен-Пьер а, Микелон а, аьхкенан хан",
               "",
               "Сен-Пьер а, Микелон а",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Лаьмнийн стандартан хан (АЦШ)",
               "MST",
               "Лаьмнийн аьхкенан хан (АЦШ)",
               "MST",
               "Лаьмнийн хан (АЦШ)",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалан , гӀ-наш",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа – Керла Гвиней",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Юккъера Австрали, стандартан хан",
               "ACST",
               "Юккъера Австрали, аьхкенан хан",
               "ACDT",
               "Юккъера Австрали",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Малхбален Австрали, стандартан хан",
               "AEST",
               "Малхбален Австрали, аьхкенан хан",
               "AEDT",
               "Малхбален Австрали",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Малхбузен Австрали, стандартан хан",
               "AWST",
               "Малхбузен Австрали, аьхкенан хан",
               "AWDT",
               "Малхбузен Австрали",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Юккъера Индонези",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Малхбален Индонези",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Малхбузен Индонези",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Юккъера Австрали, малхбузен стандартан хан",
               "",
               "Юккъера Австрали, малхбузен аьхкенан хан",
               "",
               "Юккъера Австрали, малхбузен хан",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Ирланди, аьхкенан хан",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Ирланди, аьхкенан хан",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Гринвичица юкъара хан",
                    "GMT",
                    "Британин, аьхкенан хан",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Бакох" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Орал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ӏамман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дакка" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Джуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алма-Ата" },
            { "timezone.excity.Asia/Anadyr", "Анадырь" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атирау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеврон" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Маскат" },
            { "timezone.excity.Asia/Riyadh", "Эр-Рияд" },
            { "timezone.excity.Asia/Saigon", "Хошимин" },
            { "timezone.excity.Asia/Taipei", "Тайбэй" },
            { "timezone.excity.Asia/Tehran", "ТехӀран" },
            { "timezone.excity.Asia/Urumqi", "Урумчи" },
            { "timezone.excity.Etc/Unknown", "Йоьвзуш йоцу гӀала" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Маэ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "КъахӀира" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "БагӀдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутск" },
            { "timezone.excity.Asia/Jakarta", "Джакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучинг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никоси" },
            { "timezone.excity.Asia/Rangoon", "Рангун" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тимпу" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "Софи" },
            { "timezone.excity.Europe/Vaduz", "Вадуц" },
            { "timezone.excity.Indian/Cocos", "Кокосийн, гӀ-наш" },
            { "timezone.excity.Pacific/Apia", "Апи" },
            { "timezone.excity.Pacific/Fiji", "Фиджи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуэ" },
            { "timezone.excity.Pacific/Truk", "Трук, гӀ-наш" },
            { "timezone.excity.Pacific/Wake", "Уэйк, гӀ-е" },
            { "timezone.excity.Africa/Asmera", "Асмера" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Банги" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Бисау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуту" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ниамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Баи" },
            { "timezone.excity.America/Belem", "Белен" },
            { "timezone.excity.America/Boise", "Бойсе" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Калькутта" },
            { "timezone.excity.Asia/Damascus", "Димашкъ" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Джайпур" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандыга" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин гӀ-е" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Усть-Нера" },
            { "timezone.excity.Europe/Athens", "Афина" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дублин" },
            { "timezone.excity.Europe/Jersey", "Джерси" },
            { "timezone.excity.Europe/Lisbon", "Лиссабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопье" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморийн гӀайренаш" },
            { "timezone.excity.Pacific/Efate", "Эфате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абиджан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайман" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гайана" },
            { "timezone.excity.America/Havana", "Гавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Джуно" },
            { "timezone.excity.America/La_Paz", "Ла-Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Нассау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифи" },
            { "timezone.excity.America/Regina", "Реджайна" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Гонконг" },
            { "timezone.excity.Asia/Jerusalem", "Къудс-ГӀала" },
            { "timezone.excity.Asia/Kamchatka", "Петропавловск-Камчатски" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пхеньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кызылорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Вьентьян" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вильнюс" },
            { "timezone.excity.Indian/Mayotte", "Майорка" },
            { "timezone.excity.Indian/Reunion", "Реюньон" },
            { "timezone.excity.Pacific/Easter", "Мархин гӀайренаш" },
            { "timezone.excity.Pacific/Kosrae", "Косрае" },
            { "timezone.excity.Pacific/Majuro", "Маджуро" },
            { "timezone.excity.Pacific/Midway", "Мидуэй, гӀ-наш" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понапе, гӀ-наш" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити, гӀ-наш" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уоллис" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Джибути" },
            { "timezone.excity.Africa/El_Aaiun", "Эль-Аюн" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монрови" },
            { "timezone.excity.Africa/Ndjamena", "Нджамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайенна" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордова" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Готхоб" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Галифакс" },
            { "timezone.excity.America/Iqaluit", "Икалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норонха" },
            { "timezone.excity.America/Ojinaga", "Охинага" },
            { "timezone.excity.America/Phoenix", "Финикс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпень" },
            { "timezone.excity.Atlantic/Azores", "Азоран гӀайренаш" },
            { "timezone.excity.Atlantic/Canary", "Канаран гӀайренаш" },
            { "timezone.excity.Atlantic/Faeroe", "Фарерийн гӀайренаш" },
            { "timezone.excity.Australia/Eucla", "Юкла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бюзинген-ам-Хохрайн" },
            { "timezone.excity.Europe/Chisinau", "Кишинев" },
            { "timezone.excity.Europe/Guernsey", "Гернси" },
            { "timezone.excity.Europe/Helsinki", "Хельсинки" },
            { "timezone.excity.Europe/Istanbul", "Стамбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Мальдиваш" },
            { "timezone.excity.Pacific/Chatham", "Чатем, гӀ-е" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбьен, гӀ-наш" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишо" },
            { "timezone.excity.America/Anguilla", "Ангилья" },
            { "timezone.excity.America/Asuncion", "Асунсьон" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Эдмонтон" },
            { "timezone.excity.America/Eirunepe", "Эйрунепе" },
            { "timezone.excity.America/Mazatlan", "Масатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Нью-Йорк" },
            { "timezone.excity.America/Resolute", "Резолют" },
            { "timezone.excity.America/Santarem", "Сантарен" },
            { "timezone.excity.America/Santiago", "Сантьяго" },
            { "timezone.excity.America/St_Johns", "Сент-Джонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Китс" },
            { "timezone.excity.America/St_Lucia", "Сент-Люси" },
            { "timezone.excity.America/Winnipeg", "Виннипег" },
            { "timezone.excity.Antarctica/Casey", "Кейси" },
            { "timezone.excity.Antarctica/Davis", "Дейвис" },
            { "timezone.excity.Antarctica/Syowa", "Сёва" },
            { "timezone.excity.Antarctica/Troll", "Тролль" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермудаш" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра, гӀ-е" },
            { "timezone.excity.Atlantic/Stanley", "Стэнли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Аштаркхне" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Мариехамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокгольм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульяновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Ӏийса пайхамар винчу ден гӀайре" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маврики" },
            { "timezone.excity.Pacific/Auckland", "Окленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Honolulu", "Гонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Питкерн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Либревиль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкоридж" },
            { "timezone.excity.America/Araguaina", "Арагуаина" },
            { "timezone.excity.America/Boa_Vista", "Боа-Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чиуауа" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глейс-Бей" },
            { "timezone.excity.America/Goose_Bay", "Гус-Бей" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гуаякиль" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтеррей" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паулу" },
            { "timezone.excity.America/St_Thomas", "Сент-Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моусон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала-Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферополь" },
            { "timezone.excity.Pacific/Galapagos", "Галапагосан гӀайренаш" },
            { "timezone.excity.Pacific/Kwajalein", "Кваджалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркизан, гӀ-наш" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго-Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавиль" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд Турк" },
            { "timezone.excity.America/Guadeloupe", "Гваделупа" },
            { "timezone.excity.America/Hermosillo", "Эрмосильо" },
            { "timezone.excity.America/Kralendijk", "Кралендейк" },
            { "timezone.excity.America/Louisville", "Луисвилл" },
            { "timezone.excity.America/Martinique", "Мартиника" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монсеррат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Риу-Бранку" },
            { "timezone.excity.America/St_Vincent", "Сент-Винсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Мак-Мердо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколымск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкьявик" },
            { "timezone.excity.Atlantic/St_Helena", "Езачу Еленин гӀайре" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Брисбен" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "Мэн, гӀ-е" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханнесбург" },
            { "timezone.excity.America/El_Salvador", "Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нельсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анджелес" },
            { "timezone.excity.America/Mexico_City", "Мехико" },
            { "timezone.excity.America/Porto_Velho", "Порту-Велью" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрто-Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгйир" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо-Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд-Хау, гӀ-е" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариву" },
            { "timezone.excity.Pacific/Guadalcanal", "Гвадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-эс-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Бланк-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампу-Гранди" },
            { "timezone.excity.America/Danmarkshavn", "Денмарксхавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон-Крик" },
            { "timezone.excity.America/Indiana/Knox", "Нокс" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта-Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкин-Инлет" },
            { "timezone.excity.America/Scoresbysund", "Скорсбисунн" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуори" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвиль, гӀ-е" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт-Морсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кеймбридж-Бей" },
            { "timezone.excity.America/Coral_Harbour", "Корал-Харбор" },
            { "timezone.excity.America/Indiana/Vevay", "Вивэй" },
            { "timezone.excity.America/Lower_Princes", "Лоуэр-Принсес-Куортер" },
            { "timezone.excity.America/Port_of_Spain", "Порт-оф-Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санто-Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сен-Бартельми" },
            { "timezone.excity.America/Swift_Current", "Свифт-Карент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен-Хилл" },
            { "timezone.excity.America/Bahia_Banderas", "Баия-де-Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Къилба Джорджи" },
            { "timezone.excity.America/Argentina/Salta", "Сальта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго" },
            { "timezone.excity.America/Indiana/Winamac", "Винамак" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуая" },
            { "timezone.excity.America/Indiana/Tell_City", "Телл-Сити" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсенс" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон-д’Юрвиль" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан-Луис" },
            { "timezone.excity.America/Indiana/Petersburg", "Петерсбург" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтиселло" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бойла, Къилбаседа Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Юкъ, Къилбаседа Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио-Гальегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Салем" },
        };
        return data;
    }
}
