/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xplot.h"

static int					/* plotting colors */ 
    plotcolor [] = { FL_GREEN,
		     FL_BLUE, FL_RED,
		     FL_MAGENTA, 
		     FL_TOMATO, FL_INDIANRED, FL_SLATEBLUE,
		     FL_DARKGOLD, FL_DARKTOMATO,
		     FL_DARKORANGE, FL_DEEPPINK, FL_CHARTREUSE,
		     FL_DARKVIOLET, FL_DOGERBLUE,
		   };

void readfile (FILE *f, char *name)
{
    Data
	*dest;                      /* tmp pointer into storage of data */
    char
	buf [100];                  /* file input buf */
    register int
	twodim = 0,                 /* 1- or 2-dim file? */
        active = 1,                 /* initially active? */
	res;                        /* conversion result */
    float
	curx, cury;                 /* X/Y values to enter */
        
    /* make sure we have a valid (default) formatstring */
    if (! formatstring [0])
        strcpy (formatstring, "%f %f ");
    
    /* make memory for data */
    if (! (data = (Data *) realloc (data, (ndata + 1) * sizeof (Data))) )
	error ("out of memory");
    dest = data + ndata;
    
    if (verbose)
        printf ("%s: ", name);
    
    if (++ndata > FL_MAX_XYPLOTOVERLAY)
    {
	warning ("only up to %d overlays supported in one plot at one time",
		 FL_MAX_XYPLOTOVERLAY);
        active = 0;
    }     

    dest->npoints = 0;
    dest->x = 0;
    dest->y = 0;
    dest->color = plotcolor [ndata % (sizeof (plotcolor) / sizeof (int))];
    dest->active = active;

    /* let's see if this is a one- or twodim stream */
    if (! fgetline (buf, 99, f))
	error ("empty datastream");
    res = sscanf (buf, formatstring, &curx, &cury);
    if (res == 2)
	twodim = 1;
    else if (res < 1)
	error ("invalid data format");

    /* now enter all data */
    if (! twodim)
	curx = 0;
    
    while (1)
    {
	/* create room for x/y */ 
	if (! (dest->x = (float *) realloc (dest->x,
			    (dest->npoints + 1) * sizeof (float))) ||
	    ! (dest->y = (float *) realloc (dest->y,
			    (dest->npoints + 1) * sizeof (float)))
	   )
	    error ("out of memory");

	/* get the values */ 
	if (twodim)
	{
	    if (sscanf (buf, "%f %f ", &curx, &cury) < 2)
		error ("invalid data for 2-dim stream");
	}
	else
	    if (sscanf (buf, "%f ", &cury) < 1)
		error ("invalid data for 1-dim stream");

	dest->x [dest->npoints] = curx;
	dest->y [dest->npoints] = cury;
	dest->npoints++;

	/* determine overall min/max values */
	if (minx > curx)
	    minx = curx;
	if (maxx < curx)
	    maxx = curx;
        if (! ylimits_set)
        {
   	    if (miny > cury)
	        miny = cury;
	    if (maxy < cury)
	        maxy = cury;
        }

	/* adjust X for one-dimensional series */ 
	if (! twodim)
	    curx += 1.0;

	/* next line */ 
	if (! fgetline (buf, 99, f))
	    break;
    }

    /* add the file info to the activator browser */
    sprintf (buf, "@C%d[+] %s", dest->color, name);
    fl_add_browser_line (activate_browser, buf);

    /* show # of points */ 
    if (verbose)
        printf ("%d points\n", data [ndata - 1].npoints);
}
