package net.tinyos.comm;

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

/**
 * Updated to include the open() method, which allows us to keep this object
 * while being temporarily disconnected from the serial port
 */

public class NativeSerial {

  /** The handle to the serial port we're connected to */
  protected long swigCPtr;

  /** True if we have an open serial port connection */
  protected boolean swigCMemOwn;

  /** Name of the port */
  private String myPortname = "";

  /**
   * Constructor
   * 
   * @param portname
   */
  public NativeSerial(String portname) {
    this(TOSCommJNI.new_NativeSerial(portname), true);
  }

  /**
   * Constructor
   * 
   * @param cPtr
   * @param cMemoryOwn
   */
  private NativeSerial(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  /**
   * Reconnect to this serial port
   * 
   * @return true if the connection is made
   */
  public boolean open() {
    if (!swigCMemOwn && !myPortname.matches("")) {
      swigCPtr = TOSCommJNI.new_NativeSerial(myPortname);
      swigCMemOwn = true;
      return true;
    }

    return false;
  }

  public void close() {
    // We can come here with swigCptr == 0 from finalize if the C++
    // constructor throws an exception. Ideally, we should guard all
    // methods in the C++ code, but this is simpler.
    
    if (swigCPtr != 0) {
      TOSCommJNI.NativeSerial_close(swigCPtr);
    }
  }

  protected NativeSerial() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if (swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      TOSCommJNI.delete_NativeSerial(swigCPtr);
    }
    swigCPtr = 0;
  }

  protected static long getCPtr(NativeSerial obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public void setSerialPortParams(int baudrate, int databits, int stopbits,
      boolean parity) {
    TOSCommJNI.NativeSerial_setSerialPortParams(swigCPtr, baudrate, databits,
        stopbits, parity);
  }

  public int getBaudRate() {
    return TOSCommJNI.NativeSerial_getBaudRate(swigCPtr);
  }

  public int getDataBits() {
    return TOSCommJNI.NativeSerial_getDataBits(swigCPtr);
  }

  public int getStopBits() {
    return TOSCommJNI.NativeSerial_getStopBits(swigCPtr);
  }

  public boolean getParity() {
    return TOSCommJNI.NativeSerial_getParity(swigCPtr);
  }

  public void notifyOn(int event, boolean enable) {
    if (swigCPtr != 0) {
      TOSCommJNI.NativeSerial_notifyOn(swigCPtr, event, enable);
    }
  }

  public boolean isNotifyOn(int event) {
    return TOSCommJNI.NativeSerial_isNotifyOn(swigCPtr, event);
  }

  public boolean waitForEvent() {
    if (swigCPtr != 0) {
      try {
        return TOSCommJNI.NativeSerial_waitForEvent(swigCPtr);
      } catch (Exception e) {
        return false;
      }
    }
    return false;
  }

  public boolean cancelWait() {
    if (swigCPtr != 0) {
      return TOSCommJNI.NativeSerial_cancelWait(swigCPtr);
    }
    return false;
  }

  public boolean didEventOccur(int event) {
    return TOSCommJNI.NativeSerial_didEventOccur(swigCPtr, event);
  }

  public void setDTR(boolean high) {
    TOSCommJNI.NativeSerial_setDTR(swigCPtr, high);
  }

  public void setRTS(boolean high) {
    TOSCommJNI.NativeSerial_setRTS(swigCPtr, high);
  }

  public boolean isDTR() {
    return TOSCommJNI.NativeSerial_isDTR(swigCPtr);
  }

  public boolean isRTS() {
    return TOSCommJNI.NativeSerial_isRTS(swigCPtr);
  }

  public boolean isCTS() {
    return TOSCommJNI.NativeSerial_isCTS(swigCPtr);
  }

  public boolean isDSR() {
    return TOSCommJNI.NativeSerial_isDSR(swigCPtr);
  }

  public boolean isRI() {
    return TOSCommJNI.NativeSerial_isRI(swigCPtr);
  }

  public boolean isCD() {
    return TOSCommJNI.NativeSerial_isCD(swigCPtr);
  }

  public void sendBreak(int millis) {
    TOSCommJNI.NativeSerial_sendBreak(swigCPtr, millis);
  }

  public int available() {
    try {
      return TOSCommJNI.NativeSerial_available(swigCPtr);
    } catch (Exception e) {
      return 0;
    }
  }

  public int read() {
    return TOSCommJNI.NativeSerial_read__SWIG_0(swigCPtr);
  }

  public int read(byte[] buffer_out, int off, int len) {
    return TOSCommJNI.NativeSerial_read__SWIG_1(swigCPtr, buffer_out, off, len);
  }

  public int write(int b) {
    return TOSCommJNI.NativeSerial_write__SWIG_0(swigCPtr, b);
  }

  public int write(byte[] buffer_in, int off, int len) {
    return TOSCommJNI.NativeSerial_write__SWIG_1(swigCPtr, buffer_in, off, len);
  }

  public static String getTOSCommMap() {
    return TOSCommJNI.NativeSerial_getTOSCommMap();
  }

}
