/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFDIALOG_H
#define _SC_DIFFDIALOG_H

// sc
#include "sublib/TargetId.h"
#include "svn/DiffSummarizeTypes.h"
class DiffViewModel;
class RevisionWidget;
class ExternProvider;

namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;
class QLabel;
class Q3ListView;
class Q3ListViewItem;

// sys
#include <vector>


class DiffDialog : public QWidget, public TargetId
{
  typedef QWidget super;
  Q_OBJECT 

public:
  DiffDialog( DiffViewModel* model, ExternProvider* p, QWidget *parent = 0 );
  virtual ~DiffDialog();

  void closeEvent( QCloseEvent* e );

  void setPathOrUrl1( const QString& pathOrUrl1 );
  void setPathOrUrl2( const QString& pathOrUrl2 );
  void setRevision1( const svn::Revision* );
  void setRevision2( const svn::Revision* );

  void enablePathOrUrl1( bool enable );
  void enablePathOrUrl2( bool enable );
  void enableTypeChange( bool enable );

public slots:
  void addSumEntry( svn::DiffSummarizePtr );
  void checkButtons( const QString& text );
  void doubleClicked( Q3ListViewItem*, const QPoint&, int );
  void textChanged1( const QString& text );
  void textChanged2( const QString& text );

private slots:
  void diff();
  void patch();
  void sum();
  void close();

  void selectRep1Url();
  void selectRep2Url();
  void changedDiffType( bool );

public slots:
  void enableButtons();
  void updateSelection();

private:
  void getSelection( svn::DiffSummarizes& );

private:
  DiffViewModel*  _model;
  ExternProvider* _p;

  QComboBox*      _rep1;
  QLabel*         _rep1L;
  QPushButton*    _rep1B;

  QCheckBox*      _type;
  QComboBox*      _rep2;
  QLabel*         _rep2L;
  QPushButton*    _rep2B;

  RevisionWidget* _rwPeg;
  RevisionWidget* _rw1;
  RevisionWidget* _rw2;

  QCheckBox*      _recurse;
  QCheckBox*      _ancestry;
  QCheckBox*      _deleted;

  Q3ListView*     _summarize;

  QPushButton*    _diff;
  QPushButton*    _sum;
  QPushButton*    _patch;
  QPushButton*    _close;
};

#endif // _SC_DIFFDIALOG_H
