#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2018 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# -------------------------------------------------------------------------
# http://wiki.debian.org/RpathIssue

if test ! -f libtool; then
  echo "`pwd`/libtool: file not found"
  exit 1
fi

mv libtool libtool.old && cp libtool.old libtool

if true; then

 sed -i -r 's/(hardcode_into_libs)=.*$/\1=no/' libtool

else
# old style
  sed -e 's/^hardcode_direct.*$/hardcode_direct=yes/g'   \
      -e 's/^hardcode_minus_L.*$/hardcode_minus_L=yes/g' \
      -e 's/^hardcode_shlibpath_var.*$/hardcode_shlibpath_var=no/g' \
    < libtool > libtool.new

  mv libtool.new libtool
fi
