/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line875
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line875: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line875: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line875(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line875: not enough keys\n");
    return 1;
}

int lex_line875()
{
    const size_t padding = 7; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_var_unserializer.ig--skeleton.c.line875.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_var_unserializer.ig--skeleton.c.line875.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN (7)) YYFILL(7);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy4,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy5,  &&yy4,
                &&yy2,  &&yy2,  &&yy6,  &&yy7,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy8,  &&yy9,  &&yy2,  &&yy10, &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy11, &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy12,
                &&yy2,  &&yy2,  &&yy13, &&yy14, &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy15, &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
                &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
            };
            goto *yytarget[yych];
        }
yy2:
        YYSKIP ();
yy3:
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 13);
        continue;
yy4:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy17;
        goto yy3;
yy5:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == ';') goto yy19;
        goto yy3;
yy6:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy21;
        goto yy3;
yy7:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy22;
        goto yy3;
yy8:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy23;
        goto yy3;
yy9:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy24;
        goto yy3;
yy10:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy25;
        goto yy3;
yy11:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy26;
        goto yy3;
yy12:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy27;
        goto yy3;
yy13:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy28;
        goto yy3;
yy14:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ':') goto yy29;
        goto yy3;
yy15:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 12);
        continue;
yy17:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy31;
        }
        if (yych == '+') goto yy30;
yy18:
        YYRESTORE ();
        goto yy3;
yy19:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 2);
        continue;
yy21:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= ',') {
            if (yych == '+') goto yy33;
            goto yy18;
        } else {
            if (yych <= '-') goto yy33;
            if (yych <= '/') goto yy18;
            if (yych <= '9') goto yy34;
            goto yy18;
        }
yy22:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '+') goto yy36;
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy37;
        goto yy18;
yy23:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '+') goto yy39;
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy40;
        goto yy18;
yy24:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '1') goto yy42;
        goto yy18;
yy25:
        YYSKIP ();
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy43, &&yy18, &&yy44, &&yy45, &&yy18,
                &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
                &&yy46, &&yy46, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy48, &&yy18, &&yy18, &&yy18, &&yy18, &&yy49, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18
            };
            goto *yytarget[yych];
        }
yy26:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= ',') {
            if (yych == '+') goto yy50;
            goto yy18;
        } else {
            if (yych <= '-') goto yy50;
            if (yych <= '/') goto yy18;
            if (yych <= '9') goto yy51;
            goto yy18;
        }
yy27:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= ',') {
            if (yych == '+') goto yy53;
            goto yy18;
        } else {
            if (yych <= '-') goto yy53;
            if (yych <= '/') goto yy18;
            if (yych <= '9') goto yy54;
            goto yy18;
        }
yy28:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= ',') {
            if (yych == '+') goto yy56;
            goto yy18;
        } else {
            if (yych <= '-') goto yy56;
            if (yych <= '/') goto yy18;
            if (yych <= '9') goto yy57;
            goto yy18;
        }
yy29:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '+') goto yy59;
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy60;
        goto yy18;
yy30:
        YYSKIP ();
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy31;
        }
        goto yy18;
yy31:
        YYSKIP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy31;
        }
        if (yych <= '/') goto yy18;
        if (yych <= ':') goto yy62;
        goto yy18;
yy33:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy34:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy34;
        if (yych == ';') goto yy63;
        goto yy18;
yy36:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy37:
        YYSKIP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy37;
        if (yych <= ':') goto yy65;
        goto yy18;
yy39:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy40:
        YYSKIP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy40;
        if (yych <= ':') goto yy66;
        goto yy18;
yy42:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == ';') goto yy67;
        goto yy18;
yy43:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '.') goto yy45;
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy46;
        goto yy18;
yy44:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') {
            if (yych != '.') goto yy18;
        } else {
            if (yych <= '9') goto yy46;
            if (yych == 'I') goto yy48;
            goto yy18;
        }
yy45:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy69;
        goto yy18;
yy46:
        YYSKIP ();
        if (YYLESSTHAN (4)) YYFILL(4);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy69, &&yy18,
                &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
                &&yy46, &&yy46, &&yy18, &&yy71, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy73, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy73, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18
            };
            goto *yytarget[yych];
        }
yy48:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == 'N') goto yy74;
        goto yy18;
yy49:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == 'A') goto yy75;
        goto yy18;
yy50:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy51:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy51;
        if (yych == ';') goto yy76;
        goto yy18;
yy53:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy54:
        YYSKIP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy54;
        if (yych <= ':') goto yy78;
        goto yy18;
yy56:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy57:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy57;
        if (yych == ';') goto yy79;
        goto yy18;
yy59:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych >= ':') goto yy18;
yy60:
        YYSKIP ();
        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy60;
        if (yych <= ':') goto yy81;
        goto yy18;
yy62:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '"') goto yy82;
        goto yy18;
yy63:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 0);
        continue;
yy65:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '"') goto yy84;
        goto yy18;
yy66:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '{') goto yy86;
        goto yy18;
yy67:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 3);
        continue;
yy69:
        YYSKIP ();
        if (YYLESSTHAN (4)) YYFILL(4);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
                &&yy69, &&yy69, &&yy18, &&yy71, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy73, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy73, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
                &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18
            };
            goto *yytarget[yych];
        }
yy71:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 6);
        continue;
yy73:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= ',') {
            if (yych == '+') goto yy88;
            goto yy18;
        } else {
            if (yych <= '-') goto yy88;
            if (yych <= '/') goto yy18;
            if (yych <= '9') goto yy89;
            goto yy18;
        }
yy74:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == 'F') goto yy91;
        goto yy18;
yy75:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == 'N') goto yy91;
        goto yy18;
yy76:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 4);
        continue;
yy78:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '"') goto yy92;
        goto yy18;
yy79:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 1);
        continue;
yy81:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == '"') goto yy94;
        goto yy18;
yy82:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 11);
        continue;
yy84:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 8);
        continue;
yy86:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 9);
        continue;
yy88:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= ',') {
            if (yych == '+') goto yy96;
            goto yy18;
        } else {
            if (yych <= '-') goto yy96;
            if (yych <= '/') goto yy18;
            if (yych >= ':') goto yy18;
        }
yy89:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy89;
        if (yych == ';') goto yy71;
        goto yy18;
yy91:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych == ';') goto yy97;
        goto yy18;
yy92:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 10);
        continue;
yy94:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 7);
        continue;
yy96:
        YYSKIP ();
        yych = YYPEEK ();
        if (yych <= '/') goto yy18;
        if (yych <= '9') goto yy89;
        goto yy18;
yy97:
        YYSKIP ();
        status = check_key_count_line875(keys_count, i, 3)
             || action_line875(&i, keys, input, token, &cursor, 5);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line875: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line875: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line875() != 0) {
        return 1;
    }
    return 0;
}
 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABDEFGHIJKLMPQTUVWXYZ[\]^_`cefghjklmnpqtuvwxyz{|~C:+00:"O:+11:"C:+22:"O:+33:"C:+44:"O:+55:"C:+66:"O:+77:"C:+88:"O:+99:"C:+00: O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:	C:+00:
O:+11:C:+22:O:+33:
C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22: O:+33:!C:+44:#O:+55:$C:+66:%O:+77:&C:+88:'O:+99:(C:+00:)O:+11:*C:+22:+O:+33:,C:+44:-O:+55:.C:+66:/O:+77:0C:+88:1O:+99:2C:+00:3O:+11:4C:+22:5O:+33:6C:+44:7O:+55:8C:+66:9O:+77::C:+88:;O:+99:<C:+00:=O:+11:>C:+22:?O:+33:@C:+44:AO:+55:BC:+66:CO:+77:DC:+88:EO:+99:FC:+00:GO:+11:HC:+22:IO:+33:JC:+44:KO:+55:LC:+66:MO:+77:NC:+88:OO:+99:PC:+00:QO:+11:RC:+22:SO:+33:TC:+44:UO:+55:VC:+66:WO:+77:XC:+88:YO:+99:ZC:+00:[O:+11:\C:+22:]O:+33:^C:+44:_O:+55:`C:+66:aO:+77:bC:+88:cO:+99:dC:+00:eO:+11:fC:+22:gO:+33:hC:+44:iO:+55:jC:+66:kO:+77:lC:+88:mO:+99:nC:+00:oO:+11:pC:+22:qO:+33:rC:+44:sO:+55:tC:+66:uO:+77:vC:+88:wO:+99:xC:+00:yO:+11:zC:+22:{O:+33:|C:+44:}O:+55:~C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:O:+55:C:+66:O:+77:C:+88:O:+99:C:+00:O:+11:C:+22:O:+33:C:+44:C:+00 O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99	C:+00
O:+11C:+22O:+33
C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22 O:+33!C:+44"O:+55#C:+66$O:+77%C:+88&O:+99'C:+00(O:+11)C:+22*O:+33+C:+44,O:+55-C:+66.O:+77/C:+88;O:+99<C:+00=O:+11>C:+22?O:+33@C:+44AO:+55BC:+66CO:+77DC:+88EO:+99FC:+00GO:+11HC:+22IO:+33JC:+44KO:+55LC:+66MO:+77NC:+88OO:+99PC:+00QO:+11RC:+22SO:+33TC:+44UO:+55VC:+66WO:+77XC:+88YO:+99ZC:+00[O:+11\C:+22]O:+33^C:+44_O:+55`C:+66aO:+77bC:+88cO:+99dC:+00eO:+11fC:+22gO:+33hC:+44iO:+55jC:+66kO:+77lC:+88mO:+99nC:+00oO:+11pC:+22qO:+33rC:+44sO:+55tC:+66uO:+77vC:+88wO:+99xC:+00yO:+11zC:+22{O:+33|C:+44}O:+55~C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44O:+55C:+66O:+77C:+88O:+99C:+00O:+11C:+22O:+33C:+44C:+0:"O:+1:"C:+2:"O:+3:"C:+4:"O:+5:"C:+6:"O:+7:"C:+8:"O:+9:"C:+0 O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9	C:+0
O:+1C:+2O:+3
C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2 O:+3!C:+4"O:+5#C:+6$O:+7%C:+8&O:+9'C:+0(O:+1)C:+2*O:+3+C:+4,O:+5-C:+6.O:+7/C:+8;O:+9<C:+0=O:+1>C:+2?O:+3@C:+4AO:+5BC:+6CO:+7DC:+8EO:+9FC:+0GO:+1HC:+2IO:+3JC:+4KO:+5LC:+6MO:+7NC:+8OO:+9PC:+0QO:+1RC:+2SO:+3TC:+4UO:+5VC:+6WO:+7XC:+8YO:+9ZC:+0[O:+1\C:+2]O:+3^C:+4_O:+5`C:+6aO:+7bC:+8cO:+9dC:+0eO:+1fC:+2gO:+3hC:+4iO:+5jC:+6kO:+7lC:+8mO:+9nC:+0oO:+1pC:+2qO:+3rC:+4sO:+5tC:+6uO:+7vC:+8wO:+9xC:+0yO:+1zC:+2{O:+3|C:+4}O:+5~C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4O:+5C:+6O:+7C:+8O:+9C:+0O:+1C:+2O:+3C:+4C:+ O:+C:+O:+C:+O:+C:+O:+C:+O:+	C:+
O:+C:+O:+
C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+ O:+!C:+"O:+#C:+$O:+%C:+&O:+'C:+(O:+)C:+*O:++C:+,O:+-C:+.O:+/C:+:O:+;C:+<O:+=C:+>O:+?C:+@O:+AC:+BO:+CC:+DO:+EC:+FO:+GC:+HO:+IC:+JO:+KC:+LO:+MC:+NO:+OC:+PO:+QC:+RO:+SC:+TO:+UC:+VO:+WC:+XO:+YC:+ZO:+[C:+\O:+]C:+^O:+_C:+`O:+aC:+bO:+cC:+dO:+eC:+fO:+gC:+hO:+iC:+jO:+kC:+lO:+mC:+nO:+oC:+pO:+qC:+rO:+sC:+tO:+uC:+vO:+wC:+xO:+yC:+zO:+{C:+|O:+}C:+~O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:+O:+C:0 O:1C:2O:3C:4O:5C:6O:7C:8O:9	C:0
O:1C:2O:3
C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2 O:3!C:4"O:5#C:6$O:7%C:8&O:9'C:0(O:1)C:2*O:3+C:4,O:5-C:6.O:7/C:8;O:9<C:0=O:1>C:2?O:3@C:4AO:5BC:6CO:7DC:8EO:9FC:0GO:1HC:2IO:3JC:4KO:5LC:6MO:7NC:8OO:9PC:0QO:1RC:2SO:3TC:4UO:5VC:6WO:7XC:8YO:9ZC:0[O:1\C:2]O:3^C:4_O:5`C:6aO:7bC:8cO:9dC:0eO:1fC:2gO:3hC:4iO:5jC:6kO:7lC:8mO:9nC:0oO:1pC:2qO:3rC:4sO:5tC:6uO:7vC:8wO:9xC:0yO:1zC:2{O:3|C:4}O:5~C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4O:5C:6O:7C:8O:9C:0O:1C:2O:3C:4C: O:C:O:C:O:C:O:C:O:	C:
O:C:O:
C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C: O:!C:"O:#C:$O:%C:&O:'C:(O:)C:*O:,C:-O:.C:/O::C:;O:<C:=O:>C:?O:@C:AO:BC:CO:DC:EO:FC:GO:HC:IO:JC:KO:LC:MO:NC:OO:PC:QO:RC:SO:TC:UO:VC:WO:XC:YO:ZC:[O:\C:]O:^C:_O:`C:aO:bC:cO:dC:eO:fC:gO:hC:iO:jC:kO:lC:mO:nC:oO:pC:qO:rC:sO:tC:uO:vC:wO:xC:yO:zC:{O:|C:}O:~C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:O:C:C OCOCOCOCO	C
OCO
COCOCOCOCOCOCOCOCOC O!C"O#C$O%C&O'C(O)C*O+C,O-C.O/C0O1C2O3C4O5C6O7C8O9C;O<C=O>C?O@CAOBCCODCEOFCGOHCIOJCKOLCMONCOOPCQORCSOTCUOVCWOXCYOZC[O\C]O^C_O`CaObCcOdCeOfCgOhCiOjCkOlCmOnCoOpCqOrCsOtCuOvCwOxCyOzC{O|C}O~COCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCOCN;N NNNNNNNNN	N
NNN
NNNNNNNNNNNNNNNNNNN N!N"N#N$N%N&N'N(N)N*N+N,N-N.N/N0N1N2N3N4N5N6N7N8N9N:N<N=N>N?N@NANBNCNDNENFNGNHNINJNKNLNMNNNONPNQNRNSNTNUNVNWNXNYNZN[N\N]N^N_N`NaNbNcNdNeNfNgNhNiNjNkNlNmNnNoNpNqNrNsNtNuNvNwNxNyNzN{N|N}N~NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNR:+00;R:-11;R:+22;R:-33;R:+44;R:-55;R:+66;R:-77;R:+88;R:-99;R:+00 R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99	R:+00
R:-11R:+22R:-33
R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22 R:-33!R:+44"R:-55#R:+66$R:-77%R:+88&R:-99'R:+00(R:-11)R:+22*R:-33+R:+44,R:-55-R:+66.R:-77/R:+88:R:-99<R:+00=R:-11>R:+22?R:-33@R:+44AR:-55BR:+66CR:-77DR:+88ER:-99FR:+00GR:-11HR:+22IR:-33JR:+44KR:-55LR:+66MR:-77NR:+88OR:-99PR:+00QR:-11RR:+22SR:-33TR:+44UR:-55VR:+66WR:-77XR:+88YR:-99ZR:+00[R:-11\R:+22]R:-33^R:+44_R:-55`R:+66aR:-77bR:+88cR:-99dR:+00eR:-11fR:+22gR:-33hR:+44iR:-55jR:+66kR:-77lR:+88mR:-99nR:+00oR:-11pR:+22qR:-33rR:+44sR:-55tR:+66uR:-77vR:+88wR:-99xR:+00yR:-11zR:+22{R:-33|R:+44}R:-55~R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:-55R:+66R:-77R:+88R:-99R:+00R:-11R:+22R:-33R:+44R:+0;R:-1;R:+2;R:-3;R:+4;R:-5;R:+6;R:-7;R:+8;R:-9;R:+0 R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9	R:+0
R:-1R:+2R:-3
R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2 R:-3!R:+4"R:-5#R:+6$R:-7%R:+8&R:-9'R:+0(R:-1)R:+2*R:-3+R:+4,R:-5-R:+6.R:-7/R:+8:R:-9<R:+0=R:-1>R:+2?R:-3@R:+4AR:-5BR:+6CR:-7DR:+8ER:-9FR:+0GR:-1HR:+2IR:-3JR:+4KR:-5LR:+6MR:-7NR:+8OR:-9PR:+0QR:-1RR:+2SR:-3TR:+4UR:-5VR:+6WR:-7XR:+8YR:-9ZR:+0[R:-1\R:+2]R:-3^R:+4_R:-5`R:+6aR:-7bR:+8cR:-9dR:+0eR:-1fR:+2gR:-3hR:+4iR:-5jR:+6kR:-7lR:+8mR:-9nR:+0oR:-1pR:+2qR:-3rR:+4sR:-5tR:+6uR:-7vR:+8wR:-9xR:+0yR:-1zR:+2{R:-3|R:+4}R:-5~R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:-5R:+6R:-7R:+8R:-9R:+0R:-1R:+2R:-3R:+4R:+ R:-R:+R:-R:+R:-R:+R:-R:+R:-	R:+
R:-R:+R:-
R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+ R:-!R:+"R:-#R:+$R:-%R:+&R:-'R:+(R:-)R:+*R:-+R:+,R:--R:+.R:-/R:+:R:-;R:+<R:-=R:+>R:-?R:+@R:-AR:+BR:-CR:+DR:-ER:+FR:-GR:+HR:-IR:+JR:-KR:+LR:-MR:+NR:-OR:+PR:-QR:+RR:-SR:+TR:-UR:+VR:-WR:+XR:-YR:+ZR:-[R:+\R:-]R:+^R:-_R:+`R:-aR:+bR:-cR:+dR:-eR:+fR:-gR:+hR:-iR:+jR:-kR:+lR:-mR:+nR:-oR:+pR:-qR:+rR:-sR:+tR:-uR:+vR:-wR:+xR:-yR:+zR:-{R:+|R:-}R:+~R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:+R:-R:0;R:1;R:2;R:3;R:4;R:5;R:6;R:7;R:8;R:9;R: R:R:R:R:R:R:R:R:R:	R:
R:R:R:
R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R: R:!R:"R:#R:$R:%R:&R:'R:(R:)R:*R:,R:.R:/R::R:;R:<R:=R:>R:?R:@R:AR:BR:CR:DR:ER:FR:GR:HR:IR:JR:KR:LR:MR:NR:OR:PR:QR:RR:SR:TR:UR:VR:WR:XR:YR:ZR:[R:\R:]R:^R:_R:`R:aR:bR:cR:dR:eR:fR:gR:hR:iR:jR:kR:lR:mR:nR:oR:pR:qR:rR:sR:tR:uR:vR:wR:xR:yR:zR:{R:|R:}R:~R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R:R RRRRRRRRR	R
RRR
RRRRRRRRRRRRRRRRRRR R!R"R#R$R%R&R'R(R)R*R+R,R-R.R/R0R1R2R3R4R5R6R7R8R9R;R<R=R>R?R@RARBRCRDRERFRGRHRIRJRKRLRMRNRORPRQRRRSRTRURVRWRXRYRZR[R\R]R^R_R`RaRbRcRdReRfRgRhRiRjRkRlRmRnRoRpRqRrRsRtRuRvRwRxRyRzR{R|R}R~RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRS:+00:"S:+11:"S:+22:"S:+33:"S:+44:"S:+55:"S:+66:"S:+77:"S:+88:"S:+99:"S:+00: S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:	S:+00:
S:+11:S:+22:S:+33:
S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22: S:+33:!S:+44:#S:+55:$S:+66:%S:+77:&S:+88:'S:+99:(S:+00:)S:+11:*S:+22:+S:+33:,S:+44:-S:+55:.S:+66:/S:+77:0S:+88:1S:+99:2S:+00:3S:+11:4S:+22:5S:+33:6S:+44:7S:+55:8S:+66:9S:+77::S:+88:;S:+99:<S:+00:=S:+11:>S:+22:?S:+33:@S:+44:AS:+55:BS:+66:CS:+77:DS:+88:ES:+99:FS:+00:GS:+11:HS:+22:IS:+33:JS:+44:KS:+55:LS:+66:MS:+77:NS:+88:OS:+99:PS:+00:QS:+11:RS:+22:SS:+33:TS:+44:US:+55:VS:+66:WS:+77:XS:+88:YS:+99:ZS:+00:[S:+11:\S:+22:]S:+33:^S:+44:_S:+55:`S:+66:aS:+77:bS:+88:cS:+99:dS:+00:eS:+11:fS:+22:gS:+33:hS:+44:iS:+55:jS:+66:kS:+77:lS:+88:mS:+99:nS:+00:oS:+11:pS:+22:qS:+33:rS:+44:sS:+55:tS:+66:uS:+77:vS:+88:wS:+99:xS:+00:yS:+11:zS:+22:{S:+33:|S:+44:}S:+55:~S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+55:S:+66:S:+77:S:+88:S:+99:S:+00:S:+11:S:+22:S:+33:S:+44:S:+00 S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99	S:+00
S:+11S:+22S:+33
S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22 S:+33!S:+44"S:+55#S:+66$S:+77%S:+88&S:+99'S:+00(S:+11)S:+22*S:+33+S:+44,S:+55-S:+66.S:+77/S:+88;S:+99<S:+00=S:+11>S:+22?S:+33@S:+44AS:+55BS:+66CS:+77DS:+88ES:+99FS:+00GS:+11HS:+22IS:+33JS:+44KS:+55LS:+66MS:+77NS:+88OS:+99PS:+00QS:+11RS:+22SS:+33TS:+44US:+55VS:+66WS:+77XS:+88YS:+99ZS:+00[S:+11\S:+22]S:+33^S:+44_S:+55`S:+66aS:+77bS:+88cS:+99dS:+00eS:+11fS:+22gS:+33hS:+44iS:+55jS:+66kS:+77lS:+88mS:+99nS:+00oS:+11pS:+22qS:+33rS:+44sS:+55tS:+66uS:+77vS:+88wS:+99xS:+00yS:+11zS:+22{S:+33|S:+44}S:+55~S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+55S:+66S:+77S:+88S:+99S:+00S:+11S:+22S:+33S:+44S:+0:"S:+1:"S:+2:"S:+3:"S:+4:"S:+5:"S:+6:"S:+7:"S:+8:"S:+9:"S:+0 S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9	S:+0
S:+1S:+2S:+3
S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2 S:+3!S:+4"S:+5#S:+6$S:+7%S:+8&S:+9'S:+0(S:+1)S:+2*S:+3+S:+4,S:+5-S:+6.S:+7/S:+8;S:+9<S:+0=S:+1>S:+2?S:+3@S:+4AS:+5BS:+6CS:+7DS:+8ES:+9FS:+0GS:+1HS:+2IS:+3JS:+4KS:+5LS:+6MS:+7NS:+8OS:+9PS:+0QS:+1RS:+2SS:+3TS:+4US:+5VS:+6WS:+7XS:+8YS:+9ZS:+0[S:+1\S:+2]S:+3^S:+4_S:+5`S:+6aS:+7bS:+8cS:+9dS:+0eS:+1fS:+2gS:+3hS:+4iS:+5jS:+6kS:+7lS:+8mS:+9nS:+0oS:+1pS:+2qS:+3rS:+4sS:+5tS:+6uS:+7vS:+8wS:+9xS:+0yS:+1zS:+2{S:+3|S:+4}S:+5~S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+5S:+6S:+7S:+8S:+9S:+0S:+1S:+2S:+3S:+4S:+ S:+S:+S:+S:+S:+S:+S:+S:+S:+	S:+
S:+S:+S:+
S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+ S:+!S:+"S:+#S:+$S:+%S:+&S:+'S:+(S:+)S:+*S:++S:+,S:+-S:+.S:+/S:+:S:+;S:+<S:+=S:+>S:+?S:+@S:+AS:+BS:+CS:+DS:+ES:+FS:+GS:+HS:+IS:+JS:+KS:+LS:+MS:+NS:+OS:+PS:+QS:+RS:+SS:+TS:+US:+VS:+WS:+XS:+YS:+ZS:+[S:+\S:+]S:+^S:+_S:+`S:+aS:+bS:+cS:+dS:+eS:+fS:+gS:+hS:+iS:+jS:+kS:+lS:+mS:+nS:+oS:+pS:+qS:+rS:+sS:+tS:+uS:+vS:+wS:+xS:+yS:+zS:+{S:+|S:+}S:+~S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:+S:0 S:1S:2S:3S:4S:5S:6S:7S:8S:9	S:0
S:1S:2S:3
S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2 S:3!S:4"S:5#S:6$S:7%S:8&S:9'S:0(S:1)S:2*S:3+S:4,S:5-S:6.S:7/S:8;S:9<S:0=S:1>S:2?S:3@S:4AS:5BS:6CS:7DS:8ES:9FS:0GS:1HS:2IS:3JS:4KS:5LS:6MS:7NS:8OS:9PS:0QS:1RS:2SS:3TS:4US:5VS:6WS:7XS:8YS:9ZS:0[S:1\S:2]S:3^S:4_S:5`S:6aS:7bS:8cS:9dS:0eS:1fS:2gS:3hS:4iS:5jS:6kS:7lS:8mS:9nS:0oS:1pS:2qS:3rS:4sS:5tS:6uS:7vS:8wS:9xS:0yS:1zS:2{S:3|S:4}S:5~S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S:5S:6S:7S:8S:9S:0S:1S:2S:3S:4S: S:S:S:S:S:S:S:S:S:	S:
S:S:S:
S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S: S:!S:"S:#S:$S:%S:&S:'S:(S:)S:*S:,S:-S:.S:/S::S:;S:<S:=S:>S:?S:@S:AS:BS:CS:DS:ES:FS:GS:HS:IS:JS:KS:LS:MS:NS:OS:PS:QS:RS:SS:TS:US:VS:WS:XS:YS:ZS:[S:\S:]S:^S:_S:`S:aS:bS:cS:dS:eS:fS:gS:hS:iS:jS:kS:lS:mS:nS:oS:pS:qS:rS:sS:tS:uS:vS:wS:xS:yS:zS:{S:|S:}S:~S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S:S SSSSSSSSS	S
SSS
SSSSSSSSSSSSSSSSSSS S!S"S#S$S%S&S'S(S)S*S+S,S-S.S/S0S1S2S3S4S5S6S7S8S9S;S<S=S>S?S@SASBSCSDSESFSGSHSISJSKSLSMSNSOSPSQSRSSSTSUSVSWSXSYSZS[S\S]S^S_S`SaSbScSdSeSfSgShSiSjSkSlSmSnSoSpSqSrSsStSuSvSwSxSySzS{S|S}S~SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSa:+00:{a:+11:{a:+22:{a:+33:{a:+44:{a:+55:{a:+66:{a:+77:{a:+88:{a:+99:{a:+00: a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:	a:+00:
a:+11:a:+22:a:+33:
a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22: a:+33:!a:+44:"a:+55:#a:+66:$a:+77:%a:+88:&a:+99:'a:+00:(a:+11:)a:+22:*a:+33:+a:+44:,a:+55:-a:+66:.a:+77:/a:+88:0a:+99:1a:+00:2a:+11:3a:+22:4a:+33:5a:+44:6a:+55:7a:+66:8a:+77:9a:+88::a:+99:;a:+00:<a:+11:=a:+22:>a:+33:?a:+44:@a:+55:Aa:+66:Ba:+77:Ca:+88:Da:+99:Ea:+00:Fa:+11:Ga:+22:Ha:+33:Ia:+44:Ja:+55:Ka:+66:La:+77:Ma:+88:Na:+99:Oa:+00:Pa:+11:Qa:+22:Ra:+33:Sa:+44:Ta:+55:Ua:+66:Va:+77:Wa:+88:Xa:+99:Ya:+00:Za:+11:[a:+22:\a:+33:]a:+44:^a:+55:_a:+66:`a:+77:aa:+88:ba:+99:ca:+00:da:+11:ea:+22:fa:+33:ga:+44:ha:+55:ia:+66:ja:+77:ka:+88:la:+99:ma:+00:na:+11:oa:+22:pa:+33:qa:+44:ra:+55:sa:+66:ta:+77:ua:+88:va:+99:wa:+00:xa:+11:ya:+22:za:+33:|a:+44:}a:+55:~a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+55:a:+66:a:+77:a:+88:a:+99:a:+00:a:+11:a:+22:a:+33:a:+44:a:+00 a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99	a:+00
a:+11a:+22a:+33
a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22 a:+33!a:+44"a:+55#a:+66$a:+77%a:+88&a:+99'a:+00(a:+11)a:+22*a:+33+a:+44,a:+55-a:+66.a:+77/a:+88;a:+99<a:+00=a:+11>a:+22?a:+33@a:+44Aa:+55Ba:+66Ca:+77Da:+88Ea:+99Fa:+00Ga:+11Ha:+22Ia:+33Ja:+44Ka:+55La:+66Ma:+77Na:+88Oa:+99Pa:+00Qa:+11Ra:+22Sa:+33Ta:+44Ua:+55Va:+66Wa:+77Xa:+88Ya:+99Za:+00[a:+11\a:+22]a:+33^a:+44_a:+55`a:+66aa:+77ba:+88ca:+99da:+00ea:+11fa:+22ga:+33ha:+44ia:+55ja:+66ka:+77la:+88ma:+99na:+00oa:+11pa:+22qa:+33ra:+44sa:+55ta:+66ua:+77va:+88wa:+99xa:+00ya:+11za:+22{a:+33|a:+44}a:+55~a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+55a:+66a:+77a:+88a:+99a:+00a:+11a:+22a:+33a:+44a:+0:{a:+1:{a:+2:{a:+3:{a:+4:{a:+5:{a:+6:{a:+7:{a:+8:{a:+9:{a:+0 a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9	a:+0
a:+1a:+2a:+3
a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2 a:+3!a:+4"a:+5#a:+6$a:+7%a:+8&a:+9'a:+0(a:+1)a:+2*a:+3+a:+4,a:+5-a:+6.a:+7/a:+8;a:+9<a:+0=a:+1>a:+2?a:+3@a:+4Aa:+5Ba:+6Ca:+7Da:+8Ea:+9Fa:+0Ga:+1Ha:+2Ia:+3Ja:+4Ka:+5La:+6Ma:+7Na:+8Oa:+9Pa:+0Qa:+1Ra:+2Sa:+3Ta:+4Ua:+5Va:+6Wa:+7Xa:+8Ya:+9Za:+0[a:+1\a:+2]a:+3^a:+4_a:+5`a:+6aa:+7ba:+8ca:+9da:+0ea:+1fa:+2ga:+3ha:+4ia:+5ja:+6ka:+7la:+8ma:+9na:+0oa:+1pa:+2qa:+3ra:+4sa:+5ta:+6ua:+7va:+8wa:+9xa:+0ya:+1za:+2{a:+3|a:+4}a:+5~a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+5a:+6a:+7a:+8a:+9a:+0a:+1a:+2a:+3a:+4a:+ a:+a:+a:+a:+a:+a:+a:+a:+a:+	a:+
a:+a:+a:+
a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+ a:+!a:+"a:+#a:+$a:+%a:+&a:+'a:+(a:+)a:+*a:++a:+,a:+-a:+.a:+/a:+:a:+;a:+<a:+=a:+>a:+?a:+@a:+Aa:+Ba:+Ca:+Da:+Ea:+Fa:+Ga:+Ha:+Ia:+Ja:+Ka:+La:+Ma:+Na:+Oa:+Pa:+Qa:+Ra:+Sa:+Ta:+Ua:+Va:+Wa:+Xa:+Ya:+Za:+[a:+\a:+]a:+^a:+_a:+`a:+aa:+ba:+ca:+da:+ea:+fa:+ga:+ha:+ia:+ja:+ka:+la:+ma:+na:+oa:+pa:+qa:+ra:+sa:+ta:+ua:+va:+wa:+xa:+ya:+za:+{a:+|a:+}a:+~a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:+a:0 a:1a:2a:3a:4a:5a:6a:7a:8a:9	a:0
a:1a:2a:3
a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2 a:3!a:4"a:5#a:6$a:7%a:8&a:9'a:0(a:1)a:2*a:3+a:4,a:5-a:6.a:7/a:8;a:9<a:0=a:1>a:2?a:3@a:4Aa:5Ba:6Ca:7Da:8Ea:9Fa:0Ga:1Ha:2Ia:3Ja:4Ka:5La:6Ma:7Na:8Oa:9Pa:0Qa:1Ra:2Sa:3Ta:4Ua:5Va:6Wa:7Xa:8Ya:9Za:0[a:1\a:2]a:3^a:4_a:5`a:6aa:7ba:8ca:9da:0ea:1fa:2ga:3ha:4ia:5ja:6ka:7la:8ma:9na:0oa:1pa:2qa:3ra:4sa:5ta:6ua:7va:8wa:9xa:0ya:1za:2{a:3|a:4}a:5~a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a:5a:6a:7a:8a:9a:0a:1a:2a:3a:4a: a:a:a:a:a:a:a:a:a:	a:
a:a:a:
a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a: a:!a:"a:#a:$a:%a:&a:'a:(a:)a:*a:,a:-a:.a:/a::a:;a:<a:=a:>a:?a:@a:Aa:Ba:Ca:Da:Ea:Fa:Ga:Ha:Ia:Ja:Ka:La:Ma:Na:Oa:Pa:Qa:Ra:Sa:Ta:Ua:Va:Wa:Xa:Ya:Za:[a:\a:]a:^a:_a:`a:aa:ba:ca:da:ea:fa:ga:ha:ia:ja:ka:la:ma:na:oa:pa:qa:ra:sa:ta:ua:va:wa:xa:ya:za:{a:|a:}a:~a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a:a aaaaaaaaa	a
aaa
aaaaaaaaaaaaaaaaaaa a!a"a#a$a%a&a'a(a)a*a+a,a-a.a/a0a1a2a3a4a5a6a7a8a9a;a<a=a>a?a@aAaBaCaDaEaFaGaHaIaJaKaLaMaNaOaPaQaRaSaTaUaVaWaXaYaZa[a\a]a^a_a`aaabacadaeafagahaiajakalamanaoapaqarasatauavawaxayaza{a|a}a~aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab:0;b:1;b:0 b:1b:0b:1b:0b:1b:0b:1b:0b:1	b:0
b:1b:0b:1
b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0 b:1!b:0"b:1#b:0$b:1%b:0&b:1'b:0(b:1)b:0*b:1+b:0,b:1-b:0.b:1/b:00b:11b:02b:13b:04b:15b:06b:17b:08b:19b:0:b:1<b:0=b:1>b:0?b:1@b:0Ab:1Bb:0Cb:1Db:0Eb:1Fb:0Gb:1Hb:0Ib:1Jb:0Kb:1Lb:0Mb:1Nb:0Ob:1Pb:0Qb:1Rb:0Sb:1Tb:0Ub:1Vb:0Wb:1Xb:0Yb:1Zb:0[b:1\b:0]b:1^b:0_b:1`b:0ab:1bb:0cb:1db:0eb:1fb:0gb:1hb:0ib:1jb:0kb:1lb:0mb:1nb:0ob:1pb:0qb:1rb:0sb:1tb:0ub:1vb:0wb:1xb:0yb:1zb:0{b:1|b:0}b:1~b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b:1b:0b: b:b:b:b:b:b:b:b:b:	b:
b:b:b:
b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b: b:!b:"b:#b:$b:%b:&b:'b:(b:)b:*b:+b:,b:-b:.b:/b:2b:3b:4b:5b:6b:7b:8b:9b::b:;b:<b:=b:>b:?b:@b:Ab:Bb:Cb:Db:Eb:Fb:Gb:Hb:Ib:Jb:Kb:Lb:Mb:Nb:Ob:Pb:Qb:Rb:Sb:Tb:Ub:Vb:Wb:Xb:Yb:Zb:[b:\b:]b:^b:_b:`b:ab:bb:cb:db:eb:fb:gb:hb:ib:jb:kb:lb:mb:nb:ob:pb:qb:rb:sb:tb:ub:vb:wb:xb:yb:zb:{b:|b:}b:~b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b bbbbbbbbb	b
bbb
bbbbbbbbbbbbbbbbbbb b!b"b#b$b%b&b'b(b)b*b+b,b-b.b/b0b1b2b3b4b5b6b7b8b9b;b<b=b>b?b@bAbBbCbDbEbFbGbHbIbJbKbLbMbNbObPbQbRbSbTbUbVbWbXbYbZb[b\b]b^b_b`babbbcbdbebfbgbhbibjbkblbmbnbobpbqbrbsbtbubvbwbxbybzb{b|b}b~bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbd:+.00;d:+.11;d:+.22;d:+.33;d:+.44;d:+.55;d:+.66;d:+.77;d:+.88;d:+.99;d:+.00E+0;d:+.11e-1;d:+.22E+2;d:+.33e-3;d:+.44E+4;d:+.55e-5;d:+.66E+6;d:+.77e-7;d:+.88E+8;d:+.99e-9;d:+.00E+00;d:+.11e-11;d:+.22E+22;d:+.33e-33;d:+.44E+44;d:+.55e-55;d:+.66E+66;d:+.77e-77;d:+.88E+88;d:+.99e-99;d:+.00E+00 d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99	d:+.00E+00
d:+.11e-11d:+.22E+22d:+.33e-33
d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22 d:+.33e-33!d:+.44E+44"d:+.55e-55#d:+.66E+66$d:+.77e-77%d:+.88E+88&d:+.99e-99'd:+.00E+00(d:+.11e-11)d:+.22E+22*d:+.33e-33+d:+.44E+44,d:+.55e-55-d:+.66E+66.d:+.77e-77/d:+.88E+88:d:+.99e-99<d:+.00E+00=d:+.11e-11>d:+.22E+22?d:+.33e-33@d:+.44E+44Ad:+.55e-55Bd:+.66E+66Cd:+.77e-77Dd:+.88E+88Ed:+.99e-99Fd:+.00E+00Gd:+.11e-11Hd:+.22E+22Id:+.33e-33Jd:+.44E+44Kd:+.55e-55Ld:+.66E+66Md:+.77e-77Nd:+.88E+88Od:+.99e-99Pd:+.00E+00Qd:+.11e-11Rd:+.22E+22Sd:+.33e-33Td:+.44E+44Ud:+.55e-55Vd:+.66E+66Wd:+.77e-77Xd:+.88E+88Yd:+.99e-99Zd:+.00E+00[d:+.11e-11\d:+.22E+22]d:+.33e-33^d:+.44E+44_d:+.55e-55`d:+.66E+66ad:+.77e-77bd:+.88E+88cd:+.99e-99dd:+.00E+00ed:+.11e-11fd:+.22E+22gd:+.33e-33hd:+.44E+44id:+.55e-55jd:+.66E+66kd:+.77e-77ld:+.88E+88md:+.99e-99nd:+.00E+00od:+.11e-11pd:+.22E+22qd:+.33e-33rd:+.44E+44sd:+.55e-55td:+.66E+66ud:+.77e-77vd:+.88E+88wd:+.99e-99xd:+.00E+00yd:+.11e-11zd:+.22E+22{d:+.33e-33|d:+.44E+44}d:+.55e-55~d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.55e-55d:+.66E+66d:+.77e-77d:+.88E+88d:+.99e-99d:+.00E+00d:+.11e-11d:+.22E+22d:+.33e-33d:+.44E+44d:+.00E+0 d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9	d:+.00E+0
d:+.11e-1d:+.22E+2d:+.33e-3
d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2 d:+.33e-3!d:+.44E+4"d:+.55e-5#d:+.66E+6$d:+.77e-7%d:+.88E+8&d:+.99e-9'd:+.00E+0(d:+.11e-1)d:+.22E+2*d:+.33e-3+d:+.44E+4,d:+.55e-5-d:+.66E+6.d:+.77e-7/d:+.88E+8:d:+.99e-9<d:+.00E+0=d:+.11e-1>d:+.22E+2?d:+.33e-3@d:+.44E+4Ad:+.55e-5Bd:+.66E+6Cd:+.77e-7Dd:+.88E+8Ed:+.99e-9Fd:+.00E+0Gd:+.11e-1Hd:+.22E+2Id:+.33e-3Jd:+.44E+4Kd:+.55e-5Ld:+.66E+6Md:+.77e-7Nd:+.88E+8Od:+.99e-9Pd:+.00E+0Qd:+.11e-1Rd:+.22E+2Sd:+.33e-3Td:+.44E+4Ud:+.55e-5Vd:+.66E+6Wd:+.77e-7Xd:+.88E+8Yd:+.99e-9Zd:+.00E+0[d:+.11e-1\d:+.22E+2]d:+.33e-3^d:+.44E+4_d:+.55e-5`d:+.66E+6ad:+.77e-7bd:+.88E+8cd:+.99e-9dd:+.00E+0ed:+.11e-1fd:+.22E+2gd:+.33e-3hd:+.44E+4id:+.55e-5jd:+.66E+6kd:+.77e-7ld:+.88E+8md:+.99e-9nd:+.00E+0od:+.11e-1pd:+.22E+2qd:+.33e-3rd:+.44E+4sd:+.55e-5td:+.66E+6ud:+.77e-7vd:+.88E+8wd:+.99e-9xd:+.00E+0yd:+.11e-1zd:+.22E+2{d:+.33e-3|d:+.44E+4}d:+.55e-5~d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.55e-5d:+.66E+6d:+.77e-7d:+.88E+8d:+.99e-9d:+.00E+0d:+.11e-1d:+.22E+2d:+.33e-3d:+.44E+4d:+.00E++0;d:+.11e--1;d:+.22E++2;d:+.33e--3;d:+.44E++4;d:+.55e--5;d:+.66E++6;d:+.77e--7;d:+.88E++8;d:+.99e--9;d:+.00E++ d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--	d:+.00E++
d:+.11e--d:+.22E++d:+.33e--
d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++ d:+.33e--!d:+.44E++"d:+.55e--#d:+.66E++$d:+.77e--%d:+.88E++&d:+.99e--'d:+.00E++(d:+.11e--)d:+.22E++*d:+.33e--+d:+.44E++,d:+.55e---d:+.66E++.d:+.77e--/d:+.88E++:d:+.99e--;d:+.00E++<d:+.11e--=d:+.22E++>d:+.33e--?d:+.44E++@d:+.55e--Ad:+.66E++Bd:+.77e--Cd:+.88E++Dd:+.99e--Ed:+.00E++Fd:+.11e--Gd:+.22E++Hd:+.33e--Id:+.44E++Jd:+.55e--Kd:+.66E++Ld:+.77e--Md:+.88E++Nd:+.99e--Od:+.00E++Pd:+.11e--Qd:+.22E++Rd:+.33e--Sd:+.44E++Td:+.55e--Ud:+.66E++Vd:+.77e--Wd:+.88E++Xd:+.99e--Yd:+.00E++Zd:+.11e--[d:+.22E++\d:+.33e--]d:+.44E++^d:+.55e--_d:+.66E++`d:+.77e--ad:+.88E++bd:+.99e--cd:+.00E++dd:+.11e--ed:+.22E++fd:+.33e--gd:+.44E++hd:+.55e--id:+.66E++jd:+.77e--kd:+.88E++ld:+.99e--md:+.00E++nd:+.11e--od:+.22E++pd:+.33e--qd:+.44E++rd:+.55e--sd:+.66E++td:+.77e--ud:+.88E++vd:+.99e--wd:+.00E++xd:+.11e--yd:+.22E++zd:+.33e--{d:+.44E++|d:+.55e--}d:+.66E++~d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.66E++d:+.77e--d:+.88E++d:+.99e--d:+.00E++d:+.11e--d:+.22E++d:+.33e--d:+.44E++d:+.55e--d:+.00E+ d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-	d:+.00E+
d:+.11e-d:+.22E+d:+.33e-
d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+ d:+.33e-!d:+.44E+"d:+.55e-#d:+.66E+$d:+.77e-%d:+.88E+&d:+.99e-'d:+.00E+(d:+.11e-)d:+.22E+*d:+.33e-,d:+.44E+.d:+.55e-/d:+.66E+:d:+.77e-;d:+.88E+<d:+.99e-=d:+.00E+>d:+.11e-?d:+.22E+@d:+.33e-Ad:+.44E+Bd:+.55e-Cd:+.66E+Dd:+.77e-Ed:+.88E+Fd:+.99e-Gd:+.00E+Hd:+.11e-Id:+.22E+Jd:+.33e-Kd:+.44E+Ld:+.55e-Md:+.66E+Nd:+.77e-Od:+.88E+Pd:+.99e-Qd:+.00E+Rd:+.11e-Sd:+.22E+Td:+.33e-Ud:+.44E+Vd:+.55e-Wd:+.66E+Xd:+.77e-Yd:+.88E+Zd:+.99e-[d:+.00E+\d:+.11e-]d:+.22E+^d:+.33e-_d:+.44E+`d:+.55e-ad:+.66E+bd:+.77e-cd:+.88E+dd:+.99e-ed:+.00E+fd:+.11e-gd:+.22E+hd:+.33e-id:+.44E+jd:+.55e-kd:+.66E+ld:+.77e-md:+.88E+nd:+.99e-od:+.00E+pd:+.11e-qd:+.22E+rd:+.33e-sd:+.44E+td:+.55e-ud:+.66E+vd:+.77e-wd:+.88E+xd:+.99e-yd:+.00E+zd:+.11e-{d:+.22E+|d:+.33e-}d:+.44E+~d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.44E+d:+.55e-d:+.66E+d:+.77e-d:+.88E+d:+.99e-d:+.00E+d:+.11e-d:+.22E+d:+.33e-d:+.00E0;d:+.11e1;d:+.22E2;d:+.33e3;d:+.44E4;d:+.55e5;d:+.66E6;d:+.77e7;d:+.88E8;d:+.99e9;d:+.00E d:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99e	d:+.00E
d:+.11ed:+.22Ed:+.33e
d:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22E d:+.33e!d:+.44E"d:+.55e#d:+.66E$d:+.77e%d:+.88E&d:+.99e'd:+.00E(d:+.11e)d:+.22E*d:+.33e,d:+.44E.d:+.55e/d:+.66E:d:+.77e;d:+.88E<d:+.99e=d:+.00E>d:+.11e?d:+.22E@d:+.33eAd:+.44EBd:+.55eCd:+.66EDd:+.77eEd:+.88EFd:+.99eGd:+.00EHd:+.11eId:+.22EJd:+.33eKd:+.44ELd:+.55eMd:+.66ENd:+.77eOd:+.88EPd:+.99eQd:+.00ERd:+.11eSd:+.22ETd:+.33eUd:+.44EVd:+.55eWd:+.66EXd:+.77eYd:+.88EZd:+.99e[d:+.00E\d:+.11e]d:+.22E^d:+.33e_d:+.44E`d:+.55ead:+.66Ebd:+.77ecd:+.88Edd:+.99eed:+.00Efd:+.11egd:+.22Ehd:+.33eid:+.44Ejd:+.55ekd:+.66Eld:+.77emd:+.88End:+.99eod:+.00Epd:+.11eqd:+.22Erd:+.33esd:+.44Etd:+.55eud:+.66Evd:+.77ewd:+.88Exd:+.99eyd:+.00Ezd:+.11e{d:+.22E|d:+.33e}d:+.44E~d:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.44Ed:+.55ed:+.66Ed:+.77ed:+.88Ed:+.99ed:+.00Ed:+.11ed:+.22Ed:+.33ed:+.00 d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99	d:+.00
d:+.11d:+.22d:+.33
d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22 d:+.33!d:+.44"d:+.55#d:+.66$d:+.77%d:+.88&d:+.99'd:+.00(d:+.11)d:+.22*d:+.33+d:+.44,d:+.55-d:+.66.d:+.77/d:+.88:d:+.99<d:+.00=d:+.11>d:+.22?d:+.33@d:+.44Ad:+.55Bd:+.66Cd:+.77Dd:+.88Fd:+.99Gd:+.00Hd:+.11Id:+.22Jd:+.33Kd:+.44Ld:+.55Md:+.66Nd:+.77Od:+.88Pd:+.99Qd:+.00Rd:+.11Sd:+.22Td:+.33Ud:+.44Vd:+.55Wd:+.66Xd:+.77Yd:+.88Zd:+.99[d:+.00\d:+.11]d:+.22^d:+.33_d:+.44`d:+.55ad:+.66bd:+.77cd:+.88dd:+.99fd:+.00gd:+.11hd:+.22id:+.33jd:+.44kd:+.55ld:+.66md:+.77nd:+.88od:+.99pd:+.00qd:+.11rd:+.22sd:+.33td:+.44ud:+.55vd:+.66wd:+.77xd:+.88yd:+.99zd:+.00{d:+.11|d:+.22}d:+.33~d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.33d:+.44d:+.55d:+.66d:+.77d:+.88d:+.99d:+.00d:+.11d:+.22d:+.0;d:+.1;d:+.2;d:+.3;d:+.4;d:+.5;d:+.6;d:+.7;d:+.8;d:+.9;d:+.0E d:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9e	d:+.0E
d:+.1ed:+.2Ed:+.3e
d:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2E d:+.3e!d:+.4E"d:+.5e#d:+.6E$d:+.7e%d:+.8E&d:+.9e'd:+.0E(d:+.1e)d:+.2E*d:+.3e,d:+.4E.d:+.5e/d:+.6E:d:+.7e;d:+.8E<d:+.9e=d:+.0E>d:+.1e?d:+.2E@d:+.3eAd:+.4EBd:+.5eCd:+.6EDd:+.7eEd:+.8EFd:+.9eGd:+.0EHd:+.1eId:+.2EJd:+.3eKd:+.4ELd:+.5eMd:+.6ENd:+.7eOd:+.8EPd:+.9eQd:+.0ERd:+.1eSd:+.2ETd:+.3eUd:+.4EVd:+.5eWd:+.6EXd:+.7eYd:+.8EZd:+.9e[d:+.0E\d:+.1e]d:+.2E^d:+.3e_d:+.4E`d:+.5ead:+.6Ebd:+.7ecd:+.8Edd:+.9eed:+.0Efd:+.1egd:+.2Ehd:+.3eid:+.4Ejd:+.5ekd:+.6Eld:+.7emd:+.8End:+.9eod:+.0Epd:+.1eqd:+.2Erd:+.3esd:+.4Etd:+.5eud:+.6Evd:+.7ewd:+.8Exd:+.9eyd:+.0Ezd:+.1e{d:+.2E|d:+.3e}d:+.4E~d:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.4Ed:+.5ed:+.6Ed:+.7ed:+.8Ed:+.9ed:+.0Ed:+.1ed:+.2Ed:+.3ed:+.0 d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9	d:+.0
d:+.1d:+.2d:+.3
d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2 d:+.3!d:+.4"d:+.5#d:+.6$d:+.7%d:+.8&d:+.9'd:+.0(d:+.1)d:+.2*d:+.3+d:+.4,d:+.5-d:+.6.d:+.7/d:+.8:d:+.9<d:+.0=d:+.1>d:+.2?d:+.3@d:+.4Ad:+.5Bd:+.6Cd:+.7Dd:+.8Fd:+.9Gd:+.0Hd:+.1Id:+.2Jd:+.3Kd:+.4Ld:+.5Md:+.6Nd:+.7Od:+.8Pd:+.9Qd:+.0Rd:+.1Sd:+.2Td:+.3Ud:+.4Vd:+.5Wd:+.6Xd:+.7Yd:+.8Zd:+.9[d:+.0\d:+.1]d:+.2^d:+.3_d:+.4`d:+.5ad:+.6bd:+.7cd:+.8dd:+.9fd:+.0gd:+.1hd:+.2id:+.3jd:+.4kd:+.5ld:+.6md:+.7nd:+.8od:+.9pd:+.0qd:+.1rd:+.2sd:+.3td:+.4ud:+.5vd:+.6wd:+.7xd:+.8yd:+.9zd:+.0{d:+.1|d:+.2}d:+.3~d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+.3d:+.4d:+.5d:+.6d:+.7d:+.8d:+.9d:+.0d:+.1d:+.2d:+. d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.	d:+.
d:+.d:+.d:+.
d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+. d:+.!d:+."d:+.#d:+.$d:+.%d:+.&d:+.'d:+.(d:+.)d:+.*d:+.+d:+.,d:+.-d:+..d:+./d:+.:d:+.;d:+.<d:+.=d:+.>d:+.?d:+.@d:+.Ad:+.Bd:+.Cd:+.Dd:+.Ed:+.Fd:+.Gd:+.Hd:+.Id:+.Jd:+.Kd:+.Ld:+.Md:+.Nd:+.Od:+.Pd:+.Qd:+.Rd:+.Sd:+.Td:+.Ud:+.Vd:+.Wd:+.Xd:+.Yd:+.Zd:+.[d:+.\d:+.]d:+.^d:+._d:+.`d:+.ad:+.bd:+.cd:+.dd:+.ed:+.fd:+.gd:+.hd:+.id:+.jd:+.kd:+.ld:+.md:+.nd:+.od:+.pd:+.qd:+.rd:+.sd:+.td:+.ud:+.vd:+.wd:+.xd:+.yd:+.zd:+.{d:+.|d:+.}d:+.~d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+.d:+00.;d:+11.;d:+22.;d:+33.;d:+44.;d:+55.;d:+66.;d:+77.;d:+88.;d:+99.;d:+00.E d:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.e	d:+00.E
d:+11.ed:+22.Ed:+33.e
d:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.E d:+33.e!d:+44.E"d:+55.e#d:+66.E$d:+77.e%d:+88.E&d:+99.e'd:+00.E(d:+11.e)d:+22.E*d:+33.e,d:+44.E.d:+55.e/d:+66.E:d:+77.e;d:+88.E<d:+99.e=d:+00.E>d:+11.e?d:+22.E@d:+33.eAd:+44.EBd:+55.eCd:+66.EDd:+77.eEd:+88.EFd:+99.eGd:+00.EHd:+11.eId:+22.EJd:+33.eKd:+44.ELd:+55.eMd:+66.ENd:+77.eOd:+88.EPd:+99.eQd:+00.ERd:+11.eSd:+22.ETd:+33.eUd:+44.EVd:+55.eWd:+66.EXd:+77.eYd:+88.EZd:+99.e[d:+00.E\d:+11.e]d:+22.E^d:+33.e_d:+44.E`d:+55.ead:+66.Ebd:+77.ecd:+88.Edd:+99.eed:+00.Efd:+11.egd:+22.Ehd:+33.eid:+44.Ejd:+55.ekd:+66.Eld:+77.emd:+88.End:+99.eod:+00.Epd:+11.eqd:+22.Erd:+33.esd:+44.Etd:+55.eud:+66.Evd:+77.ewd:+88.Exd:+99.eyd:+00.Ezd:+11.e{d:+22.E|d:+33.e}d:+44.E~d:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+44.Ed:+55.ed:+66.Ed:+77.ed:+88.Ed:+99.ed:+00.Ed:+11.ed:+22.Ed:+33.ed:+00.0;d:+11.1;d:+22.2;d:+33.3;d:+44.4;d:+55.5;d:+66.6;d:+77.7;d:+88.8;d:+99.9;d:+00.0E d:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9e	d:+00.0E
d:+11.1ed:+22.2Ed:+33.3e
d:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2E d:+33.3e!d:+44.4E"d:+55.5e#d:+66.6E$d:+77.7e%d:+88.8E&d:+99.9e'd:+00.0E(d:+11.1e)d:+22.2E*d:+33.3e,d:+44.4E.d:+55.5e/d:+66.6E:d:+77.7e;d:+88.8E<d:+99.9e=d:+00.0E>d:+11.1e?d:+22.2E@d:+33.3eAd:+44.4EBd:+55.5eCd:+66.6EDd:+77.7eEd:+88.8EFd:+99.9eGd:+00.0EHd:+11.1eId:+22.2EJd:+33.3eKd:+44.4ELd:+55.5eMd:+66.6ENd:+77.7eOd:+88.8EPd:+99.9eQd:+00.0ERd:+11.1eSd:+22.2ETd:+33.3eUd:+44.4EVd:+55.5eWd:+66.6EXd:+77.7eYd:+88.8EZd:+99.9e[d:+00.0E\d:+11.1e]d:+22.2E^d:+33.3e_d:+44.4E`d:+55.5ead:+66.6Ebd:+77.7ecd:+88.8Edd:+99.9eed:+00.0Efd:+11.1egd:+22.2Ehd:+33.3eid:+44.4Ejd:+55.5ekd:+66.6Eld:+77.7emd:+88.8End:+99.9eod:+00.0Epd:+11.1eqd:+22.2Erd:+33.3esd:+44.4Etd:+55.5eud:+66.6Evd:+77.7ewd:+88.8Exd:+99.9eyd:+00.0Ezd:+11.1e{d:+22.2E|d:+33.3e}d:+44.4E~d:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+44.4Ed:+55.5ed:+66.6Ed:+77.7ed:+88.8Ed:+99.9ed:+00.0Ed:+11.1ed:+22.2Ed:+33.3ed:+00.00;d:+11.11;d:+22.22;d:+33.33;d:+44.44;d:+55.55;d:+66.66;d:+77.77;d:+88.88;d:+99.99;d:+00.00E d:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99e	d:+00.00E
d:+11.11ed:+22.22Ed:+33.33e
d:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22E d:+33.33e!d:+44.44E"d:+55.55e#d:+66.66E$d:+77.77e%d:+88.88E&d:+99.99e'd:+00.00E(d:+11.11e)d:+22.22E*d:+33.33e,d:+44.44E.d:+55.55e/d:+66.66E:d:+77.77e;d:+88.88E<d:+99.99e=d:+00.00E>d:+11.11e?d:+22.22E@d:+33.33eAd:+44.44EBd:+55.55eCd:+66.66EDd:+77.77eEd:+88.88EFd:+99.99eGd:+00.00EHd:+11.11eId:+22.22EJd:+33.33eKd:+44.44ELd:+55.55eMd:+66.66ENd:+77.77eOd:+88.88EPd:+99.99eQd:+00.00ERd:+11.11eSd:+22.22ETd:+33.33eUd:+44.44EVd:+55.55eWd:+66.66EXd:+77.77eYd:+88.88EZd:+99.99e[d:+00.00E\d:+11.11e]d:+22.22E^d:+33.33e_d:+44.44E`d:+55.55ead:+66.66Ebd:+77.77ecd:+88.88Edd:+99.99eed:+00.00Efd:+11.11egd:+22.22Ehd:+33.33eid:+44.44Ejd:+55.55ekd:+66.66Eld:+77.77emd:+88.88End:+99.99eod:+00.00Epd:+11.11eqd:+22.22Erd:+33.33esd:+44.44Etd:+55.55eud:+66.66Evd:+77.77ewd:+88.88Exd:+99.99eyd:+00.00Ezd:+11.11e{d:+22.22E|d:+33.33e}d:+44.44E~d:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+44.44Ed:+55.55ed:+66.66Ed:+77.77ed:+88.88Ed:+99.99ed:+00.00Ed:+11.11ed:+22.22Ed:+33.33ed:+00.00 d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99	d:+00.00
d:+11.11d:+22.22d:+33.33
d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22 d:+33.33!d:+44.44"d:+55.55#d:+66.66$d:+77.77%d:+88.88&d:+99.99'd:+00.00(d:+11.11)d:+22.22*d:+33.33+d:+44.44,d:+55.55-d:+66.66.d:+77.77/d:+88.88:d:+99.99<d:+00.00=d:+11.11>d:+22.22?d:+33.33@d:+44.44Ad:+55.55Bd:+66.66Cd:+77.77Dd:+88.88Fd:+99.99Gd:+00.00Hd:+11.11Id:+22.22Jd:+33.33Kd:+44.44Ld:+55.55Md:+66.66Nd:+77.77Od:+88.88Pd:+99.99Qd:+00.00Rd:+11.11Sd:+22.22Td:+33.33Ud:+44.44Vd:+55.55Wd:+66.66Xd:+77.77Yd:+88.88Zd:+99.99[d:+00.00\d:+11.11]d:+22.22^d:+33.33_d:+44.44`d:+55.55ad:+66.66bd:+77.77cd:+88.88dd:+99.99fd:+00.00gd:+11.11hd:+22.22id:+33.33jd:+44.44kd:+55.55ld:+66.66md:+77.77nd:+88.88od:+99.99pd:+00.00qd:+11.11rd:+22.22sd:+33.33td:+44.44ud:+55.55vd:+66.66wd:+77.77xd:+88.88yd:+99.99zd:+00.00{d:+11.11|d:+22.22}d:+33.33~d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+33.33d:+44.44d:+55.55d:+66.66d:+77.77d:+88.88d:+99.99d:+00.00d:+11.11d:+22.22d:+00.0 d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9	d:+00.0
d:+11.1d:+22.2d:+33.3
d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2 d:+33.3!d:+44.4"d:+55.5#d:+66.6$d:+77.7%d:+88.8&d:+99.9'd:+00.0(d:+11.1)d:+22.2*d:+33.3+d:+44.4,d:+55.5-d:+66.6.d:+77.7/d:+88.8:d:+99.9<d:+00.0=d:+11.1>d:+22.2?d:+33.3@d:+44.4Ad:+55.5Bd:+66.6Cd:+77.7Dd:+88.8Fd:+99.9Gd:+00.0Hd:+11.1Id:+22.2Jd:+33.3Kd:+44.4Ld:+55.5Md:+66.6Nd:+77.7Od:+88.8Pd:+99.9Qd:+00.0Rd:+11.1Sd:+22.2Td:+33.3Ud:+44.4Vd:+55.5Wd:+66.6Xd:+77.7Yd:+88.8Zd:+99.9[d:+00.0\d:+11.1]d:+22.2^d:+33.3_d:+44.4`d:+55.5ad:+66.6bd:+77.7cd:+88.8dd:+99.9fd:+00.0gd:+11.1hd:+22.2id:+33.3jd:+44.4kd:+55.5ld:+66.6md:+77.7nd:+88.8od:+99.9pd:+00.0qd:+11.1rd:+22.2sd:+33.3td:+44.4ud:+55.5vd:+66.6wd:+77.7xd:+88.8yd:+99.9zd:+00.0{d:+11.1|d:+22.2}d:+33.3~d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+33.3d:+44.4d:+55.5d:+66.6d:+77.7d:+88.8d:+99.9d:+00.0d:+11.1d:+22.2d:+00. d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.	d:+00.
d:+11.d:+22.d:+33.
d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22. d:+33.!d:+44."d:+55.#d:+66.$d:+77.%d:+88.&d:+99.'d:+00.(d:+11.)d:+22.*d:+33.+d:+44.,d:+55.-d:+66..d:+77./d:+88.:d:+99.<d:+00.=d:+11.>d:+22.?d:+33.@d:+44.Ad:+55.Bd:+66.Cd:+77.Dd:+88.Fd:+99.Gd:+00.Hd:+11.Id:+22.Jd:+33.Kd:+44.Ld:+55.Md:+66.Nd:+77.Od:+88.Pd:+99.Qd:+00.Rd:+11.Sd:+22.Td:+33.Ud:+44.Vd:+55.Wd:+66.Xd:+77.Yd:+88.Zd:+99.[d:+00.\d:+11.]d:+22.^d:+33._d:+44.`d:+55.ad:+66.bd:+77.cd:+88.dd:+99.fd:+00.gd:+11.hd:+22.id:+33.jd:+44.kd:+55.ld:+66.md:+77.nd:+88.od:+99.pd:+00.qd:+11.rd:+22.sd:+33.td:+44.ud:+55.vd:+66.wd:+77.xd:+88.yd:+99.zd:+00.{d:+11.|d:+22.}d:+33.~d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+33.d:+44.d:+55.d:+66.d:+77.d:+88.d:+99.d:+00.d:+11.d:+22.d:+00;d:+11;d:+22;d:+33;d:+44;d:+55;d:+66;d:+77;d:+88;d:+99;d:+00E d:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99e	d:+00E
d:+11ed:+22Ed:+33e
d:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22E d:+33e!d:+44E"d:+55e#d:+66E$d:+77e%d:+88E&d:+99e'd:+00E(d:+11e)d:+22E*d:+33e,d:+44E.d:+55e/d:+66E:d:+77e;d:+88E<d:+99e=d:+00E>d:+11e?d:+22E@d:+33eAd:+44EBd:+55eCd:+66EDd:+77eEd:+88EFd:+99eGd:+00EHd:+11eId:+22EJd:+33eKd:+44ELd:+55eMd:+66ENd:+77eOd:+88EPd:+99eQd:+00ERd:+11eSd:+22ETd:+33eUd:+44EVd:+55eWd:+66EXd:+77eYd:+88EZd:+99e[d:+00E\d:+11e]d:+22E^d:+33e_d:+44E`d:+55ead:+66Ebd:+77ecd:+88Edd:+99eed:+00Efd:+11egd:+22Ehd:+33eid:+44Ejd:+55ekd:+66Eld:+77emd:+88End:+99eod:+00Epd:+11eqd:+22Erd:+33esd:+44Etd:+55eud:+66Evd:+77ewd:+88Exd:+99eyd:+00Ezd:+11e{d:+22E|d:+33e}d:+44E~d:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+44Ed:+55ed:+66Ed:+77ed:+88Ed:+99ed:+00Ed:+11ed:+22Ed:+33ed:+00 d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99	d:+00
d:+11d:+22d:+33
d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22 d:+33!d:+44"d:+55#d:+66$d:+77%d:+88&d:+99'd:+00(d:+11)d:+22*d:+33+d:+44,d:+55-d:+66/d:+77:d:+88<d:+99=d:+00>d:+11?d:+22@d:+33Ad:+44Bd:+55Cd:+66Dd:+77Fd:+88Gd:+99Hd:+00Id:+11Jd:+22Kd:+33Ld:+44Md:+55Nd:+66Od:+77Pd:+88Qd:+99Rd:+00Sd:+11Td:+22Ud:+33Vd:+44Wd:+55Xd:+66Yd:+77Zd:+88[d:+99\d:+00]d:+11^d:+22_d:+33`d:+44ad:+55bd:+66cd:+77dd:+88fd:+99gd:+00hd:+11id:+22jd:+33kd:+44ld:+55md:+66nd:+77od:+88pd:+99qd:+00rd:+11sd:+22td:+33ud:+44vd:+55wd:+66xd:+77yd:+88zd:+99{d:+00|d:+11}d:+22~d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+22d:+33d:+44d:+55d:+66d:+77d:+88d:+99d:+00d:+11d:+0.;d:+1.;d:+2.;d:+3.;d:+4.;d:+5.;d:+6.;d:+7.;d:+8.;d:+9.;d:+0;d:+1;d:+2;d:+3;d:+4;d:+5;d:+6;d:+7;d:+8;d:+9;d:+0E d:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9e	d:+0E
d:+1ed:+2Ed:+3e
d:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2E d:+3e!d:+4E"d:+5e#d:+6E$d:+7e%d:+8E&d:+9e'd:+0E(d:+1e)d:+2E*d:+3e,d:+4E.d:+5e/d:+6E:d:+7e;d:+8E<d:+9e=d:+0E>d:+1e?d:+2E@d:+3eAd:+4EBd:+5eCd:+6EDd:+7eEd:+8EFd:+9eGd:+0EHd:+1eId:+2EJd:+3eKd:+4ELd:+5eMd:+6ENd:+7eOd:+8EPd:+9eQd:+0ERd:+1eSd:+2ETd:+3eUd:+4EVd:+5eWd:+6EXd:+7eYd:+8EZd:+9e[d:+0E\d:+1e]d:+2E^d:+3e_d:+4E`d:+5ead:+6Ebd:+7ecd:+8Edd:+9eed:+0Efd:+1egd:+2Ehd:+3eid:+4Ejd:+5ekd:+6Eld:+7emd:+8End:+9eod:+0Epd:+1eqd:+2Erd:+3esd:+4Etd:+5eud:+6Evd:+7ewd:+8Exd:+9eyd:+0Ezd:+1e{d:+2E|d:+3e}d:+4E~d:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+4Ed:+5ed:+6Ed:+7ed:+8Ed:+9ed:+0Ed:+1ed:+2Ed:+3ed:+0 d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9	d:+0
d:+1d:+2d:+3
d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2 d:+3!d:+4"d:+5#d:+6$d:+7%d:+8&d:+9'd:+0(d:+1)d:+2*d:+3+d:+4,d:+5-d:+6/d:+7:d:+8<d:+9=d:+0>d:+1?d:+2@d:+3Ad:+4Bd:+5Cd:+6Dd:+7Fd:+8Gd:+9Hd:+0Id:+1Jd:+2Kd:+3Ld:+4Md:+5Nd:+6Od:+7Pd:+8Qd:+9Rd:+0Sd:+1Td:+2Ud:+3Vd:+4Wd:+5Xd:+6Yd:+7Zd:+8[d:+9\d:+0]d:+1^d:+2_d:+3`d:+4ad:+5bd:+6cd:+7dd:+8fd:+9gd:+0hd:+1id:+2jd:+3kd:+4ld:+5md:+6nd:+7od:+8pd:+9qd:+0rd:+1sd:+2td:+3ud:+4vd:+5wd:+6xd:+7yd:+8zd:+9{d:+0|d:+1}d:+2~d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+2d:+3d:+4d:+5d:+6d:+7d:+8d:+9d:+0d:+1d:+ d:+d:+d:+d:+d:+d:+d:+d:+d:+	d:+
d:+d:+d:+
d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+ d:+!d:+"d:+#d:+$d:+%d:+&d:+'d:+(d:+)d:+*d:++d:+,d:+-d:+/d:+:d:+;d:+<d:+=d:+>d:+?d:+@d:+Ad:+Bd:+Cd:+Dd:+Ed:+Fd:+Gd:+Hd:+Id:+Jd:+Kd:+Ld:+Md:+Nd:+Od:+Pd:+Qd:+Rd:+Sd:+Td:+Ud:+Vd:+Wd:+Xd:+Yd:+Zd:+[d:+\d:+]d:+^d:+_d:+`d:+ad:+bd:+cd:+dd:+ed:+fd:+gd:+hd:+id:+jd:+kd:+ld:+md:+nd:+od:+pd:+qd:+rd:+sd:+td:+ud:+vd:+wd:+xd:+yd:+zd:+{d:+|d:+}d:+~d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:+d:-. d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.	d:-.
d:-.d:-.d:-.
d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-. d:-.!d:-."d:-.#d:-.$d:-.%d:-.&d:-.'d:-.(d:-.)d:-.*d:-.+d:-.,d:-.-d:-..d:-./d:-.:d:-.;d:-.<d:-.=d:-.>d:-.?d:-.@d:-.Ad:-.Bd:-.Cd:-.Dd:-.Ed:-.Fd:-.Gd:-.Hd:-.Id:-.Jd:-.Kd:-.Ld:-.Md:-.Nd:-.Od:-.Pd:-.Qd:-.Rd:-.Sd:-.Td:-.Ud:-.Vd:-.Wd:-.Xd:-.Yd:-.Zd:-.[d:-.\d:-.]d:-.^d:-._d:-.`d:-.ad:-.bd:-.cd:-.dd:-.ed:-.fd:-.gd:-.hd:-.id:-.jd:-.kd:-.ld:-.md:-.nd:-.od:-.pd:-.qd:-.rd:-.sd:-.td:-.ud:-.vd:-.wd:-.xd:-.yd:-.zd:-.{d:-.|d:-.}d:-.~d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-.d:-0;d:-1;d:-2;d:-3;d:-4;d:-5;d:-6;d:-7;d:-8;d:-9;d:-INF;d:-INF d:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INF	d:-INF
d:-INFd:-INFd:-INF
d:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INF d:-INF!d:-INF"d:-INF#d:-INF$d:-INF%d:-INF&d:-INF'd:-INF(d:-INF)d:-INF*d:-INF+d:-INF,d:-INF-d:-INF.d:-INF/d:-INF0d:-INF1d:-INF2d:-INF3d:-INF4d:-INF5d:-INF6d:-INF7d:-INF8d:-INF9d:-INF:d:-INF<d:-INF=d:-INF>d:-INF?d:-INF@d:-INFAd:-INFBd:-INFCd:-INFDd:-INFEd:-INFFd:-INFGd:-INFHd:-INFId:-INFJd:-INFKd:-INFLd:-INFMd:-INFNd:-INFOd:-INFPd:-INFQd:-INFRd:-INFSd:-INFTd:-INFUd:-INFVd:-INFWd:-INFXd:-INFYd:-INFZd:-INF[d:-INF\d:-INF]d:-INF^d:-INF_d:-INF`d:-INFad:-INFbd:-INFcd:-INFdd:-INFed:-INFfd:-INFgd:-INFhd:-INFid:-INFjd:-INFkd:-INFld:-INFmd:-INFnd:-INFod:-INFpd:-INFqd:-INFrd:-INFsd:-INFtd:-INFud:-INFvd:-INFwd:-INFxd:-INFyd:-INFzd:-INF{d:-INF|d:-INF}d:-INF~d:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-INFd:-IN d:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-IN	d:-IN
d:-INd:-INd:-IN
d:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-IN d:-IN!d:-IN"d:-IN#d:-IN$d:-IN%d:-IN&d:-IN'd:-IN(d:-IN)d:-IN*d:-IN+d:-IN,d:-IN-d:-IN.d:-IN/d:-IN0d:-IN1d:-IN2d:-IN3d:-IN4d:-IN5d:-IN6d:-IN7d:-IN8d:-IN9d:-IN:d:-IN;d:-IN<d:-IN=d:-IN>d:-IN?d:-IN@d:-INAd:-INBd:-INCd:-INDd:-INEd:-INGd:-INHd:-INId:-INJd:-INKd:-INLd:-INMd:-INNd:-INOd:-INPd:-INQd:-INRd:-INSd:-INTd:-INUd:-INVd:-INWd:-INXd:-INYd:-INZd:-IN[d:-IN\d:-IN]d:-IN^d:-IN_d:-IN`d:-INad:-INbd:-INcd:-INdd:-INed:-INfd:-INgd:-INhd:-INid:-INjd:-INkd:-INld:-INmd:-INnd:-INod:-INpd:-INqd:-INrd:-INsd:-INtd:-INud:-INvd:-INwd:-INxd:-INyd:-INzd:-IN{d:-IN|d:-IN}d:-IN~d:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-INd:-I d:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-I	d:-I
d:-Id:-Id:-I
d:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-I d:-I!d:-I"d:-I#d:-I$d:-I%d:-I&d:-I'd:-I(d:-I)d:-I*d:-I+d:-I,d:-I-d:-I.d:-I/d:-I0d:-I1d:-I2d:-I3d:-I4d:-I5d:-I6d:-I7d:-I8d:-I9d:-I:d:-I;d:-I<d:-I=d:-I>d:-I?d:-I@d:-IAd:-IBd:-ICd:-IDd:-IEd:-IFd:-IGd:-IHd:-IId:-IJd:-IKd:-ILd:-IMd:-IOd:-IPd:-IQd:-IRd:-ISd:-ITd:-IUd:-IVd:-IWd:-IXd:-IYd:-IZd:-I[d:-I\d:-I]d:-I^d:-I_d:-I`d:-Iad:-Ibd:-Icd:-Idd:-Ied:-Ifd:-Igd:-Ihd:-Iid:-Ijd:-Ikd:-Ild:-Imd:-Ind:-Iod:-Ipd:-Iqd:-Ird:-Isd:-Itd:-Iud:-Ivd:-Iwd:-Ixd:-Iyd:-Izd:-I{d:-I|d:-I}d:-I~d:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:-Id:- d:-d:-d:-d:-d:-d:-d:-d:-d:-	d:-
d:-d:-d:-
d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:- d:-!d:-"d:-#d:-$d:-%d:-&d:-'d:-(d:-)d:-*d:-+d:-,d:--d:-/d:-:d:-;d:-<d:-=d:->d:-?d:-@d:-Ad:-Bd:-Cd:-Dd:-Ed:-Fd:-Gd:-Hd:-Jd:-Kd:-Ld:-Md:-Nd:-Od:-Pd:-Qd:-Rd:-Sd:-Td:-Ud:-Vd:-Wd:-Xd:-Yd:-Zd:-[d:-\d:-]d:-^d:-_d:-`d:-ad:-bd:-cd:-dd:-ed:-fd:-gd:-hd:-id:-jd:-kd:-ld:-md:-nd:-od:-pd:-qd:-rd:-sd:-td:-ud:-vd:-wd:-xd:-yd:-zd:-{d:-|d:-}d:-~d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:-d:. d:.d:.d:.d:.d:.d:.d:.d:.d:.	d:.
d:.d:.d:.
d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:. d:.!d:."d:.#d:.$d:.%d:.&d:.'d:.(d:.)d:.*d:.+d:.,d:.-d:..d:./d:.:d:.;d:.<d:.=d:.>d:.?d:.@d:.Ad:.Bd:.Cd:.Dd:.Ed:.Fd:.Gd:.Hd:.Id:.Jd:.Kd:.Ld:.Md:.Nd:.Od:.Pd:.Qd:.Rd:.Sd:.Td:.Ud:.Vd:.Wd:.Xd:.Yd:.Zd:.[d:.\d:.]d:.^d:._d:.`d:.ad:.bd:.cd:.dd:.ed:.fd:.gd:.hd:.id:.jd:.kd:.ld:.md:.nd:.od:.pd:.qd:.rd:.sd:.td:.ud:.vd:.wd:.xd:.yd:.zd:.{d:.|d:.}d:.~d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:.d:0;d:1;d:2;d:3;d:4;d:5;d:6;d:7;d:8;d:9;d:I d:Id:Id:Id:Id:Id:Id:Id:Id:I	d:I
d:Id:Id:I
d:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:I d:I!d:I"d:I#d:I$d:I%d:I&d:I'd:I(d:I)d:I*d:I+d:I,d:I-d:I.d:I/d:I0d:I1d:I2d:I3d:I4d:I5d:I6d:I7d:I8d:I9d:I:d:I;d:I<d:I=d:I>d:I?d:I@d:IAd:IBd:ICd:IDd:IEd:IFd:IGd:IHd:IId:IJd:IKd:ILd:IMd:IOd:IPd:IQd:IRd:ISd:ITd:IUd:IVd:IWd:IXd:IYd:IZd:I[d:I\d:I]d:I^d:I_d:I`d:Iad:Ibd:Icd:Idd:Ied:Ifd:Igd:Ihd:Iid:Ijd:Ikd:Ild:Imd:Ind:Iod:Ipd:Iqd:Ird:Isd:Itd:Iud:Ivd:Iwd:Ixd:Iyd:Izd:I{d:I|d:I}d:I~d:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:Id:NAN;d:NA d:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NA	d:NA
d:NAd:NAd:NA
d:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NA d:NA!d:NA"d:NA#d:NA$d:NA%d:NA&d:NA'd:NA(d:NA)d:NA*d:NA+d:NA,d:NA-d:NA.d:NA/d:NA0d:NA1d:NA2d:NA3d:NA4d:NA5d:NA6d:NA7d:NA8d:NA9d:NA:d:NA;d:NA<d:NA=d:NA>d:NA?d:NA@d:NAAd:NABd:NACd:NADd:NAEd:NAFd:NAGd:NAHd:NAId:NAJd:NAKd:NALd:NAMd:NAOd:NAPd:NAQd:NARd:NASd:NATd:NAUd:NAVd:NAWd:NAXd:NAYd:NAZd:NA[d:NA\d:NA]d:NA^d:NA_d:NA`d:NAad:NAbd:NAcd:NAdd:NAed:NAfd:NAgd:NAhd:NAid:NAjd:NAkd:NAld:NAmd:NAnd:NAod:NApd:NAqd:NArd:NAsd:NAtd:NAud:NAvd:NAwd:NAxd:NAyd:NAzd:NA{d:NA|d:NA}d:NA~d:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:NAd:N d:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:N	d:N
d:Nd:Nd:N
d:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:N d:N!d:N"d:N#d:N$d:N%d:N&d:N'd:N(d:N)d:N*d:N+d:N,d:N-d:N.d:N/d:N0d:N1d:N2d:N3d:N4d:N5d:N6d:N7d:N8d:N9d:N:d:N;d:N<d:N=d:N>d:N?d:N@d:NBd:NCd:NDd:NEd:NFd:NGd:NHd:NId:NJd:NKd:NLd:NMd:NNd:NOd:NPd:NQd:NRd:NSd:NTd:NUd:NVd:NWd:NXd:NYd:NZd:N[d:N\d:N]d:N^d:N_d:N`d:Nad:Nbd:Ncd:Ndd:Ned:Nfd:Ngd:Nhd:Nid:Njd:Nkd:Nld:Nmd:Nnd:Nod:Npd:Nqd:Nrd:Nsd:Ntd:Nud:Nvd:Nwd:Nxd:Nyd:Nzd:N{d:N|d:N}d:N~d:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd:Nd: d:d:d:d:d:d:d:d:d:	d:
d:d:d:
d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d: d:!d:"d:#d:$d:%d:&d:'d:(d:)d:*d:,d:/d::d:;d:<d:=d:>d:?d:@d:Ad:Bd:Cd:Dd:Ed:Fd:Gd:Hd:Jd:Kd:Ld:Md:Od:Pd:Qd:Rd:Sd:Td:Ud:Vd:Wd:Xd:Yd:Zd:[d:\d:]d:^d:_d:`d:ad:bd:cd:dd:ed:fd:gd:hd:id:jd:kd:ld:md:nd:od:pd:qd:rd:sd:td:ud:vd:wd:xd:yd:zd:{d:|d:}d:~d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d:d ddddddddd	d
ddd
ddddddddddddddddddd d!d"d#d$d%d&d'd(d)d*d+d,d-d.d/d0d1d2d3d4d5d6d7d8d9d;d<d=d>d?d@dAdBdCdDdEdFdGdHdIdJdKdLdMdNdOdPdQdRdSdTdUdVdWdXdYdZd[d\d]d^d_d`dadbdcdddedfdgdhdidjdkdldmdndodpdqdrdsdtdudvdwdxdydzd{d|d}d~dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddi:+00;i:-11;i:+22;i:-33;i:+44;i:-55;i:+66;i:-77;i:+88;i:-99;i:+00 i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99	i:+00
i:-11i:+22i:-33
i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22 i:-33!i:+44"i:-55#i:+66$i:-77%i:+88&i:-99'i:+00(i:-11)i:+22*i:-33+i:+44,i:-55-i:+66.i:-77/i:+88:i:-99<i:+00=i:-11>i:+22?i:-33@i:+44Ai:-55Bi:+66Ci:-77Di:+88Ei:-99Fi:+00Gi:-11Hi:+22Ii:-33Ji:+44Ki:-55Li:+66Mi:-77Ni:+88Oi:-99Pi:+00Qi:-11Ri:+22Si:-33Ti:+44Ui:-55Vi:+66Wi:-77Xi:+88Yi:-99Zi:+00[i:-11\i:+22]i:-33^i:+44_i:-55`i:+66ai:-77bi:+88ci:-99di:+00ei:-11fi:+22gi:-33hi:+44ii:-55ji:+66ki:-77li:+88mi:-99ni:+00oi:-11pi:+22qi:-33ri:+44si:-55ti:+66ui:-77vi:+88wi:-99xi:+00yi:-11zi:+22{i:-33|i:+44}i:-55~i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:-55i:+66i:-77i:+88i:-99i:+00i:-11i:+22i:-33i:+44i:+0;i:-1;i:+2;i:-3;i:+4;i:-5;i:+6;i:-7;i:+8;i:-9;i:+0 i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9	i:+0
i:-1i:+2i:-3
i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2 i:-3!i:+4"i:-5#i:+6$i:-7%i:+8&i:-9'i:+0(i:-1)i:+2*i:-3+i:+4,i:-5-i:+6.i:-7/i:+8:i:-9<i:+0=i:-1>i:+2?i:-3@i:+4Ai:-5Bi:+6Ci:-7Di:+8Ei:-9Fi:+0Gi:-1Hi:+2Ii:-3Ji:+4Ki:-5Li:+6Mi:-7Ni:+8Oi:-9Pi:+0Qi:-1Ri:+2Si:-3Ti:+4Ui:-5Vi:+6Wi:-7Xi:+8Yi:-9Zi:+0[i:-1\i:+2]i:-3^i:+4_i:-5`i:+6ai:-7bi:+8ci:-9di:+0ei:-1fi:+2gi:-3hi:+4ii:-5ji:+6ki:-7li:+8mi:-9ni:+0oi:-1pi:+2qi:-3ri:+4si:-5ti:+6ui:-7vi:+8wi:-9xi:+0yi:-1zi:+2{i:-3|i:+4}i:-5~i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:-5i:+6i:-7i:+8i:-9i:+0i:-1i:+2i:-3i:+4i:+ i:-i:+i:-i:+i:-i:+i:-i:+i:-	i:+
i:-i:+i:-
i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+ i:-!i:+"i:-#i:+$i:-%i:+&i:-'i:+(i:-)i:+*i:-+i:+,i:--i:+.i:-/i:+:i:-;i:+<i:-=i:+>i:-?i:+@i:-Ai:+Bi:-Ci:+Di:-Ei:+Fi:-Gi:+Hi:-Ii:+Ji:-Ki:+Li:-Mi:+Ni:-Oi:+Pi:-Qi:+Ri:-Si:+Ti:-Ui:+Vi:-Wi:+Xi:-Yi:+Zi:-[i:+\i:-]i:+^i:-_i:+`i:-ai:+bi:-ci:+di:-ei:+fi:-gi:+hi:-ii:+ji:-ki:+li:-mi:+ni:-oi:+pi:-qi:+ri:-si:+ti:-ui:+vi:-wi:+xi:-yi:+zi:-{i:+|i:-}i:+~i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:+i:-i:0;i:1;i:2;i:3;i:4;i:5;i:6;i:7;i:8;i:9;i: i:i:i:i:i:i:i:i:i:	i:
i:i:i:
i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i: i:!i:"i:#i:$i:%i:&i:'i:(i:)i:*i:,i:.i:/i::i:;i:<i:=i:>i:?i:@i:Ai:Bi:Ci:Di:Ei:Fi:Gi:Hi:Ii:Ji:Ki:Li:Mi:Ni:Oi:Pi:Qi:Ri:Si:Ti:Ui:Vi:Wi:Xi:Yi:Zi:[i:\i:]i:^i:_i:`i:ai:bi:ci:di:ei:fi:gi:hi:ii:ji:ki:li:mi:ni:oi:pi:qi:ri:si:ti:ui:vi:wi:xi:yi:zi:{i:|i:}i:~i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i:i iiiiiiiii	i
iii
iiiiiiiiiiiiiiiiiii i!i"i#i$i%i&i'i(i)i*i+i,i-i.i/i0i1i2i3i4i5i6i7i8i9i;i<i=i>i?i@iAiBiCiDiEiFiGiHiIiJiKiLiMiNiOiPiQiRiSiTiUiViWiXiYiZi[i\i]i^i_i`iaibicidieifigihiiijikiliminioipiqirisitiuiviwixiyizi{i|i}i~iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiio:+00:"o:-11:"o:+22:"o:-33:"o:+44:"o:-55:"o:+66:"o:-77:"o:+88:"o:-99:"o:+00: o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:	o:+00:
o:-11:o:+22:o:-33:
o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22: o:-33:!o:+44:#o:-55:$o:+66:%o:-77:&o:+88:'o:-99:(o:+00:)o:-11:*o:+22:+o:-33:,o:+44:-o:-55:.o:+66:/o:-77:0o:+88:1o:-99:2o:+00:3o:-11:4o:+22:5o:-33:6o:+44:7o:-55:8o:+66:9o:-77::o:+88:;o:-99:<o:+00:=o:-11:>o:+22:?o:-33:@o:+44:Ao:-55:Bo:+66:Co:-77:Do:+88:Eo:-99:Fo:+00:Go:-11:Ho:+22:Io:-33:Jo:+44:Ko:-55:Lo:+66:Mo:-77:No:+88:Oo:-99:Po:+00:Qo:-11:Ro:+22:So:-33:To:+44:Uo:-55:Vo:+66:Wo:-77:Xo:+88:Yo:-99:Zo:+00:[o:-11:\o:+22:]o:-33:^o:+44:_o:-55:`o:+66:ao:-77:bo:+88:co:-99:do:+00:eo:-11:fo:+22:go:-33:ho:+44:io:-55:jo:+66:ko:-77:lo:+88:mo:-99:no:+00:oo:-11:po:+22:qo:-33:ro:+44:so:-55:to:+66:uo:-77:vo:+88:wo:-99:xo:+00:yo:-11:zo:+22:{o:-33:|o:+44:}o:-55:~o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:-55:o:+66:o:-77:o:+88:o:-99:o:+00:o:-11:o:+22:o:-33:o:+44:o:+00 o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99	o:+00
o:-11o:+22o:-33
o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22 o:-33!o:+44"o:-55#o:+66$o:-77%o:+88&o:-99'o:+00(o:-11)o:+22*o:-33+o:+44,o:-55-o:+66.o:-77/o:+88;o:-99<o:+00=o:-11>o:+22?o:-33@o:+44Ao:-55Bo:+66Co:-77Do:+88Eo:-99Fo:+00Go:-11Ho:+22Io:-33Jo:+44Ko:-55Lo:+66Mo:-77No:+88Oo:-99Po:+00Qo:-11Ro:+22So:-33To:+44Uo:-55Vo:+66Wo:-77Xo:+88Yo:-99Zo:+00[o:-11\o:+22]o:-33^o:+44_o:-55`o:+66ao:-77bo:+88co:-99do:+00eo:-11fo:+22go:-33ho:+44io:-55jo:+66ko:-77lo:+88mo:-99no:+00oo:-11po:+22qo:-33ro:+44so:-55to:+66uo:-77vo:+88wo:-99xo:+00yo:-11zo:+22{o:-33|o:+44}o:-55~o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:-55o:+66o:-77o:+88o:-99o:+00o:-11o:+22o:-33o:+44o:+0:"o:-1:"o:+2:"o:-3:"o:+4:"o:-5:"o:+6:"o:-7:"o:+8:"o:-9:"o:+0 o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9	o:+0
o:-1o:+2o:-3
o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2 o:-3!o:+4"o:-5#o:+6$o:-7%o:+8&o:-9'o:+0(o:-1)o:+2*o:-3+o:+4,o:-5-o:+6.o:-7/o:+8;o:-9<o:+0=o:-1>o:+2?o:-3@o:+4Ao:-5Bo:+6Co:-7Do:+8Eo:-9Fo:+0Go:-1Ho:+2Io:-3Jo:+4Ko:-5Lo:+6Mo:-7No:+8Oo:-9Po:+0Qo:-1Ro:+2So:-3To:+4Uo:-5Vo:+6Wo:-7Xo:+8Yo:-9Zo:+0[o:-1\o:+2]o:-3^o:+4_o:-5`o:+6ao:-7bo:+8co:-9do:+0eo:-1fo:+2go:-3ho:+4io:-5jo:+6ko:-7lo:+8mo:-9no:+0oo:-1po:+2qo:-3ro:+4so:-5to:+6uo:-7vo:+8wo:-9xo:+0yo:-1zo:+2{o:-3|o:+4}o:-5~o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:-5o:+6o:-7o:+8o:-9o:+0o:-1o:+2o:-3o:+4o:+ o:-o:+o:-o:+o:-o:+o:-o:+o:-	o:+
o:-o:+o:-
o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+ o:-!o:+"o:-#o:+$o:-%o:+&o:-'o:+(o:-)o:+*o:-+o:+,o:--o:+.o:-/o:+:o:-;o:+<o:-=o:+>o:-?o:+@o:-Ao:+Bo:-Co:+Do:-Eo:+Fo:-Go:+Ho:-Io:+Jo:-Ko:+Lo:-Mo:+No:-Oo:+Po:-Qo:+Ro:-So:+To:-Uo:+Vo:-Wo:+Xo:-Yo:+Zo:-[o:+\o:-]o:+^o:-_o:+`o:-ao:+bo:-co:+do:-eo:+fo:-go:+ho:-io:+jo:-ko:+lo:-mo:+no:-oo:+po:-qo:+ro:-so:+to:-uo:+vo:-wo:+xo:-yo:+zo:-{o:+|o:-}o:+~o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:+o:-o:0 o:1o:2o:3o:4o:5o:6o:7o:8o:9	o:0
o:1o:2o:3
o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2 o:3!o:4"o:5#o:6$o:7%o:8&o:9'o:0(o:1)o:2*o:3+o:4,o:5-o:6.o:7/o:8;o:9<o:0=o:1>o:2?o:3@o:4Ao:5Bo:6Co:7Do:8Eo:9Fo:0Go:1Ho:2Io:3Jo:4Ko:5Lo:6Mo:7No:8Oo:9Po:0Qo:1Ro:2So:3To:4Uo:5Vo:6Wo:7Xo:8Yo:9Zo:0[o:1\o:2]o:3^o:4_o:5`o:6ao:7bo:8co:9do:0eo:1fo:2go:3ho:4io:5jo:6ko:7lo:8mo:9no:0oo:1po:2qo:3ro:4so:5to:6uo:7vo:8wo:9xo:0yo:1zo:2{o:3|o:4}o:5~o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o:5o:6o:7o:8o:9o:0o:1o:2o:3o:4o: o:o:o:o:o:o:o:o:o:	o:
o:o:o:
o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o: o:!o:"o:#o:$o:%o:&o:'o:(o:)o:*o:,o:.o:/o::o:;o:<o:=o:>o:?o:@o:Ao:Bo:Co:Do:Eo:Fo:Go:Ho:Io:Jo:Ko:Lo:Mo:No:Oo:Po:Qo:Ro:So:To:Uo:Vo:Wo:Xo:Yo:Zo:[o:\o:]o:^o:_o:`o:ao:bo:co:do:eo:fo:go:ho:io:jo:ko:lo:mo:no:oo:po:qo:ro:so:to:uo:vo:wo:xo:yo:zo:{o:|o:}o:~o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o:o ooooooooo	o
ooo
ooooooooooooooooooo o!o"o#o$o%o&o'o(o)o*o+o,o-o.o/o0o1o2o3o4o5o6o7o8o9o;o<o=o>o?o@oAoBoCoDoEoFoGoHoIoJoKoLoMoNoOoPoQoRoSoToUoVoWoXoYoZo[o\o]o^o_o`oaobocodoeofogohoiojokolomonooopoqorosotouovowoxoyozo{o|o}o~ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooor:+00;r:-11;r:+22;r:-33;r:+44;r:-55;r:+66;r:-77;r:+88;r:-99;r:+00 r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99	r:+00
r:-11r:+22r:-33
r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22 r:-33!r:+44"r:-55#r:+66$r:-77%r:+88&r:-99'r:+00(r:-11)r:+22*r:-33+r:+44,r:-55-r:+66.r:-77/r:+88:r:-99<r:+00=r:-11>r:+22?r:-33@r:+44Ar:-55Br:+66Cr:-77Dr:+88Er:-99Fr:+00Gr:-11Hr:+22Ir:-33Jr:+44Kr:-55Lr:+66Mr:-77Nr:+88Or:-99Pr:+00Qr:-11Rr:+22Sr:-33Tr:+44Ur:-55Vr:+66Wr:-77Xr:+88Yr:-99Zr:+00[r:-11\r:+22]r:-33^r:+44_r:-55`r:+66ar:-77br:+88cr:-99dr:+00er:-11fr:+22gr:-33hr:+44ir:-55jr:+66kr:-77lr:+88mr:-99nr:+00or:-11pr:+22qr:-33rr:+44sr:-55tr:+66ur:-77vr:+88wr:-99xr:+00yr:-11zr:+22{r:-33|r:+44}r:-55~r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:-55r:+66r:-77r:+88r:-99r:+00r:-11r:+22r:-33r:+44r:+0;r:-1;r:+2;r:-3;r:+4;r:-5;r:+6;r:-7;r:+8;r:-9;r:+0 r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9	r:+0
r:-1r:+2r:-3
r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2 r:-3!r:+4"r:-5#r:+6$r:-7%r:+8&r:-9'r:+0(r:-1)r:+2*r:-3+r:+4,r:-5-r:+6.r:-7/r:+8:r:-9<r:+0=r:-1>r:+2?r:-3@r:+4Ar:-5Br:+6Cr:-7Dr:+8Er:-9Fr:+0Gr:-1Hr:+2Ir:-3Jr:+4Kr:-5Lr:+6Mr:-7Nr:+8Or:-9Pr:+0Qr:-1Rr:+2Sr:-3Tr:+4Ur:-5Vr:+6Wr:-7Xr:+8Yr:-9Zr:+0[r:-1\r:+2]r:-3^r:+4_r:-5`r:+6ar:-7br:+8cr:-9dr:+0er:-1fr:+2gr:-3hr:+4ir:-5jr:+6kr:-7lr:+8mr:-9nr:+0or:-1pr:+2qr:-3rr:+4sr:-5tr:+6ur:-7vr:+8wr:-9xr:+0yr:-1zr:+2{r:-3|r:+4}r:-5~r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:-5r:+6r:-7r:+8r:-9r:+0r:-1r:+2r:-3r:+4r:+ r:-r:+r:-r:+r:-r:+r:-r:+r:-	r:+
r:-r:+r:-
r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+ r:-!r:+"r:-#r:+$r:-%r:+&r:-'r:+(r:-)r:+*r:-+r:+,r:--r:+.r:-/r:+:r:-;r:+<r:-=r:+>r:-?r:+@r:-Ar:+Br:-Cr:+Dr:-Er:+Fr:-Gr:+Hr:-Ir:+Jr:-Kr:+Lr:-Mr:+Nr:-Or:+Pr:-Qr:+Rr:-Sr:+Tr:-Ur:+Vr:-Wr:+Xr:-Yr:+Zr:-[r:+\r:-]r:+^r:-_r:+`r:-ar:+br:-cr:+dr:-er:+fr:-gr:+hr:-ir:+jr:-kr:+lr:-mr:+nr:-or:+pr:-qr:+rr:-sr:+tr:-ur:+vr:-wr:+xr:-yr:+zr:-{r:+|r:-}r:+~r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:+r:-r:0;r:1;r:2;r:3;r:4;r:5;r:6;r:7;r:8;r:9;r: r:r:r:r:r:r:r:r:r:	r:
r:r:r:
r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r: r:!r:"r:#r:$r:%r:&r:'r:(r:)r:*r:,r:.r:/r::r:;r:<r:=r:>r:?r:@r:Ar:Br:Cr:Dr:Er:Fr:Gr:Hr:Ir:Jr:Kr:Lr:Mr:Nr:Or:Pr:Qr:Rr:Sr:Tr:Ur:Vr:Wr:Xr:Yr:Zr:[r:\r:]r:^r:_r:`r:ar:br:cr:dr:er:fr:gr:hr:ir:jr:kr:lr:mr:nr:or:pr:qr:rr:sr:tr:ur:vr:wr:xr:yr:zr:{r:|r:}r:~r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r:r rrrrrrrrr	r
rrr
rrrrrrrrrrrrrrrrrrr r!r"r#r$r%r&r'r(r)r*r+r,r-r.r/r0r1r2r3r4r5r6r7r8r9r;r<r=r>r?r@rArBrCrDrErFrGrHrIrJrKrLrMrNrOrPrQrRrSrTrUrVrWrXrYrZr[r\r]r^r_r`rarbrcrdrerfrgrhrirjrkrlrmrnrorprqrrrsrtrurvrwrxryrzr{r|r}r~rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrs:+00:"s:+11:"s:+22:"s:+33:"s:+44:"s:+55:"s:+66:"s:+77:"s:+88:"s:+99:"s:+00: s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:	s:+00:
s:+11:s:+22:s:+33:
s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22: s:+33:!s:+44:#s:+55:$s:+66:%s:+77:&s:+88:'s:+99:(s:+00:)s:+11:*s:+22:+s:+33:,s:+44:-s:+55:.s:+66:/s:+77:0s:+88:1s:+99:2s:+00:3s:+11:4s:+22:5s:+33:6s:+44:7s:+55:8s:+66:9s:+77::s:+88:;s:+99:<s:+00:=s:+11:>s:+22:?s:+33:@s:+44:As:+55:Bs:+66:Cs:+77:Ds:+88:Es:+99:Fs:+00:Gs:+11:Hs:+22:Is:+33:Js:+44:Ks:+55:Ls:+66:Ms:+77:Ns:+88:Os:+99:Ps:+00:Qs:+11:Rs:+22:Ss:+33:Ts:+44:Us:+55:Vs:+66:Ws:+77:Xs:+88:Ys:+99:Zs:+00:[s:+11:\s:+22:]s:+33:^s:+44:_s:+55:`s:+66:as:+77:bs:+88:cs:+99:ds:+00:es:+11:fs:+22:gs:+33:hs:+44:is:+55:js:+66:ks:+77:ls:+88:ms:+99:ns:+00:os:+11:ps:+22:qs:+33:rs:+44:ss:+55:ts:+66:us:+77:vs:+88:ws:+99:xs:+00:ys:+11:zs:+22:{s:+33:|s:+44:}s:+55:~s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+55:s:+66:s:+77:s:+88:s:+99:s:+00:s:+11:s:+22:s:+33:s:+44:s:+00 s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99	s:+00
s:+11s:+22s:+33
s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22 s:+33!s:+44"s:+55#s:+66$s:+77%s:+88&s:+99's:+00(s:+11)s:+22*s:+33+s:+44,s:+55-s:+66.s:+77/s:+88;s:+99<s:+00=s:+11>s:+22?s:+33@s:+44As:+55Bs:+66Cs:+77Ds:+88Es:+99Fs:+00Gs:+11Hs:+22Is:+33Js:+44Ks:+55Ls:+66Ms:+77Ns:+88Os:+99Ps:+00Qs:+11Rs:+22Ss:+33Ts:+44Us:+55Vs:+66Ws:+77Xs:+88Ys:+99Zs:+00[s:+11\s:+22]s:+33^s:+44_s:+55`s:+66as:+77bs:+88cs:+99ds:+00es:+11fs:+22gs:+33hs:+44is:+55js:+66ks:+77ls:+88ms:+99ns:+00os:+11ps:+22qs:+33rs:+44ss:+55ts:+66us:+77vs:+88ws:+99xs:+00ys:+11zs:+22{s:+33|s:+44}s:+55~s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+55s:+66s:+77s:+88s:+99s:+00s:+11s:+22s:+33s:+44s:+0:"s:+1:"s:+2:"s:+3:"s:+4:"s:+5:"s:+6:"s:+7:"s:+8:"s:+9:"s:+0 s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9	s:+0
s:+1s:+2s:+3
s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2 s:+3!s:+4"s:+5#s:+6$s:+7%s:+8&s:+9's:+0(s:+1)s:+2*s:+3+s:+4,s:+5-s:+6.s:+7/s:+8;s:+9<s:+0=s:+1>s:+2?s:+3@s:+4As:+5Bs:+6Cs:+7Ds:+8Es:+9Fs:+0Gs:+1Hs:+2Is:+3Js:+4Ks:+5Ls:+6Ms:+7Ns:+8Os:+9Ps:+0Qs:+1Rs:+2Ss:+3Ts:+4Us:+5Vs:+6Ws:+7Xs:+8Ys:+9Zs:+0[s:+1\s:+2]s:+3^s:+4_s:+5`s:+6as:+7bs:+8cs:+9ds:+0es:+1fs:+2gs:+3hs:+4is:+5js:+6ks:+7ls:+8ms:+9ns:+0os:+1ps:+2qs:+3rs:+4ss:+5ts:+6us:+7vs:+8ws:+9xs:+0ys:+1zs:+2{s:+3|s:+4}s:+5~s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+5s:+6s:+7s:+8s:+9s:+0s:+1s:+2s:+3s:+4s:+ s:+s:+s:+s:+s:+s:+s:+s:+s:+	s:+
s:+s:+s:+
s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+ s:+!s:+"s:+#s:+$s:+%s:+&s:+'s:+(s:+)s:+*s:++s:+,s:+-s:+.s:+/s:+:s:+;s:+<s:+=s:+>s:+?s:+@s:+As:+Bs:+Cs:+Ds:+Es:+Fs:+Gs:+Hs:+Is:+Js:+Ks:+Ls:+Ms:+Ns:+Os:+Ps:+Qs:+Rs:+Ss:+Ts:+Us:+Vs:+Ws:+Xs:+Ys:+Zs:+[s:+\s:+]s:+^s:+_s:+`s:+as:+bs:+cs:+ds:+es:+fs:+gs:+hs:+is:+js:+ks:+ls:+ms:+ns:+os:+ps:+qs:+rs:+ss:+ts:+us:+vs:+ws:+xs:+ys:+zs:+{s:+|s:+}s:+~s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:+s:0 s:1s:2s:3s:4s:5s:6s:7s:8s:9	s:0
s:1s:2s:3
s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2 s:3!s:4"s:5#s:6$s:7%s:8&s:9's:0(s:1)s:2*s:3+s:4,s:5-s:6.s:7/s:8;s:9<s:0=s:1>s:2?s:3@s:4As:5Bs:6Cs:7Ds:8Es:9Fs:0Gs:1Hs:2Is:3Js:4Ks:5Ls:6Ms:7Ns:8Os:9Ps:0Qs:1Rs:2Ss:3Ts:4Us:5Vs:6Ws:7Xs:8Ys:9Zs:0[s:1\s:2]s:3^s:4_s:5`s:6as:7bs:8cs:9ds:0es:1fs:2gs:3hs:4is:5js:6ks:7ls:8ms:9ns:0os:1ps:2qs:3rs:4ss:5ts:6us:7vs:8ws:9xs:0ys:1zs:2{s:3|s:4}s:5~s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s:5s:6s:7s:8s:9s:0s:1s:2s:3s:4s: s:s:s:s:s:s:s:s:s:	s:
s:s:s:
s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s: s:!s:"s:#s:$s:%s:&s:'s:(s:)s:*s:,s:-s:.s:/s::s:;s:<s:=s:>s:?s:@s:As:Bs:Cs:Ds:Es:Fs:Gs:Hs:Is:Js:Ks:Ls:Ms:Ns:Os:Ps:Qs:Rs:Ss:Ts:Us:Vs:Ws:Xs:Ys:Zs:[s:\s:]s:^s:_s:`s:as:bs:cs:ds:es:fs:gs:hs:is:js:ks:ls:ms:ns:os:ps:qs:rs:ss:ts:us:vs:ws:xs:ys:zs:{s:|s:}s:~s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s:s sssssssss	s
sss
sssssssssssssssssss s!s"s#s$s%s&s's(s)s*s+s,s-s.s/s0s1s2s3s4s5s6s7s8s9s;s<s=s>s?s@sAsBsCsDsEsFsGsHsIsJsKsLsMsNsOsPsQsRsSsTsUsVsWsXsYsZs[s\s]s^s_s`sasbscsdsesfsgshsisjskslsmsnsospsqsrssstsusvswsxsyszs{s|s}s~sssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssss}

























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































          




















































































































































































































































          










































































































































































































































































































































































































































































































          


























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































										



















































































































































































































































































































































































































































































































										




































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
																				























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
																				




















































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	


























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































