# Largest Contentful Paint Changes in M88

## Changes in Chrome 88

In Chrome 88, some changes were made to Largest Contentful Paint to bring its
implementation in line with the updated [specification](https://wicg.github.io/largest-contentful-paint/),
and fix bugs in the chromium implementation.

The changes are:

 * Full viewport images, which are visually equivalent to background images, are
   no longer considered as the largest contentful paint.
   [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2441732).
 * Images which are later removed from the page are now considered as potential
   largest contentful paints.
   [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2480845).
 * Largest Contentful Paint stops recording after an input in an out of process
   iframe. This change only affects Chrome's reporting of Largest Contentful
   Paint in the [Chrome User Experience Report](https://developers.google.com/web/tools/chrome-user-experience-report),
   as the API doesn't include iframes.
   [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2436770).
 * Prior to Chrome 88, Largest Contentful Paint had a bug where it incorrectly
   classified some images as invisible. This could happen in the case of
   offscreen or tiny placeholder images which were replaced with large visible
   images. The bug has been fixed, and the large visible images are now counted
   as possible largest contentful paints.
   [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2561270).

## How does this affect a site's metrics?

Each change only affects sites with specific types of content.

The change to ignore full viewport images as potential largest contentful paints
will improve Largest Contentful Paint times for pages with background images.
This is intended as Largest Contentful Paint attempts to time when the main
content on the page is visible, and this generally is
[not background images](https://github.com/anniesullie/LCP_Examples/blob/master/body_background/README.md).

The change to include images which are later removed from the DOM as possible
largest contentful paints will improve Largest Contentful Paint times on sites
which have images of the same size inserted multiple times. This is a common
pattern for carousels, as well as some JavaScript frameworks which do
server-side rendering.

The change to stop recording after an input in an out of process iframe will
improve Largest Contentful Paint times on sites which have cross-process iframes.

The bug fix for invisible elements may result in increased Largest Contentful
Paint timings for sites using a placeholder pattern that swaps in the largest
contentful image.

## When were users affected?

Chrome 88 is currently scheduled to be released the week of January 19, 2021.
