# First Contentful Paint Changes in M89

## Changes in Chrome 89

In Chrome 89, an improvement was made to the code that reports First Contentful
Paint to [URL-Keyed Metrics](https://chromium.googlesource.com/chromium/src/+/master/services/metrics/ukm_api.md).
This change increases the number of reports of First Contentful Paint that Chrome
receives right before the user closes a tab.
[Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2552628).

## How does this affect a site's metrics?

We don't see any difference in the values produced by the metric after this
change. However, after this change Chrome will now receive more reports of
First Contentful Paint, which means that some sites which previously had too
little data to be included in the
[Chrome User Experience Report](https://developers.google.com/web/tools/chrome-user-experience-report)
will now be included, especially on desktop where tab switching is more common.

## When were users affected?

Chrome 89 is currently scheduled to be released the week of March 2, 2021.
