#!/bin/sh

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9]\)~.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
SVN_COMMIT='svn log http://py-leveldb.googlecode.com/svn/trunk/ -l 1 | sed -ne "s/r\([0-9]\+\).*/\1/p"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
PY_LEVELDB_SVN_COMMIT=$(eval "${SVN_COMMIT}")
svn export --ignore-externals -r ${PY_LEVELDB_SVN_COMMIT} \
   http://py-leveldb.googlecode.com/svn/trunk/ python-leveldb
cd python-leveldb/
cd .. && tar cjf \
	${OLDDIR}/python-leveldb_${BASE_REL}~svn${PY_LEVELDB_SVN_COMMIT}.orig.tar.bz2 \
	python-leveldb --exclude-vcs
rm -rf ${GOS_DIR}
