# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
import uuid
from .operations.workflows_operations import WorkflowsOperations
from .operations.workflow_versions_operations import WorkflowVersionsOperations
from .operations.workflow_triggers_operations import WorkflowTriggersOperations
from .operations.workflow_trigger_histories_operations import WorkflowTriggerHistoriesOperations
from .operations.workflow_runs_operations import WorkflowRunsOperations
from .operations.workflow_run_actions_operations import WorkflowRunActionsOperations
from .operations.workflow_run_action_repetitions_operations import WorkflowRunActionRepetitionsOperations
from .operations.workflow_run_action_scoped_repetitions_operations import WorkflowRunActionScopedRepetitionsOperations
from .operations.workflow_run_operations import WorkflowRunOperations
from .operations.integration_accounts_operations import IntegrationAccountsOperations
from .operations.integration_account_assemblies_operations import IntegrationAccountAssembliesOperations
from .operations.integration_account_batch_configurations_operations import IntegrationAccountBatchConfigurationsOperations
from .operations.schemas_operations import SchemasOperations
from .operations.maps_operations import MapsOperations
from .operations.partners_operations import PartnersOperations
from .operations.agreements_operations import AgreementsOperations
from .operations.certificates_operations import CertificatesOperations
from .operations.sessions_operations import SessionsOperations
from . import models


class LogicManagementClientConfiguration(AzureConfiguration):
    """Configuration for LogicManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(LogicManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-logic/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class LogicManagementClient(SDKClient):
    """REST API for Azure Logic Apps.

    :ivar config: Configuration for client.
    :vartype config: LogicManagementClientConfiguration

    :ivar workflows: Workflows operations
    :vartype workflows: azure.mgmt.logic.operations.WorkflowsOperations
    :ivar workflow_versions: WorkflowVersions operations
    :vartype workflow_versions: azure.mgmt.logic.operations.WorkflowVersionsOperations
    :ivar workflow_triggers: WorkflowTriggers operations
    :vartype workflow_triggers: azure.mgmt.logic.operations.WorkflowTriggersOperations
    :ivar workflow_trigger_histories: WorkflowTriggerHistories operations
    :vartype workflow_trigger_histories: azure.mgmt.logic.operations.WorkflowTriggerHistoriesOperations
    :ivar workflow_runs: WorkflowRuns operations
    :vartype workflow_runs: azure.mgmt.logic.operations.WorkflowRunsOperations
    :ivar workflow_run_actions: WorkflowRunActions operations
    :vartype workflow_run_actions: azure.mgmt.logic.operations.WorkflowRunActionsOperations
    :ivar workflow_run_action_repetitions: WorkflowRunActionRepetitions operations
    :vartype workflow_run_action_repetitions: azure.mgmt.logic.operations.WorkflowRunActionRepetitionsOperations
    :ivar workflow_run_action_scoped_repetitions: WorkflowRunActionScopedRepetitions operations
    :vartype workflow_run_action_scoped_repetitions: azure.mgmt.logic.operations.WorkflowRunActionScopedRepetitionsOperations
    :ivar workflow_run_operations: WorkflowRunOperations operations
    :vartype workflow_run_operations: azure.mgmt.logic.operations.WorkflowRunOperations
    :ivar integration_accounts: IntegrationAccounts operations
    :vartype integration_accounts: azure.mgmt.logic.operations.IntegrationAccountsOperations
    :ivar integration_account_assemblies: IntegrationAccountAssemblies operations
    :vartype integration_account_assemblies: azure.mgmt.logic.operations.IntegrationAccountAssembliesOperations
    :ivar integration_account_batch_configurations: IntegrationAccountBatchConfigurations operations
    :vartype integration_account_batch_configurations: azure.mgmt.logic.operations.IntegrationAccountBatchConfigurationsOperations
    :ivar schemas: Schemas operations
    :vartype schemas: azure.mgmt.logic.operations.SchemasOperations
    :ivar maps: Maps operations
    :vartype maps: azure.mgmt.logic.operations.MapsOperations
    :ivar partners: Partners operations
    :vartype partners: azure.mgmt.logic.operations.PartnersOperations
    :ivar agreements: Agreements operations
    :vartype agreements: azure.mgmt.logic.operations.AgreementsOperations
    :ivar certificates: Certificates operations
    :vartype certificates: azure.mgmt.logic.operations.CertificatesOperations
    :ivar sessions: Sessions operations
    :vartype sessions: azure.mgmt.logic.operations.SessionsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = LogicManagementClientConfiguration(credentials, subscription_id, base_url)
        super(LogicManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2016-06-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.workflows = WorkflowsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_versions = WorkflowVersionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_triggers = WorkflowTriggersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_trigger_histories = WorkflowTriggerHistoriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_runs = WorkflowRunsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_actions = WorkflowRunActionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_action_repetitions = WorkflowRunActionRepetitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_action_scoped_repetitions = WorkflowRunActionScopedRepetitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_operations = WorkflowRunOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_accounts = IntegrationAccountsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_assemblies = IntegrationAccountAssembliesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_batch_configurations = IntegrationAccountBatchConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.schemas = SchemasOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.maps = MapsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.partners = PartnersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.agreements = AgreementsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.certificates = CertificatesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.sessions = SessionsOperations(
            self._client, self.config, self._serialize, self._deserialize)

    def list_operations(
            self, custom_headers=None, raw=False, **operation_config):
        """Lists all of the available Logic REST API operations.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Operation
        :rtype:
         ~azure.mgmt.logic.models.OperationPaged[~azure.mgmt.logic.models.Operation]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.logic.models.ErrorResponseException>`
        """
        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = self.list_operations.metadata['url']

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.OperationPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.OperationPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
    list_operations.metadata = {'url': '/providers/Microsoft.Logic/operations'}
