# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Certificate(Model):
    """A certificate that can be installed on compute nodes and can be used to
    authenticate operations on the machine.

    :param thumbprint: The X.509 thumbprint of the certificate. This is a
     sequence of up to 40 hex digits.
    :type thumbprint: str
    :param thumbprint_algorithm: The algorithm used to derive the thumbprint.
    :type thumbprint_algorithm: str
    :param url: The URL of the certificate.
    :type url: str
    :param state: The current state of the certificate. Possible values
     include: 'active', 'deleting', 'deleteFailed'
    :type state: str or ~azure.batch.models.CertificateState
    :param state_transition_time: The time at which the certificate entered
     its current state.
    :type state_transition_time: datetime
    :param previous_state: The previous state of the certificate. This
     property is not set if the certificate is in its initial active state.
     Possible values include: 'active', 'deleting', 'deleteFailed'
    :type previous_state: str or ~azure.batch.models.CertificateState
    :param previous_state_transition_time: The time at which the certificate
     entered its previous state. This property is not set if the certificate is
     in its initial Active state.
    :type previous_state_transition_time: datetime
    :param public_data: The public part of the certificate as a base-64
     encoded .cer file.
    :type public_data: str
    :param delete_certificate_error: The error that occurred on the last
     attempt to delete this certificate. This property is set only if the
     certificate is in the DeleteFailed state.
    :type delete_certificate_error: ~azure.batch.models.DeleteCertificateError
    """

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'state': {'key': 'state', 'type': 'CertificateState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'CertificateState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(self, **kwargs):
        super(Certificate, self).__init__(**kwargs)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.url = kwargs.get('url', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.previous_state_transition_time = kwargs.get('previous_state_transition_time', None)
        self.public_data = kwargs.get('public_data', None)
        self.delete_certificate_error = kwargs.get('delete_certificate_error', None)
