# Pyntor::Video - Plays video
# Copyright (C) 2004 - 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *
import sys
import time
import random
import os, pwd

class Video:
	def init(self, options):
		self.videofile = options["video"]
		self.preview = options["preview"]

		pygame.mixer.quit()

		try:
			self.video = pygame.movie.Movie(self.videofile)
		except:
			print "(Video) failed opening video file"
			self.disabled = 1
			return

		size = self.video.get_size()
		if size == (0, 0):
			print "(Video) invalid video format, need MPEG"
			self.disabled = 1
			return

		#screen = pygame.display.get_surface()

		#screencopy = pygame.Surface((screen.get_width(), screen.get_height()))
		#screencopy.blit(screen, (0, 0))

		#surface = pygame.Surface((screen.get_width(), screen.get_height()))
		#surface.blit(screen, (0, 0))

		self.pages = 1

	def render(self, screen, page, globalpage):
		size = self.video.get_size()
		print "XXX SIZE", size
		vsurface = pygame.Surface(size)
		self.video.set_display(vsurface)
		#video.set_display(screen)

		self.video.set_volume(1.0)

		while 1:
			self.video.play()

			#(width, height) = size
			#xsurface = pygame.transform.scale(vsurface, (width * 2, height * 2))
			if self.preview:
				xsurface = pygame.transform.scale(vsurface, (200, 150))
				screen.blit(xsurface, (412, 500))
			else:
				xsurface = pygame.transform.scale(vsurface, (1024, 768))
				screen.blit(xsurface, (0, 0))
			#screen.blit(vsurface, (0, 0))
			#screen.blit(surface, (0, 0))
			#pygame.display.update()
			pygame.display.flip()

		#screen.blit(screencopy, (0, 0))

	def interactive(self, event):
		#oldpos = self.scrollpos

		#h = pygame.display.get_surface().get_height()

		if event.type == KEYDOWN:
			key = event.key
			if key == K_ESCAPE or pygame.event.peek(QUIT):
				return "exit"

			if key == K_s:
				filename = "video" + ".bmp"
				pygame.image.save(screen, os.path.join("static", filename))
			if key == K_RIGHT:
				video.skip(10.0)
			if key == K_UP:
				video.skip(50.0)

			if key == K_v:
				#screen.blit(screencopy, (0, 0))
				self.preview = 1 - self.preview

component = Video()

parameters = (
	("video", "Video file name", None),
	("preview", "Display as preview only", 0)
)

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Video: play MPEG videos

Usage: 'pod' -video <videfile> [-preview 1]
 Where <videofile> is an MPEG-encoded video, which can be played full-screen or
 in preview size

Display: yes

Interactivity: Preview/fullscreen can be toggled with the 'v' key, the playback
can be controlled with right and up cursor keys, and screenshots are possible
via the 's' key
"""

