/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CAddInCollectionDoc.h"
#include "Doc/CafCoreTypesDoc/CAddInsDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/AddInsXml.h"
#include "Doc/DocXml/CafCoreTypesXml/AddInCollectionXml.h"

using namespace Caf;

void AddInsXml::add(
	const SmartPtrCAddInsDoc addInsDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AddInsXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(addInsDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCAddInCollectionDoc> addInCollectionVal =
			addInsDoc->getAddInCollection();
		CAF_CM_VALIDATE_STL(addInCollectionVal);

		if (! addInCollectionVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCAddInCollectionDoc> > addInCollectionIter(addInCollectionVal);
				addInCollectionIter; addInCollectionIter++) {
				const SmartPtrCXmlElement addInCollectionXml =
					thisXml->createAndAddElement("addInCollection");
				AddInCollectionXml::add(*addInCollectionIter, addInCollectionXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCAddInsDoc AddInsXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AddInsXml", "parse");

	SmartPtrCAddInsDoc addInsDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection addInCollectionChildrenXml =
			thisXml->findRequiredChildren("addInCollection");

		std::deque<SmartPtrCAddInCollectionDoc> addInCollectionVal;
		if (! addInCollectionChildrenXml.IsNull() && ! addInCollectionChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> addInCollectionXmlIter(*addInCollectionChildrenXml);
				addInCollectionXmlIter; addInCollectionXmlIter++) {
				const SmartPtrCXmlElement addInCollectionXml = addInCollectionXmlIter->second;
				const SmartPtrCAddInCollectionDoc addInCollectionDoc =
					AddInCollectionXml::parse(addInCollectionXml);
				addInCollectionVal.push_back(addInCollectionDoc);
			}
		}

		addInsDoc.CreateInstance();
		addInsDoc->initialize(
			addInCollectionVal);
	}
	CAF_CM_EXIT;

	return addInsDoc;
}

