#include <assert.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <string>

#include "lib/util.h"
#include "watch_maildirs.h"
#include "watcher_maildir.h"
#include "watcher_partial.h"

using std::string;

watcher_partial::watcher_partial(struct dnotify_state* state, const string& partial_maildir)
	: state(state), partial_maildir(partial_maildir)
{
	string maildir(mkfilename(state->base_path, partial_maildir));

	fd = start_watch(maildir.c_str());

	if (is_maildir(maildir))
		exit(EXIT_RESTART); // it is probably illegal to delete this, so exit
}

watcher_partial::~watcher_partial()
{
	if (fd >= 0)
		stop_watch(fd);
}


void watcher_partial::process_event(int fd)
{
	assert(fd == this->fd);

	if (!is_maildir(mkfilename(state->base_path, partial_maildir)))
		return;

	transition_to_maildir();
}

void watcher_partial::transition_to_maildir()
{
	send_maildir_modified(maildir_to_imap(partial_maildir).c_str());

	stop_watch(fd);
	fd = -1;

	new watcher_maildir(state, partial_maildir);

	delete this;
}

int watcher_partial::start_watch(const char* dir)
{
	int fd = open(dir, O_RDONLY);
	die_if(fd < 0, "open(\"%s\")", dir);
	set_fd_watch(fd, cn_notify, dir);
	state->add_imap_watcher(fd, maildir_to_imap(partial_maildir), this);
	return fd;
}

void watcher_partial::stop_watch(int fd)
{
	state->remove_imap_watcher(fd, maildir_to_imap(partial_maildir));
	int r = close(fd);
	die_if(r < 0, "close");
}
