/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: nzb.h,v 1.2 2004/08/24 21:59:11 mnordstr Exp $
    This file provides the nzb XML function headers.

*/

#ifndef NZB_H
#define NZB_H

#include <iostream>
#include <vector>
#include <libxml/parser.h>

#define NZB_OK			0	// Ok
#define NZB_ERROR		1	// General/Unknown error

using namespace std;

struct nzb_group {
	string group;
};

struct nzb_segment {
	unsigned long bytes;
	unsigned int number;
	string msgid;
};

struct nzb_file {
	int status;
	string poster;
	unsigned int date;
	string subject;

	unsigned int c_groups;
	unsigned int c_segments;
	
	vector<nzb_group> groups;
	vector<nzb_segment> segments;
};

struct nzb_return {
	unsigned int count;
	vector<nzb_file> files;
};

extern "C" nzb_return parse_nzb(string data);
nzb_file parse_file(xmlDocPtr doc, xmlNodePtr cur);
vector<nzb_group> parse_groups(xmlDocPtr doc, xmlNodePtr cur);
vector<nzb_segment> parse_segments(xmlDocPtr doc, xmlNodePtr cur);

#endif
