/*
 * libdasm -- simple x86 disassembly library
 * (c) 2004 - 2006  jt / nologin.org
 *
 * opcode_tables.h:
 * Opcode tables for FPU, 1, 2 and 3-byte opcodes and
 * extensions.
 *
 */

#include "libdasm.h"


// lock/rep prefix name table
const char *rep_table[] = {
	 "lock ", "repne ", "rep "
};

// Register name table (also includes Jcc branch hint prefixes)
const char *reg_table[11][8] = {
	{ "eax",  "ecx",  "edx",  "ebx",  "esp",  "ebp",  "esi",  "edi"  },
	{ "ax",   "cx",   "dx",   "bx",   "sp",   "bp",   "si",   "di"   },
	{ "al",   "cl",   "dl",   "bl",   "ah",   "ch",   "dh",   "bh"   },
	{ "es",   "cs",   "ss",   "ds",   "fs",   "gs",   "??",   "??"   },
	{ "dr0",  "dr1",  "dr2",  "dr3",  "dr4",  "dr5",  "dr6",  "dr7"  },
	{ "cr0",  "cr1",  "cr2",  "cr3",  "cr4",  "cr5",  "cr6",  "cr7"  },
	{ "tr0",  "tr1",  "tr2",  "tr3",  "tr4",  "tr5",  "tr6",  "tr7"  },
	{ "xmm0", "xmm1", "xmm2", "xmm3", "xmm4", "xmm5", "xmm6", "xmm7" },
	{ "mm0",  "mm1",  "mm2",  "mm3",  "mm4",  "mm5",  "mm6",  "mm7"  },
	{ "st(0)","st(1)","st(2)","st(3)","st(4)","st(5)","st(6)","st(7)"},
	{ "??",   "(bnt)","??",   "(bt)", "??",   "??",   "??",   "??"   },
};

// Name table index
#define REG_GEN_DWORD 0
#define REG_GEN_WORD  1
#define REG_GEN_BYTE  2
#define REG_SEGMENT   3
#define REG_DEBUG     4
#define REG_CONTROL   5
#define REG_TEST      6
#define REG_XMM       7 
#define REG_MMX       8 
#define REG_FPU       9
#define REG_BRANCH    10	// Not registers strictly speaking..

// 1-byte opcodes
INST inst_table1[256] = {
	{ INSTRUCTION_TYPE_ADD,    "add",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADD,    "add",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADD,    "add",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADD,    "add",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADD,    "add",       AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_ADD,    "add",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_ES|F_r|P_r,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_ES|F_r|P_w,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OR,     "or",        AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,     "or",        AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,     "or",        AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,     "or",        AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,     "or",        AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OR,     "or",        AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_CS|F_r|P_r,       FLAGS_NONE,                FLAGS_NONE,   0 },
	// Escape to 2-byte opcode table
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_ADC,    "adc",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,    "adc",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,    "adc",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,    "adc",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,    "adc",       AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_ADC,    "adc",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_SS|F_r|P_r,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_SS|F_r|P_w,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_SBB,    "sbb",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,    "sbb",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,    "sbb",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,    "sbb",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,    "sbb",       AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_SBB,    "sbb",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_DS|F_r|P_r,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_DS|F_r|P_w,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_AND,    "and",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,    "and",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,    "and",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,    "and",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,    "and",       AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_AND,    "and",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	// seg ES override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DCL,    "daa",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_SUB,    "sub",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,    "sub",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,    "sub",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,    "sub",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,    "sub",       AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_SUB,    "sub",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	// seg CS override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DCL,    "das",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XOR,    "xor",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,    "xor",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,    "xor",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,    "xor",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,    "xor",       AM_REG|REG_EAX|OT_b|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XOR,    "xor",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	// seg SS override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_ASC,    "aaa",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_CMP,    "cmp",       AM_E|OT_b|P_r,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,    "cmp",       AM_E|OT_v|P_r,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,    "cmp",       AM_G|OT_b|P_r,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,    "cmp",       AM_G|OT_v|P_r,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,    "cmp",       AM_REG|REG_EAX|OT_b|P_r,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_CMP,    "cmp",       AM_REG|REG_EAX|OT_v|P_r,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	// seg DS override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_ASC,    "aas",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_EAX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_ECX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_EDX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_EBX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_ESP|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_EBP|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_ESI|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_REG|REG_EDI|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_EAX|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_ECX|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_EDX|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_EBX|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_ESP|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_EBP|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_ESI|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_REG|REG_EDI|OT_v,         FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_EAX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_ECX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_EDX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_EBX|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_ESP|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_EBP|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_ESI|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_EDI|OT_v|P_r,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_EAX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_ECX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_EDX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_EBX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_ESP|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_EBP|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_ESI|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_EDI|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH ,  "pusha",     FLAGS_NONE|P_r,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "popa",      FLAGS_NONE|P_w,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "bound",     AM_G|OT_v|P_r,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_PRIV,   "arpl",      AM_E|OT_w|P_r,               AM_G|OT_w|P_r,             FLAGS_NONE,   1 },
	// seg FS override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	// seg GS override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	// operand size override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	// address size override
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_I|OT_v|P_r,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_EIMUL,  "imul",      AM_G|OT_v|P_r,               AM_E|OT_v|P_r,             AM_I|OT_v|P_r,1 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_I|OT_b|F_s|P_r,           FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_EIMUL,  "imul",      AM_G|OT_v|P_r,               AM_E|OT_v|P_r,         AM_I|OT_b|F_s|P_r,1 },
	{ INSTRUCTION_TYPE_PRIV,   "insb",      FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "insv",      FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "outsb",     FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "outsv",     FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jo",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jno",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jc",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jnc",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jz",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jnz",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jna",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "ja",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "js",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jns",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jp",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jpo",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jl",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jnl",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jng",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jg",        AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "g1",        AM_E|OT_b,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g1",        AM_E|OT_v,                   AM_I|OT_v,                 FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g1",        AM_E|OT_b,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g1",        AM_E|OT_v,                   AM_I|OT_b|F_s,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_TEST,   "test",      AM_E|OT_b|P_r,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_TEST,   "test",      AM_E|OT_v|P_r,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_E|OT_b|P_w,               AM_G|OT_b|P_w,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_E|OT_v|P_w,               AM_G|OT_v|P_w,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_E|OT_b|P_w,               AM_G|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_G|OT_b|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOVSR,  "mov",       AM_E|OT_w|P_w,               AM_S|OT_w|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_LEA,    "lea",       AM_G|OT_v|P_w,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOVSR,  "mov",       AM_S|OT_w|P_w,               AM_E|OT_w|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "nop",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_ECX|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_EDX|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_EBX|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_ESP|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_EBP|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_ESI|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_XCHG,   "xchg",      AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_EDI|OT_v|P_w,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "cbw",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "cwd",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_CALL,   "callf",     AM_A|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "wait",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "pushf",     FLAGS_NONE|P_r,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "popf",      FLAGS_NONE|P_w,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "sahf",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "lahf",      FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EAX|OT_b|P_w,     AM_O|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EAX|OT_v|P_w,     AM_O|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_O|OT_v|P_w,               AM_REG|REG_EAX|OT_b|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_O|OT_v|P_w,               AM_REG|REG_EAX|OT_v|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOVS,   "movsb",     FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOVS,   "movsd",     FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_CMPS,   "cmpsb",     FLAGS_NONE|P_r,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_CMPS,   "cmpsd",     FLAGS_NONE|P_r,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_TEST,   "test",      AM_REG|REG_EAX|OT_b|P_r,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_TEST,   "test",      AM_REG|REG_EAX|OT_v|P_r,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_STOS,   "stosb",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_STOS,   "stosd",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_LODS,   "lodsb",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_LODS,   "lodsd",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_SCAS,   "scasb",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_SCAS,   "scasd",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_AL|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_CL|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_DL|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_BL|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_AH|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_CH|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_DH|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_BH|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_ECX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EDX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EBX|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_ESP|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EBP|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_ESI|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_REG|REG_EDI|OT_v|P_w,     AM_I|OT_v|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "g2",        AM_E|OT_b,                   AM_I|OT_b,                 FLAGS_NONE,   1 }, 
	{ INSTRUCTION_TYPE_OTHER,  "g2",        AM_E|OT_v,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_RET,    "retn",      AM_I|OT_w|P_r,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_RET,    "ret",       FLAGS_NONE|P_r,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_LFP,    "les",       AM_G|OT_v|P_w,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_LFP,    "lds",       AM_G|OT_v|P_w,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MOV,    "mov",       AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "enter",     AM_I|OT_w|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "leave",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_RET,    "retf",      AM_I|OT_w|P_r,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "retf",      FLAGS_NONE|P_r,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INT,    "int3",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_INT,    "int",       AM_I|OT_b|P_r,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "into",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "iret",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "g2",        AM_E|OT_b,                   AM_I1|OT_b,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g2",        AM_E|OT_v,                   AM_I1|OT_b,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g2",        AM_E|OT_b,                   AM_REG|REG_CL|OT_b,        FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g2",        AM_E|OT_v,                   AM_REG|REG_CL|OT_b,        FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ASC,    "aam",       AM_I|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_ASC,    "aad",       AM_I|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "salc",      FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "xlat",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "esc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_LOOP,   "loopn",     AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_LOOP,   "loope",     AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_LOOP,   "loop",      AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jecxz",     AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "in",        AM_REG|REG_AL|OT_b|P_w,      AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "in",        AM_REG|REG_EAX|OT_v|P_w,     AM_I|OT_b|P_r,             FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "out",       AM_I|OT_b|P_w,               AM_REG|REG_AL|OT_b|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "out",       AM_I|OT_b|P_w,               AM_REG|REG_EAX|OT_v|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_CALL,   "call",      AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMP,    "jmp",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMP,    "jmpf",      AM_A|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMP,    "jmp",       AM_J|OT_b|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "in",        AM_REG|REG_EAX|OT_b|P_w,     AM_REG|REG_EDX|OT_w|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "in",        AM_REG|REG_EAX|OT_v|P_w,     AM_REG|REG_EDX|OT_w|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "out",       AM_REG|REG_EDX|OT_w|P_w,     AM_REG|REG_EAX|OT_b|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "out",       AM_REG|REG_EDX|OT_w|P_w,     AM_REG|REG_EAX|OT_v|P_r,   FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "ext",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "int1",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "ext",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "ext",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PRIV,   "hlt",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "cmc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "g3",        AM_E|OT_b,                   FLAGS_NONE,                FLAGS_NONE,   1 }, 
	{ INSTRUCTION_TYPE_OTHER,  "g3",        AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 }, 
	{ INSTRUCTION_TYPE_OTHER,  "clc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "stc",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "cli",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "sti",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "cld",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "std",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_OTHER,  "g4",        AM_E|OT_b,                   FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  "g5",        AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 }, 
};


// 2-byte instructions

INST inst_table2[256] = {
        { INSTRUCTION_TYPE_OTHER,  "g6",        AM_E|OT_w,                   FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  "g7",        AM_M|OT_w,                   FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "lar",       AM_G|OT_v|P_w,               AM_E|OT_w|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "lsl",       AM_G|OT_v|P_w,               AM_E|OT_w|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "loadall286",FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "clts",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "loadall",   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_PRIV,   "invd",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "wbinvd",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "ud2",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movups", AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movups", AM_W|OT_ps|P_w,              AM_V|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movlps", AM_V|OT_q|P_w,               AM_M|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movlps", AM_M|OT_q|P_w,               AM_V|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"unpcklps",AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"unpcklps",AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movhps", AM_V|OT_q|P_w,               AM_M|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movhps", AM_M|OT_q|P_w,               AM_V|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_PRIV,   "mov",       AM_R|OT_d|P_w,               AM_C|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "mov",       AM_R|OT_d|P_w,               AM_D|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "mov",       AM_C|OT_d|P_w,               AM_R|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "mov",       AM_D|OT_d|P_w,               AM_R|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "mov",       AM_R|OT_d|P_w,               AM_T|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_PRIV,   "mov",       AM_T|OT_d|P_w,               AM_R|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movaps", AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movaps", AM_W|OT_ps|P_w,              AM_V|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"cvtpi2ps",AM_V|OT_ps|P_r,              AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movntps",AM_M|OT_ps|P_w,              AM_V|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"cvttps2pi",AM_P|OT_q|P_r,               AM_W|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"cvtps2pi",AM_P|OT_q|P_r,               AM_W|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"ucomiss",AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"comiss", AM_V|OT_ss|P_w,              AM_W|OT_ss|P_w,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER, "wrmsr",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER, "rdtsc",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_PRIV,  "rdmsr",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER, "rdpmc",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "sysenter",  FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_PRIV,  "sysexit",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MOVC,   "cmovo",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovno",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovb",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovae",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmove",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovne",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovbe",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmova",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovs",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovns",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovp",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovnp",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovl",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovge",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovle",    AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVC,   "cmovg",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"movmskps",AM_G|OT_d|P_w,               AM_V|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"sqrtps", AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"rsqrtps",AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"rcpps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"andps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"andnps", AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"orps",   AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"xorps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"addps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"mulps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"cvtps2pd",AM_V|OT_pd|P_r,              AM_W|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"cvtdq2ps",AM_V|OT_ps|P_r,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"subps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"minps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"divps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"maxps",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"punpcklbw",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"punpcklwd",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"punpckldq",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"packusdw",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pcmpgtb",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pcmpgtw",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pcmpgtd",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"packsswb",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"punpckhbw",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"punpckhbd",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"punpckhdq",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"packssdw",AM_P|OT_q|P_w,               AM_Q|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MMX|TYPE_3, "movd",  AM_P|OT_d|P_w,               AM_E|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"movq",   AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pshufw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             AM_I|OT_b,    1 },
	// groups 12-14
        { INSTRUCTION_TYPE_MMX,    "g12",       AM_P|OT_q,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX,    "g13",       AM_P|OT_q,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX,    "g14",       AM_P|OT_q,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pcmpeqb",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pcmpeqw",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pcmpeqd",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX,    "emms",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,  FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,  FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"movd",   AM_E|OT_d|P_w,               AM_P|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"movq",   AM_Q|OT_q|P_w,               AM_P|OT_q|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_JMPC,   "jo",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jno",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jc",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jnc",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jz",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jnz",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jna",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "ja",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "js",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jns",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jp",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jpo",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jl",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jnl",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jng",       AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_JMPC,   "jg",        AM_J|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SETC,   "seto",      AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setno",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setb",      AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setnb",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setz",      AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setnz",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setbe",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setnbe",    AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "sets",      AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setns",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setp",      AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setnp",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setl",      AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setnl",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setle",     AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SETC,   "setnle",    AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_FS|F_r|P_r,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_FS|F_r|P_w,       FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "cpuid",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BT,     "bt",        AM_E|OT_v|P_r,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  "shld",      AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             AM_I|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_OTHER,  "shld",      AM_E|OT_v|P_w,               AM_G|OT_v|P_r,   AM_REG|REG_ECX|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_REG|REG_GS|F_r|P_r,       FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_POP,    "pop",       AM_REG|REG_GS|F_r|P_w,       FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  "rsm",       FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BTS,    "bts",       AM_E|OT_v|P_r,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  "shrd",      AM_E|OT_v|P_w,               AM_G|OT_v|P_r,             AM_I|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_OTHER,  "shrd",      AM_E|OT_v|P_w,               AM_G|OT_v|P_r,   AM_REG|REG_ECX|OT_b|P_r,1 },
	// XXX: check addressing mode, Intel manual is a little bit confusing...
        { INSTRUCTION_TYPE_OTHER,  "grp15",     AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_EIMUL,  "imul",      AM_G|OT_v|P_r,               AM_E|OT_v|P_r,            FLAGS_NONE|P_r,1 },
        { INSTRUCTION_TYPE_OTHER,  "cmpxchg",   AM_E|OT_b|P_w,               AM_G|OT_b|P_w,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  "cmpxchg",   AM_E|OT_v|P_w,               AM_G|OT_v|P_w,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_LFP,    "lss",       AM_G|OT_v|P_w,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BTR,    "btr",       AM_E|OT_v|P_r,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_LFP,    "lfs",       AM_G|OT_v|P_w,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_LFP,    "lgs",       AM_G|OT_v|P_w,               AM_M|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVZX,  "movzx",     AM_G|OT_v|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVZX,  "movzx",     AM_G|OT_d|P_w,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	// XXX: group 10 / invalid opcode?
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER, "g8",         AM_E|OT_v,                   AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BTC,    "btc",       AM_E|OT_v|P_r,               AM_G|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BSF,    "bsf",       AM_G|OT_v|P_r,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BSR,    "bsr",       AM_G|OT_v|P_r,               AM_E|OT_v|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVSX,  "movsx",     AM_G|OT_v|P_w,               AM_E|OT_b|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MOVSX,  "movsx",     AM_G|OT_v|P_w,               AM_E|OT_w|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_XADD,   "xadd",      AM_E|OT_b|P_w,               AM_G|OT_b|P_w,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_XADD,   "xadd",      AM_E|OT_v|P_w,               AM_G|OT_v|P_w,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"cmpps",  AM_V|OT_ps|P_r,              AM_W|OT_ps|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_OTHER,  "movnti",    AM_M|OT_d|P_w,               AM_G|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"pinsrw", AM_P|OT_w|P_w,               AM_E|OT_w|P_r,             AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"pextrv", AM_G|OT_w|P_w,               AM_P|OT_w|P_r,             AM_I|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_SSE|TYPE_3,"shufps", AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            AM_I|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_OTHER,  "g9",        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_EAX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_ECX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_EDX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_EBX|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_ESP|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_EBP|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_ESI|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_BSWAP,  "bswap",     AM_REG|REG_EDI|OT_v|P_w,     FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psrlw",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psrld",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psrlq",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddq",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmullw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmovmskb",AM_G|OT_q|P_w,               AM_P|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubusb",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubusw",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pminub", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pand",   AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddusb",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddusw",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmaxsw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pandn",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pavgb",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psraw",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psrad",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pavgw",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmulhuw",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmulhw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"movntq", AM_M|OT_q|P_w,               AM_V|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubsb", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubsw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pminsw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"por",    AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddsb", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddsw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmaxsw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pxor",   AM_P|OT_q,                   AM_Q|OT_q,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER|TYPE_3,NULL,   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psllw",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pslld",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psllq",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmuludq",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"pmaddwd",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psadbw", AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
	// XXX: check operand types
        { INSTRUCTION_TYPE_MMX|TYPE_3,"maskmovq",AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubb",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubw",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubd",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"psubq",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddb",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddw",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_MMX|TYPE_3,"paddd",  AM_P|OT_q|P_w,               AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
};

// 3-byte instructions, prefix 0x66

// Yeah, I know, it's waste to use a full 256-instruction table but now
// I'm prepared for future Intel extensions ;-)

INST inst_table3_66[256] = {
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movupd",    AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movupd",    AM_W|OT_pd|P_w,              AM_V|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movlpd",    AM_V|OT_q|P_w,               AM_M|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movlpd",    AM_M|OT_q|P_w,               AM_V|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "unpcklpd",  AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "unpcklpd",  AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movhpd",    AM_V|OT_q|P_w,               AM_M|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movhpd",    AM_M|OT_q|P_w,               AM_V|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movapd",    AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movapd",    AM_W|OT_pd|P_w,              AM_V|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtpi2pd",  AM_V|OT_pd|P_r,              AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movntpd",   AM_M|OT_pd|P_w,              AM_V|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvttpd2pi", AM_P|OT_q|P_r,               AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtpd2pi",  AM_P|OT_q|P_r,               AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "ucomisd",   AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "comisd",    AM_V|OT_sd|P_w,              AM_W|OT_sd|P_w,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movmskpd",  AM_G|OT_d|P_w,               AM_V|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "sqrtpd",    AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "andpd",     AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "andnpd",    AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "orpd",      AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "xorpd",     AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "addpd",     AM_V|OT_pd|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "mulpd",     AM_V|OT_pd|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtpd2ps",  AM_V|OT_pd|P_r,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtps2dq",  AM_V|OT_pd|P_r,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "subpd",     AM_V|OT_pd|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "minpd",     AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "divpd",     AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "maxpd",     AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpcklbw", AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpcklwd", AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punockldq", AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "packusdw",  AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pcmpgtb",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pcmpgtw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pcmpgtd",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "packsswb",  AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpckhbw", AM_V|OT_dq|P_w,              AM_Q|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpckhbd", AM_V|OT_dq|P_w,              AM_Q|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpckhdq", AM_V|OT_dq|P_w,              AM_Q|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "packssdw",  AM_V|OT_dq|P_w,              AM_Q|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpcklqdq", AM_V|OT_dq|P_w,             AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "punpckhqd", AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movd",      AM_V|OT_d|P_w,               AM_E|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movdqa",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pshufd",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            AM_I|OT_b,    1 },
	// groups 12-14
        { INSTRUCTION_TYPE_SSE,   "g12",        AM_P|OT_dq,                  AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,   "g13",        AM_W|OT_dq,                  AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,   "g14",        AM_W|OT_dq,                  AM_I|OT_b,                 FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pcmpeqb",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pcmpeqw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pcmpeqd",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,   "haddpd",     AM_V|OT_pd,                  AM_W|OT_pd,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,   "hsubpd",     AM_V|OT_pd,                  AM_W|OT_pd,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movd",      AM_E|OT_d|P_w,               AM_V|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movdqa",    AM_W|OT_dq|P_w,              AM_V|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cmppd",     AM_V|OT_pd|P_r,              AM_W|OT_pd|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "pinsrw",    AM_V|OT_w|P_w,               AM_E|OT_w|P_r,             AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_SSE,    "pextrv",    AM_G|OT_w|P_w,               AM_V|OT_w|P_r,             AM_I|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_SSE,    "shufpd",    AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            AM_I|OT_b|P_r,1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "addsubpd",  AM_V|OT_pd|P_w,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psrlw",     AM_V|OT_dq|P_w,              AM_Q|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psrld",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psrlq",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddq",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmullw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movq",      AM_W|OT_q|P_w,               AM_V|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmovmskb",  AM_G|OT_d|P_w,               AM_V|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubusb",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubusw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pminub",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pand",      AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddusb",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddusw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmaxsw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pandn",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pavgb",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psraw",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psrad",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pavgw",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmulhuw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmulhw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvttpd2dq", AM_V|OT_dq|P_r,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movntq",    AM_M|OT_dq|P_w,              AM_V|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubsb",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubsw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pminsw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "por",       AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddsb",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddsw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmaxsw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pxor",      AM_V|OT_dq,                  AM_W|OT_dq,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "psllw",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pslld",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psllq",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmuludq",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pmaddwd",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psadbw",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "maskmovdqu", AM_V|OT_dq|P_w,             AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubb",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubw",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubd",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psubq",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddb",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddw",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "paddd",     AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
}; 

// 3-byte instructions, prefix 0xf2

INST inst_table3_f2[256] = {
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movsd",     AM_W|OT_sd|P_w,              AM_V|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movddup",   AM_V|OT_q|P_w,               AM_W|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cvtsi2sd",  AM_V|OT_sd|P_r,              AM_E|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cvttsd2si", AM_G|OT_d|P_r,               AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtsd2si",  AM_G|OT_d|P_r,               AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "sqrtsd",    AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "addsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "mulsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtsd2ss",  AM_V|OT_ss|P_r,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "subsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "minsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "divsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "maxsd",     AM_V|OT_sd|P_w,              AM_W|OT_sd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "pshuflw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,   "haddps",     AM_V|OT_ps,                  AM_W|OT_ps,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,   "hsubps",     AM_V|OT_ps,                  AM_W|OT_ps,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cmpsd",     AM_V|OT_sd|P_r,              AM_W|OT_sd|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "addsubpd",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movdq2q",   AM_P|OT_q|P_w,               AM_V|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cvtpd2dq",  AM_V|OT_dq|P_r,              AM_W|OT_pd|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,   "lddqu",      AM_V|OT_dq,                  AM_M|OT_dq,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
}; 

// 3-byte instructions, prefix 0xf3

INST inst_table3_f3[256] = {
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movss",     AM_W|OT_ss|P_w,              AM_V|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movsldup",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movshdup",  AM_V|OT_ps|P_w,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cvtsi2ss",  AM_V|OT_ss|P_r,              AM_E|OT_d|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cvttss2si", AM_G|OT_d|P_r,               AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtss2si",  AM_G|OT_d|P_r,               AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "sqrtss",    AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "rsqrtss",   AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "rcpss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "addss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "mulss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvtsd2sd",  AM_V|OT_sd|P_r,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "cvttps2dq", AM_V|OT_dq|P_r,              AM_W|OT_ps|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "subss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "minss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "divss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "maxss",     AM_V|OT_ss|P_w,              AM_W|OT_ss|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movdqu",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_SSE,    "pshufhw",   AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movq",      AM_V|OT_q|P_w,               AM_W|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "movdqu",    AM_V|OT_dq|P_w,              AM_W|OT_dq|P_r,            FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cmpss",     AM_V|OT_ss|P_r,              AM_W|OT_ss|P_r,            AM_I|OT_b,    1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "movq2dq",   AM_V|OT_dq|P_w,              AM_Q|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_SSE,    "cvtdq2pd",  AM_V|OT_pd|P_r,              AM_W|OT_q|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
        { INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
}; 

// Extension tables

INST inst_table_ext1_1[8] = {
	{ INSTRUCTION_TYPE_ADD,   "add",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,    "or",         AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,   "adc",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,   "sbb",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,   "and",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,   "sub",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,   "xor",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,   "cmp",        AM_E|OT_b|P_r,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
};
INST inst_table_ext1_2[8] = {
	{ INSTRUCTION_TYPE_ADD,   "add",        AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,    "or",         AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,   "adc",        AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,   "sbb",        AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,   "and",        AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,   "sub",        AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,   "xor",        AM_E|OT_v|P_w,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,   "cmp",        AM_E|OT_v|P_r,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
};
INST inst_table_ext1_3[8] = {
	{ INSTRUCTION_TYPE_ADD,   "add",        AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OR,    "or",         AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ADC,   "adc",        AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SBB,   "sbb",        AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_AND,   "and",        AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SUB,   "sub",        AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_XOR,   "xor",        AM_E|OT_v|P_w,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CMP,   "cmp",        AM_E|OT_v|P_r,               AM_I|OT_b|F_s|P_r,         FLAGS_NONE,   1 },
};

INST inst_table_ext2_1[8] = {
	{ INSTRUCTION_TYPE_ROX,   "rol",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "ror",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcl",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcr",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shl",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shr",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER, NULL,         FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SHX,   "sar",        AM_E|OT_b|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
};
INST inst_table_ext2_2[8] = {
	{ INSTRUCTION_TYPE_ROX,   "rol",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "ror",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcl",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcr",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shl",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shr",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER, NULL,         FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SHX,   "sar",        AM_E|OT_v|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
};
INST inst_table_ext2_3[8] = {
	{ INSTRUCTION_TYPE_ROX,   "rol",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "ror",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcl",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcr",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shl",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shr",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER, NULL,         FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SHX,   "sar",        AM_E|OT_b|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
};
INST inst_table_ext2_4[8] = {
	{ INSTRUCTION_TYPE_ROX,   "rol",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "ror",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcl",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcr",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shl",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shr",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER, NULL,         FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SHX,   "sar",        AM_E|OT_v|P_w,               AM_I1|OT_b|P_r,            FLAGS_NONE,   1 },
};
INST inst_table_ext2_5[8] = {
	{ INSTRUCTION_TYPE_ROX,   "rol",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "ror",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcl",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcr",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shl",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shr",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER, NULL,         FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SHX,   "sar",        AM_E|OT_b|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
};
INST inst_table_ext2_6[8] = {
	{ INSTRUCTION_TYPE_ROX,   "rol",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "ror",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcl",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_ROX,   "rcr",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shl",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_SHX,   "shr",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER, NULL,         FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SHX,   "sar",        AM_E|OT_v|P_w,               AM_REG|REG_CL|OT_b|P_r,    FLAGS_NONE,   1 },
};

INST inst_table_ext3_1[8] = {
	{ INSTRUCTION_TYPE_TEST,   "test",      AM_E|OT_b|P_r,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_NOT,    "not",       AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_NEG,    "neg",       AM_E|OT_b|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MUL,    "mul",       AM_E|OT_b|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_IMUL,   "imul",      AM_E|OT_b|P_r,               FLAGS_NONE|P_r,           FLAGS_NONE|P_r,1 },
	{ INSTRUCTION_TYPE_DIV,    "div",       AM_E|OT_b|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_IDIV,   "idiv",      AM_E|OT_b|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
};
INST inst_table_ext3_2[8] = {
	{ INSTRUCTION_TYPE_TEST,   "test",      AM_E|OT_v|P_r,               AM_I|OT_v|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_NOT,    "not",       AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_NEG,    "neg",       AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_MUL,    "mul",       AM_E|OT_v|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_IMUL,   "imul",      AM_E|OT_v|P_r,               FLAGS_NONE|P_r,           FLAGS_NONE|P_r,1 },
	{ INSTRUCTION_TYPE_DIV,    "div",       AM_E|OT_v|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_IDIV,   "idiv",      AM_E|OT_v|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
};

INST inst_table_ext4[8] = {
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_E|OT_b|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_E|OT_b,                   FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

INST inst_table_ext5[8] = {
	{ INSTRUCTION_TYPE_INC,    "inc",       AM_E|OT_v|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_DEC,    "dec",       AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CALL,   "call",      AM_E|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_CALL,   "callf",     AM_E|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_JMP,    "jmp",       AM_E|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_JMP,    "jmpf",      AM_E|OT_v|P_x,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_PUSH,   "push",      AM_E|OT_v|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

INST inst_table_ext6[8] = {
        { INSTRUCTION_TYPE_SLDT,   "sldt",      AM_E|OT_w|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "str",       AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "lldt",      AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "ltr",       AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "verr",      AM_E|OT_w|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,   "verw",      AM_E|OT_w|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

INST inst_table_ext7[8] = {
        { INSTRUCTION_TYPE_SGDT,  "sgdt",       AM_M|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SIDT,  "sidt",       AM_M|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,  "lgdt",       AM_M|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,  "lidt",       AM_M|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,  "smsw",       AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_PRIV,  "lmsw",       AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_PRIV,  "invlpg",     AM_M|OT_b|P_r,               FLAGS_NONE,                FLAGS_NONE,   1 },
};
INST inst_monitor =
	{ INSTRUCTION_TYPE_OTHER,  "monitor",   FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 };
INST inst_mwait =
	{ INSTRUCTION_TYPE_OTHER,  "mwait",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 };

INST inst_table_ext8[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_BT,     "bt",        AM_E|OT_v|P_r,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BTS,    "bts",       AM_E|OT_v|P_r,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BTR,    "btr",       AM_E|OT_v|P_r,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_BTC,    "btc",       AM_E|OT_v|P_r,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
};

INST inst_table_ext9[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_SSE,   "cmpxch8b",   AM_M|OT_q,                   FLAGS_NONE,                FLAGS_NONE,   1 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

INST inst_table_ext10[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// XXX: not used yet
INST inst_table_ext11[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// XXX: intel manual says AM_P.. but that seems to produce wrong disasm
INST inst_table_ext12[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psrlw",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psraw",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psllw",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};
// XXX: intel manual says AM_P.. but that seems to produce wrong disasm
INST inst_table_ext12_66[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psrlw",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psraw",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psllw",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// XXX: intel manual says AM_P.. but that seems to produce wrong disasm
INST inst_table_ext13[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psrld",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psrad",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "pslld",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};
// XXX: intel manual says AM_P.. but that seems to produce wrong disasm
INST inst_table_ext13_66[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psrld",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psrad",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "pslld",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// XXX: intel manual says AM_P.. but that seems to produce wrong disasm
INST inst_table_ext14[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psrlq",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_MMX,    "psllq",     AM_Q|OT_q|P_w,               AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};
// XXX: intel manual says AM_P.. but that seems to produce wrong disasm
INST inst_table_ext14_66[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psrlq",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "psrldq",    AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_SSE,    "psllq",     AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_SSE,    "pslldq",    AM_W|OT_dq|P_w,              AM_I|OT_b|P_r,             FLAGS_NONE,   1 },
};

INST inst_table_ext15[8] = {
        { INSTRUCTION_TYPE_OTHER, "fxsave",     AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER, "fxrstor",    AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER, "ldmxcsr",    AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
        { INSTRUCTION_TYPE_OTHER, "stmxcsr",    AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
        { INSTRUCTION_TYPE_OTHER, "sfence",     AM_E|OT_v,                   FLAGS_NONE,                FLAGS_NONE,   1 },
};

INST inst_table_ext16[8] = {
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_OTHER,  NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// Table of extension tables

INST * inst_table_ext[25] = {
	inst_table_ext1_1,
	inst_table_ext1_2,
	inst_table_ext1_3,
	inst_table_ext2_1,
	inst_table_ext2_2,
	inst_table_ext2_3,
	inst_table_ext2_4,
	inst_table_ext2_5,
	inst_table_ext2_6,
	inst_table_ext3_1,
	inst_table_ext3_2,
	inst_table_ext4,
	inst_table_ext5,
	inst_table_ext6,
	inst_table_ext7,
	inst_table_ext8,
	inst_table_ext9,
	inst_table_ext10,
	inst_table_ext11,
	inst_table_ext12,
	inst_table_ext13,
	inst_table_ext14,
	inst_table_ext15,
	inst_table_ext16,
};

// FPU instruction tables

/*
 * Tables are composed in two parts:
 *
 * - 1st part (index 0-7) are identified by the reg field of MODRM byte
 *   if the MODRM is < 0xc0. reg field can be used directly as an index to table.
 *
 * - 2nd part (8 - 0x47) are identified by the MODRM byte itself. In that case,
 *   the index can be calculated by "index = MODRM - 0xb8"
 *
 */
INST inst_table_fpu_d8[72] = {
	{ INSTRUCTION_TYPE_FADD,   "fadds",     AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FMUL,   "fmuls",     AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FCOM,   "fcoms",     AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomps",    AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FSUB,   "fsubs",     AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubrs",    AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FDIV,   "fdivs",     AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivrs",    AM_E|OT_d|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOM,   "fcom",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcomp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
};
INST inst_table_fpu_d9[72] = {
	{ INSTRUCTION_TYPE_FLD,    "flds",      AM_E|OT_d,                   FLAGS_NONE,                FLAGS_NONE,   1 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	// XXX: operand type is not correct
	{ INSTRUCTION_TYPE_FPU,    "fldenv",    AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    "fldcw",     AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    "fstenv",    AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    "fstcw",     AM_E|OT_v|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FLD,    "fld",       AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FXCH,   "fxch",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fnop",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fchs",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fabs",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "ftst",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fxam",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fld1",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fldl2t",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fldl2e",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fldpi",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fldlg2",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fldln2",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fldz",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "f2xm1",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fyl2x",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fptan",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fpatan",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fxtract",   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fprem1",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fdecstp",   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fincstp",   FLAGS_NONE|P_w,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fprem",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fyl2xp1",   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fsqrt",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fsincos",   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "frndint",   FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fscale",    FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "fsin",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fcos",      FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
};
INST inst_table_fpu_da[72] = {
	{ INSTRUCTION_TYPE_FIADD,  "fiaddl",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIMUL,  "fimull",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FICOM,  "ficoml",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FICOMP, "ficompl",   AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISUB,  "fisubl",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISUBR, "fisubrl",   AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIDIV,  "fidivl",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIDIVR, "fidivrl",   AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovb",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmove",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovbe",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovu",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FUCOMP, "fucompp",   FLAGS_NONE|P_w,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// XXX: fsetpm??
INST inst_table_fpu_db[72] = {
	{ INSTRUCTION_TYPE_FILD,   "fildl",     AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISTTP, "fisttp",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIST,   "fistl",     AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISTP,  "fistp",     AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FLD,    "fldt",      AM_E|OT_t,                   FLAGS_NONE,                FLAGS_NONE,   1 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FSTP,   "fstpl",     AM_E|OT_t|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnb",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovne",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnbe",  AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCMOVC, "fcmovnu",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fclex",     FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    "finit",     FLAGS_NONE|P_w,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMI, "fucomi",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMI,  "fcomi",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};
INST inst_table_fpu_dc[72] = {
	{ INSTRUCTION_TYPE_FADD,   "faddl",     AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FMUL,   "fmull",     AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FCOM,   "fcoml",     AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FCOMP,  "fcompl",    AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FSUB,   "fsubl",     AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubrl",    AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FDIV,   "fdivl",     AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivrl",    AM_E|OT_q|P_w,               FLAGS_NONE|P_r,            FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADD,   "fadd",      AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMUL,   "fmul",      AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBR,  "fsubr",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUB,   "fsub",      AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVR,  "fdivr",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIV,   "fdiv",      AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
};
INST inst_table_fpu_dd[72] = {
	{ INSTRUCTION_TYPE_FLD,    "fldl",      AM_E|OT_q,                   FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISTTP, "fisttp",    AM_E|OT_q|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FST,    "fstl",      AM_E|OT_q|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FSTP,   "fstpl",     AM_E|OT_q|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	// XXX: operand type is not exactly right..
	{ INSTRUCTION_TYPE_FPU,    "frstor",    AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	// XXX: operand type is not exactly right..
	{ INSTRUCTION_TYPE_FPU,    "fsave",     AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	// XXX: operand type is not exactly right..
	{ INSTRUCTION_TYPE_FPU,    "fstsw",     AM_E|OT_d|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST0|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST1|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST2|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST3|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST4|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST5|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST6|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREE,  "ffree",     AM_REG|REG_ST7|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST0|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST1|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST2|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST3|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST4|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST5|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST6|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FST,    "fst",       AM_REG|REG_ST7|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST0|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST1|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST2|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST3|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST4|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST5|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST6|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSTP,   "fstp",      AM_REG|REG_ST7|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOM,  "fucom",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST0|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST1|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST2|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST3|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST4|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST5|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST6|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMP, "fucomp",    AM_REG|REG_ST7|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};
INST inst_table_fpu_de[72] = {
	{ INSTRUCTION_TYPE_FIADD,  "fiadd",     AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIMUL,  "fimul",     AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FICOM,  "ficom",     AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FICOMP, "ficomp",    AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISUB,  "fisub",     AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISUBR, "fisubr",    AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIDIV,  "fidiv",     AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIDIVR, "fidivr",    AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FADDP,  "faddp",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FMULP,  "fmulp",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FCOMPP, "fcompp",    FLAGS_NONE|P_w,              FLAGS_NONE|P_r,            FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBRP, "fsubrp",    AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FSUBP,  "fsubp",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVRP, "fdivrp",    AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST1|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST2|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST3|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST4|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST5|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST6|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FDIVP,  "fdivp",     AM_REG|REG_ST7|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
};

INST inst_table_fpu_df[72] = {
	{ INSTRUCTION_TYPE_FILD,   "fild",      AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	// fisttp: IA-32 2004
	{ INSTRUCTION_TYPE_FISTTP, "fisttp",    AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FIST,   "fist",      AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISTP,  "fistp",     AM_E|OT_w|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    "fbld",      AM_E|OT_t|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FILD,   "fild",      AM_E|OT_t|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FPU,    "fbstp",     AM_E|OT_t|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	{ INSTRUCTION_TYPE_FISTP,  "fistp",     AM_E|OT_t|P_w,               FLAGS_NONE,                FLAGS_NONE,   1 },
	// ffreep undocumented!!
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST0|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST1|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST2|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST3|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST4|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST5|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST6|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FFREEP, "ffreep",    AM_REG|REG_ST7|F_f|P_w,      FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    "fstsw",     FLAGS_NONE|P_w,              FLAGS_NONE,                FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FUCOMIP,"fucomip",   AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST0|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST1|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST2|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST3|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST4|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST5|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST6|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FCOMIP, "fcomip",    AM_REG|REG_ST0|F_f|P_w,      AM_REG|REG_ST7|F_f|P_r,    FLAGS_NONE,   0 },
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
	{ INSTRUCTION_TYPE_FPU,    NULL,        FLAGS_NONE,                  FLAGS_NONE,                FLAGS_NONE,   0 }, 
};

// Table of FPU instruction tables

/*
 * These tables are accessed by the following way:
 *
 * INST *fpuinst = inst_table4[opcode - 0xd8][index];
 * where index is determined by the MODRM byte.
 *
 */
INST * inst_table4[8] = {
	inst_table_fpu_d8,
	inst_table_fpu_d9,
	inst_table_fpu_da,
	inst_table_fpu_db,
	inst_table_fpu_dc,
	inst_table_fpu_dd,
	inst_table_fpu_de,
	inst_table_fpu_df,
};

