// $Id: gc_trait_allele.h,v 1.6 2018/01/03 21:32:55 mkkuhner Exp $

/*
Copyright 2002-2005 Mary K. Kuhner, Peter Beerli, and Joseph Felsenstein

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

/* Authors: Mary Kuhner, Jon Yamato, and Joseph Felsenstein */


#ifndef GC_TRAIT_ALLELE_H
#define GC_TRAIT_ALLELE_H

#include "gc_quantum.h"
#include "wx/string.h"

class gcTraitAllele : public GCQuantum
{
    friend class GCStructures;

  private:
    bool                            m_hasTraitId;
    size_t                          m_traitId;

    void    SetTraitId(size_t traitId);
    void    UnsetTraitId();

  protected:

  public:
    gcTraitAllele();
    virtual ~gcTraitAllele();

    bool    HasTraitId()    const;
    size_t  GetTraitId()    const;

    virtual void    SetName(wxString name); // overrides gc_quantum version
    // so name can be checked for spaces
};

#endif  // GC_TRAIT_ALLELE_H

//____________________________________________________________________________________
