/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "kvpnckicker.h"

#include <QtGui/QCloseEvent>
#include <QtGui/QImage>
#include <QtGui/QToolTip>
#include <QHelpEvent>

#include <kaction.h>
#include <kactioncollection.h>
#include <kiconloader.h>
#include <klocale.h>

#include "kvpnc.h"

KVpncKicker::KVpncKicker(KVpncConfig *GlobalConfig, QWidget* parent, const char *name) : KSystemTrayIcon(KIcon(loadIcon("disconnected")), parent)
{
    Q_UNUSED(name);

    this->parent = parent;
    this->initDockWindow();
    this->GlobalConfig = GlobalConfig;
    QAction *quit = actionCollection()->action("file_quit");
    quit->disconnect();
    KVpnc *myParent = static_cast<KVpnc *>(parent);
    connect(quit, SIGNAL(activated()), myParent, SLOT(quitCalledKicker()));

    show();
}

KVpncKicker::~KVpncKicker() {}

void KVpncKicker::closeEvent(QCloseEvent *e)
{
    if (GlobalConfig->KvpncDebugLevel > 1)
        GlobalConfig->appendLogEntry(i18n("CloseEvent received (receiver: %1)." , QString("kvpnckicker")), KVpncEnum::debug);

    emit closeEventKicker(e);
}

void KVpncKicker::setStatus(int Status)
{
    if (Status == connecting) {
        setIcon(KIcon(QString("connecting"), KIconLoader().global()));

    } else if (Status ==  connected) {
        setIcon(loadIcon("connected"));
    } else
        setIcon(loadIcon("disconnected"));
}

void KVpncKicker::initDockWindow()
{
//  disconnectedIcon = loadIcon( "disconnected");
//  connectedIcon = loadIcon( "connected"  );
//  connectingIcon = loadIcon( "connecting" );
    //setFixedSize( DOCK_WIDTH, DOCK_HEIGHT );
//  setPixmap( loadIcon( "disconnected") );
//  QToolTip::add(0, i18n("Disconnected"));
}

KMenu* KVpncKicker::menu()
{
    return (KMenu *)contextMenu();
}

bool KVpncKicker::event(QEvent *e)
{
	if (e->type() == QEvent::ToolTip) {
		QHelpEvent *helpEvent = static_cast<QHelpEvent *>(e);
		const QPoint &p = helpEvent->pos();
		emit showTooltipRequested(p);
	}
	return KSystemTrayIcon::event(e);
}


#include "kvpnckicker.moc"
