/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _HIGHSCORE_H
#define _HIGHSCORE_H

#include <gtk/gtk.h>

#include "score.h"

class HighScore {
   ScoreList _beginner;
   ScoreList _intermediate;
   ScoreList _expert;

   void FillHighScore(ScoreList& slist, GtkWidget* table);
protected:
public:
   HighScore() {}
   void Read();
   void Write();
   bool IsNewBeginnerHighScore(int seconds) {
      return _beginner.IsNewHighScore(seconds);}
   bool IsNewIntermediateHighScore(int seconds) {
      return _intermediate.IsNewHighScore(seconds);}
   bool IsNewExpertHighScore(int seconds) {
      return _expert.IsNewHighScore(seconds);}
   void AddBeginnerHighScore(Score& score) {
      _beginner.AddHighScore(score);}
   void AddIntermediateHighScore(Score& score) {
      _intermediate.AddHighScore(score);}
   void AddExpertHighScore(Score& score) {
      _expert.AddHighScore(score);}
   const ScoreList& Beginner() {return _beginner;}
   const ScoreList& Intermediate() {return _intermediate;}
   const ScoreList& Expert() {return _expert;}
};

#endif // _HIGHSCORE_H
