/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __GIMP_IMAGE_MERGE_H__
#define __GIMP_IMAGE_MERGE_H__


GimpLayer   * gimp_image_merge_visible_layers  (GimpImage      *image,
                                                GimpContext    *context,
                                                GimpMergeType   merge_type,
                                                gboolean        merge_active_group,
                                                gboolean        discard_invisible);
GimpLayer   * gimp_image_merge_down            (GimpImage      *image,
                                                GimpLayer      *current_layer,
                                                GimpContext    *context,
                                                GimpMergeType   merge_type,
                                                GError        **error);
GimpLayer   * gimp_image_merge_group_layer     (GimpImage      *image,
                                                GimpGroupLayer *group);

GimpLayer   * gimp_image_flatten               (GimpImage      *image,
                                                GimpContext    *context,
                                                GError        **error);

GimpVectors * gimp_image_merge_visible_vectors (GimpImage      *image,
                                                GError        **error);


#endif /* __GIMP_IMAGE_MERGE_H__ */
