/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-monitor.h"
#include "glue-gui-recorder.h"
#include "glue.h"

struct cpssp {
	GtkWidget *gui;
	void * recorder;
};

/*
 * Simulator Callbacks
 */
static void
COMP_(gui_pixel_set)(
	void *_cpssp,
	unsigned int x,
	unsigned int y,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_recorder_pixel_set(cpssp->recorder, x, y, r, g, b);
	gui_gtk_monitor_pixel_set(GUI_GTK_MONITOR(cpssp->gui), x, y, r, g, b);
}

static void
COMP_(gui_size_set)(void *_cpssp, unsigned int width, unsigned int height)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_recorder_size_set(cpssp->recorder, width, height);
	gui_gtk_monitor_size_set(GUI_GTK_MONITOR(cpssp->gui), width, height);
}

static void
COMP_(gui_sync)(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_monitor_sync(GUI_GTK_MONITOR(cpssp->gui));
}

static void
COMP_(gui_screenshot_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (val == 0) return;

	gui_recorder_screenshot(cpssp->recorder);
}

static void
COMP_(gui_rec_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_recorder_rec_set(cpssp->recorder, val);
	gui_gtk_monitor_rec_set(GUI_GTK_MONITOR(cpssp->gui), (gboolean) val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
COMP_(gui_recording_on_event)(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp * cpssp = (struct cpssp *) _cpssp;

	gui_recorder_rec_set(cpssp->recorder, 1);
}

static void
COMP_(gui_recording_off_event)(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp * cpssp = (struct cpssp *) _cpssp;

	gui_recorder_rec_set(cpssp->recorder, 0);
}

static void
COMP_(gui_screenshot_pressed)(GtkWidget *w, gpointer _cpssp)
{
	COMP_(gui_screenshot_set)(_cpssp, 1);
}

static void
COMP_(gui_screenshot_released)(GtkWidget *w, gpointer _cpssp)
{
	COMP_(gui_screenshot_set)(_cpssp, 0);
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power_230v,
	struct sig_vga_conn *port_vga,
	struct sig_opt_rgb *port_opt_video,
	struct sig_boolean *port_screenshot,
	struct sig_boolean *port_rec
)
{
	static const struct sig_opt_rgb_funcs opt_video_funcs = {
		.pixel_set = COMP_(gui_pixel_set),
		.size_set = COMP_(gui_size_set),
		.sync = COMP_(gui_sync),
	};
	static const struct sig_boolean_funcs screenshot_funcs = {
		.set = COMP_(gui_screenshot_set),
	};
	static const struct sig_boolean_funcs rec_funcs = {
		.set = COMP_(gui_rec_set),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->recorder = gui_recorder_create(1600, 1200);

	cpssp->gui = gui_gtk_monitor_new("VGA", 1600, 1200);
	g_signal_connect(G_OBJECT(cpssp->gui), "recording-on",
			G_CALLBACK(COMP_(gui_recording_on_event)),
			cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui), "recording-off",
			G_CALLBACK(COMP_(gui_recording_off_event)),
			cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui), "screenshot-pressed",
			G_CALLBACK(COMP_(gui_screenshot_pressed)),
			cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui), "screenshot-released",
			G_CALLBACK(COMP_(gui_screenshot_released)),
			cpssp);
	gtk_widget_show(cpssp->gui);

	/* sync it once, initially */
	gui_gtk_monitor_sync(GUI_GTK_MONITOR(cpssp->gui));

	gui_gtk_comp_add(page, SCOMP, name, cpssp->gui, TRUE, TRUE, NULL);
	gui_gtk_monitor_grab_focus(GUI_GTK_MONITOR(cpssp->gui));

	/* In */
	sig_opt_rgb_connect(port_opt_video, cpssp, &opt_video_funcs);
	sig_boolean_connect_in(port_screenshot, cpssp, &screenshot_funcs);
	sig_boolean_connect_in(port_rec, cpssp, &rec_funcs);

	return cpssp;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	gui_recorder_destroy(cpssp->recorder);

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	gui_gtk_monitor_suspend(cpssp->gui, fComp);
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	gui_gtk_monitor_resume(cpssp->gui, fComp);
}
