/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "chip_st_l3gd20_gui.h"
#ifdef HAVE_GTK
#include "chip_st_l3gd20_gui_gtk.h"
#endif

void *
chip_st_l3gd20_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_vdd,
	struct sig_std_logic *port_vdd_io,
	struct sig_std_logic *port_cs,
	struct sig_std_logic *port_int1,
	struct sig_std_logic *port_drdy_int2_,
	struct sig_std_logic *port_scl_spc,
	struct sig_std_logic *port_sda_sdi_sdo,
	struct sig_std_logic *port_sdo_sao,
	struct sig_std_logic *port_res8,
	struct sig_std_logic *port_res9,
	struct sig_std_logic *port_res10,
	struct sig_std_logic *port_res11,
	struct sig_std_logic *port_res12,
	struct sig_std_logic *port_res14,
	struct sig_std_logic *port_res15,
	struct sig_integer *port_gyro_x,
	struct sig_integer *port_gyro_y,
	struct sig_integer *port_gyro_z,
	struct sig_integer *port_temp
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return chip_st_l3gd20_gui_gtk_create(page, name, port_manage,
				port_gnd, port_vdd, port_vdd_io,
				port_cs, port_int1, port_drdy_int2_,
				port_scl_spc, port_sda_sdi_sdo, port_sdo_sao,
				port_res8, port_res9, port_res10, port_res11,
				port_res12, port_res14, port_res15,
				port_gyro_x, port_gyro_y, port_gyro_z,
				port_temp);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
chip_st_l3gd20_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chip_st_l3gd20_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
chip_st_l3gd20_gui_suspend(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chip_st_l3gd20_gui_gtk_suspend(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
chip_st_l3gd20_gui_resume(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chip_st_l3gd20_gui_gtk_resume(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}
