package screensaver

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

// Data screensaver configurations
type Data struct {
	Version           string `json:"version"`
	BatteryDelay      int    `json:"battery_delay"`
	LinePowerDelay    int    `json:"line_power_delay"`
	LockScreenAtAwake bool   `json:"lock_screen_at_awake"`
	Current           string `json:"current"`
}

const (
	Name = "screensaver"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeInt(&core.BatteryDelay, curInfo.BatteryDelay,
		cacheInfo.BatteryDelay)
	utils.MergeInt(&core.LinePowerDelay, curInfo.LinePowerDelay,
		cacheInfo.LinePowerDelay)
	utils.MergeBool(&core.LockScreenAtAwake, curInfo.LockScreenAtAwake,
		cacheInfo.LockScreenAtAwake)
	utils.MergeString(&core.Current, curInfo.Current,
		cacheInfo.Current)
}
