package dock

import (
	"reflect"
	"testing"
)

var (
	_core1 = Data{
		IconSize:    24,
		DisplayMode: "fashion",
		HideMode:    "showing",
		Position:    "bottom",
		DockedApps:  []string{"firefox", "eog"},
		Plugins: map[string]map[string]interface{}{
			"tray": map[string]interface{}{
				"position": 2,
			},
		},
	}
	_core2 = Data{
		IconSize:    24,
		DisplayMode: "efficient",
		HideMode:    "hidden",
		Position:    "left",
		DockedApps:  []string{"firefox", "eog", "gedit"},
		Plugins: map[string]map[string]interface{}{
			"tray": map[string]interface{}{
				"position": 2,
			},
			"power": map[string]interface{}{
				"position": 3,
			},
		},
	}
)

func TestName(t *testing.T) {
	var core = &Data{}
	if core.Name() != "dock" {
		panic("[TestName] name should be equal")
	}
}

func TestModel(t *testing.T) {
	var core = &Data{}
	if !reflect.DeepEqual(core, core.Model()) {
		panic("[TestModel] model should be equal")
	}
}

func TestToIFC(t *testing.T) {
	var tmp = &Data{}
	if !reflect.DeepEqual(tmp.ToIFC(&_core1), &_core1) {
		panic("[TestToIFC] ToIFC should be equal")
	}
	if reflect.DeepEqual(tmp.ToIFC(&_core1), tmp) {
		panic("[TestToIFC] ToIFC should be not equal with tmp")
	}
}

func TestEqual(t *testing.T) {
	core := _core1
	if (&core).Equal(&_core2) {
		panic("[TestEqual] core should be not equal with core2")
	}
	if !(&core).Equal(&_core1) {
		panic("[TestEqual] core should be equal with core1")
	}
}

func TestGenCache(t *testing.T) {
	if !reflect.DeepEqual((&_core1).GenCache(&Data{}), &_core1) {
		panic("[TestGenCache] cache should be equal with core1")
	}
}

func TestMerge(t *testing.T) {
	tmp1 := _core1
	(&tmp1).Merge(&_core2, &_core1)
	if !reflect.DeepEqual(&tmp1, &_core2) {
		panic("[TestMerge] tmp1 should be equal with core2")
	}
	tmp2 := _core2
	tmp2.IconSize = 36
	(&tmp2).Merge(&_core1, &_core2)
	tmp3 := _core1
	tmp3.IconSize = 36
	if !reflect.DeepEqual(&tmp2, &tmp3) {
		panic("[TestMerge] tmp2 should be equal with tmp3")
	}
}
