package main

import (
	"pkg.deepin.io/daemon/sync/infrastructure/log"

	"github.com/mitchellh/mapstructure"

	"encoding/json"

	"github.com/godbus/dbus"
	"pkg.deepin.io/daemon/sync/modules"
)

func (d *Daemon) OnMessage(playload map[string]interface{}) *dbus.Error {
	log.Info("receive message", playload)
	type message struct {
		Action      string
		AccessToken string `mapstructure:"access_token"`
	}

	msg := &message{}
	mapstructure.Decode(playload, msg)

	caller := d.conn.Object("com.deepin.deepinid", "/com/deepin/deepinid")
	switch msg.Action {
	case "logout":
		caller.Call("com.deepin.deepinid.Logout", 0).Store()
	case "revoke_access":
		caller.Call("com.deepin.deepinid.RevokeAccess", 0, msg.AccessToken).Store()
	}

	return nil
}

func (d *Daemon) IsOnline() (bool, *dbus.Error) {
	data, err := getMachineData(d.hw.ID, d.token)
	if err != nil {
		return false, dbus.NewError(dbusIFC+".IsOnline",
			[]interface{}{err.Error()})
	}
	var tmp = struct {
		Online bool
	}{}
	err = json.Unmarshal(data, &tmp)
	if err != nil {
		return false, dbus.NewError(dbusIFC+".IsOnline",
			[]interface{}{err.Error()})
	}
	return tmp.Online, nil
}

func (d *Daemon) Register(sender dbus.Sender, name, busPath string) *dbus.Error {
	log.Debug("[Register] args:", sender, name, busPath)
	err := d.core.Register(name, &modules.ModuleBusInfo{
		ServiceName: string(sender),
		Path:        busPath,
	})
	if err != nil {
		return dbus.NewError(dbusIFC+".Register",
			[]interface{}{err.Error()})
	}
	return nil
}

func (d *Daemon) SwitcherSet(name string, enabled bool) *dbus.Error {
	changed, err := d.core.SwitcherSet(name, enabled)
	if err != nil {
		return dbus.NewError(dbusIFC+".SwitcherSet",
			[]interface{}{err.Error()})
	}
	if changed {
		err = d.conn.Emit(dbusPath, dbusIFC+"."+dbusSigSwitcherChange, name, enabled)
		if err != nil {
			log.Warning("Failed to emit switcher change signal:", err)
		}
	}
	return nil
}

func (d *Daemon) SwitcherGet(name string) (bool, *dbus.Error) {
	v := d.core.SwitcherGet(name)
	return v, nil
}

func (d *Daemon) SwitcherDump() (string, *dbus.Error) {
	data, err := d.core.SwitcherDump()
	if err != nil {
		return "", dbus.NewError(dbusIFC+".SwitcherDump",
			[]interface{}{err.Error()})
	}
	return string(data), nil
}
