/*
 * Copyright (C) 2016 ~ 2018 Deepin Technology Co., Ltd.
 *               2016 ~ 2018 dragondjf
 *
 * Author:     dragondjf<dingjiangfeng@deepin.com>
 *
 * Maintainer: dragondjf<dingjiangfeng@deepin.com>
 *             zccrs<zhangjide@deepin.com>
 *             Tangtong<tangtong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "singletonapp.h"
#include <QProcess>
#include <QLocalSocket>
#include <QDebug>

SingletonApp::SingletonApp(QObject *parent) : QObject(parent)
{
    initConnections();
}

void SingletonApp::initConnections()
{
    connect(&m_server, &QLocalServer::newConnection, this, &SingletonApp::handleConnection);
}

QString SingletonApp::getServerPathByKey(const QString &key)
{
    QString serverPath = QString("%1/%2").arg(getServerRootPath(), key);
    return serverPath;
}

QString SingletonApp::getUserId()
{
    QString cmd = "id";
    QProcess p;
    p.start(cmd, (QStringList() << "-u"));
    p.waitForFinished(-1);
    QString uid = p.readLine();
    return uid.trimmed();
}

QString SingletonApp::getServerRootPath()
{
    QString path;
    QString uid = getUserId();
    if(uid == "0")
        path = QString("/tmp");
    else
        path = QString("/run/user/%1").arg(uid);
    return path;
}

SingletonApp *SingletonApp::instance()
{
    static SingletonApp* app = new SingletonApp;
    return app;
}

bool SingletonApp::setSingletonApplication(const QString &key)
{
    m_key = key;
    QString serverPath = getServerPathByKey(key);
    QLocalSocket socket;
    socket.connectToServer(serverPath);
    bool ret = socket.waitForConnected(1000);
    if(ret){
        socket.write("MultiProcess");
        socket.flush();
        return false;
    }

    QLocalServer::removeServer(serverPath);
    ret = m_server.listen(serverPath);
    return ret;
}

void SingletonApp::readData()
{
    QLocalSocket* socket = qobject_cast<QLocalSocket*>(sender());
    if(!socket)
        return;

    QByteArray data = socket->readAll();
    qDebug () << "New connection requested:" << data;
}

void SingletonApp::handleConnection()
{
    QLocalSocket* socket = m_server.nextPendingConnection();
    connect(socket, &QLocalSocket::readyRead, this, &SingletonApp::readData);
}

