#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""version.py """

# Copyright (C) 2009-2017 Federico Brega, Pierluigi Villani

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
from urllib.request import urlopen
from urllib.error import URLError
import threading

# Version of this software
VERSION = '1.9.1'

# This url is used to fetch the latest version number directely from
# the website
LAST_VERSION_URL = 'https://cyclograph.sourceforge.io/latestcg'

# This parameter enables or disables the check if the user is running
# the latest version.
# It is intended for environments where the installable software is controlled
# as are distribution.
VERSION_CHECK_ENABLED = True


class LastVersionQuery(threading.Thread):
    lastversion = ''

    def query(self):
        if not VERSION_CHECK_ENABLED:
            return
        try:
            page = urlopen(LAST_VERSION_URL)
            self.lastversion = page.read().decode().strip()
            page.close()
        except URLError:
            self.lastversion = ''

    def islast(self):
        if not self.lastversion:
            return True
        return version_list(VERSION) >= version_list(self.lastversion)

    def run(self):
        self.query()


def version_list(version_string):
    return [int(x) for x in version_string.split('.')]

if __name__ == "__main__":
    print(VERSION)
