#
#  An experimental level set.
#

import boarddef
from boarddef import LNasty, LMonky, LGhosty, LFlappy
from boarddef import LSpringy, LOrcy, LGramy, LBlitzy
from boarddef import RNasty, RMonky, RGhosty, RFlappy
from boarddef import RSpringy, ROrcy, RGramy, RBlitzy


class level01(boarddef.Level):
    a = LNasty
    b = RNasty
    
    walls = """
####################################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##         a   a   b   b          ##
####   ######################   ####
##                                ##
##                                ##
##                                ##
##        a   a     b   b         ##
####   ######################   ####
##                                ##
##                                ##
##                                ##
##       a   a       b   b        ##
####   ######################   ####
##                                ##
##                                ##
##                                ##
##      a   a         b   b       ##
####   ######################   ####
##                                ##
##                                ##
##                                ##
##                                ##
####################################
"""
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level02(boarddef.Level):
    letter = 1
    lightning = 1
    top = 0

    a = LNasty
    b = RNasty
    
    walls = """
##                                ##
##                                ##
##b                               ##
##############        ##############
##                              a ##
#############          #############
##b                               ##
############            ############
##                              a ##
###########              ###########
##b                               ##
##########                ##########
##                              a ##
#########                  #########
##b                               ##
########                    ########
##                              a ##
#######                      #######
##b                               ##
######           ##           ######
##                              a ##
#####         ###  ###         #####
##                                ##
####      ####  ####  ####      ####
##                                ##
###           ########           ###
##                                ##
############            ############
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>x<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>x<<
>>                                <<
>>                                <<
>>>>>>>>>>>>>>^      ^<<<<<<<<<<<<<<
>>                                <<
>>>>>>>>>>>>>^        ^<<<<<<<<<<<<<
>>                                <<
>>>>>>>>>>>>^          ^<<<<<<<<<<<<
>>                                <<
>>>>>>>>>>>^            ^<<<<<<<<<<<
>>                                <<
>>>>>>>>>>^              ^<<<<<<<<<<
>>                                <<
>>>>>>>>>^                ^<<<<<<<<<
>>                                <<
>>>>>>>>^                  ^<<<<<<<<
>>                                <<
>>>>>>>^                    ^<<<<<<<
>>                                <<
>>>>>>^                      ^<<<<<<
>>                                <<
>>>>>^                        ^<<<<<
>>                                <<
>>>>^                          ^<<<<
>>                                <<
>>>^                            ^<<<
>>                                <<
"""


class level03(boarddef.Level):
    letter    = 1
    fire      = 0
    lightning = 0
    water     = 1
    top       = 1

    a = LNasty, RNasty
    b = ()
    c = LMonky, RMonky

    walls = """
##                                ##
##                                ##
##     #            #             ##
##            b                   ##
##                          #     ##
##   a     #    #                 ##
##   #                  #         ##
##                                ##
##    b            a         b    ##
##            #    #            # ##
##       c                        ##
##       #               #   c    ##
##    #          b           #    ##
##                                ##
## #           #    #             ##
##                                ##
##        #               #       ##
##               #    a         # ##
##     #  b           #           ##
##                                ##
##            c              #    ##
##    #       #     b    #        ##
##  #                             ##
##          #                     ##
##                  #             ##
##     #                      #   ##
##                     #          ##
#####         #                #####
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level04(level03):
    a = LNasty, RNasty
    b = LGhosty, RGhosty
    c = ()

class level05(level03):
    a = LSpringy, RSpringy
    b = LSpringy, RSpringy
    c = ()



class level06(boarddef.Level):
    letter    = 1
    fire      = 0
    lightning = 1
    water     = 0
    top       = 0

    a = LSpringy
    b = RSpringy
    c = LBlitzy

    walls = """
##         ##############         ##
##                                ##
##                                ##
## b bcbcbcb bb     a a acacaca a ##
################    ################
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##             #    #             ##
##   ###########    ###########   ##
##             bababa             ##
##   ##########################   ##
##                                ##
##                                ##
##                                ##
##########                ##########
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
######     ##############     ######
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>>>>>>>>>>>>>>>^^^^<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^ ^<<<<<<<<<<<<<>>>>>>>>>>>>>^ ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level07(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 1

    a = LSpringy
    b = RSpringy

    walls = """
############   #############    ####
###                               ##
###   b                           ##
##    b                           ##
####  b                           ##
##  # b                           ##
##   #b                           ##
##    #                   ######  ##
##     #     b                    ##
##      #    b     #####          ##
##       #   b                    ##
##        #  b                    ##
##         # b                    ##
##          ###                   ##
##             #                  ##
##              #    b            ##
##               #   b            ##
##                #  b            ##
##                 # b            ##
##                  #b            ##
##                   #            ##
##                    #           ##
##                     #          ##
##                      #         ##
##                       #        ##
##                        #       ##
##                         #      ##
############   #############    ####
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>v                              v<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvv v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>vvvvv v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>>>>v v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>   v v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>   v v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>   v v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>> xxx v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>     v<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>      <<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>      <<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>      <<<<<<<<<<<<<<<<<<<<<<<<<<<
>>>                              ^<<
>vv                              ^<<
>vv                              ^<<
>vv                              ^<<
>vv                              ^<<
>vv                              ^<<
>vv                              ^<<
>vv                              ^<<
>vv                              ^<<
>vvvvvvvvvvvvvvvv                ^<<
>vvvvvvvvvvvvvvvv                ^<<
>vvvvvvvvvvvvvvvv                ^<<
>vvvvvvvvvvvvvvvv                ^<<
"""


class level08(boarddef.Level):
    letter    = 1
    fire      = 1
    lightning = 1
    water     = 0
    top       = 0

    a = b = c = d = e = LFlappy

    walls = """
##                                ##
##                                ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##     a    b    c    d    e      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##     e    d    c    b    a      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##     a    b    c    d    e      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##     e    d    c    b    a      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##     a    b    c    d    e      ##
####   ##   ##   ##   ##   ##   ####
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level09(level08):

    a = ()
    b = RGhosty
    c = RBlitzy
    d = ()
    e = LBlitzy


class level10(boarddef.Level):
    top = 1

    a = RSpringy
    b = LSpringy
    c = LSpringy
    d = RSpringy
    e = LSpringy

    walls = """
##   #    #    #    #    #    #   ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##     a    b    c    d    e      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##     e    d    c    b    a      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##     a    b    c    d    e      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##     e    d    c    b    a      ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##   #    #    #    #    #    #   ##
##                                ##
####   ##   ##   ##   ##   ##   ####
##                                ##
##   #    #    #    #    #    #   ##
##                                ##
####   ##   ##   ##   ##   ##   ####
""" #    []      []      []    # """

    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""



class level11(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 1
    water     = 0
    top       = 0

    a = LSpringy
    b = RFlappy
    c = RSpringy
    
    walls = """
####################################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##         b  b  b  b  b          ##
##                                ##
##        b  b  b  b  b  b        ##
##                                ##
##                                ##
##                                ##
##                                ##
####################################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##               a                ##
##               c                ##
##               a                ##
##               c                ##
##               a                ##
##               c                ##
##               a                ##
##               c                ##
####################################
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""



class level12(level11):
    letter    = 0
    fire      = 1
    lightning = 0
    water     = 0
    top       = 1

    a = LGhosty
    b = RFlappy
    c = RGhosty


class level13(boarddef.Level):
    letter    = 1
    fire      = 0
    lightning = 1
    water     = 0
    top       = 1

    a = LFlappy
    b = RFlappy

    walls = """
##########     ######     ##########
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##     a       ######       b     ##
##             ######             ##
##     b       ######       a     ##
##             ######             ##
##     a       ######       b     ##
##             ######             ##
##     b       ######       a     ##
##             ######             ##
##     a       ######       b     ##
##                                ##
##     b       ######       a     ##
##             ######             ##
##     a       ######       b     ##
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##             ######             ##
##########     ######     ##########
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>             xxxx             <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>                              <<<
>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>     <<<<<<<<<<<<<<<<
>>                                <<
"""    


class level14(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    a = RSpringy
    b = ()

    walls = """
####################################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
###a     #      #      #a     #   ##
## #    # #a   # #a   # #    # #  ##
##  #  #   #  #   #  #   #  #   # ##
##   ##     ##     ##     ##     ###
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
####################################
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level15(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 1
    top       = 0

    f = LFlappy
    b = RBlitzy
    a = LOrcy, RMonky
    g = RGramy
    h = LGhosty
    n = LNasty
    s = LSpringy

    walls = """
#############  ###### f f  #########
##   a         #b    f f f        ##
##   #           ###### #### #######
##   # a     a  #      #          ##
##    ####### ##        #   # g   ##
##           #           #    # # ##
##           #           #        ##
##           #           #        ##
##           #           #        ##
##           #           #        ##
##           # n  n # n #         ##
##            # #### ###          ##
##             #        #         ##
##   s         #        #         ##
##   s         #     h  #         ##
## # #    s    # h       #        ##
##   #    s    #        #         ##
##    # #### ##         #         ##
##     #    #  ##### ### ##       ##
##     #    #                     ##
##     # b  #                     ##
##      ####                      ##
##                                ##
##                                ##
##                   ######       ##
##                  #      #      ##
##                  #      #      ##
#############  ######  f   #########
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>>>>>>>>>>>>>>>>>vvvv<<<<<<<<<<<<<<
>>^               vvvv           x<<
>>^              >vvvv<          ^<<
>>^             > xxxx <         ^<<
>>^   >>>>vvv<<<                 ^<<
>>^       vv<           >>>>>>>>>^<<
>>^       xx              ^      ^<<
>>^                       ^      ^<<
>>^                       ^      ^<<
>>^                      >^      ^<<
>>^         ^<          >^       ^<<
>>^          ^<<<<<<<>>>>^       ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^ ^<                           ^<<
>>^  ^<      xx                  ^<<
>>^   ^      ^^<<<<<<<<<<<<      ^<<
>>^   ^      ^                   ^<<
>>^   ^<    >^                   ^<<
>>^    ^<<>>^                    ^<<
>>^                              ^<<
>>^                  ^^^^^^      ^<<
>>^                ^<>vvvv<>^    ^<<
>>^                ^<>vvvv<>^    ^<<
>>                 ^<>vvvv<>^     <<
"""


class level16(boarddef.Level):
    letter    = 1
    fire      = 1
    lightning = 1
    water     = 0
    top       = 1

    a = LGhosty, RGhosty

    walls = """
##                        #       ##
##                    ## ##       ##
##   a          a     ######      ##
##                   ######   #   ##
##                #########       ##
##             ############       ##
##        #    # ##########    a  ##
## a     ###       ########       ##
##       #### ###   #######       ##
##       #########  ###      a    ##
##       ######### ### #          ##
##        ##############          ##
##        ##############          ##
##        ####### ######          ##
##        ######  ######       a  ##
##        #####   #####           ##
##        ####     ####  a        ##
##        #####    ###            ##
##        ###########        a    ##
##     a  ###   ####              ##
##        ## ######               ##
##        ##  #####               ##
##        #### ##                 ##
##        #######                 ##
##         #####                  ##
##       # ####                   ##
##                                ##
####################################
""" #    []      []      []    # """

    winds = """
>>                                <<
>>>>>>>>vvvvvvvvvvvvvvvvvvvv<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level17(boarddef.Level):
    letter    = 1
    fire      = 1
    lightning = 0
    water     = 1
    top       = 0

    a = LGhosty, RFlappy

    walls = """
##   #####             #          ##
## ########            #          ##
## #######     a        #       # ##
## #######              #       # ##
## ######           a   ##      # ##
## #####                ##      # ##
## ######    #   a    ###   #   ####
## #####                  # #   ####
## ###########      ####### #  #####
## #### ##### #     ## ####  # #####
## ####  ######    ###  ###  # # ###
##  ##    #  ## #  ## ###### #  ####
##  ###         #  ###    ## #  ####
##  ###         ## ####    # ## ####
##  ###   a     ## ###     #  #  ###
##   ###        ## ###     ## #  ###
##   ###       ##  ### a   ## #  ###
##   ####       #   ##    ### #  ###
##   ####       #  ###    ### #   ##
##    ###         ###    #### #   ##
##    ####    a     ## # ####     ##
##     ###          #######      ###
###    ###   ############ ## #   ###
###     ##   ###########  ####    ##
###     ###  ###   ##########     ##
###      ### ################     ##
##       ##      #############    ##
###       #           #######     ##
"""


class level18(boarddef.Level):
    letter    = 1
    fire      = 0
    lightning = 0
    water     = 1
    top       = 0

    b = LBlitzy, RBlitzy
    a = LOrcy

    walls = """
#################  #################
##   #         ##  ##         #   ##
##   #         ##  ##         #   ##
##   # b   b  ##    ##  b   b #   ##
##  #  #######        #######  #  ##
##  #b #         a          #b #  ##
##   ##         ####         ##   ##
##           #      a #           ##
##            #      #            ##
##               a                ##
##              ####              ##
##           #a       #           ##
##            #      #            ##
##               a                ##
##              ####              ##
##           #      a #           ##
##            #      #            ##
##               a                ##
##              ####              ##
##           #a       #           ##
##            #      #            ##
##               a                ##
##              ####              ##
##           #      a #           ##
##            ##    ##            ##
##             ##  ##             ##
##             ##  ##             ##
#################  #################
""" #    []      []      []    # """

    winds = """
>>                                <<
>>>>>>>>>>>>>>>>>^^<<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^            > ^^ <            ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^            ^<<>>^            ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level19(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    a = LNasty
    b = LMonky
    c = LOrcy
    d = LGramy

    walls = """
####################################
####################################
####################################
####################################
####################################
####################################
####################################
####################################
##                                ##
##              #  #              ##
##              #  #              ##
##           #  #  #  #           ##
##           #  #  #  #           ##
##           #  #  #  #           ##
##        #  #  #  #  #  #        ##
##        #  #  #  #  #  #        ##
##        #  #  #  #  #  #        ##
##        #  #  #  #  #  #        ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #  #  #  #  #  #  #  #     ##
##     #a #b #c #d #c #b #a #     ##
####################################
""" #    []      []      []    # """
    
    winds = """
>>xxxxxxxxx>>>>xxxxxx<<<<xxxxxxxxx<<
>>^           >>> ^              ^<<
>>^              ^ <<<           ^<<
>>^                              ^<<
>>^     >>                <<     ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level20(boarddef.Level):
    letter    = 1
    fire      = 0
    lightning = 0
    water     = 0
    top       = 1

    a = RGhosty
    b = RNasty
    c = LSpringy
    d = LFlappy

    walls = """
##            ## # # #            ##
##            #      #            ##
##            #      #            ##
##            #      #            ##
##            #      #            ##
##           ### # # ##           ##
##           #        #           ##
##           #        #           ##
##           #        #           ##
##           #        #           ##
##          ## # # # ###          ##
##          #          #          ##
##          # a d d d  #          ##
##          # a        #          ##
##          # a     c  #          ##
##          #       c  #          ##
##          # b b b c  #          ##
##          ### # # # ##          ##
##           #        #           ##
##           #        #           ##
##           #        #           ##
##           #        #           ##
##           ## # # ###           ##
##            #      #            ##
##            #      #            ##
##            #      #            ##
##            #      #            ##
################ # # ###############
""" #    []      []      []    # """
    
    winds = """
>>v          v< v v v>v          v<<
>>v          v<v>vxvv>v          v<<
>>v          v<vvvvvv>v          v<<
>>v          v<vvvvvv>v          v<<
>>v          v<>v>v<v>v          v<<
>>v         v<< v x <>>v         v<<
>>v         v<vvvvvvvv>v         v<<
>>v         v<vvvvvvvv>v         v<<
>>v         v<vvvvvvvv>v         v<<
>>v         v<v<v<v<v<>v         v<<
>>v        v<<v x x v >>v        v<<
>>v        v<vvvvvvvvvv>v        v<<
>>v        v<vvvvvvvvvv>v        v<<
>>v        v<vvvvvvvvvv>v        v<<
>>v        v<vvvvvvvvvv>v        v<<
>>v        v<vvvvvvvvvv>v        v<<
>>v        v<>>v<v<v<<<>v        v<<
>>v        v<< v x x v>>v        v<<
>>v         v<v>>vvvvv>v         v<<
>>v         v<vvvvvvvv>v         v<<
>>v         v<vvvvvvvv>v         v<<
>>v         v<>v>v<v<<>v         v<<
>>v         v<<v x < >>v         v<<
>>v          v<vvvvvv>v          v<<
>>v          v<vvvvvv>v          v<<
>>v          v<vvvvvv>v          v<<
>>v          v<>v>v<v>v          v<<
>>           v< v v v>v           <<
"""


class level21(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    s = LSpringy, LSpringy
    f = LFlappy, LFlappy
    g = RGhosty, RGhosty

    walls = """
###########      ##       ##########
##       ##             s ##      ##
##        ##f   ##       ##       ##
##         ##  ##       ##        ##
##         ##  ##     s ##        ##
##          #          ##         ##
##           ##     s ##          ##
##          ##       ####         ##
##         ##       ##  ##        ##
##         ##     s ##  ##        ##
##        ##       ##    ##       ##
##       ##       ##      ##      ##
##       ##     s ##      ##      ##
##       ##      ##       ##      ##
##       ##      ##       ##      ##
##       ##s            g ##      ##
##        ##    ##       ##       ##
##         ##  ##       ##        ##
##         ##  ##     f ##        ##
##          #          ##         ##
##           ##     g ##          ##
##          ##       ####         ##
##         ##       ##  ##        ##
##         ##     f ##  ##        ##
##        ##       ##    ##       ##
##       ##       ##      ##      ##
##       ##     g ##      ##      ##
###########      ##       ##########
""" #    []      []      []    # """


class level22(level21):
    water = 1
    letter = 1

    s = RBlitzy, RBlitzy
    f = LOrcy, LOrcy
    g = LGramy, LGramy


class level23(boarddef.Level):
    letter    = 1
    fire      = 1
    lightning = 1
    water     = 1
    top       = 0

    a = LNasty
    b = RMonky
    c = LGramy
    d = ROrcy
    s = LSpringy

    walls = """
##                                ##
##  ### ####### ############## #  ##
##    #   # a   #   b    #   # #  ##
##  # ### # ### #  ##### # ### #  ##
##  #d  # # # # #  #  c  # #   #  ##
##  ### # # # ###  # ##### ### #  ##
##    # # # #    s # #  d    # #  ##
##  ### # # ### #### ####### ###  ##
##  #c  # #   # #  a       #   #  ##
##  ### # ### # ########## ### #  ##
##  # # # # # # #   b  #  c  # #  ##
##  # ### # ### #  ### ### ### #  ##
##  #     b   # #s   #   # #      ##
##  # ####### # ######## # #####  ##
##  # # a   # #    # a   #  d  #  ##
##  ### ##### ###  # ##### ### #  ##
##      #  d    #  # # b   # # #  ##
##  ### # #######  # ##### # ###  ##
##    # #   #   cs   #   # #   #  ##
##  ### ### ######## # ### ### #  ##
##  # #   #   b    #   # #c  # #  ##
##  # ### # #####  ##### # ### #  ##
##  # d # # #   #          #   #  ##
##  ### # # # # ########## ### #  ##
##  # #   # # #   a      #   # #  ##
##  # ####### ################ #  ##
##                                ##
####################################
"""


class level24(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    n = LOrcy
    a = RGhosty, LFlappy

    walls = """
####################################
##   ##   ## # # # #  # #   # ### ##
## ## # # # #  #   # # ## # #  #  ##
##   ## ### #   #a     # n  # # # ##
## ## # #  a #a      #   ## # ### ##
##   ##   #           a    #  ### ##
######  #        #     #a # ########
###### n #a #               # ######
##### # #                 #  #######
#######                    # n #####
#### #  #                    #######
##### #a                        ####
##### #  #                 # #######
##### #                       # ####
#### #                       # #####
###### # #                     #####
#### #                   #  ### ####
####### #                     ######
##### #   #                # # #####
##### ##   #                # ######
####### #     #     #   #  # #######
####### # #               # # ######
######## #  #  #     #  # # ########
######## ## #     #   #  # #########
########## # # # #  #  ## ##########
##    ###### # # #  # # ######    ##
##                                ##
####################################
"""

    winds = """
>>                                <<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^ >            xx          <   ^<<
>>^  >             xx       <    ^<<
>>^   >       xxx    x     <     ^<<
>>^    >   xxx       xxx  <      ^<<
>>^     > x             x<       ^<<
>>^      >x                      ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level25(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    b = RGhosty
    a = LGhosty

    walls = """
####################################
##                                ##
##                                ##
##    #######################     ##
##                          #     ##
##         a  a  a  a  a  a #     ##
##      ##################  #     ##
##       #              #   #     ##
##       # a a a a a a  #b  #     ##
##       #  ##########  #  ##     ##
##       #   #      #   #  #      ##
##       #b  #a a a #b  #  #      ##
##       ##  #  #####  ##  #      ##
##        #  #         #   #      ##
##        #  # b b b b #b  #      ##
##        #  ###########  ##      ##
##        #       #       #       ##
##        #b b b    b b b #       ##
##        ###### b   ######       ##
##             #######            ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
####################################
""" #    []      []      []    # """


class level26(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    n = LNasty
    m = RNasty
    a = LGramy
    g = LGhosty

    walls = """
##     #######        #######     ##
##      ###  ##########  ###      ##
## g     ##              ##    g  ##
##n m n m n  ########## m n m n m ##
###############      ###############
##        ################        ##
##         ####      ####         ##
##          ############          ##
## ######    ##      ##    ###### ##
##     ###    #########   ###     ##
##      ###   #      ##  ###      ##
##nmnmnm ### ########## ###mnmnmn ##
###############nmnmn ###############
#####     ################     #####
#############          #############
## ##     ##            ##     ## ##
##  #######              #######  ##
##  #     ################     #  ##
##  ###########      ###########  ##
##  #     # ############ #     #  ##
##  #######  ##      ##  #######  ##
##  # m n #   ########   # n m #  ##
##  #######   #      #   #######  ##
##            ########            ##
##            # m    #            ##
##            ########            ##
##                                ##
####################################
""" #    []      []      []    # """


class level27(boarddef.Level):
    letter    = 1
    fire      = 1
    lightning = 1
    water     = 0
    top       = 0

    n = LNasty
    m = RMonky

    walls = """
###########    ######    #        ##
##                  #    #        ##
##    #########     #    #   n    ##
##                  #    ###########
## #  nnn                         ##
## #########                      ##
##                                ##
##          nnn #                 ##
##        #######  ##    #        ##
##                  #    #        ##
##                  #    #        ##
##   #nnn      mmmm #    #      m ##
##   #####     ######    ###########
##                                ##
##                                ##
##      #######                   ##
##                ###    #        ##
##                  #    #        ##
##              nnn #    #      n ##
##             ######    ###########
##                                ##
##   #mmmmmm                      ##
##   ########                     ##
##                                ##
##      ########  ###    #        ##
##                  #    #        ##
##              nnn #    #        ##
###########    ######    ###########
""" #    []      []      []    # """


class level28(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 1
    top       = 1

    m = LMonky
    g = LGramy
    h = LGhosty
    f = LFlappy
    b = LSpringy
    a = RSpringy

    walls = """
##              #  #              ##
##            b #  #a             ##
##            b #  #a             ##
##          #####  #####          ##
##          #          #          ##
##           #        #           ##
##            #      #            ##
##             #    #             ##
##                                ##
##                                ##
##                                ##
##         #            #         ##
###### #####            # # # # # ##
##  m m m    #        #           ##
## ######### #        # h f  h  f ##
##   g  g  g #        #           ##
####### ######        # h     f   ##
## m m m       #    #    f        ##
## ########### #    # h   h     h ##
##    g  g  g  #    #      f   f  ##
######## #######    # # # # # # # ##
##                                ##
##                                ##
##                                ##
####### #####    ##    ##### #######
##    #          ##          #    ##
##    #                      #    ##
#################  #################
""" #    []      []      []    # """
    
    winds = """
>>v                              v<<
>>v                              v<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""

class level29(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 0

    m = LMonky, RMonky
    g = LGramy, RGramy
    o = LOrcy,  ROrcy
    n = LNasty, RNasty

    walls = """
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
#################  #################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##    # m  g  o  nn  o  g  m #    ##
##    ########################    ##
##                                ##
""" #    []      []      []    # """
    
    winds = """
vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>xxxxxxxxxxxxxxx  xxxxxxxxxxxxxxx<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>x>>>>v>>>>v<>v<<<<v<<<<x<<<<<<
vvvvvvxxxxxxxxxxxxxxxxxxxxxxxxvvvvvv
vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
"""

class level29(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 1

    a = LNasty
    b = RNasty
    g = RGhosty
    r = RGramy
    m = LMonky

    walls = """
##      ############################
##                                ##
#####                             ##
#####                             ##
#####                             ##
#####                             ##
#####                          #  ##
##### a b a  ba   ab  a  ba    #  ##
################################  ##
##                                ##
##                                ##
##     ##    g                    ##
##     ##                         ##
##     ##                         ##
##     ##                         ##
##     ##                         ##
##     ## br  a  rb a  rb a  r  a ##
##     #############################
##                          ##    ##
##      ##        ##        ##    ##
#####   ##     mm ##mm      ##    ##
##############################    ##
#####   ##        ##        ##    ##
#####   ##        ##              ##
#####                             ##
##                                ##
##                                ##
##  ################################
""" #    []      []      []    # """
    
    winds = """
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv ^<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv ^<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv ^<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv ^<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv ^<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv ^<<
>>vv>>>>>>>>>>>>>>>>>>>>>>>>>>>> v<<
>>vv                              <<
>>vv                              <<
>>vv     vvvvvvvvvvvvvvvvvvvvvv   <<
>>vv     vvvvvvvvvvvvvvvvvvvvvv   <<
>>vv     vvvvvvvvvvvvvvvvvvvvvv   <<
>>vv     vvvvvvvvvvvvvvvvvvvvvv   <<
>>vv     vvvvvvvvvvvvvvvvvvvvvv   <<
>>vv     vvvvvvvvvvvvvvvvvvvvvv   <<
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>                                <<
"""


class level30(boarddef.Level):
    letter    = 1
    fire      = 1
    lightning = 1
    water     = 0
    top       = 1

    a = RNasty

    walls = """
####################################
####################################
##     #####     ##     #####     ##
## a   ##### a   ## a   ##### a   ##
####################################
####################################
####################################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
######                        ######
##                                ##
##                                ##
##                                ##
##                                ##
####################################
""" #    []      []      []    # """
    
    winds = """
>>                                <<
>>                                <<
>>>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx<<<
>>>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx<<<
>>>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx<<<
>>>xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx<<<
>>>                              <<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>>vv<<<<<<<<<<<<<<<<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>                                <<
"""


class level31(level30):
    fire      = 0
    lightning = 0


class level32(boarddef.Level):
    n = LNasty
    m = LMonky
    o = LOrcy
    g = LGramy
    h = LGhosty
    f = LFlappy
    s = LSpringy
    b = LBlitzy

    walls = """
####################              ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                          ########
##                                ##
##                                ##
##                             #  ##
##                       #######  ##
##                                ##
##                                ##
##                         #      ##
##                   #######      ##
##                                ##
##                                ##
##                                ##
##                   #  #         ##
##                   #  #     #   ##
##                   #  #     # n ##
##                   #  #     ######
##                   #  #  #      ##
##                   #  #  #  n n ##
##                      #  #########
##                 #              ##
##                 #              ##
####################              ##
""" #    []      []      []    # """
    
    winds = """
>>>>>>>>>>>>>>>>xxxx<<vvvvvvvvvvvv>v
>>^                  ^<<vvvvvvvvvv>v
>>^                    ^<<vvvvvvvv>v
>>^                      ^<<vvvvvv>v
>>^                        ^<<vvvv>v
>>^                          ^<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                 vvvvvvvvvvvvvv>v
>>^                 vvvvvvvvvvvvvv>v
>>                  vvvvvvvvvvvvvv>v
"""


class level33(boarddef.Level):
    m = LMonky, RMonky
    g = LGramy, RGramy
    o = LOrcy,  ROrcy
    n = LNasty, RNasty

    walls = """
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
#################  #################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
##    ## m g  o  nn  o  g m ##    ##
##    ########################    ##
##                                ##
""" #    []      []      []    # """

    winds = """
v<vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv>v
v<vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv>v
v<vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv>v
v<vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv>v
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>                                <<
>>xxxxxxxxxxxxxxx  xxxxxxxxxxxxxxx<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>v>>>>v>>>>v<>v<<<<v<<<<v<<<<<<
>>>>>>x>>>>v>>>>v<>v<<<<v<<<<x<<<<<<
v<vvvvxxxxxxxxxxxxxxxxxxxxxxxxvvvv>v
v<vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv>v
"""


class level34(boarddef.Level):
    letter    = 0
    fire      = 0
    lightning = 0
    water     = 0
    top       = 1

    a = RBlitzy
    b = LBlitzy

    walls = """
##     # ##  #   ##   #  ## #     ##
##       ##  #   ba   #  ##       ##
##     ###  b####  ####   ###     ##
##     #  #     #  #   b #  #     ##
##     ####     #  #     ####     ##
##     #######b #  #  #######     ##
##           #  #  #b #           ##
##           #  #  #  #           ##
##           #  #  #  #           ##
##           #b #  #  #           ##
##           #  #  #b #           ##
##              #  #              ##
##           #  #  #  #           ##
##           #b #  #  #           ##
##           #  #  #b #           ##
##           #  #  #  #           ##
##           #  #  #  #           ##
##           #b #  #  #           ##
##           #  #  #b #           ##
##           #  #  #  #           ##
##           #  #  #  #           ##
##           #b #  #  #           ##
##           #  #  #b #           ##
##     #######  #  #  #######     ##
##     ####     #  #     ####     ##
##     ####  ####  ####  ####     ##
##     ####           b  ####     ##
##     ## #              # ##     ##
""" #    []      []      []    # """
    
    winds = """
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>xxxxxvvvvvvvvvvvvvvvvvvvvvvxxxxx<<
"""


class level35(boarddef.Level):
    s = LNasty
    o = LNasty, LNasty, RNasty, RNasty
    a = RBlitzy
    b = LBlitzy

    walls = """
####################################
##            ###s ###            ##
##s ##      b ######## a      ##s ##
####################################
##                                ##
##                                ##
##                                ##
##               ##               ##
##              ####              ##
##            ########            ##
##          ############          ##
##             ######             ##
##           ##########           ##
##        ################        ##
##           ##########           ##
##         ##############         ##
##       ##################       ##
##               ##               ##
##               ##               ##
##              ####              ##
##             ######             ##
##            ## ## ##            ##
##           ##  ##  ##           ##
##                                ##
##                                ##
##                                ##
##   #o o o o o o o o o o o o #   ##
####################################
""" #    []      []      []    # """
    
    winds = """
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>>>>>>>>>>>>>>>    <<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>      <<<<<<<<<<<<<<<
>>>>>>>>>>>>>>        <<<<<<<<<<<<<<
>>>>>>>>>>>>>          <<<<<<<<<<<<<
>>>>>>>>>>>>            <<<<<<<<<<<<
>>>>>>>>>>>              <<<<<<<<<<<
>>>>>>>>>>                <<<<<<<<<<
>>>>>>>>>                  <<<<<<<<<
>>>>>>>>                    <<<<<<<<
>>>>>>>                      <<<<<<<
>>>>>>                        <<<<<<
>>>>>                          <<<<<
>>>>                            <<<<
>>>                              <<<
>>vv<<<<<<<<<<<<<<>>>>>>>>>>>>>>vv<<
>>vv<<<<<<<<<<<<<<>>>>>>>>>>>>>>vv<<
>>vv<<<<<<<<<<<<<<>>>>>>>>>>>>>>vv<<
>>vv<<<<<<<<<<<<<<>>>>>>>>>>>>>>vv<<
>>vv<<<<<<<<<<<<<<>>>>>>>>>>>>>>vv<<
>>vv<<<<<<<<<<<<<<>>>>>>>>>>>>>>vv<<
>>vv<<<<<<^^^^^^^^^^^^^^^^>>>>>>vv<<
>>vv<<<<^^^^^^^^^^^^^^^^^^^^>>>>vv<<
>>xx<<^^^^^^^^^^^^^^^^^^^^^^^^>>xx<<
>>xx<<<<<<<<<<<<<<>>>>>>>>>>>>>>xx<<
"""


class level36(boarddef.Level):
    s = LSpringy
    b = LBlitzy

    walls = """
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
##       b               b        ##
##               s                ##
""" #    []      []      []    # """
    
    winds = """
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>>>>>>>>>>>>>>>xxxx<<<<<<<<<<<<<<<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>^                              ^<<
>>                                <<
"""


class level37(boarddef.Level):
    n = LNasty
    m = LMonky

    walls = """
#################  #################
##   m m m m m # ## #m m m m m    ##
##  #n n n n n #    #n n n n n #  ##
#################  #################
##        #######  #######        ##
##        ################        ##
##  ############################  ##
##   #    ####        ####    #   ##
##  ####  #####      #####  ####  ##
##  ####  ################  ####  ##
##  ####  ################  ####  ##
##  #########          #########  ##
##  ###    ##############    ###  ##
##  ####  # ############ #  ####  ##
##     #### ############ ####     ##
############    ####    ############
############     ##     ############
##  #        ##      ##        #  ##
##  ############    ############  ##
##  #       #####  #####       #  ##
##  ############################  ##
##  ############################  ##
##  ########            ########  ##
######## ##              ## ########
######## #      ####      # ########
##      #       ####       #      ##
##    ##      ###  ###      ##    ##
######    ################    ######
""" #    []      []      []    # """

    winds = """
>>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<<
>>xx<<<<<<<<<<<<<<>>>>>>>>>>>>>>xx<<
>>xx^^^^^^^^^^^^^^^^^^^^^^^^^^^^xx<<
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vv>>>>vvvvvvvvvvvvvvvvvvvv<<<<vv>v
v<vvvv<>vvvvvvvvvvvvvvvvvvvv<>vvvv>v
v<vvvv>>vvvvvvvvvvvvvvvvvvvv<<vvvv>v
v<vv>vvvvvvvvvvvvvvvvvvvvvvvvvv>vv>v
v<vv>vvvvvvvvvvvvvvvvvvvvvvvvvv>vv>v
v>vv<vvvvvvvvvvvvvvvvvvvvvvvvvv>vv<v
v>vv<vvvvvvvvvvvvvvvvvvvvvvvvvv>vv<v
v>vv<vvvvvvvvvvvvvvvvvvvvvvvvvv>vv<v
v>vv<vvvvvvvvvvvvvvvvvvvvvvvvvv>vv<v
v>vv<vvvvvvvvvvvvvvvvvvvvvvvvvv>vv<v
v>vv<vvvvvvvvvvvvvvvvvvvvvvvvvv>vv<v
v>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<v
v>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<v
v>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<v
v>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<v
v>vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv<v
"""

class level38(boarddef.Level):
    g = RGhosty

    walls = """
####################################
##          #                     ##
## g        #              g      ##
##          #                     ##
##          #    g                ##
##          #                     ##
##         ###       ##### ##     ##
##          ###     ######## ##   ##
##         ####    ###  ######    ##
##       ### ###  #######  ###    ##
##            ##  ##########      ##
##             #  ########        ##
##             #             g    ##
##    g       ##########          ##
##           ###########          ##
##          ########## ##         ##
##         ############ ##        ##
##     ### ############  ##       ##
##     #### ##########   ###      ##
##     ##### ########     ##      ##
##      #### ######               ##
##                #####           ##
##              ########          ##
##                                ##
##                                ##
##                                ##
##                                ##
####################################
"""


class levelFinal(boarddef.Level):

    walls = """
################    ################
##                                ##
##                                ##
##            ###  ###            ##
##                                ##
##         ###        ###         ##
##                                ##
##      ###              ###      ##
##                                ##
##   ###                    ###   ##
##                                ##
#####                          #####
##                                ##
##   ###                    ###   ##
##                                ##
##      ###              ###      ##
##                                ##
##         ###        ###         ##
##                                ##
##            ###  ###            ##
##                                ##
####################################
##                                ##
##                                ##
##                                ##
##                                ##
##                                ##
################    ################
""" #    []      []      []    # """
# nb.: the previous line has no purpose
# other than helping with wall alignment
    
    winds = """
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>>>>>>>>>>>>>>>^^^^<<<<<<<<<<<<<<<<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
>>              ^^^^              <<
"""
