//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Fabrizio Di Marco and Marco Di Antonio (acetoneiso@gmail.com)
//Copyright 2010/2011 Marco Di Antonio

//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
#ifndef MYQTAPP_H 
#define MYQTAPP_H
#include <QProcess>
#include "../build/ui_acetoneiso.h"
#include <QProgressBar>
#include <QListWidget>
#include <QTabWidget>
#include <QDebug>
#include <QtWebKit>
#include <QWebView>
#include <QProcess>
#include <QThread>
#include"progress.h"
#include"QFileSystemModel"
#include"QFileSystemWatcher"
#include <QSystemTrayIcon>

class acetoneiso : public QMainWindow, private Ui::acetoneiso
{
    Q_OBJECT
 
public:
    acetoneiso();
    QString folder_mounted;
    progressDiag prog;
    float burn_dim;
    QString fileDaMontare;
    QFile pathToListWidgetFile;

    QString deviceID() const;
    QByteArray leggiRigo( int numeroRigo, QFile *filee );
    void dimToBurnProg( float n );
    
    //tray
    void setVisible(bool visible);
    QSystemTrayIcon *trayIcon;
    QAction *OptionsAction;
    QAction *AboutAction;
    QAction *MountAction;
    QAction *minimizeAction;
    QAction *restoreAction;
    QAction *quitAction;
    QMenu *trayIconMenu;
    bool tray_has_loaded;
    QString immagine_con_percorso;
    QByteArray process_output;
    QString ripdvd_audiotype;
    
    //torrent
    int indexTorrentIs; //globally know current item torrent selected
    QString global_torrent_file; //global current torrent file full path
    QString  RealTorrentName; // global current torrent real name
    QByteArray aria2RealNameOutput;
    QByteArray aria2RealNameOutput_temp;
    QByteArray aria2_output;
    QByteArray aria2_output_real;
    QList<QProcess*> process_list;
    QList<QTreeWidgetItem*> item_list;
    QHash<QProcess*,QString>  processId_torrentName;
    
    

    
protected:
    void closeEvent(QCloseEvent *event);
 
    
private slots:
    void connections(); 
    void load_trayicon();
    void mount();
    void umount();
    void extract();
    void converter();
    void foldertoiso();
    void psxrip();
    void compress();
    void decrypt();
    void encrypt();
    void isocd();
    void md5check();
    void md5generate();
    void merge();
    void split();
    void uncompress();
    void play();
    void unplay();
    void gencue();
    //void database();
    void a_donate();
    void macimg();
    void udf();
    void rip();
    void vidgeneric();
    void flvavi();
    void gmount();
    void gumount();
    void isopcgame();
    void backupaudio();
    void mdatabase(QListWidgetItem *item);
    void getboot();
    void printOut(int, QProcess::ExitStatus);
    void progBarra();
    void closeProg();
    void status_mounted_no_boot();
    void printOutcompress(int, QProcess::ExitStatus);
    void printOutuncompress(int, QProcess::ExitStatus);
    void printOutpsx(int, QProcess::ExitStatus);
    void printOutsplit(int, QProcess::ExitStatus);
    void printOutisofromcd(int, QProcess::ExitStatus);
    void printOutMACIMG(int, QProcess::ExitStatus);
    void printOutbackaudio(int, QProcess::ExitStatus);
    void printOutfuseiso(int, QProcess::ExitStatus);
    void printOutgpg(int, QProcess::ExitStatus);
    void printOutcue(int, QProcess::ExitStatus);
    void printOutrip(int, QProcess::ExitStatus);
    void printOutrip2(int, QProcess::ExitStatus);
    void open_mounted(QListWidgetItem *item);
    void status_mounted();
    void get_poweriso();
    void extract_poweriso();
    void messaggio_poweriso();
    void message_extract_finish();
    void initial_get_database();
    void remove_fromDatabase();
    void mergeMSG(int, QProcess::ExitStatus);
    void Monta( QString &image, QString &destination );
    void openBrowser( QString &destination, QString onlyfile, float divide, QString &temporary, QString image_with_path );
    void on_options_nda_activated();
    void createOption();
    void on_actionAbout_activated();
    void on_actionManual_activated();
    void printOutvidgen(int, QProcess::ExitStatus);
    void printOutflv(int, QProcess::ExitStatus);
    void printOututube(int, QProcess::ExitStatus);
    void printOutumount(int, QProcess::ExitStatus);
    //void printOutburniso(int, QProcess::ExitStatus);
    void printOutucheck(int, QProcess::ExitStatus);
    void printOutaudiotools(int, QProcess::ExitStatus);
    void utube();
    void utubeuser();
    void metacafe();
    //void pornotube();
    //void formatcd();
    //void formatdvd();
    void umountcheck();
    //void treeView_change(  );
    //void setTreeView();
    //void setRootIndex(const QModelIndex& index);
    //void initFileSystemWatcher();
    void cmlMount();
    void wma2wav();
    void wavmp3( QString str1, QString str2 );
    void ripcdaudio();
    void printOutripaudio(int, QProcess::ExitStatus);
    void rar();
    void extractaudio();
    void wav2mp3();
    void printOutextractaudiofromvideo(int, QProcess::ExitStatus);
    void search();
    void setDockPos();
    void setDockInit();
    void userListMenuRequested(const QPoint & pos);
    void menuMount();
    void contextExtract();
    void convertpsp();
    void load_history();
    void clear_history();
    void remove_non_images_history(int);
    void iconActivated(QSystemTrayIcon::ActivationReason reason);
    void database_label();
    void call_database_options();
    void history_autoclean();
    void history_remove_nonexistant_images();
    void historydoubleclickmount(QListWidgetItem *);
    void historycontextmenu(const QPoint & posh);
    void mountdisplaycontextmenu(const QPoint & posm);
    void historycontextmenuMount();
    void global_functions_mount(QString immagine_con_percorso);
    void historycontextmenuDelete();
    void search_history();
    void openfilemanager_contextmenu();
    void openFileManager(QString immagine_con_percorso);
    void unmount_contextmenu();
    void showProgressDisplay();
    void updateProgressDisplay_vidgen();
    void hide_process_display();
    void updateProgressDisplay_flv();
    void updateProgressDisplay_extractaudiofromvideo();
    void updateProgressDisplay_UTube();
    void restore_all_button_processes();
    void disable_all_button_processes();
    void paypal();
    void updateProgressDisplay_MKisofs();
    void updateProgressDisplay_POweriso();
    void updateProgressDisplay_MAcimg();
    void updateProgressDisplay_BAckaudio();
    void updateProgressDisplay_PSxrip();
    void updateProgressDisplay_RIp();
    void updateProgressDisplay_RIp2();
    void updateProgressDisplay_RAR();
    void printOutRAR(int, QProcess::ExitStatus);
    void erase_media();
    void sha1();
    void sha256();
    void sha384();
    void create_virtual_drives();
    void remove_virtual_drives();
    void quitto();
    void mountdisplayClicked();
    void burniso2_cd();
    int utubedownload();
    void removeHistory();
    
    //torrent
    void mainTabChanged(int);
    void itemTorrentChanged();
    void readTorrentList();
    void openTorrent();
    void openUrlTorrent() ;
    void handleTorrentName(QString);
    void AriaName();
    void ariaGotName(int, QProcess::ExitStatus);
    void saveTorrentListCFG();
    void AriaDisplay() ;
    void runTorrent(QString, QString);
    void closeAllTorrents();
   
    
private:
    QProcess *MKisofs;
    QProcess FUse;
    QProcess BRowser;
    QProgressBar *progressBar;
    QProcess PZip;
    QProcess DD;
    QProcess FUsermount;
    QProcess *PSxrip;
    QProcess PZipuncompress;
    QProcess UMountcdrom;
    QProcess SPlit;
    QProcess WGet;
    QProcess TAr;
    QProcess *POweriso;
    QProcess CUe;
    QProcess KAffeine;
    QProcess VLc;
    QProcess SMplayer;
    QProcess WGet1;
    QProcess WGet2;
    QProcess CAt;
    QProcess *BAckaudio;
    QProcess MOunt;
    QProcess UMount;
    QProcess MD5;
    QProcess MD5Check;
    QProcess *MAcimg;
    QProcess ELtorito;
    QProcess GPg;
    QProcess TOc;
    QProcess *RIp;
    QProcess *RIp2;
    QProcess *VIdgen;
    QProcess *FLv;
    QProcess *UTube;
    QProcess AUdio;
    QProcess AUdiowav;
    QProcess Uudf;
    QProcess BIso;
    QProcess UCheck;
    QProcess HalCap;
    QProcess HalProp;
    QProcess HalPropV;
    QProcess HalPropM;
    QProcess RIpaudio;
    QProcess findmedia;
    QProcess mediaType;
    QProcess isMediaEmpty;
    QProcess isAppendable;
    QProcess capacity;
    QProcess *extractaudiofromvideo;
    QProcess GEnisoimage;
    QProcess *RAR;
    QProcess SHA;

    
    //torrent
    QProcess *aria2cTorrentName;
    QProcess *aria2c;
    QTreeWidgetItem *item_file; 
    QIcon *icon_downloading; 
    QIcon *icon_completed;
    
};

#endif 

