// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.components.crash.anr;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.junit.runner.RunWith;

import org.chromium.base.test.BaseRobolectricTestRunner;
import org.chromium.components.crash.anr.AnrDataOuterClass.AnrData;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

/** Unit tests for AnrCollector. */
@RunWith(BaseRobolectricTestRunner.class)
public final class AnrCollectorTest {
    // There are a number of lines well over 100 characters, with tab characters present as well.
    // This is a line-for-line copy of exactly what we get from the API. So, to maintain
    // readability, we avoid line wrapping and preserve tab characters.
    static final String TEXT_FROM_GET_TRACE_INPUT_STREAM =
            "----- pid 10849 at 2021-09-28 15:41:53 -----\n"
            + "Cmd line: com.google.android.apps.chrome\n"
            + "Build fingerprint: 'google/sdk_gphone_x86/generic_x86_arm:11/RSR1.201013.001/6903271:user/release-keys'\n"
            + "ABI: 'x86'\n"
            + "Build type: optimized\n"
            + "Zygote loaded classes=15746 post zygote classes=1796\n"
            + "Dumping registered class loaders\n"
            + "#0 dalvik.system.PathClassLoader: [], parent #1\n"
            + "#1 java.lang.BootClassLoader: [], no parent\n"
            + "#2 dalvik.system.PathClassLoader: [/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/base.apk], parent #1\n"
            + "#3 dalvik.system.PathClassLoader: [/data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk], parent #1\n"
            + "#4 dalvik.system.PathClassLoader: [/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/split_chrome.apk], parent #2\n"
            + "#5 dalvik.system.DelegateLastClassLoader: [/data/user_de/0/com.google.android.gms/app_chimera/m/0000001a/DynamiteLoader.apk], parent #0\n"
            + "#6 dalvik.system.DelegateLastClassLoader: [/data/user_de/0/com.google.android.gms/app_chimera/m/0000001d/GoogleCertificates.apk], parent #4\n"
            + "Done dumping class loaders\n"
            + "Classes initialized: 1391 in 79.445ms\n"
            + "Intern table: 31916 strong; 520 weak\n"
            + "JNI: CheckJNI is on; globals=798 (plus 43 weak)\n"
            + "Libraries: /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!/lib/x86/libmonochrome.so /data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/base.apk!/lib/x86/libchromium_android_linker.so libandroid.so libaudioeffect_jni.so libcompiler_rt.so libicu_jni.so libjavacore.so libjavacrypto.so libjnigraphics.so libmedia_jni.so libopenjdk.so librs_jni.so libsfplugin_ccodec.so libsoundpool.so libstats_jni.so libwebviewchromium_loader.so (16)\n"
            + "Heap: 87% free, 3559KB/26MB; 81403 objects\n"
            + "Dumping cumulative Gc timings\n"
            + "Average major GC reclaim bytes ratio inf over 0 GC cycles\n"
            + "Average major GC copied live bytes ratio 0.723527 over 4 major GCs\n"
            + "Cumulative bytes moved 11416448\n"
            + "Cumulative objects moved 215864\n"
            + "Peak regions allocated 35 (8960KB) / 768 (192MB)\n"
            + "Start Dumping histograms for 1 iterations for young concurrent copying\n"
            + "ProcessMarkStack:	Sum: 9.613ms 99% C.I. 9.613ms-9.613ms Avg: 9.613ms Max: 9.613ms\n"
            + "ScanImmuneSpaces:	Sum: 4.390ms 99% C.I. 4.390ms-4.390ms Avg: 4.390ms Max: 4.390ms\n"
            + "VisitConcurrentRoots:	Sum: 2.118ms 99% C.I. 2.118ms-2.118ms Avg: 2.118ms Max: 2.118ms\n"
            + "SweepSystemWeaks:	Sum: 1.486ms 99% C.I. 1.486ms-1.486ms Avg: 1.486ms Max: 1.486ms\n"
            + "ClearFromSpace:	Sum: 1.095ms 99% C.I. 1.095ms-1.095ms Avg: 1.095ms Max: 1.095ms\n"
            + "GrayAllDirtyImmuneObjects:	Sum: 866us 99% C.I. 866us-866us Avg: 866us Max: 866us\n"
            + "InitializePhase:	Sum: 861us 99% C.I. 861us-861us Avg: 861us Max: 861us\n"
            + "FlipOtherThreads:	Sum: 414us 99% C.I. 414us-414us Avg: 414us Max: 414us\n"
            + "ScanCardsForSpace:	Sum: 249us 99% C.I. 249us-249us Avg: 249us Max: 249us\n"
            + "VisitNonThreadRoots:	Sum: 221us 99% C.I. 221us-221us Avg: 221us Max: 221us\n"
            + "EnqueueFinalizerReferences:	Sum: 207us 99% C.I. 207us-207us Avg: 207us Max: 207us\n"
            + "SweepArray:	Sum: 204us 99% C.I. 204us-204us Avg: 204us Max: 204us\n"
            + "ProcessReferences:	Sum: 117us 99% C.I. 1us-116us Avg: 58.500us Max: 116us\n"
            + "RecordFree:	Sum: 51us 99% C.I. 5us-46us Avg: 25.500us Max: 46us\n"
            + "CopyingPhase:	Sum: 48us 99% C.I. 48us-48us Avg: 48us Max: 48us\n"
            + "FreeList:	Sum: 45us 99% C.I. 45us-45us Avg: 45us Max: 45us\n"
            + "(Paused)ClearCards:	Sum: 39us 99% C.I. 0.250us-16us Avg: 3us Max: 16us\n"
            + "MarkZygoteLargeObjects:	Sum: 36us 99% C.I. 36us-36us Avg: 36us Max: 36us\n"
            + "ThreadListFlip:	Sum: 28us 99% C.I. 28us-28us Avg: 28us Max: 28us\n"
            + "(Paused)GrayAllNewlyDirtyImmuneObjects:	Sum: 26us 99% C.I. 26us-26us Avg: 26us Max: 26us\n"
            + "ResetStack:	Sum: 21us 99% C.I. 21us-21us Avg: 21us Max: 21us\n"
            + "ReclaimPhase:	Sum: 10us 99% C.I. 10us-10us Avg: 10us Max: 10us\n"
            + "(Paused)SetFromSpace:	Sum: 8us 99% C.I. 8us-8us Avg: 8us Max: 8us\n"
            + "(Paused)FlipCallback:	Sum: 6us 99% C.I. 6us-6us Avg: 6us Max: 6us\n"
            + "UnBindBitmaps:	Sum: 2us 99% C.I. 2us-2us Avg: 2us Max: 2us\n"
            + "FlipThreadRoots:	Sum: 1us 99% C.I. 1us-1us Avg: 1us Max: 1us\n"
            + "Done Dumping histograms\n"
            + "young concurrent copying paused:	Sum: 105us 99% C.I. 105us-105us Avg: 105us Max: 105us\n"
            + "young concurrent copying freed-bytes: Avg: 3768KB Max: 3768KB Min: 3768KB\n"
            + "Freed-bytes histogram: 3520:1\n"
            + "young concurrent copying total time: 22.235ms mean time: 22.235ms\n"
            + "young concurrent copying freed: 52955 objects with total size 3768KB\n"
            + "young concurrent copying throughput: 2.40705e+06/s / 167MB/s  per cpu-time: 175419636/s / 167MB/s\n"
            + "Average minor GC reclaim bytes ratio 0.905098 over 1 GC cycles\n"
            + "Average minor GC copied live bytes ratio 0.218373 over 2 minor GCs\n"
            + "Cumulative bytes moved 1933528\n"
            + "Cumulative objects moved 34234\n"
            + "Peak regions allocated 35 (8960KB) / 768 (192MB)\n"
            + "Total time spent in GC: 22.235ms\n"
            + "Mean GC size throughput: 165MB/s per cpu-time: 163MB/s\n"
            + "Mean GC object throughput: 2.38161e+06 objects/s\n"
            + "Total number of allocations 134358\n"
            + "Total bytes allocated 7328KB\n"
            + "Total bytes freed 3768KB\n"
            + "Free memory 23MB\n"
            + "Free memory until GC 23MB\n"
            + "Free memory until OOME 188MB\n"
            + "Total memory 26MB\n"
            + "Max memory 192MB\n"
            + "Zygote space size 3016KB\n"
            + "Total mutator paused time: 105us\n"
            + "Total time waiting for GC to complete: 2.938us\n"
            + "Total GC count: 1\n"
            + "Total GC time: 22.235ms\n"
            + "Total blocking GC count: 0\n"
            + "Total blocking GC time: 0\n"
            + "Native bytes total: 18233624 registered: 279864\n"
            + "Total native bytes at last GC: 18144188\n"
            + "/system/framework/oat/x86/android.test.base.odex: quicken\n"
            + "/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/oat/x86/split_chrome.odex: speed-profile\n"
            + "/system/framework/oat/x86/android.hidl.manager-V1.0-java.odex: quicken\n"
            + "/system/framework/oat/x86/android.hidl.base-V1.0-java.odex: quicken\n"
            + "/data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/oat/x86/base.odex: speed-profile\n"
            + "/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/oat/x86/split_extra_icu.odex: speed-profile\n"
            + "/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/oat/x86/base.odex: speed-profile\n"
            + "Current JIT code cache size (used / resident): 82KB / 88KB\n"
            + "Current JIT data cache size (used / resident): 51KB / 64KB\n"
            + "Zygote JIT code cache size (at point of fork): 40KB / 44KB\n"
            + "Zygote JIT data cache size (at point of fork): 30KB / 32KB\n"
            + "Current JIT mini-debug-info size: 29KB\n"
            + "Current JIT capacity: 256KB\n"
            + "Current number of JIT JNI stub entries: 0\n"
            + "Current number of JIT code cache entries: 90\n"
            + "Total number of JIT compilations: 55\n"
            + "Total number of JIT compilations for on stack replacement: 0\n"
            + "Total number of JIT code cache collections: 2\n"
            + "Memory used for stack maps: Avg: 356B Max: 2396B Min: 20B\n"
            + "Memory used for compiled code: Avg: 1551B Max: 10KB Min: 82B\n"
            + "Memory used for profiling info: Avg: 296B Max: 3116B Min: 20B\n"
            + "Start Dumping histograms for 95 iterations for JIT timings\n"
            + "Compiling:	Sum: 585.229ms 99% C.I. 0.197ms-231.487ms Avg: 6.292ms Max: 411.532ms\n"
            + "TrimMaps:	Sum: 7.909ms 99% C.I. 19us-810.499us Avg: 85.043us Max: 908us\n"
            + "Code cache collection:	Sum: 5.340ms 99% C.I. 0.572ms-4.758ms Avg: 2.670ms Max: 4.768ms\n"
            + "Done Dumping histograms\n"
            + "Memory used for compilation: Avg: 112KB Max: 1087KB Min: 9680B\n"
            + "ProfileSaver total_bytes_written=0\n"
            + "ProfileSaver total_number_of_writes=0\n"
            + "ProfileSaver total_number_of_code_cache_queries=0\n"
            + "ProfileSaver total_number_of_skipped_writes=0\n"
            + "ProfileSaver total_number_of_failed_writes=0\n"
            + "ProfileSaver total_ms_of_sleep=5000\n"
            + "ProfileSaver total_ms_of_work=0\n"
            + "ProfileSaver total_number_of_hot_spikes=0\n"
            + "ProfileSaver total_number_of_wake_ups=0\n"
            + "Number of JIT inline cache deoptimizations: 3\n"
            + "\n"
            + "suspend all histogram:	Sum: 90us 99% C.I. 1us-46us Avg: 10us Max: 46us\n"
            + "DALVIK THREADS (25):\n"
            + "\"Signal Catcher\" daemon prio=10 tid=6 Runnable\n"
            + "  | group=\"system\" sCount=0 dsCount=0 flags=0 obj=0x134c01b0 self=0xe2d44610\n"
            + "  | sysTid=10865 nice=-20 cgrp=top-app sched=0/0 handle=0xd7f9d1e0\n"
            + "  | state=R schedstat=( 13249338 1928149 5 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xd7ea2000-0xd7ea4000 stackSize=1008KB\n"
            + "  | held mutexes= \"mutator lock\"(shared held)\n"
            + "  native: #00 pc 00542d9e  /apex/com.android.art/lib/libart.so (art::DumpNativeStack(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, int, BacktraceMap*, char const*, art::ArtMethod*, void*, bool)+110)\n"
            + "  native: #01 pc 006a0897  /apex/com.android.art/lib/libart.so (art::Thread::DumpStack(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, bool, BacktraceMap*, bool) const+1015)\n"
            + "  native: #02 pc 0069a171  /apex/com.android.art/lib/libart.so (art::Thread::Dump(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, bool, BacktraceMap*, bool) const+65)\n"
            + "  native: #03 pc 006c61b4  /apex/com.android.art/lib/libart.so (art::DumpCheckpoint::Run(art::Thread*)+1172)\n"
            + "  native: #04 pc 006bf266  /apex/com.android.art/lib/libart.so (art::ThreadList::RunCheckpoint(art::Closure*, art::Closure*)+630)\n"
            + "  native: #05 pc 006be1ce  /apex/com.android.art/lib/libart.so (art::ThreadList::Dump(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, bool)+2446)\n"
            + "  native: #06 pc 006bd70c  /apex/com.android.art/lib/libart.so (art::ThreadList::DumpForSigQuit(std::__1::basic_ostream<char, std::__1::char_traits<char> >&)+1644)\n"
            + "  native: #07 pc 0064d654  /apex/com.android.art/lib/libart.so (art::Runtime::DumpForSigQuit(std::__1::basic_ostream<char, std::__1::char_traits<char> >&)+212)\n"
            + "  native: #08 pc 00665b6a  /apex/com.android.art/lib/libart.so (art::SignalCatcher::HandleSigQuit()+1818)\n"
            + "  native: #09 pc 0066496b  /apex/com.android.art/lib/libart.so (art::SignalCatcher::Run(void*)+587)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"main\" prio=5 tid=1 Sleeping\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x712b6c28 self=0xe2d41c10\n"
            + "  | sysTid=10849 nice=-10 cgrp=top-app sched=0/0 handle=0xf114a478\n"
            + "  | state=S schedstat=( 478587788 174448370 929 ) utm=34 stm=13 core=0 HZ=100\n"
            + "  | stack=0xff4d8000-0xff4da000 stackSize=8192KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Thread.sleep(Native method)\n"
            + "  - sleeping on <0x0add3331> (a java.lang.Object)\n"
            + "  at java.lang.Thread.sleep(Thread.java:442)\n"
            + "  - locked <0x0add3331> (a java.lang.Object)\n"
            + "  at java.lang.Thread.sleep(Thread.java:358)\n"
            + "  at android.os.SystemClock.sleep(SystemClock.java:131)\n"
            + "  at org.chromium.chrome.browser.settings.SettingsActivity.onOptionsItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at android.app.Activity.onMenuItemSelected(Activity.java:4269)\n"
            + "  at C11.onMenuItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at Vd.onMenuItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at oe.onMenuItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at hV3.onClick(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at android.view.View.performClick(View.java:7448)\n"
            + "  at android.view.View.performClickInternal(View.java:7425)\n"
            + "  at android.view.View.access$3600(View.java:810)\n"
            + "  at android.view.View$PerformClick.run(View.java:28305)\n"
            + "  at android.os.Handler.handleCallback(Handler.java:938)\n"
            + "  at android.os.Handler.dispatchMessage(Handler.java:99)\n"
            + "  at android.os.Looper.loop(Looper.java:223)\n"
            + "  at android.app.ActivityThread.main(ActivityThread.java:7656)\n"
            + "  at java.lang.reflect.Method.invoke(Native method)\n"
            + "  at com.android.internal.os.RuntimeInit$MethodAndArgsCaller.run(RuntimeInit.java:592)\n"
            + "  at com.android.internal.os.ZygoteInit.main(ZygoteInit.java:947)\n"
            + "\n"
            + "\"ReferenceQueueDaemon\" daemon prio=5 tid=7 Waiting\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c0228 self=0xe2d47e10\n"
            + "  | sysTid=10872 nice=4 cgrp=top-app sched=0/0 handle=0xc2f251e0\n"
            + "  | state=S schedstat=( 1373918 4806489 4 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xc2e22000-0xc2e24000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x0eadea16> (a java.lang.Class<java.lang.ref.ReferenceQueue>)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.Object.wait(Object.java:568)\n"
            + "  at java.lang.Daemons$ReferenceQueueDaemon.runInternal(Daemons.java:217)\n"
            + "  - locked <0x0eadea16> (a java.lang.Class<java.lang.ref.ReferenceQueue>)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"FinalizerWatchdogDaemon\" daemon prio=5 tid=8 Waiting\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c02a0 self=0xe2d4a810\n"
            + "  | sysTid=10874 nice=4 cgrp=top-app sched=0/0 handle=0xc2d131e0\n"
            + "  | state=S schedstat=( 311400 4725185 4 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xc2c10000-0xc2c12000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x00638f97> (a java.lang.Daemons$FinalizerWatchdogDaemon)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.Object.wait(Object.java:568)\n"
            + "  at java.lang.Daemons$FinalizerWatchdogDaemon.sleepUntilNeeded(Daemons.java:341)\n"
            + "  - locked <0x00638f97> (a java.lang.Daemons$FinalizerWatchdogDaemon)\n"
            + "  at java.lang.Daemons$FinalizerWatchdogDaemon.runInternal(Daemons.java:321)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"Jit thread pool worker thread 0\" daemon prio=5 tid=9 Native\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c0318 self=0xe2d42a10\n"
            + "  | sysTid=10870 nice=0 cgrp=top-app sched=0/0 handle=0xd7e9fd60\n"
            + "  | state=S schedstat=( 544856613 44836261 101 ) utm=38 stm=15 core=1 HZ=100\n"
            + "  | stack=0xd7da1000-0xd7da3000 stackSize=1023KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 001d82ec  /apex/com.android.art/lib/libart.so (art::ConditionVariable::WaitHoldingLocks(art::Thread*)+108)\n"
            + "  native: #03 pc 001d8273  /apex/com.android.art/lib/libart.so (art::ConditionVariable::Wait(art::Thread*)+35)\n"
            + "  native: #04 pc 006c838f  /apex/com.android.art/lib/libart.so (art::ThreadPool::GetTask(art::Thread*)+143)\n"
            + "  native: #05 pc 006c73e5  /apex/com.android.art/lib/libart.so (art::ThreadPoolWorker::Run()+133)\n"
            + "  native: #06 pc 006c6e9d  /apex/com.android.art/lib/libart.so (art::ThreadPoolWorker::Callback(void*)+269)\n"
            + "  native: #07 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #08 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"HeapTaskDaemon\" daemon prio=5 tid=10 WaitingForTaskProcessor\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c1470 self=0xe2d45410\n"
            + "  | sysTid=10871 nice=4 cgrp=top-app sched=0/0 handle=0xd7d9b1e0\n"
            + "  | state=S schedstat=( 24497375 5430499 8 ) utm=2 stm=0 core=1 HZ=100\n"
            + "  | stack=0xd7c98000-0xd7c9a000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 001d82ec  /apex/com.android.art/lib/libart.so (art::ConditionVariable::WaitHoldingLocks(art::Thread*)+108)\n"
            + "  native: #03 pc 001d8273  /apex/com.android.art/lib/libart.so (art::ConditionVariable::Wait(art::Thread*)+35)\n"
            + "  native: #04 pc 0034a036  /apex/com.android.art/lib/libart.so (art::gc::TaskProcessor::GetTask(art::Thread*)+630)\n"
            + "  native: #05 pc 0034aa64  /apex/com.android.art/lib/libart.so (art::gc::TaskProcessor::RunAllTasks(art::Thread*)+84)\n"
            + "  native: #06 pc 005591f5  /apex/com.android.art/lib/libart.so (art::VMRuntime_runHeapTasks(_JNIEnv*, _jobject*)+53)\n"
            + "  at dalvik.system.VMRuntime.runHeapTasks(Native method)\n"
            + "  at java.lang.Daemons$HeapTaskDaemon.runInternal(Daemons.java:531)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"FinalizerDaemon\" daemon prio=5 tid=11 Waiting\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c0390 self=0xe2d40e10\n"
            + "  | sysTid=10873 nice=4 cgrp=top-app sched=0/0 handle=0xc2e1c1e0\n"
            + "  | state=S schedstat=( 1051441 5125750 4 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xc2d19000-0xc2d1b000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x05ee5584> (a java.lang.Object)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.ref.ReferenceQueue.remove(ReferenceQueue.java:190)\n"
            + "  - locked <0x05ee5584> (a java.lang.Object)\n"
            + "  at java.lang.ref.ReferenceQueue.remove(ReferenceQueue.java:211)\n"
            + "  at java.lang.Daemons$FinalizerDaemon.runInternal(Daemons.java:273)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"Binder:10849_1\" prio=5 tid=12 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0408 self=0xe2d4c410\n"
            + "  | sysTid=10875 nice=0 cgrp=top-app sched=0/0 handle=0xc2b0c1e0\n"
            + "  | state=S schedstat=( 607170 4411639 7 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xc2a11000-0xc2a13000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 000cd46c  /apex/com.android.runtime/lib/bionic/libc.so (__ioctl+28)\n"
            + "  native: #02 pc 00080e6a  /apex/com.android.runtime/lib/bionic/libc.so (ioctl+58)\n"
            + "  native: #03 pc 00050edb  /system/lib/libbinder.so (android::IPCThreadState::talkWithDriver(bool)+331)\n"
            + "  native: #04 pc 0005117a  /system/lib/libbinder.so (android::IPCThreadState::getAndExecuteCommand()+42)\n"
            + "  native: #05 pc 00051cb8  /system/lib/libbinder.so (android::IPCThreadState::joinThreadPool(bool)+72)\n"
            + "  native: #06 pc 0007e309  /system/lib/libbinder.so (android::PoolThread::threadLoop()+41)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 00098fee  /system/lib/libandroid_runtime.so (android::AndroidRuntime::javaThreadShell(void*)+174)\n"
            + "  native: #09 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"Binder:10849_2\" prio=5 tid=13 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0480 self=0xe2d48c10\n"
            + "  | sysTid=10876 nice=0 cgrp=top-app sched=0/0 handle=0xc2a0b1e0\n"
            + "  | state=S schedstat=( 5272069 33206603 14 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xc2910000-0xc2912000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 000cd46c  /apex/com.android.runtime/lib/bionic/libc.so (__ioctl+28)\n"
            + "  native: #02 pc 00080e6a  /apex/com.android.runtime/lib/bionic/libc.so (ioctl+58)\n"
            + "  native: #03 pc 00050edb  /system/lib/libbinder.so (android::IPCThreadState::talkWithDriver(bool)+331)\n"
            + "  native: #04 pc 0005117a  /system/lib/libbinder.so (android::IPCThreadState::getAndExecuteCommand()+42)\n"
            + "  native: #05 pc 00051cb8  /system/lib/libbinder.so (android::IPCThreadState::joinThreadPool(bool)+72)\n"
            + "  native: #06 pc 0007e309  /system/lib/libbinder.so (android::PoolThread::threadLoop()+41)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 00098fee  /system/lib/libandroid_runtime.so (android::AndroidRuntime::javaThreadShell(void*)+174)\n"
            + "  native: #09 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"Profile Saver\" daemon prio=5 tid=14 Native\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c04f8 self=0xe2d50a10\n"
            + "  | sysTid=10886 nice=9 cgrp=top-app sched=0/0 handle=0xc25931e0\n"
            + "  | state=S schedstat=( 7065834 1783772 21 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xc2498000-0xc249a000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 001d82ec  /apex/com.android.art/lib/libart.so (art::ConditionVariable::WaitHoldingLocks(art::Thread*)+108)\n"
            + "  native: #03 pc 001d8273  /apex/com.android.art/lib/libart.so (art::ConditionVariable::Wait(art::Thread*)+35)\n"
            + "  native: #04 pc 003cc829  /apex/com.android.art/lib/libart.so (art::ProfileSaver::Run()+633)\n"
            + "  native: #05 pc 003d2e8f  /apex/com.android.art/lib/libart.so (art::ProfileSaver::RunProfileSaverThread(void*)+175)\n"
            + "  native: #06 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #07 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"CrAsyncTask #1\" prio=5 tid=15 TimedWaiting\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0570 self=0xe2d51810\n"
            + "  | sysTid=10889 nice=-1 cgrp=top-app sched=0/0 handle=0xc239b1e0\n"
            + "  | state=S schedstat=( 5906313 2046809 11 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xc2298000-0xc229a000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at sun.misc.Unsafe.park(Native method)\n"
            + "  - waiting on an unknown object\n"
            + "  at java.util.concurrent.locks.LockSupport.parkNanos(LockSupport.java:230)\n"
            + "  at java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos(AbstractQueuedSynchronizer.java:2109)\n"
            + "  at java.util.concurrent.ArrayBlockingQueue.poll(ArrayBlockingQueue.java:402)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.getTask(ThreadPoolExecutor.java:1091)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1152)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:641)\n"
            + "  at p00.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"CrAsyncTask #2\" prio=5 tid=16 TimedWaiting\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0790 self=0xe2d4ee10\n"
            + "  | sysTid=10894 nice=10 cgrp=top-app sched=0/0 handle=0xc1b511e0\n"
            + "  | state=S schedstat=( 1434137 8412443 14 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xc1a4e000-0xc1a50000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at sun.misc.Unsafe.park(Native method)\n"
            + "  - waiting on an unknown object\n"
            + "  at java.util.concurrent.locks.LockSupport.parkNanos(LockSupport.java:230)\n"
            + "  at java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos(AbstractQueuedSynchronizer.java:2109)\n"
            + "  at java.util.concurrent.ArrayBlockingQueue.poll(ArrayBlockingQueue.java:402)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.getTask(ThreadPoolExecutor.java:1091)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1152)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:641)\n"
            + "  at p00.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"RenderThread\" daemon prio=7 tid=19 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0c70 self=0xe2d4fc10\n"
            + "  | sysTid=10898 nice=-10 cgrp=top-app sched=0/0 handle=0xc193f1e0\n"
            + "  | state=S schedstat=( 2602000672 50772536 773 ) utm=30 stm=229 core=3 HZ=100\n"
            + "  | stack=0xc1844000-0xc1846000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 000cf2cb  /apex/com.android.runtime/lib/bionic/libc.so (__epoll_pwait+43)\n"
            + "  native: #02 pc 00088f9d  /apex/com.android.runtime/lib/bionic/libc.so (epoll_wait+45)\n"
            + "  native: #03 pc 0001a003  /system/lib/libutils.so (android::Looper::pollInner(int)+259)\n"
            + "  native: #04 pc 00019e96  /system/lib/libutils.so (android::Looper::pollOnce(int, int*, int*, void**)+118)\n"
            + "  native: #05 pc 002452c5  /system/lib/libhwui.so (android::uirenderer::ThreadBase::waitForWork()+149)\n"
            + "  native: #06 pc 0026cab7  /system/lib/libhwui.so (android::uirenderer::renderthread::RenderThread::threadLoop()+119)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #09 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #10 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"CrAsyncTask #3\" prio=5 tid=20 TimedWaiting\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0ce8 self=0xe2d52610\n"
            + "  | sysTid=10901 nice=10 cgrp=top-app sched=0/0 handle=0xc16471e0\n"
            + "  | state=S schedstat=( 43937569 28546608 85 ) utm=4 stm=0 core=0 HZ=100\n"
            + "  | stack=0xc1544000-0xc1546000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at sun.misc.Unsafe.park(Native method)\n"
            + "  - waiting on an unknown object\n"
            + "  at java.util.concurrent.locks.LockSupport.parkNanos(LockSupport.java:230)\n"
            + "  at java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos(AbstractQueuedSynchronizer.java:2109)\n"
            + "  at java.util.concurrent.ArrayBlockingQueue.poll(ArrayBlockingQueue.java:402)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.getTask(ThreadPoolExecutor.java:1091)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1152)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:641)\n"
            + "  at p00.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"GmsDynamite\" prio=5 tid=21 Waiting\n"
            + "  | group=\"dynamiteLoader\" sCount=1 dsCount=0 flags=1 obj=0x134c0dc0 self=0xe2d57a10\n"
            + "  | sysTid=10904 nice=19 cgrp=top-app sched=0/0 handle=0xb50281e0\n"
            + "  | state=S schedstat=( 293737 4529784 3 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xb4f25000-0xb4f27000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x0ca0d16d> (a vE0)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.Object.wait(Object.java:568)\n"
            + "  at vE0.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  - locked <0x0ca0d16d> (a vE0)\n"
            + "\n"
            + "\"queued-work-looper\" prio=5 tid=22 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0f68 self=0xe2d58810\n"
            + "  | sysTid=10911 nice=-2 cgrp=top-app sched=0/0 handle=0xc14d61e0\n"
            + "  | state=S schedstat=( 10225849 983976 22 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xc13d3000-0xc13d5000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=25 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c1138 self=0xe2d56c10\n"
            + "  | sysTid=10917 nice=0 cgrp=top-app sched=0/0 handle=0xbff171e0\n"
            + "  | state=S schedstat=( 34339976 115169857 451 ) utm=2 stm=1 core=2 HZ=100\n"
            + "  | stack=0xbfe1c000-0xbfe1e000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"GoogleApiHandler\" prio=5 tid=26 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c11b0 self=0xe2d54210\n"
            + "  | sysTid=10930 nice=9 cgrp=top-app sched=0/0 handle=0xbf30b1e0\n"
            + "  | state=S schedstat=( 9053686 20157363 34 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xbf208000-0xbf20a000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 000cf2cb  /apex/com.android.runtime/lib/bionic/libc.so (__epoll_pwait+43)\n"
            + "  native: #02 pc 00088f9d  /apex/com.android.runtime/lib/bionic/libc.so (epoll_wait+45)\n"
            + "  native: #03 pc 0001a003  /system/lib/libutils.so (android::Looper::pollInner(int)+259)\n"
            + "  native: #04 pc 00019e96  /system/lib/libutils.so (android::Looper::pollOnce(int, int*, int*, void**)+118)\n"
            + "  native: #05 pc 0010ef8b  /system/lib/libandroid_runtime.so (android::android_os_MessageQueue_nativePollOnce(_JNIEnv*, _jobject*, long long, int)+59)\n"
            + "  at android.os.MessageQueue.nativePollOnce(Native method)\n"
            + "  at android.os.MessageQueue.next(MessageQueue.java:335)\n"
            + "  at android.os.Looper.loop(Looper.java:183)\n"
            + "  at android.os.HandlerThread.run(HandlerThread.java:67)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=27 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c1290 self=0xe2d5a410\n"
            + "  | sysTid=10923 nice=0 cgrp=top-app sched=0/0 handle=0xbf9111e0\n"
            + "  | state=S schedstat=( 7861103 15723367 24 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xbf816000-0xbf818000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 0007725e  /apex/com.android.runtime/lib/bionic/libc.so (__futex_wait_ex(void volatile*, bool, int, bool, timespec const*)+142)\n"
            + "  native: #03 pc 000e5bce  /apex/com.android.runtime/lib/bionic/libc.so (pthread_cond_timedwait+110)\n"
            + "  native: #04 pc 0237955a  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=28 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c1308 self=0xe2d59610\n"
            + "  | sysTid=10921 nice=0 cgrp=top-app sched=0/0 handle=0xbfb131e0\n"
            + "  | state=S schedstat=( 5466001 16594180 28 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xbfa18000-0xbfa1a000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 0007725e  /apex/com.android.runtime/lib/bionic/libc.so (__futex_wait_ex(void volatile*, bool, int, bool, timespec const*)+142)\n"
            + "  native: #03 pc 000e5bce  /apex/com.android.runtime/lib/bionic/libc.so (pthread_cond_timedwait+110)\n"
            + "  native: #04 pc 0237955a  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"Binder:10849_3\" prio=5 tid=29 Native\n"
            + "  | stack=0xbf107000-0xbf109000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 000cd46c  /apex/com.android.runtime/lib/bionic/libc.so (__ioctl+28)\n"
            + "  native: #02 pc 00080e6a  /apex/com.android.runtime/lib/bionic/libc.so (ioctl+58)\n"
            + "  native: #03 pc 00050edb  /system/lib/libbinder.so (android::IPCThreadState::talkWithDriver(bool)+331)\n"
            + "  native: #04 pc 0005117a  /system/lib/libbinder.so (android::IPCThreadState::getAndExecuteCommand()+42)\n"
            + "  native: #05 pc 00051cb8  /system/lib/libbinder.so (android::IPCThreadState::joinThreadPool(bool)+72)\n"
            + "  native: #06 pc 0007e309  /system/lib/libbinder.so (android::PoolThread::threadLoop()+41)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 00098fee  /system/lib/libandroid_runtime.so (android::AndroidRuntime::javaThreadShell(void*)+174)\n"
            + "  native: #09 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=30 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c13f8 self=0xe2d5f810\n"
            + "  | sysTid=10924 nice=0 cgrp=top-app sched=0/0 handle=0xbf8101e0\n"
            + "  | state=S schedstat=( 13183111 66742760 36 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xbf715000-0xbf717000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 0007725e  /apex/com.android.runtime/lib/bionic/libc.so (__futex_wait_ex(void volatile*, bool, int, bool, timespec const*)+142)\n"
            + "  native: #03 pc 000e5bce  /apex/com.android.runtime/lib/bionic/libc.so (pthread_cond_timedwait+110)\n"
            + "  native: #04 pc 0237955a  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + " \"NetworkStatusListener\" prio=5 tid=31 Native\n"
            + "   | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x12c41780 self=0xe2d5ea10\n"
            + "   | sysTid=10940 nice=0 cgrp=top-app sched=0/0 handle=0xbedb41e0\n"
            + "   | state=S schedstat=( 6504387 4427985 21 ) utm=0 stm=0 core=0 HZ=100\n"
            + "    static final String PREAMBLE;\n"
            + "    static final String MAIN_THREAD_STACK_TRACES;\n"
            + "    static final String OTHER_STACK_TRACES;\n"
            + "\n";

    static final String PREAMBLE = "----- pid 10849 at 2021-09-28 15:41:53 -----\n"
            + "Cmd line: com.google.android.apps.chrome\n"
            + "Build fingerprint: 'google/sdk_gphone_x86/generic_x86_arm:11/RSR1.201013.001/6903271:user/release-keys'\n"
            + "ABI: 'x86'\n"
            + "Build type: optimized\n"
            + "Zygote loaded classes=15746 post zygote classes=1796\n"
            + "Dumping registered class loaders\n"
            + "#0 dalvik.system.PathClassLoader: [], parent #1\n"
            + "#1 java.lang.BootClassLoader: [], no parent\n"
            + "#2 dalvik.system.PathClassLoader: [/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/base.apk], parent #1\n"
            + "#3 dalvik.system.PathClassLoader: [/data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk], parent #1\n"
            + "#4 dalvik.system.PathClassLoader: [/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/split_chrome.apk], parent #2\n"
            + "#5 dalvik.system.DelegateLastClassLoader: [/data/user_de/0/com.google.android.gms/app_chimera/m/0000001a/DynamiteLoader.apk], parent #0\n"
            + "#6 dalvik.system.DelegateLastClassLoader: [/data/user_de/0/com.google.android.gms/app_chimera/m/0000001d/GoogleCertificates.apk], parent #4\n"
            + "Done dumping class loaders\n"
            + "Classes initialized: 1391 in 79.445ms\n"
            + "Intern table: 31916 strong; 520 weak\n"
            + "JNI: CheckJNI is on; globals=798 (plus 43 weak)\n"
            + "Libraries: /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!/lib/x86/libmonochrome.so /data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/base.apk!/lib/x86/libchromium_android_linker.so libandroid.so libaudioeffect_jni.so libcompiler_rt.so libicu_jni.so libjavacore.so libjavacrypto.so libjnigraphics.so libmedia_jni.so libopenjdk.so librs_jni.so libsfplugin_ccodec.so libsoundpool.so libstats_jni.so libwebviewchromium_loader.so (16)\n"
            + "Heap: 87% free, 3559KB/26MB; 81403 objects\n"
            + "Dumping cumulative Gc timings\n"
            + "Average major GC reclaim bytes ratio inf over 0 GC cycles\n"
            + "Average major GC copied live bytes ratio 0.723527 over 4 major GCs\n"
            + "Cumulative bytes moved 11416448\n"
            + "Cumulative objects moved 215864\n"
            + "Peak regions allocated 35 (8960KB) / 768 (192MB)\n"
            + "Start Dumping histograms for 1 iterations for young concurrent copying\n"
            + "ProcessMarkStack:	Sum: 9.613ms 99% C.I. 9.613ms-9.613ms Avg: 9.613ms Max: 9.613ms\n"
            + "ScanImmuneSpaces:	Sum: 4.390ms 99% C.I. 4.390ms-4.390ms Avg: 4.390ms Max: 4.390ms\n"
            + "VisitConcurrentRoots:	Sum: 2.118ms 99% C.I. 2.118ms-2.118ms Avg: 2.118ms Max: 2.118ms\n"
            + "SweepSystemWeaks:	Sum: 1.486ms 99% C.I. 1.486ms-1.486ms Avg: 1.486ms Max: 1.486ms\n"
            + "ClearFromSpace:	Sum: 1.095ms 99% C.I. 1.095ms-1.095ms Avg: 1.095ms Max: 1.095ms\n"
            + "GrayAllDirtyImmuneObjects:	Sum: 866us 99% C.I. 866us-866us Avg: 866us Max: 866us\n"
            + "InitializePhase:	Sum: 861us 99% C.I. 861us-861us Avg: 861us Max: 861us\n"
            + "FlipOtherThreads:	Sum: 414us 99% C.I. 414us-414us Avg: 414us Max: 414us\n"
            + "ScanCardsForSpace:	Sum: 249us 99% C.I. 249us-249us Avg: 249us Max: 249us\n"
            + "VisitNonThreadRoots:	Sum: 221us 99% C.I. 221us-221us Avg: 221us Max: 221us\n"
            + "EnqueueFinalizerReferences:	Sum: 207us 99% C.I. 207us-207us Avg: 207us Max: 207us\n"
            + "SweepArray:	Sum: 204us 99% C.I. 204us-204us Avg: 204us Max: 204us\n"
            + "ProcessReferences:	Sum: 117us 99% C.I. 1us-116us Avg: 58.500us Max: 116us\n"
            + "RecordFree:	Sum: 51us 99% C.I. 5us-46us Avg: 25.500us Max: 46us\n"
            + "CopyingPhase:	Sum: 48us 99% C.I. 48us-48us Avg: 48us Max: 48us\n"
            + "FreeList:	Sum: 45us 99% C.I. 45us-45us Avg: 45us Max: 45us\n"
            + "(Paused)ClearCards:	Sum: 39us 99% C.I. 0.250us-16us Avg: 3us Max: 16us\n"
            + "MarkZygoteLargeObjects:	Sum: 36us 99% C.I. 36us-36us Avg: 36us Max: 36us\n"
            + "ThreadListFlip:	Sum: 28us 99% C.I. 28us-28us Avg: 28us Max: 28us\n"
            + "(Paused)GrayAllNewlyDirtyImmuneObjects:	Sum: 26us 99% C.I. 26us-26us Avg: 26us Max: 26us\n"
            + "ResetStack:	Sum: 21us 99% C.I. 21us-21us Avg: 21us Max: 21us\n"
            + "ReclaimPhase:	Sum: 10us 99% C.I. 10us-10us Avg: 10us Max: 10us\n"
            + "(Paused)SetFromSpace:	Sum: 8us 99% C.I. 8us-8us Avg: 8us Max: 8us\n"
            + "(Paused)FlipCallback:	Sum: 6us 99% C.I. 6us-6us Avg: 6us Max: 6us\n"
            + "UnBindBitmaps:	Sum: 2us 99% C.I. 2us-2us Avg: 2us Max: 2us\n"
            + "FlipThreadRoots:	Sum: 1us 99% C.I. 1us-1us Avg: 1us Max: 1us\n"
            + "Done Dumping histograms\n"
            + "young concurrent copying paused:	Sum: 105us 99% C.I. 105us-105us Avg: 105us Max: 105us\n"
            + "young concurrent copying freed-bytes: Avg: 3768KB Max: 3768KB Min: 3768KB\n"
            + "Freed-bytes histogram: 3520:1\n"
            + "young concurrent copying total time: 22.235ms mean time: 22.235ms\n"
            + "young concurrent copying freed: 52955 objects with total size 3768KB\n"
            + "young concurrent copying throughput: 2.40705e+06/s / 167MB/s  per cpu-time: 175419636/s / 167MB/s\n"
            + "Average minor GC reclaim bytes ratio 0.905098 over 1 GC cycles\n"
            + "Average minor GC copied live bytes ratio 0.218373 over 2 minor GCs\n"
            + "Cumulative bytes moved 1933528\n"
            + "Cumulative objects moved 34234\n"
            + "Peak regions allocated 35 (8960KB) / 768 (192MB)\n"
            + "Total time spent in GC: 22.235ms\n"
            + "Mean GC size throughput: 165MB/s per cpu-time: 163MB/s\n"
            + "Mean GC object throughput: 2.38161e+06 objects/s\n"
            + "Total number of allocations 134358\n"
            + "Total bytes allocated 7328KB\n"
            + "Total bytes freed 3768KB\n"
            + "Free memory 23MB\n"
            + "Free memory until GC 23MB\n"
            + "Free memory until OOME 188MB\n"
            + "Total memory 26MB\n"
            + "Max memory 192MB\n"
            + "Zygote space size 3016KB\n"
            + "Total mutator paused time: 105us\n"
            + "Total time waiting for GC to complete: 2.938us\n"
            + "Total GC count: 1\n"
            + "Total GC time: 22.235ms\n"
            + "Total blocking GC count: 0\n"
            + "Total blocking GC time: 0\n"
            + "Native bytes total: 18233624 registered: 279864\n"
            + "Total native bytes at last GC: 18144188\n"
            + "/system/framework/oat/x86/android.test.base.odex: quicken\n"
            + "/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/oat/x86/split_chrome.odex: speed-profile\n"
            + "/system/framework/oat/x86/android.hidl.manager-V1.0-java.odex: quicken\n"
            + "/system/framework/oat/x86/android.hidl.base-V1.0-java.odex: quicken\n"
            + "/data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/oat/x86/base.odex: speed-profile\n"
            + "/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/oat/x86/split_extra_icu.odex: speed-profile\n"
            + "/data/app/~~vsJt6r0FRID_SGtfoYZfsw==/com.google.android.apps.chrome-elBS_VoQghHLRXEgGrwmbQ==/oat/x86/base.odex: speed-profile\n"
            + "Current JIT code cache size (used / resident): 82KB / 88KB\n"
            + "Current JIT data cache size (used / resident): 51KB / 64KB\n"
            + "Zygote JIT code cache size (at point of fork): 40KB / 44KB\n"
            + "Zygote JIT data cache size (at point of fork): 30KB / 32KB\n"
            + "Current JIT mini-debug-info size: 29KB\n"
            + "Current JIT capacity: 256KB\n"
            + "Current number of JIT JNI stub entries: 0\n"
            + "Current number of JIT code cache entries: 90\n"
            + "Total number of JIT compilations: 55\n"
            + "Total number of JIT compilations for on stack replacement: 0\n"
            + "Total number of JIT code cache collections: 2\n"
            + "Memory used for stack maps: Avg: 356B Max: 2396B Min: 20B\n"
            + "Memory used for compiled code: Avg: 1551B Max: 10KB Min: 82B\n"
            + "Memory used for profiling info: Avg: 296B Max: 3116B Min: 20B\n"
            + "Start Dumping histograms for 95 iterations for JIT timings\n"
            + "Compiling:	Sum: 585.229ms 99% C.I. 0.197ms-231.487ms Avg: 6.292ms Max: 411.532ms\n"
            + "TrimMaps:	Sum: 7.909ms 99% C.I. 19us-810.499us Avg: 85.043us Max: 908us\n"
            + "Code cache collection:	Sum: 5.340ms 99% C.I. 0.572ms-4.758ms Avg: 2.670ms Max: 4.768ms\n"
            + "Done Dumping histograms\n"
            + "Memory used for compilation: Avg: 112KB Max: 1087KB Min: 9680B\n"
            + "ProfileSaver total_bytes_written=0\n"
            + "ProfileSaver total_number_of_writes=0\n"
            + "ProfileSaver total_number_of_code_cache_queries=0\n"
            + "ProfileSaver total_number_of_skipped_writes=0\n"
            + "ProfileSaver total_number_of_failed_writes=0\n"
            + "ProfileSaver total_ms_of_sleep=5000\n"
            + "ProfileSaver total_ms_of_work=0\n"
            + "ProfileSaver total_number_of_hot_spikes=0\n"
            + "ProfileSaver total_number_of_wake_ups=0\n"
            + "Number of JIT inline cache deoptimizations: 3\n"
            + "\n"
            + "suspend all histogram:	Sum: 90us 99% C.I. 1us-46us Avg: 10us Max: 46us\n"
            + "DALVIK THREADS (25):\n";

    static final String MAIN_THREAD_STACK_TRACE = "\"main\" prio=5 tid=1 Sleeping\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x712b6c28 self=0xe2d41c10\n"
            + "  | sysTid=10849 nice=-10 cgrp=top-app sched=0/0 handle=0xf114a478\n"
            + "  | state=S schedstat=( 478587788 174448370 929 ) utm=34 stm=13 core=0 HZ=100\n"
            + "  | stack=0xff4d8000-0xff4da000 stackSize=8192KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Thread.sleep(Native method)\n"
            + "  - sleeping on <0x0add3331> (a java.lang.Object)\n"
            + "  at java.lang.Thread.sleep(Thread.java:442)\n"
            + "  - locked <0x0add3331> (a java.lang.Object)\n"
            + "  at java.lang.Thread.sleep(Thread.java:358)\n"
            + "  at android.os.SystemClock.sleep(SystemClock.java:131)\n"
            + "  at org.chromium.chrome.browser.settings.SettingsActivity.onOptionsItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at android.app.Activity.onMenuItemSelected(Activity.java:4269)\n"
            + "  at C11.onMenuItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at Vd.onMenuItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at oe.onMenuItemSelected(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at hV3.onClick(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at android.view.View.performClick(View.java:7448)\n"
            + "  at android.view.View.performClickInternal(View.java:7425)\n"
            + "  at android.view.View.access$3600(View.java:810)\n"
            + "  at android.view.View$PerformClick.run(View.java:28305)\n"
            + "  at android.os.Handler.handleCallback(Handler.java:938)\n"
            + "  at android.os.Handler.dispatchMessage(Handler.java:99)\n"
            + "  at android.os.Looper.loop(Looper.java:223)\n"
            + "  at android.app.ActivityThread.main(ActivityThread.java:7656)\n"
            + "  at java.lang.reflect.Method.invoke(Native method)\n"
            + "  at com.android.internal.os.RuntimeInit$MethodAndArgsCaller.run(RuntimeInit.java:592)\n"
            + "  at com.android.internal.os.ZygoteInit.main(ZygoteInit.java:947)\n"
            + "\n";

    static final String OTHER_STACK_TRACES = "\"Signal Catcher\" daemon prio=10 tid=6 Runnable\n"
            + "  | group=\"system\" sCount=0 dsCount=0 flags=0 obj=0x134c01b0 self=0xe2d44610\n"
            + "  | sysTid=10865 nice=-20 cgrp=top-app sched=0/0 handle=0xd7f9d1e0\n"
            + "  | state=R schedstat=( 13249338 1928149 5 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xd7ea2000-0xd7ea4000 stackSize=1008KB\n"
            + "  | held mutexes= \"mutator lock\"(shared held)\n"
            + "  native: #00 pc 00542d9e  /apex/com.android.art/lib/libart.so (art::DumpNativeStack(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, int, BacktraceMap*, char const*, art::ArtMethod*, void*, bool)+110)\n"
            + "  native: #01 pc 006a0897  /apex/com.android.art/lib/libart.so (art::Thread::DumpStack(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, bool, BacktraceMap*, bool) const+1015)\n"
            + "  native: #02 pc 0069a171  /apex/com.android.art/lib/libart.so (art::Thread::Dump(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, bool, BacktraceMap*, bool) const+65)\n"
            + "  native: #03 pc 006c61b4  /apex/com.android.art/lib/libart.so (art::DumpCheckpoint::Run(art::Thread*)+1172)\n"
            + "  native: #04 pc 006bf266  /apex/com.android.art/lib/libart.so (art::ThreadList::RunCheckpoint(art::Closure*, art::Closure*)+630)\n"
            + "  native: #05 pc 006be1ce  /apex/com.android.art/lib/libart.so (art::ThreadList::Dump(std::__1::basic_ostream<char, std::__1::char_traits<char> >&, bool)+2446)\n"
            + "  native: #06 pc 006bd70c  /apex/com.android.art/lib/libart.so (art::ThreadList::DumpForSigQuit(std::__1::basic_ostream<char, std::__1::char_traits<char> >&)+1644)\n"
            + "  native: #07 pc 0064d654  /apex/com.android.art/lib/libart.so (art::Runtime::DumpForSigQuit(std::__1::basic_ostream<char, std::__1::char_traits<char> >&)+212)\n"
            + "  native: #08 pc 00665b6a  /apex/com.android.art/lib/libart.so (art::SignalCatcher::HandleSigQuit()+1818)\n"
            + "  native: #09 pc 0066496b  /apex/com.android.art/lib/libart.so (art::SignalCatcher::Run(void*)+587)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ReferenceQueueDaemon\" daemon prio=5 tid=7 Waiting\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c0228 self=0xe2d47e10\n"
            + "  | sysTid=10872 nice=4 cgrp=top-app sched=0/0 handle=0xc2f251e0\n"
            + "  | state=S schedstat=( 1373918 4806489 4 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xc2e22000-0xc2e24000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x0eadea16> (a java.lang.Class<java.lang.ref.ReferenceQueue>)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.Object.wait(Object.java:568)\n"
            + "  at java.lang.Daemons$ReferenceQueueDaemon.runInternal(Daemons.java:217)\n"
            + "  - locked <0x0eadea16> (a java.lang.Class<java.lang.ref.ReferenceQueue>)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"FinalizerWatchdogDaemon\" daemon prio=5 tid=8 Waiting\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c02a0 self=0xe2d4a810\n"
            + "  | sysTid=10874 nice=4 cgrp=top-app sched=0/0 handle=0xc2d131e0\n"
            + "  | state=S schedstat=( 311400 4725185 4 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xc2c10000-0xc2c12000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x00638f97> (a java.lang.Daemons$FinalizerWatchdogDaemon)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.Object.wait(Object.java:568)\n"
            + "  at java.lang.Daemons$FinalizerWatchdogDaemon.sleepUntilNeeded(Daemons.java:341)\n"
            + "  - locked <0x00638f97> (a java.lang.Daemons$FinalizerWatchdogDaemon)\n"
            + "  at java.lang.Daemons$FinalizerWatchdogDaemon.runInternal(Daemons.java:321)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"Jit thread pool worker thread 0\" daemon prio=5 tid=9 Native\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c0318 self=0xe2d42a10\n"
            + "  | sysTid=10870 nice=0 cgrp=top-app sched=0/0 handle=0xd7e9fd60\n"
            + "  | state=S schedstat=( 544856613 44836261 101 ) utm=38 stm=15 core=1 HZ=100\n"
            + "  | stack=0xd7da1000-0xd7da3000 stackSize=1023KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 001d82ec  /apex/com.android.art/lib/libart.so (art::ConditionVariable::WaitHoldingLocks(art::Thread*)+108)\n"
            + "  native: #03 pc 001d8273  /apex/com.android.art/lib/libart.so (art::ConditionVariable::Wait(art::Thread*)+35)\n"
            + "  native: #04 pc 006c838f  /apex/com.android.art/lib/libart.so (art::ThreadPool::GetTask(art::Thread*)+143)\n"
            + "  native: #05 pc 006c73e5  /apex/com.android.art/lib/libart.so (art::ThreadPoolWorker::Run()+133)\n"
            + "  native: #06 pc 006c6e9d  /apex/com.android.art/lib/libart.so (art::ThreadPoolWorker::Callback(void*)+269)\n"
            + "  native: #07 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #08 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"HeapTaskDaemon\" daemon prio=5 tid=10 WaitingForTaskProcessor\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c1470 self=0xe2d45410\n"
            + "  | sysTid=10871 nice=4 cgrp=top-app sched=0/0 handle=0xd7d9b1e0\n"
            + "  | state=S schedstat=( 24497375 5430499 8 ) utm=2 stm=0 core=1 HZ=100\n"
            + "  | stack=0xd7c98000-0xd7c9a000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 001d82ec  /apex/com.android.art/lib/libart.so (art::ConditionVariable::WaitHoldingLocks(art::Thread*)+108)\n"
            + "  native: #03 pc 001d8273  /apex/com.android.art/lib/libart.so (art::ConditionVariable::Wait(art::Thread*)+35)\n"
            + "  native: #04 pc 0034a036  /apex/com.android.art/lib/libart.so (art::gc::TaskProcessor::GetTask(art::Thread*)+630)\n"
            + "  native: #05 pc 0034aa64  /apex/com.android.art/lib/libart.so (art::gc::TaskProcessor::RunAllTasks(art::Thread*)+84)\n"
            + "  native: #06 pc 005591f5  /apex/com.android.art/lib/libart.so (art::VMRuntime_runHeapTasks(_JNIEnv*, _jobject*)+53)\n"
            + "  at dalvik.system.VMRuntime.runHeapTasks(Native method)\n"
            + "  at java.lang.Daemons$HeapTaskDaemon.runInternal(Daemons.java:531)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"FinalizerDaemon\" daemon prio=5 tid=11 Waiting\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c0390 self=0xe2d40e10\n"
            + "  | sysTid=10873 nice=4 cgrp=top-app sched=0/0 handle=0xc2e1c1e0\n"
            + "  | state=S schedstat=( 1051441 5125750 4 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xc2d19000-0xc2d1b000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x05ee5584> (a java.lang.Object)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.ref.ReferenceQueue.remove(ReferenceQueue.java:190)\n"
            + "  - locked <0x05ee5584> (a java.lang.Object)\n"
            + "  at java.lang.ref.ReferenceQueue.remove(ReferenceQueue.java:211)\n"
            + "  at java.lang.Daemons$FinalizerDaemon.runInternal(Daemons.java:273)\n"
            + "  at java.lang.Daemons$Daemon.run(Daemons.java:139)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"Binder:10849_1\" prio=5 tid=12 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0408 self=0xe2d4c410\n"
            + "  | sysTid=10875 nice=0 cgrp=top-app sched=0/0 handle=0xc2b0c1e0\n"
            + "  | state=S schedstat=( 607170 4411639 7 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xc2a11000-0xc2a13000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 000cd46c  /apex/com.android.runtime/lib/bionic/libc.so (__ioctl+28)\n"
            + "  native: #02 pc 00080e6a  /apex/com.android.runtime/lib/bionic/libc.so (ioctl+58)\n"
            + "  native: #03 pc 00050edb  /system/lib/libbinder.so (android::IPCThreadState::talkWithDriver(bool)+331)\n"
            + "  native: #04 pc 0005117a  /system/lib/libbinder.so (android::IPCThreadState::getAndExecuteCommand()+42)\n"
            + "  native: #05 pc 00051cb8  /system/lib/libbinder.so (android::IPCThreadState::joinThreadPool(bool)+72)\n"
            + "  native: #06 pc 0007e309  /system/lib/libbinder.so (android::PoolThread::threadLoop()+41)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 00098fee  /system/lib/libandroid_runtime.so (android::AndroidRuntime::javaThreadShell(void*)+174)\n"
            + "  native: #09 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"Binder:10849_2\" prio=5 tid=13 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0480 self=0xe2d48c10\n"
            + "  | sysTid=10876 nice=0 cgrp=top-app sched=0/0 handle=0xc2a0b1e0\n"
            + "  | state=S schedstat=( 5272069 33206603 14 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xc2910000-0xc2912000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 000cd46c  /apex/com.android.runtime/lib/bionic/libc.so (__ioctl+28)\n"
            + "  native: #02 pc 00080e6a  /apex/com.android.runtime/lib/bionic/libc.so (ioctl+58)\n"
            + "  native: #03 pc 00050edb  /system/lib/libbinder.so (android::IPCThreadState::talkWithDriver(bool)+331)\n"
            + "  native: #04 pc 0005117a  /system/lib/libbinder.so (android::IPCThreadState::getAndExecuteCommand()+42)\n"
            + "  native: #05 pc 00051cb8  /system/lib/libbinder.so (android::IPCThreadState::joinThreadPool(bool)+72)\n"
            + "  native: #06 pc 0007e309  /system/lib/libbinder.so (android::PoolThread::threadLoop()+41)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 00098fee  /system/lib/libandroid_runtime.so (android::AndroidRuntime::javaThreadShell(void*)+174)\n"
            + "  native: #09 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"Profile Saver\" daemon prio=5 tid=14 Native\n"
            + "  | group=\"system\" sCount=1 dsCount=0 flags=1 obj=0x134c04f8 self=0xe2d50a10\n"
            + "  | sysTid=10886 nice=9 cgrp=top-app sched=0/0 handle=0xc25931e0\n"
            + "  | state=S schedstat=( 7065834 1783772 21 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xc2498000-0xc249a000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 001d82ec  /apex/com.android.art/lib/libart.so (art::ConditionVariable::WaitHoldingLocks(art::Thread*)+108)\n"
            + "  native: #03 pc 001d8273  /apex/com.android.art/lib/libart.so (art::ConditionVariable::Wait(art::Thread*)+35)\n"
            + "  native: #04 pc 003cc829  /apex/com.android.art/lib/libart.so (art::ProfileSaver::Run()+633)\n"
            + "  native: #05 pc 003d2e8f  /apex/com.android.art/lib/libart.so (art::ProfileSaver::RunProfileSaverThread(void*)+175)\n"
            + "  native: #06 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #07 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"CrAsyncTask #1\" prio=5 tid=15 TimedWaiting\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0570 self=0xe2d51810\n"
            + "  | sysTid=10889 nice=-1 cgrp=top-app sched=0/0 handle=0xc239b1e0\n"
            + "  | state=S schedstat=( 5906313 2046809 11 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xc2298000-0xc229a000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at sun.misc.Unsafe.park(Native method)\n"
            + "  - waiting on an unknown object\n"
            + "  at java.util.concurrent.locks.LockSupport.parkNanos(LockSupport.java:230)\n"
            + "  at java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos(AbstractQueuedSynchronizer.java:2109)\n"
            + "  at java.util.concurrent.ArrayBlockingQueue.poll(ArrayBlockingQueue.java:402)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.getTask(ThreadPoolExecutor.java:1091)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1152)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:641)\n"
            + "  at p00.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"CrAsyncTask #2\" prio=5 tid=16 TimedWaiting\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0790 self=0xe2d4ee10\n"
            + "  | sysTid=10894 nice=10 cgrp=top-app sched=0/0 handle=0xc1b511e0\n"
            + "  | state=S schedstat=( 1434137 8412443 14 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xc1a4e000-0xc1a50000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at sun.misc.Unsafe.park(Native method)\n"
            + "  - waiting on an unknown object\n"
            + "  at java.util.concurrent.locks.LockSupport.parkNanos(LockSupport.java:230)\n"
            + "  at java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos(AbstractQueuedSynchronizer.java:2109)\n"
            + "  at java.util.concurrent.ArrayBlockingQueue.poll(ArrayBlockingQueue.java:402)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.getTask(ThreadPoolExecutor.java:1091)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1152)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:641)\n"
            + "  at p00.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"RenderThread\" daemon prio=7 tid=19 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0c70 self=0xe2d4fc10\n"
            + "  | sysTid=10898 nice=-10 cgrp=top-app sched=0/0 handle=0xc193f1e0\n"
            + "  | state=S schedstat=( 2602000672 50772536 773 ) utm=30 stm=229 core=3 HZ=100\n"
            + "  | stack=0xc1844000-0xc1846000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 000cf2cb  /apex/com.android.runtime/lib/bionic/libc.so (__epoll_pwait+43)\n"
            + "  native: #02 pc 00088f9d  /apex/com.android.runtime/lib/bionic/libc.so (epoll_wait+45)\n"
            + "  native: #03 pc 0001a003  /system/lib/libutils.so (android::Looper::pollInner(int)+259)\n"
            + "  native: #04 pc 00019e96  /system/lib/libutils.so (android::Looper::pollOnce(int, int*, int*, void**)+118)\n"
            + "  native: #05 pc 002452c5  /system/lib/libhwui.so (android::uirenderer::ThreadBase::waitForWork()+149)\n"
            + "  native: #06 pc 0026cab7  /system/lib/libhwui.so (android::uirenderer::renderthread::RenderThread::threadLoop()+119)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #09 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #10 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"CrAsyncTask #3\" prio=5 tid=20 TimedWaiting\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0ce8 self=0xe2d52610\n"
            + "  | sysTid=10901 nice=10 cgrp=top-app sched=0/0 handle=0xc16471e0\n"
            + "  | state=S schedstat=( 43937569 28546608 85 ) utm=4 stm=0 core=0 HZ=100\n"
            + "  | stack=0xc1544000-0xc1546000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at sun.misc.Unsafe.park(Native method)\n"
            + "  - waiting on an unknown object\n"
            + "  at java.util.concurrent.locks.LockSupport.parkNanos(LockSupport.java:230)\n"
            + "  at java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos(AbstractQueuedSynchronizer.java:2109)\n"
            + "  at java.util.concurrent.ArrayBlockingQueue.poll(ArrayBlockingQueue.java:402)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.getTask(ThreadPoolExecutor.java:1091)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1152)\n"
            + "  at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:641)\n"
            + "  at p00.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  at java.lang.Thread.run(Thread.java:923)\n"
            + "\n"
            + "\"GmsDynamite\" prio=5 tid=21 Waiting\n"
            + "  | group=\"dynamiteLoader\" sCount=1 dsCount=0 flags=1 obj=0x134c0dc0 self=0xe2d57a10\n"
            + "  | sysTid=10904 nice=19 cgrp=top-app sched=0/0 handle=0xb50281e0\n"
            + "  | state=S schedstat=( 293737 4529784 3 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xb4f25000-0xb4f27000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  at java.lang.Object.wait(Native method)\n"
            + "  - waiting on <0x0ca0d16d> (a vE0)\n"
            + "  at java.lang.Object.wait(Object.java:442)\n"
            + "  at java.lang.Object.wait(Object.java:568)\n"
            + "  at vE0.run(chromium-TrichromeChromeGoogle.aab-default-463700031:-1)\n"
            + "  - locked <0x0ca0d16d> (a vE0)\n"
            + "\n"
            + "\"queued-work-looper\" prio=5 tid=22 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c0f68 self=0xe2d58810\n"
            + "  | sysTid=10911 nice=-2 cgrp=top-app sched=0/0 handle=0xc14d61e0\n"
            + "  | state=S schedstat=( 10225849 983976 22 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xc13d3000-0xc13d5000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=25 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c1138 self=0xe2d56c10\n"
            + "  | sysTid=10917 nice=0 cgrp=top-app sched=0/0 handle=0xbff171e0\n"
            + "  | state=S schedstat=( 34339976 115169857 451 ) utm=2 stm=1 core=2 HZ=100\n"
            + "  | stack=0xbfe1c000-0xbfe1e000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"GoogleApiHandler\" prio=5 tid=26 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c11b0 self=0xe2d54210\n"
            + "  | sysTid=10930 nice=9 cgrp=top-app sched=0/0 handle=0xbf30b1e0\n"
            + "  | state=S schedstat=( 9053686 20157363 34 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xbf208000-0xbf20a000 stackSize=1040KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 000cf2cb  /apex/com.android.runtime/lib/bionic/libc.so (__epoll_pwait+43)\n"
            + "  native: #02 pc 00088f9d  /apex/com.android.runtime/lib/bionic/libc.so (epoll_wait+45)\n"
            + "  native: #03 pc 0001a003  /system/lib/libutils.so (android::Looper::pollInner(int)+259)\n"
            + "  native: #04 pc 00019e96  /system/lib/libutils.so (android::Looper::pollOnce(int, int*, int*, void**)+118)\n"
            + "  native: #05 pc 0010ef8b  /system/lib/libandroid_runtime.so (android::android_os_MessageQueue_nativePollOnce(_JNIEnv*, _jobject*, long long, int)+59)\n"
            + "  at android.os.MessageQueue.nativePollOnce(Native method)\n"
            + "  at android.os.MessageQueue.next(MessageQueue.java:335)\n"
            + "  at android.os.Looper.loop(Looper.java:183)\n"
            + "  at android.os.HandlerThread.run(HandlerThread.java:67)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=27 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c1290 self=0xe2d5a410\n"
            + "  | sysTid=10923 nice=0 cgrp=top-app sched=0/0 handle=0xbf9111e0\n"
            + "  | state=S schedstat=( 7861103 15723367 24 ) utm=0 stm=0 core=3 HZ=100\n"
            + "  | stack=0xbf816000-0xbf818000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 0007725e  /apex/com.android.runtime/lib/bionic/libc.so (__futex_wait_ex(void volatile*, bool, int, bool, timespec const*)+142)\n"
            + "  native: #03 pc 000e5bce  /apex/com.android.runtime/lib/bionic/libc.so (pthread_cond_timedwait+110)\n"
            + "  native: #04 pc 0237955a  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=28 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c1308 self=0xe2d59610\n"
            + "  | sysTid=10921 nice=0 cgrp=top-app sched=0/0 handle=0xbfb131e0\n"
            + "  | state=S schedstat=( 5466001 16594180 28 ) utm=0 stm=0 core=1 HZ=100\n"
            + "  | stack=0xbfa18000-0xbfa1a000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 0007725e  /apex/com.android.runtime/lib/bionic/libc.so (__futex_wait_ex(void volatile*, bool, int, bool, timespec const*)+142)\n"
            + "  native: #03 pc 000e5bce  /apex/com.android.runtime/lib/bionic/libc.so (pthread_cond_timedwait+110)\n"
            + "  native: #04 pc 0237955a  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"Binder:10849_3\" prio=5 tid=29 Native\n"
            + "  | stack=0xbf107000-0xbf109000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b97  [vdso] (__kernel_vsyscall+7)\n"
            + "  native: #01 pc 000cd46c  /apex/com.android.runtime/lib/bionic/libc.so (__ioctl+28)\n"
            + "  native: #02 pc 00080e6a  /apex/com.android.runtime/lib/bionic/libc.so (ioctl+58)\n"
            + "  native: #03 pc 00050edb  /system/lib/libbinder.so (android::IPCThreadState::talkWithDriver(bool)+331)\n"
            + "  native: #04 pc 0005117a  /system/lib/libbinder.so (android::IPCThreadState::getAndExecuteCommand()+42)\n"
            + "  native: #05 pc 00051cb8  /system/lib/libbinder.so (android::IPCThreadState::joinThreadPool(bool)+72)\n"
            + "  native: #06 pc 0007e309  /system/lib/libbinder.so (android::PoolThread::threadLoop()+41)\n"
            + "  native: #07 pc 00015116  /system/lib/libutils.so (android::Thread::_threadLoop(void*)+374)\n"
            + "  native: #08 pc 00098fee  /system/lib/libandroid_runtime.so (android::AndroidRuntime::javaThreadShell(void*)+174)\n"
            + "  native: #09 pc 000147d9  /system/lib/libutils.so (thread_data_t::trampoline(thread_data_t const*)+457)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + "\"ThreadPoolForeg\" prio=5 tid=30 Native\n"
            + "  | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x134c13f8 self=0xe2d5f810\n"
            + "  | sysTid=10924 nice=0 cgrp=top-app sched=0/0 handle=0xbf8101e0\n"
            + "  | state=S schedstat=( 13183111 66742760 36 ) utm=0 stm=0 core=2 HZ=100\n"
            + "  | stack=0xbf715000-0xbf717000 stackSize=1008KB\n"
            + "  | held mutexes=\n"
            + "  native: #00 pc 00000b99  [vdso] (__kernel_vsyscall+9)\n"
            + "  native: #01 pc 0005ad68  /apex/com.android.runtime/lib/bionic/libc.so (syscall+40)\n"
            + "  native: #02 pc 0007725e  /apex/com.android.runtime/lib/bionic/libc.so (__futex_wait_ex(void volatile*, bool, int, bool, timespec const*)+142)\n"
            + "  native: #03 pc 000e5bce  /apex/com.android.runtime/lib/bionic/libc.so (pthread_cond_timedwait+110)\n"
            + "  native: #04 pc 0237955a  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #05 pc 023713dc  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #06 pc 0236dee1  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #07 pc 0231f2c5  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #08 pc 02364017  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #09 pc 022fdf7f  /data/app/~~VozU4lWeE_mDx8UNcfmuYg==/com.google.android.trichromelibrary.debug_463700031-WKdKLOoLSzICU5jkoCrpsA==/base.apk!libmonochrome.so (offset 65c000) (???)\n"
            + "  native: #10 pc 000e6974  /apex/com.android.runtime/lib/bionic/libc.so (__pthread_start(void*)+100)\n"
            + "  native: #11 pc 00078567  /apex/com.android.runtime/lib/bionic/libc.so (__start_thread+71)\n"
            + "  (no managed stack frames)\n"
            + "\n"
            + " \"NetworkStatusListener\" prio=5 tid=31 Native\n"
            + "   | group=\"main\" sCount=1 dsCount=0 flags=1 obj=0x12c41780 self=0xe2d5ea10\n"
            + "   | sysTid=10940 nice=0 cgrp=top-app sched=0/0 handle=0xbedb41e0\n"
            + "   | state=S schedstat=( 6504387 4427985 21 ) utm=0 stm=0 core=0 HZ=100\n"
            + "    static final String PREAMBLE;\n"
            + "    static final String MAIN_THREAD_STACK_TRACES;\n"
            + "    static final String OTHER_STACK_TRACES;\n"
            + "\n";

    @Test
    public void testParseAnrFromReport() throws IOException {
        BufferedReader reader =
                new BufferedReader(new StringReader(TEXT_FROM_GET_TRACE_INPUT_STREAM));
        AnrData anrData = AnrCollector.parseAnrFromReport(reader);
        assertEquals(PREAMBLE, anrData.getPreamble());
        assertEquals(MAIN_THREAD_STACK_TRACE, anrData.getMainThreadStackTrace());
        assertEquals(OTHER_STACK_TRACES, anrData.getStackTraces());
    }
}
