// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Automatically generated by testing/gmock/scripts/generator/gmock_gen.py.
// Manual edits:
// - Copyright header added.
// - Includes and inclusion guard added.
// - Constructor and destructor added to satisfy chromium-style checker.

#ifndef COMPONENTS_COMPONENT_UPDATER_MOCK_COMPONENT_UPDATER_SERVICE_H_
#define COMPONENTS_COMPONENT_UPDATER_MOCK_COMPONENT_UPDATER_SERVICE_H_

#include <memory>
#include <string>
#include <utility>
#include <vector>

#include "base/functional/callback.h"
#include "base/task/sequenced_task_runner.h"
#include "base/version.h"
#include "components/component_updater/component_installer.h"
#include "components/component_updater/component_updater_service.h"
#include "testing/gmock/include/gmock/gmock.h"

namespace component_updater {

class MockComponentUpdateService : public ComponentUpdateService {
 public:
  MockComponentUpdateService();
  ~MockComponentUpdateService() override;

  void MaybeThrottle(const std::string& id,
                     base::OnceClosure callback) override {
    DoMaybeThrottle(id, std::move(callback));
  }

  base::Version GetRegisteredVersion(const std::string& app_id) override {
    return base::Version(kNullVersion);
  }

  MOCK_METHOD1(AddObserver,
      void(Observer* observer));
  MOCK_METHOD1(RemoveObserver,
      void(Observer* observer));
  MOCK_METHOD1(RegisterComponent, bool(const ComponentRegistration& component));
  MOCK_METHOD1(UnregisterComponent,
      bool(const std::string& id));
  MOCK_CONST_METHOD0(GetComponentIDs,
      std::vector<std::string>());
  MOCK_CONST_METHOD0(GetComponents, std::vector<ComponentInfo>());
  MOCK_METHOD0(GetOnDemandUpdater,
      OnDemandUpdater&());
  MOCK_METHOD2(DoMaybeThrottle,
               void(const std::string& id, const base::OnceClosure& callback));
  MOCK_METHOD0(GetSequencedTaskRunner,
      scoped_refptr<base::SequencedTaskRunner>());
  MOCK_CONST_METHOD2(GetComponentDetails,
      bool(const std::string& id, CrxUpdateItem* item));
};

}  // namespace component_updater

#endif  // COMPONENTS_COMPONENT_UPDATER_MOCK_COMPONENT_UPDATER_SERVICE_H_
