/*
 * Autogenerated from the following JSON policy
 */

#if 0
{
	"release": "01234567",
	"product": "myproduct",
	"schema-version": 1,
	"retry": [{
		"default": {
			"backoff": [1000, 2000, 3000, 5000, 10000],
			"conceal": 5,
			"jitterpc": 20,
			"svalidping": 30,
			"svalidhup": 35
		}
	}],
	"certs": [{
		"isrg_root_x1": "MIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4WhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJuZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBYMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygch77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6UA5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sWT8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyHB5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UCB5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUvKBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWnOlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTnjh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbwqHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CIrU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkqhkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZLubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KKNFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5ORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7UrTkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdCjNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVcoyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPAmRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57demyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc="
	}, {
		"LEX3_isrg_root_x1": "MIIFjTCCA3WgAwIBAgIRANOxciY0IzLc9AUoUSrsnGowDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTYxMDA2MTU0MzU1WhcNMjExMDA2MTU0MzU1WjBKMQswCQYDVQQGEwJVUzEWMBQGA1UEChMNTGV0J3MgRW5jcnlwdDEjMCEGA1UEAxMaTGV0J3MgRW5jcnlwdCBBdXRob3JpdHkgWDMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCc0wzwWuUuR7dyXTeDs2hjMOrXNSYZJeG9vjXxcJIvt7hLQQWrqZ41CFjssSrEaIcLo+N15Obzp2JxunmBYB/XkZqf89B4Z3HIaQ6Vkc/+5pnpYDxIzH7KTXcSJJ1HG1rrueweNwAcnKx7pwXqzkrrvUHlNpi5y/1tPJZo3yMqQpAMhnRnyH+lmrhSYRQTP2XpgofL2/oOVvaGifOFP5eGr7DcGu9rDZUWfcQroGWymQQ2dYBrrErzG5BJeC+ilk8qICUpBMZ0wNAxzY8xOJUWuqgzuEPxsR/DMH+ieTETPS02+OP88jNquTkxxa/EjQ0dZBYzqvqEKbbUC8DYfcOTAgMBAAGjggFnMIIBYzAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADBUBgNVHSAETTBLMAgGBmeBDAECATA/BgsrBgEEAYLfEwEBATAwMC4GCCsGAQUFBwIBFiJodHRwOi8vY3BzLnJvb3QteDEubGV0c2VuY3J5cHQub3JnMB0GA1UdDgQWBBSoSmpjBH3duubRObemRWXv86jsoTAzBgNVHR8ELDAqMCigJqAkhiJodHRwOi8vY3JsLnJvb3QteDEubGV0c2VuY3J5cHQub3JnMHIGCCsGAQUFBwEBBGYwZDAwBggrBgEFBQcwAYYkaHR0cDovL29jc3Aucm9vdC14MS5sZXRzZW5jcnlwdC5vcmcvMDAGCCsGAQUFBzAChiRodHRwOi8vY2VydC5yb290LXgxLmxldHNlbmNyeXB0Lm9yZy8wHwYDVR0jBBgwFoAUebRZ5nu25eQBc4AIiMgaWPbpm24wDQYJKoZIhvcNAQELBQADggIBABnPdSA0LTqmRf/Q1eaM2jLonG4bQdEnqOJQ8nCqxOeTRrToEKtwT++36gTSlBGxA/5dut82jJQ2jxN8RI8L9QFXrWi4xXnA2EqA10yjHiR6H9cj6MFiOnb5In1eWsRMUM2v3e9tNsCAgBukPHAg1lQh07rvFKm/Bz9BCjaxorALINUfZ9DD64j2igLIxle2DPxW8dI/F2loHMjXZjqG8RkqZUdoxtID5+90FgsGIfkMpqgRS05f4zPbCEHqCXl1eO5HyELTgcVlLXXQDgAWnRzut1hFJeczY1tjQQno6f6s+nMydLN26WuU4s3UYvOuOsUxRlJu7TSRHqDC3lSE5XggVkzdaPkuKGQbGpny+01/47hfXXNB7HntWNZ6N2Vwp7G6OfY+YQrZwIaQmhrIqJZuigsrbe3W+gdn5ykE9+Ky0VgVUsfxo52mwFYs1JKY2PGDuWx8M6DlS6qQkvHaRUo0FMd8TsSlbF0/v965qGFKhSDeQoMpYnwcmQilRh/0ayLThlHLN81gSkJjVrPI0Y8xCVPB4twb1PFUd2fPM3sA1tJ83sZ5v8vgFv2yofKRPB0t6JzUA81mSqM3kxl5e+IZwhYAyO0OTg3/fs8HqGTNKd9BqoUwSRBzp06JMg5brUCGwbCUDI0mxadJ3Bz4WxR6fyNpBK2yAinWEsikxqEt"
	}, {
	"amazon_root_ca_1": "MIIDQTCCAimgAwIBAgITBmyfz5m/jAo54vB4ikPmljZbyjANBgkqhkiG9w0BAQsFADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6b24gUm9vdCBDQSAxMB4XDTE1MDUyNjAwMDAwMFoXDTM4MDExNzAwMDAwMFowOTELMAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJvb3QgQ0EgMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALJ4gHHKeNXjca9HgFB0fW7Y14h29Jlo91ghYPl0hAEvrAIthtOgQ3pOsqTQNroBvo3bSMgHFzZM9O6II8c+6zf1tRn4SWiw3te5djgdYZ6k/oI2peVKVuRF4fn9tBb6dNqcmzU5L/qwIFAGbHrQgLKm+a/sRxmPUDgH3KKHOVj4utWp+UhnMJbulHheb4mjUcAwhmahRWa6VOujw5H5SNz/0egwLX0tdHA114gk957EWW67c4cX8jJGKLhD+rcdqsq08p8kDi1L93FcXmn/6pUCyziKrlA4b9v7LWIbxcceVOF34GfID5yHI9Y/QCB/IIDEgEw+OyQmjgSubJrIqg0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAYYwHQYDVR0OBBYEFIQYzIU07LwMlJQuCFmcx7IQTgoIMA0GCSqGSIb3DQEBCwUAA4IBAQCY8jdaQZChGsV2USggNiMOruYou6r4lK5IpDB/G/wkjUu0yKGX9rbxenDIU5PMCCjjmCXPI6T53iHTfIUJrU6adTrCC2qJeHZERxhlbI1Bjjt/msv0tadQ1wUsN+gDS63pYaACbvXy8MWy7Vu33PqUXHeeE6V/Uq2V8viTO96LXFvKWlJbYK8U90vvo/ufQJVtMVT8QtPHRh8jrdkPSHCa2XV4cdFyQzR1bldZwgJcJmApzyMZFo6IQ6XU5MsI+yMRQ+hDKXJioaldXgjUkK642M4UwtBV8ob2xJNDd2ZhwLnoQdeXeGADbkpyrqXRfboQnoZsG4q5WTP468SQvvG5"
	}, {
		"digicert_global_root_g2": "MIIDjjCCAnagAwIBAgIQAzrx5qcRqaC7KGSxHQn65TANBgkqhkiG9w0BAQsFADBhMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBHMjAeFw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuzfNNNx7a8myaJCtSnX/RrohCgiN9RlUyfuI2/Ou8jqJkTx65qsGGmvPrC3oXgkkRLpimn7Wo6h+4FR1IAWsULecYxpsMNzaHxmx1x7e/dfgy5SDN67sH0NO3Xss0r0upS/kqbitOtSZpLYl6ZtrAGCSYP9PIUkY92eQq2EGnI/yuum06ZIya7XzV+hdG82MHauVBJVJ8zUtluNJbd134/tJS7SsVQepj5WztCO7TG1F8PapspUwtP1MVYwnSlcUfIKdzXOS0xZKBgyMUNGPHgm+F6HmIcr9g+UQvIOlCsRnKPZzFBQ9RnbDhxSJITRNrw9FDKZJobq7nMWxM4MphQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNVHQ4EFgQUTiJUIBiV5uNu5g/6+rkS7QYXjzkwDQYJKoZIhvcNAQELBQADggEBAGBnKJRvDkhj6zHd6mcY1Yl9PMWLSn/pvtsrF9+wX3N3KjITOYFnQoQj8kVnNeyIv/iPsGEMNKSuIEyExtv4NeF22d+mQrvHRAiGfzZ0JFrabA0UWTW98kndth/Jsw1HKj2ZL7tcu7XUIOGZX1NGFdtom/DzMNU+MeKNhJ7jitralj41E6Vf8PlwUHBHQRFXGU7Aj64GxJUTFy8bJZ918rGOmaFvE7FBcf6IKshPECBV1/MUReXgRPTqh5Uykw7+U0b6LJ3/iyK5S9kJRaTepLiaWN0bfVKfjllDiIGknibVb63dDcY3fe0Dkhvld1927jyNxF1WW6LZZm6zNTflMrY="
	}, {
		"digicert_global_ca_g2": "MIIEizCCA3OgAwIBAgIQDI7gyQ1qiRWIBAYe4kH5rzANBgkqhkiG9w0BAQsFADBhMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBHMjAeFw0xMzA4MDExMjAwMDBaFw0yODA4MDExMjAwMDBaMEQxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxHjAcBgNVBAMTFURpZ2lDZXJ0IEdsb2JhbCBDQSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANNIfL7zBYZdW9UvhU5L4IatFaxhz1uvPmoKR/uadpFgC4przc/cV35gmAvkVNlW7SHMArZagV+Xau4CLyMnuG3UsOcGAngLH1ypmTb+u6wbBfpXzYEQQGfWMItYNdSWYb7QjHqXnxr5IuYUL6nG6AEfq/gmD6yOTSwyOR2Bm40cZbIc22GoiS9g5+vCShjEbyrpEJIJ7RfRACvmfe8EiRROM6GyD5eHn7OgzS+8LOy4g2gxPR/VSpAQGQuBldYpdlH5NnbQtwl6OErXb4y/E3w57bqukPyV93t4CTZedJMeJfD/1K2uaGvG/w/VNfFVbkhJ+Pi474j48V4Rd6rfArMCAwEAAaOCAVowggFWMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMDQGCCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMHsGA1UdHwR0MHIwN6A1oDOGMWh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEdsb2JhbFJvb3RHMi5jcmwwN6A1oDOGMWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEdsb2JhbFJvb3RHMi5jcmwwPQYDVR0gBDYwNDAyBgRVHSAAMCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwHQYDVR0OBBYEFCRuKy3QapJRUSVpAaqaR6aJ50AgMB8GA1UdIwQYMBaAFE4iVCAYlebjbuYP+vq5Eu0GF485MA0GCSqGSIb3DQEBCwUAA4IBAQALOYSR+ZfrqoGvhOlaOJL84mxZvzbIRacxAxHhBsCsMsdaVSnaT0AC9aHesO3ewPj2dZ12uYf+QYB6z13jAMZbAuabeGLJ3LhimnftiQjXS8X9Q9ViIyfEBFltcT8jW+rZ8uckJ2/0lYDblizkVIvP6hnZf1WZUXoOLRg9eFhSvGNoVwvdRLNXSmDmyHBwW4coatc7TlJFGa8kBpJIERqLrqwYElesA8u49L3KJg6nwd3jM+/AVTANlVlOnAM2BvjAjxSZnE0qnsHhfTuvcqdFuhOWKU4Z0BqYBvQ3lBetoxi6PrABDJXWKTUgNX31EGDk92hiHuwZ4STyhxGs6QiA"
	}, {
		"starfield_services_root_ca": "MIID7zCCAtegAwIBAgIBADANBgkqhkiG9w0BAQsFADCBmDELMAkGA1UEBhMCVVMxEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoTHFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xOzA5BgNVBAMTMlN0YXJmaWVsZCBTZXJ2aWNlcyBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAwMFoXDTM3MTIzMTIzNTk1OVowgZgxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFyZmllbGQgVGVjaG5vbG9naWVzLCBJbmMuMTswOQYDVQQDEzJTdGFyZmllbGQgU2VydmljZXMgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANUMOsQq+U7i9b4Zl1+OiFOxHz/Lz58gE20pOsgPfTz3a3Y4Y9k2YKibXlwAgLIvWX/2h/klQ4bnaRtSmpDhcePYLQ1Ob/bISdm28xpWriu2dBTrz/sm4xq6HZYuajtYlIlHVv8loJNwU4PahHQUw2eeBGg6345AWh1KTs9DkTvnVtYAcMtS7nt9rjrnvDH5RfbCYM8TWQIrgMw0R9+53pBlbQLPLJGmpufehRhJfGZOozptqbXuNC66DQO4M99H67FrjSXZm86B0UVGMpZwh94CDklDhbZsc7tk6mFBrMnUVN+HL8cisibMn1lUaJ/8viovxFUcdUBgF4UCVTmLfwUCAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFJxfAN+qAdcwKziIorhtSpzyEZGDMA0GCSqGSIb3DQEBCwUAA4IBAQBLNqaEd2ndOxmfZyMIbw5hyf2E3F/YNoHN2BtBLZ9g3ccaaNnRbobhiCPPE95Dz+I0swSdHynVv/heyNXBve6SbzJ08pGCL72CQnqtKrcgfU28elUSwhXqvfdqlS5sdJ/PHLTyxQGjhdByPq1zqwubdQxtRbeOlKyWN7Wg0I8VRw7j6IPdj/3vQQF3zCepYoUz8jcI73HPdwbeyBkdiEDPfUYd/x7H4c7/I9vG+o1VTqkC50cRRj70/b17KSa7qWFiNyi2LSr2EIZkyXCn0q23KXB56jzaYyWf/Wi3MOxw+3WKt21gZ7IeyLnp2KhvAotnDU0mV3HaIPzBSlCNsSi6"
	}, {
		"starfield_class_2_ca": "MIIEDzCCAvegAwIBAgIBADANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJVUzElMCMGA1UEChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMpU3RhcmZpZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQwNjI5MTczOTE2WhcNMzQwNjI5MTczOTE2WjBoMQswCQYDVQQGEwJVUzElMCMGA1UEChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMpU3RhcmZpZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwggEgMA0GCSqGSIb3DQEBAQUAA4IBDQAwggEIAoIBAQC3Msj+6XGmBIWtDBFk385N78gDGIc/oav7PKaf8MOh2tTYbitTkPskpD6E8J7oX+zlJ0T1KKY/e97gKvDIr1MvnsoFAZMej2YcOadN+lq2cwQlZut3f+dZxkqZJRRU6ybH838Z1TBwj6+wRir/resp7defqgSHo9T5iaU0X9tDkYI22WY8sbi5gv2cOj4QyDvvBmVmepsZGD3/cVE8MC5fvj13c7JdBmzDI1aaK4UmkhynArPkPw2vCHmCuDY96pzTNbO8acr1zJ3o/WSNF4Azbl5KXZnJHoe0nRrA1W4TNSNe35tfPe/W93bC6j67eA0cQmdrBNj41tpvi/JEoAGrAgEDo4HFMIHCMB0GA1UdDgQWBBS/X7fRzt0fhvRbVazc1xDCDqmI5zCBkgYDVR0jBIGKMIGHgBS/X7fRzt0fhvRbVazc1xDCDqmI56FspGowaDELMAkGA1UEBhMCVVMxJTAjBgNVBAoTHFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAsTKVN0YXJmaWVsZCBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAAWdP4id0ckaVaGsafPzWdqbAYcaT1epoXkJKtv3L7IezMdeatiDh6GX70k1PncGQVhiv45YuApnP+yz3SFmH8lU+nLMPUxA2IGvd56Deruix/U0F47ZEUD0/CwqTRV/p2JdLiXTAAsgGh1o+Re49L2L7ShZ3U0WixeDyLJlxy16paq8U4Zt3VekyvggQQto8PT7dL5WXXp59fkdheMtlb71cZBDzI0fmgAKhynpVSJYACPq4xJDKVtHCN2MQWplBqjlIapBtJUhlbl90TSrE9atvNziPTnNvT51cKEYWQPJIrSPnNVeKtelttQKbfi3QBFGmh95DmK/D5fs4C8fF5Q="
	}],
	"trust_stores": [{
		"name": "le_via_isrg",
		"stack": ["isrg_root_x1", "LEX3_isrg_root_x1"]
	}, {
		"name": "api_amazon_com",
		"stack": ["digicert_global_ca_g2", "digicert_global_root_g2"]
	}, {
		"name": "avs_via_starfield",
		"stack": ["starfield_class_2_ca", "starfield_services_root_ca"]
	}, {
		"name": "mqtt_amz_iot",
		"stack": ["amazon_root_ca_1", "starfield_class_2_ca", "starfield_services_root_ca"]
	}],
	"s": [{
		"api_amazon_com_auth": {
			"endpoint": "api.amazon.com",
			"port": 443,
			"protocol": "h1",
			"http_method": "POST",
			"http_url": "auth/o2/token",
			"plugins": [],
			"opportunistic": true,
			"tls": true,
			"h2q_oflow_txcr": true,
			"http_www_form_urlencoded": true,
			"http_no_content_length": true,
			"retry": "default",
			"tls_trust_store": "api_amazon_com"
		}
	}, {
		"avs_event": {
			"endpoint": "alexa.na.gateway.devices.a2z.com",
			"port": 443,
			"protocol": "h2",
			"http_method": "GET",
			"http_url": "v20160207/directives",
			"h2q_oflow_txcr": true,
			"http_auth_header": "authorization:",
			"http_auth_preamble": "Bearer ",
			"http_no_content_length": true,
			"nailed_up": true,
			"long_poll": true,
			"retry": "default",
			"plugins": [],
			"tls": true,
			"tls_trust_store": "avs_via_starfield"
		}
	}, {
		"avs_metadata": {
			"endpoint": "alexa.na.gateway.devices.a2z.com",
			"port": 443,
			"protocol": "h2",
			"http_method": "POST",
			"http_url": "v20160207/events",
			"opportunistic": true,
			"h2q_oflow_txcr": true,
			"http_auth_header": "authorization:",
			"http_auth_preamble": "Bearer ",
			"http_multipart_name": "metadata",
			"http_mime_content_type": "application/json; charset=UTF-8",
			"http_no_content_length": true,
			"rideshare": "avs_audio",
			"retry": "default",
			"plugins": [],
			"tls": true,
			"tls_trust_store": "avs_via_starfield"
		}
	}, {
		"avs_audio": {
			"endpoint": "alexa.na.gateway.devices.a2z.com",
			"port": 443,
			"protocol": "h2",
			"http_method": "POST",
			"http_url": "v20160207/events",
			"plugins": [],
			"tls": true,
			"h2q_oflow_txcr": true,
			"http_auth_header": "authorization:",
			"http_auth_preamble": "Bearer ",
			"http_multipart_name": "audio",
			"http_mime_content_type": "application/octet-stream",
			"http_no_content_length": true,
			"retry": "default",
			"tls_trust_store": "avs_via_starfield"
		}
	}, {
		"mintest": {
			"endpoint": "warmcat.com",
			"port": 443,
			"protocol": "h1",
			"http_method": "GET",
			"http_url": "index.html?uptag=${uptag}",
			"http_dsn_header": "x-dsn:",
			"http_fwv_header": "x-fw-version:",
			"http_devtype_header": "x-devtype:",
			"metadata": [{
				"uptag": "X-Upload-Tag:"
			}, {
				"ctype": "Content-Type:"
			}, {
				"xctype": "X-Content-Type:"
			}],
			"plugins": [],
			"tls": true,
			"opportunistic": true,
			"retry": "default",
			"tls_trust_store": "le_via_isrg"
		}
	}, {
		"h2longpolltest": {
			"endpoint": "warmcat.com",
			"port": 443,
			"protocol": "h2",
			"http_method": "GET",
			"http_url": "index.html",
			"plugins": [],
			"tls": true,
			"nailed_up": true,
			"long_poll": true,
			"retry": "default",
			"tls_trust_store": "le_via_isrg"
		}
	}, {
		"mintest-fail": {
			"endpoint": "warmcat.com",
			"port": 22,
			"protocol": "h1",
			"http_method": "GET",
			"http_url": "index.html",
			"plugins": [],
			"tls": true,
			"opportunistic": true,
			"retry": "default",
			"tls_trust_store": "le_via_isrg"
		}
	}, {
		"minpost": {
			"endpoint": "warmcat.com",
			"port": 443,
			"protocol": "h1",
			"http_method": "POST",
			"http_url": "testserver/formtest",
			"plugins": [],
			"tls": true,
			"opportunistic": true,
			"retry": "default",
			"tls_trust_store": "le_via_isrg"
		}
	}, {
		"mqtt_test": {
			"endpoint":		"a1ygonr3im5cv2-ats.iot.us-west-2.amazonaws.com",
			"port":			443,
			"tls":			true,
			"client_cert":		0,
			"tls_trust_store":	"mqtt_amz_iot",
			"protocol":		"mqtt",
			"mqtt_topic":		"test/topic0",
			"mqtt_subscribe":	"test/topic0",
			"mqtt_qos":		0,
			"retry":		"default"
		}
	}, {
		"mqtt_test1": {
			"endpoint":		"a1ygonr3im5cv2-ats.iot.us-west-2.amazonaws.com",
			"port":			443,
			"tls":			true,
			"client_cert":		0,
			"tls_trust_store":	"mqtt_amz_iot",
			"protocol":		"mqtt",
			"mqtt_topic":		"test/topic1",
			"mqtt_subscribe":	"test/topic1",
			"mqtt_qos":		1,
			"retry":		"default"
		}
	}, {
		"captive_portal_detect": {
			"endpoint": "connectivitycheck.android.com",
			"port": 80,
			"protocol": "h1",
			"http_method": "GET",
			"http_url": "generate_204",
			"opportunistic": true,
			"http_expect": 204,
			"http_fail_redirect": true
		}
	}
	]
}




 Original JSON size: 15493
#endif

static const uint32_t _rbo_bo_0[] = {
 1000,  2000,  3000,  5000,  10000, 
};
static const lws_retry_bo_t _rbo_0 = {
	.retry_ms_table = _rbo_bo_0,
	.retry_ms_table_count = 5,
	.conceal_count = 5,
	.secs_since_valid_ping = 30,
	.secs_since_valid_hangup = 35,
	.jitter_percent = 20,
};
static const uint8_t _ss_der_amazon_root_ca_1[] = {
	/* 0x  0 */ 0x30, 0x82, 0x03, 0x41, 0x30, 0x82, 0x02, 0x29, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x13, 0x06, 
	/* 0x 10 */ 0x6C, 0x9F, 0xCF, 0x99, 0xBF, 0x8C, 0x0A, 0x39, 
	/* 0x 18 */ 0xE2, 0xF0, 0x78, 0x8A, 0x43, 0xE6, 0x96, 0x36, 
	/* 0x 20 */ 0x5B, 0xCA, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 
	/* 0x 28 */ 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 
	/* 0x 30 */ 0x00, 0x30, 0x39, 0x31, 0x0B, 0x30, 0x09, 0x06, 
	/* 0x 38 */ 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 
	/* 0x 40 */ 0x31, 0x0F, 0x30, 0x0D, 0x06, 0x03, 0x55, 0x04, 
	/* 0x 48 */ 0x0A, 0x13, 0x06, 0x41, 0x6D, 0x61, 0x7A, 0x6F, 
	/* 0x 50 */ 0x6E, 0x31, 0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 
	/* 0x 58 */ 0x04, 0x03, 0x13, 0x10, 0x41, 0x6D, 0x61, 0x7A, 
	/* 0x 60 */ 0x6F, 0x6E, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 
	/* 0x 68 */ 0x43, 0x41, 0x20, 0x31, 0x30, 0x1E, 0x17, 0x0D, 
	/* 0x 70 */ 0x31, 0x35, 0x30, 0x35, 0x32, 0x36, 0x30, 0x30, 
	/* 0x 78 */ 0x30, 0x30, 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x33, 
	/* 0x 80 */ 0x38, 0x30, 0x31, 0x31, 0x37, 0x30, 0x30, 0x30, 
	/* 0x 88 */ 0x30, 0x30, 0x30, 0x5A, 0x30, 0x39, 0x31, 0x0B, 
	/* 0x 90 */ 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 
	/* 0x 98 */ 0x02, 0x55, 0x53, 0x31, 0x0F, 0x30, 0x0D, 0x06, 
	/* 0x a0 */ 0x03, 0x55, 0x04, 0x0A, 0x13, 0x06, 0x41, 0x6D, 
	/* 0x a8 */ 0x61, 0x7A, 0x6F, 0x6E, 0x31, 0x19, 0x30, 0x17, 
	/* 0x b0 */ 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x10, 0x41, 
	/* 0x b8 */ 0x6D, 0x61, 0x7A, 0x6F, 0x6E, 0x20, 0x52, 0x6F, 
	/* 0x c0 */ 0x6F, 0x74, 0x20, 0x43, 0x41, 0x20, 0x31, 0x30, 
	/* 0x c8 */ 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
	/* 0x d0 */ 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 
	/* 0x d8 */ 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 
	/* 0x e0 */ 0x82, 0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 
	/* 0x e8 */ 0xB2, 0x78, 0x80, 0x71, 0xCA, 0x78, 0xD5, 0xE3, 
	/* 0x f0 */ 0x71, 0xAF, 0x47, 0x80, 0x50, 0x74, 0x7D, 0x6E, 
	/* 0x f8 */ 0xD8, 0xD7, 0x88, 0x76, 0xF4, 0x99, 0x68, 0xF7, 
	/* 0x100 */ 0x58, 0x21, 0x60, 0xF9, 0x74, 0x84, 0x01, 0x2F, 
	/* 0x108 */ 0xAC, 0x02, 0x2D, 0x86, 0xD3, 0xA0, 0x43, 0x7A, 
	/* 0x110 */ 0x4E, 0xB2, 0xA4, 0xD0, 0x36, 0xBA, 0x01, 0xBE, 
	/* 0x118 */ 0x8D, 0xDB, 0x48, 0xC8, 0x07, 0x17, 0x36, 0x4C, 
	/* 0x120 */ 0xF4, 0xEE, 0x88, 0x23, 0xC7, 0x3E, 0xEB, 0x37, 
	/* 0x128 */ 0xF5, 0xB5, 0x19, 0xF8, 0x49, 0x68, 0xB0, 0xDE, 
	/* 0x130 */ 0xD7, 0xB9, 0x76, 0x38, 0x1D, 0x61, 0x9E, 0xA4, 
	/* 0x138 */ 0xFE, 0x82, 0x36, 0xA5, 0xE5, 0x4A, 0x56, 0xE4, 
	/* 0x140 */ 0x45, 0xE1, 0xF9, 0xFD, 0xB4, 0x16, 0xFA, 0x74, 
	/* 0x148 */ 0xDA, 0x9C, 0x9B, 0x35, 0x39, 0x2F, 0xFA, 0xB0, 
	/* 0x150 */ 0x20, 0x50, 0x06, 0x6C, 0x7A, 0xD0, 0x80, 0xB2, 
	/* 0x158 */ 0xA6, 0xF9, 0xAF, 0xEC, 0x47, 0x19, 0x8F, 0x50, 
	/* 0x160 */ 0x38, 0x07, 0xDC, 0xA2, 0x87, 0x39, 0x58, 0xF8, 
	/* 0x168 */ 0xBA, 0xD5, 0xA9, 0xF9, 0x48, 0x67, 0x30, 0x96, 
	/* 0x170 */ 0xEE, 0x94, 0x78, 0x5E, 0x6F, 0x89, 0xA3, 0x51, 
	/* 0x178 */ 0xC0, 0x30, 0x86, 0x66, 0xA1, 0x45, 0x66, 0xBA, 
	/* 0x180 */ 0x54, 0xEB, 0xA3, 0xC3, 0x91, 0xF9, 0x48, 0xDC, 
	/* 0x188 */ 0xFF, 0xD1, 0xE8, 0x30, 0x2D, 0x7D, 0x2D, 0x74, 
	/* 0x190 */ 0x70, 0x35, 0xD7, 0x88, 0x24, 0xF7, 0x9E, 0xC4, 
	/* 0x198 */ 0x59, 0x6E, 0xBB, 0x73, 0x87, 0x17, 0xF2, 0x32, 
	/* 0x1a0 */ 0x46, 0x28, 0xB8, 0x43, 0xFA, 0xB7, 0x1D, 0xAA, 
	/* 0x1a8 */ 0xCA, 0xB4, 0xF2, 0x9F, 0x24, 0x0E, 0x2D, 0x4B, 
	/* 0x1b0 */ 0xF7, 0x71, 0x5C, 0x5E, 0x69, 0xFF, 0xEA, 0x95, 
	/* 0x1b8 */ 0x02, 0xCB, 0x38, 0x8A, 0xAE, 0x50, 0x38, 0x6F, 
	/* 0x1c0 */ 0xDB, 0xFB, 0x2D, 0x62, 0x1B, 0xC5, 0xC7, 0x1E, 
	/* 0x1c8 */ 0x54, 0xE1, 0x77, 0xE0, 0x67, 0xC8, 0x0F, 0x9C, 
	/* 0x1d0 */ 0x87, 0x23, 0xD6, 0x3F, 0x40, 0x20, 0x7F, 0x20, 
	/* 0x1d8 */ 0x80, 0xC4, 0x80, 0x4C, 0x3E, 0x3B, 0x24, 0x26, 
	/* 0x1e0 */ 0x8E, 0x04, 0xAE, 0x6C, 0x9A, 0xC8, 0xAA, 0x0D, 
	/* 0x1e8 */ 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x42, 0x30, 
	/* 0x1f0 */ 0x40, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x1D, 0x13, 
	/* 0x1f8 */ 0x01, 0x01, 0xFF, 0x04, 0x05, 0x30, 0x03, 0x01, 
	/* 0x200 */ 0x01, 0xFF, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x208 */ 0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 
	/* 0x210 */ 0x01, 0x86, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x218 */ 0x0E, 0x04, 0x16, 0x04, 0x14, 0x84, 0x18, 0xCC, 
	/* 0x220 */ 0x85, 0x34, 0xEC, 0xBC, 0x0C, 0x94, 0x94, 0x2E, 
	/* 0x228 */ 0x08, 0x59, 0x9C, 0xC7, 0xB2, 0x10, 0x4E, 0x0A, 
	/* 0x230 */ 0x08, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 
	/* 0x238 */ 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 
	/* 0x240 */ 0x03, 0x82, 0x01, 0x01, 0x00, 0x98, 0xF2, 0x37, 
	/* 0x248 */ 0x5A, 0x41, 0x90, 0xA1, 0x1A, 0xC5, 0x76, 0x51, 
	/* 0x250 */ 0x28, 0x20, 0x36, 0x23, 0x0E, 0xAE, 0xE6, 0x28, 
	/* 0x258 */ 0xBB, 0xAA, 0xF8, 0x94, 0xAE, 0x48, 0xA4, 0x30, 
	/* 0x260 */ 0x7F, 0x1B, 0xFC, 0x24, 0x8D, 0x4B, 0xB4, 0xC8, 
	/* 0x268 */ 0xA1, 0x97, 0xF6, 0xB6, 0xF1, 0x7A, 0x70, 0xC8, 
	/* 0x270 */ 0x53, 0x93, 0xCC, 0x08, 0x28, 0xE3, 0x98, 0x25, 
	/* 0x278 */ 0xCF, 0x23, 0xA4, 0xF9, 0xDE, 0x21, 0xD3, 0x7C, 
	/* 0x280 */ 0x85, 0x09, 0xAD, 0x4E, 0x9A, 0x75, 0x3A, 0xC2, 
	/* 0x288 */ 0x0B, 0x6A, 0x89, 0x78, 0x76, 0x44, 0x47, 0x18, 
	/* 0x290 */ 0x65, 0x6C, 0x8D, 0x41, 0x8E, 0x3B, 0x7F, 0x9A, 
	/* 0x298 */ 0xCB, 0xF4, 0xB5, 0xA7, 0x50, 0xD7, 0x05, 0x2C, 
	/* 0x2a0 */ 0x37, 0xE8, 0x03, 0x4B, 0xAD, 0xE9, 0x61, 0xA0, 
	/* 0x2a8 */ 0x02, 0x6E, 0xF5, 0xF2, 0xF0, 0xC5, 0xB2, 0xED, 
	/* 0x2b0 */ 0x5B, 0xB7, 0xDC, 0xFA, 0x94, 0x5C, 0x77, 0x9E, 
	/* 0x2b8 */ 0x13, 0xA5, 0x7F, 0x52, 0xAD, 0x95, 0xF2, 0xF8, 
	/* 0x2c0 */ 0x93, 0x3B, 0xDE, 0x8B, 0x5C, 0x5B, 0xCA, 0x5A, 
	/* 0x2c8 */ 0x52, 0x5B, 0x60, 0xAF, 0x14, 0xF7, 0x4B, 0xEF, 
	/* 0x2d0 */ 0xA3, 0xFB, 0x9F, 0x40, 0x95, 0x6D, 0x31, 0x54, 
	/* 0x2d8 */ 0xFC, 0x42, 0xD3, 0xC7, 0x46, 0x1F, 0x23, 0xAD, 
	/* 0x2e0 */ 0xD9, 0x0F, 0x48, 0x70, 0x9A, 0xD9, 0x75, 0x78, 
	/* 0x2e8 */ 0x71, 0xD1, 0x72, 0x43, 0x34, 0x75, 0x6E, 0x57, 
	/* 0x2f0 */ 0x59, 0xC2, 0x02, 0x5C, 0x26, 0x60, 0x29, 0xCF, 
	/* 0x2f8 */ 0x23, 0x19, 0x16, 0x8E, 0x88, 0x43, 0xA5, 0xD4, 
	/* 0x300 */ 0xE4, 0xCB, 0x08, 0xFB, 0x23, 0x11, 0x43, 0xE8, 
	/* 0x308 */ 0x43, 0x29, 0x72, 0x62, 0xA1, 0xA9, 0x5D, 0x5E, 
	/* 0x310 */ 0x08, 0xD4, 0x90, 0xAE, 0xB8, 0xD8, 0xCE, 0x14, 
	/* 0x318 */ 0xC2, 0xD0, 0x55, 0xF2, 0x86, 0xF6, 0xC4, 0x93, 
	/* 0x320 */ 0x43, 0x77, 0x66, 0x61, 0xC0, 0xB9, 0xE8, 0x41, 
	/* 0x328 */ 0xD7, 0x97, 0x78, 0x60, 0x03, 0x6E, 0x4A, 0x72, 
	/* 0x330 */ 0xAE, 0xA5, 0xD1, 0x7D, 0xBA, 0x10, 0x9E, 0x86, 
	/* 0x338 */ 0x6C, 0x1B, 0x8A, 0xB9, 0x59, 0x33, 0xF8, 0xEB, 
	/* 0x340 */ 0xC4, 0x90, 0xBE, 0xF1, 0xB9, 
};
static const lws_ss_x509_t _ss_x509_amazon_root_ca_1 = {
	.vhost_name = "amazon_root_ca_1",
	.ca_der = _ss_der_amazon_root_ca_1,
	.ca_der_len = 837,
};
static const uint8_t _ss_der_starfield_class_2_ca[] = {
	/* 0x  0 */ 0x30, 0x82, 0x04, 0x0F, 0x30, 0x82, 0x02, 0xF7, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x01, 0x00, 
	/* 0x 10 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x 18 */ 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 
	/* 0x 20 */ 0x68, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 
	/* 0x 28 */ 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x25, 
	/* 0x 30 */ 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 
	/* 0x 38 */ 0x1C, 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 
	/* 0x 40 */ 0x6C, 0x64, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6E, 
	/* 0x 48 */ 0x6F, 0x6C, 0x6F, 0x67, 0x69, 0x65, 0x73, 0x2C, 
	/* 0x 50 */ 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x32, 0x30, 
	/* 0x 58 */ 0x30, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x29, 
	/* 0x 60 */ 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 0x6C, 
	/* 0x 68 */ 0x64, 0x20, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x20, 
	/* 0x 70 */ 0x32, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 
	/* 0x 78 */ 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 
	/* 0x 80 */ 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 
	/* 0x 88 */ 0x79, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x34, 0x30, 
	/* 0x 90 */ 0x36, 0x32, 0x39, 0x31, 0x37, 0x33, 0x39, 0x31, 
	/* 0x 98 */ 0x36, 0x5A, 0x17, 0x0D, 0x33, 0x34, 0x30, 0x36, 
	/* 0x a0 */ 0x32, 0x39, 0x31, 0x37, 0x33, 0x39, 0x31, 0x36, 
	/* 0x a8 */ 0x5A, 0x30, 0x68, 0x31, 0x0B, 0x30, 0x09, 0x06, 
	/* 0x b0 */ 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 
	/* 0x b8 */ 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 
	/* 0x c0 */ 0x0A, 0x13, 0x1C, 0x53, 0x74, 0x61, 0x72, 0x66, 
	/* 0x c8 */ 0x69, 0x65, 0x6C, 0x64, 0x20, 0x54, 0x65, 0x63, 
	/* 0x d0 */ 0x68, 0x6E, 0x6F, 0x6C, 0x6F, 0x67, 0x69, 0x65, 
	/* 0x d8 */ 0x73, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 
	/* 0x e0 */ 0x32, 0x30, 0x30, 0x06, 0x03, 0x55, 0x04, 0x0B, 
	/* 0x e8 */ 0x13, 0x29, 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 
	/* 0x f0 */ 0x65, 0x6C, 0x64, 0x20, 0x43, 0x6C, 0x61, 0x73, 
	/* 0x f8 */ 0x73, 0x20, 0x32, 0x20, 0x43, 0x65, 0x72, 0x74, 
	/* 0x100 */ 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 
	/* 0x108 */ 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 
	/* 0x110 */ 0x69, 0x74, 0x79, 0x30, 0x82, 0x01, 0x20, 0x30, 
	/* 0x118 */ 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
	/* 0x120 */ 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 
	/* 0x128 */ 0x01, 0x0D, 0x00, 0x30, 0x82, 0x01, 0x08, 0x02, 
	/* 0x130 */ 0x82, 0x01, 0x01, 0x00, 0xB7, 0x32, 0xC8, 0xFE, 
	/* 0x138 */ 0xE9, 0x71, 0xA6, 0x04, 0x85, 0xAD, 0x0C, 0x11, 
	/* 0x140 */ 0x64, 0xDF, 0xCE, 0x4D, 0xEF, 0xC8, 0x03, 0x18, 
	/* 0x148 */ 0x87, 0x3F, 0xA1, 0xAB, 0xFB, 0x3C, 0xA6, 0x9F, 
	/* 0x150 */ 0xF0, 0xC3, 0xA1, 0xDA, 0xD4, 0xD8, 0x6E, 0x2B, 
	/* 0x158 */ 0x53, 0x90, 0xFB, 0x24, 0xA4, 0x3E, 0x84, 0xF0, 
	/* 0x160 */ 0x9E, 0xE8, 0x5F, 0xEC, 0xE5, 0x27, 0x44, 0xF5, 
	/* 0x168 */ 0x28, 0xA6, 0x3F, 0x7B, 0xDE, 0xE0, 0x2A, 0xF0, 
	/* 0x170 */ 0xC8, 0xAF, 0x53, 0x2F, 0x9E, 0xCA, 0x05, 0x01, 
	/* 0x178 */ 0x93, 0x1E, 0x8F, 0x66, 0x1C, 0x39, 0xA7, 0x4D, 
	/* 0x180 */ 0xFA, 0x5A, 0xB6, 0x73, 0x04, 0x25, 0x66, 0xEB, 
	/* 0x188 */ 0x77, 0x7F, 0xE7, 0x59, 0xC6, 0x4A, 0x99, 0x25, 
	/* 0x190 */ 0x14, 0x54, 0xEB, 0x26, 0xC7, 0xF3, 0x7F, 0x19, 
	/* 0x198 */ 0xD5, 0x30, 0x70, 0x8F, 0xAF, 0xB0, 0x46, 0x2A, 
	/* 0x1a0 */ 0xFF, 0xAD, 0xEB, 0x29, 0xED, 0xD7, 0x9F, 0xAA, 
	/* 0x1a8 */ 0x04, 0x87, 0xA3, 0xD4, 0xF9, 0x89, 0xA5, 0x34, 
	/* 0x1b0 */ 0x5F, 0xDB, 0x43, 0x91, 0x82, 0x36, 0xD9, 0x66, 
	/* 0x1b8 */ 0x3C, 0xB1, 0xB8, 0xB9, 0x82, 0xFD, 0x9C, 0x3A, 
	/* 0x1c0 */ 0x3E, 0x10, 0xC8, 0x3B, 0xEF, 0x06, 0x65, 0x66, 
	/* 0x1c8 */ 0x7A, 0x9B, 0x19, 0x18, 0x3D, 0xFF, 0x71, 0x51, 
	/* 0x1d0 */ 0x3C, 0x30, 0x2E, 0x5F, 0xBE, 0x3D, 0x77, 0x73, 
	/* 0x1d8 */ 0xB2, 0x5D, 0x06, 0x6C, 0xC3, 0x23, 0x56, 0x9A, 
	/* 0x1e0 */ 0x2B, 0x85, 0x26, 0x92, 0x1C, 0xA7, 0x02, 0xB3, 
	/* 0x1e8 */ 0xE4, 0x3F, 0x0D, 0xAF, 0x08, 0x79, 0x82, 0xB8, 
	/* 0x1f0 */ 0x36, 0x3D, 0xEA, 0x9C, 0xD3, 0x35, 0xB3, 0xBC, 
	/* 0x1f8 */ 0x69, 0xCA, 0xF5, 0xCC, 0x9D, 0xE8, 0xFD, 0x64, 
	/* 0x200 */ 0x8D, 0x17, 0x80, 0x33, 0x6E, 0x5E, 0x4A, 0x5D, 
	/* 0x208 */ 0x99, 0xC9, 0x1E, 0x87, 0xB4, 0x9D, 0x1A, 0xC0, 
	/* 0x210 */ 0xD5, 0x6E, 0x13, 0x35, 0x23, 0x5E, 0xDF, 0x9B, 
	/* 0x218 */ 0x5F, 0x3D, 0xEF, 0xD6, 0xF7, 0x76, 0xC2, 0xEA, 
	/* 0x220 */ 0x3E, 0xBB, 0x78, 0x0D, 0x1C, 0x42, 0x67, 0x6B, 
	/* 0x228 */ 0x04, 0xD8, 0xF8, 0xD6, 0xDA, 0x6F, 0x8B, 0xF2, 
	/* 0x230 */ 0x44, 0xA0, 0x01, 0xAB, 0x02, 0x01, 0x03, 0xA3, 
	/* 0x238 */ 0x81, 0xC5, 0x30, 0x81, 0xC2, 0x30, 0x1D, 0x06, 
	/* 0x240 */ 0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 
	/* 0x248 */ 0xBF, 0x5F, 0xB7, 0xD1, 0xCE, 0xDD, 0x1F, 0x86, 
	/* 0x250 */ 0xF4, 0x5B, 0x55, 0xAC, 0xDC, 0xD7, 0x10, 0xC2, 
	/* 0x258 */ 0x0E, 0xA9, 0x88, 0xE7, 0x30, 0x81, 0x92, 0x06, 
	/* 0x260 */ 0x03, 0x55, 0x1D, 0x23, 0x04, 0x81, 0x8A, 0x30, 
	/* 0x268 */ 0x81, 0x87, 0x80, 0x14, 0xBF, 0x5F, 0xB7, 0xD1, 
	/* 0x270 */ 0xCE, 0xDD, 0x1F, 0x86, 0xF4, 0x5B, 0x55, 0xAC, 
	/* 0x278 */ 0xDC, 0xD7, 0x10, 0xC2, 0x0E, 0xA9, 0x88, 0xE7, 
	/* 0x280 */ 0xA1, 0x6C, 0xA4, 0x6A, 0x30, 0x68, 0x31, 0x0B, 
	/* 0x288 */ 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 
	/* 0x290 */ 0x02, 0x55, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 
	/* 0x298 */ 0x03, 0x55, 0x04, 0x0A, 0x13, 0x1C, 0x53, 0x74, 
	/* 0x2a0 */ 0x61, 0x72, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x20, 
	/* 0x2a8 */ 0x54, 0x65, 0x63, 0x68, 0x6E, 0x6F, 0x6C, 0x6F, 
	/* 0x2b0 */ 0x67, 0x69, 0x65, 0x73, 0x2C, 0x20, 0x49, 0x6E, 
	/* 0x2b8 */ 0x63, 0x2E, 0x31, 0x32, 0x30, 0x30, 0x06, 0x03, 
	/* 0x2c0 */ 0x55, 0x04, 0x0B, 0x13, 0x29, 0x53, 0x74, 0x61, 
	/* 0x2c8 */ 0x72, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x20, 0x43, 
	/* 0x2d0 */ 0x6C, 0x61, 0x73, 0x73, 0x20, 0x32, 0x20, 0x43, 
	/* 0x2d8 */ 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 
	/* 0x2e0 */ 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 
	/* 0x2e8 */ 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x82, 0x01, 
	/* 0x2f0 */ 0x00, 0x30, 0x0C, 0x06, 0x03, 0x55, 0x1D, 0x13, 
	/* 0x2f8 */ 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xFF, 0x30, 
	/* 0x300 */ 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
	/* 0x308 */ 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 
	/* 0x310 */ 0x01, 0x01, 0x00, 0x05, 0x9D, 0x3F, 0x88, 0x9D, 
	/* 0x318 */ 0xD1, 0xC9, 0x1A, 0x55, 0xA1, 0xAC, 0x69, 0xF3, 
	/* 0x320 */ 0xF3, 0x59, 0xDA, 0x9B, 0x01, 0x87, 0x1A, 0x4F, 
	/* 0x328 */ 0x57, 0xA9, 0xA1, 0x79, 0x09, 0x2A, 0xDB, 0xF7, 
	/* 0x330 */ 0x2F, 0xB2, 0x1E, 0xCC, 0xC7, 0x5E, 0x6A, 0xD8, 
	/* 0x338 */ 0x83, 0x87, 0xA1, 0x97, 0xEF, 0x49, 0x35, 0x3E, 
	/* 0x340 */ 0x77, 0x06, 0x41, 0x58, 0x62, 0xBF, 0x8E, 0x58, 
	/* 0x348 */ 0xB8, 0x0A, 0x67, 0x3F, 0xEC, 0xB3, 0xDD, 0x21, 
	/* 0x350 */ 0x66, 0x1F, 0xC9, 0x54, 0xFA, 0x72, 0xCC, 0x3D, 
	/* 0x358 */ 0x4C, 0x40, 0xD8, 0x81, 0xAF, 0x77, 0x9E, 0x83, 
	/* 0x360 */ 0x7A, 0xBB, 0xA2, 0xC7, 0xF5, 0x34, 0x17, 0x8E, 
	/* 0x368 */ 0xD9, 0x11, 0x40, 0xF4, 0xFC, 0x2C, 0x2A, 0x4D, 
	/* 0x370 */ 0x15, 0x7F, 0xA7, 0x62, 0x5D, 0x2E, 0x25, 0xD3, 
	/* 0x378 */ 0x00, 0x0B, 0x20, 0x1A, 0x1D, 0x68, 0xF9, 0x17, 
	/* 0x380 */ 0xB8, 0xF4, 0xBD, 0x8B, 0xED, 0x28, 0x59, 0xDD, 
	/* 0x388 */ 0x4D, 0x16, 0x8B, 0x17, 0x83, 0xC8, 0xB2, 0x65, 
	/* 0x390 */ 0xC7, 0x2D, 0x7A, 0xA5, 0xAA, 0xBC, 0x53, 0x86, 
	/* 0x398 */ 0x6D, 0xDD, 0x57, 0xA4, 0xCA, 0xF8, 0x20, 0x41, 
	/* 0x3a0 */ 0x0B, 0x68, 0xF0, 0xF4, 0xFB, 0x74, 0xBE, 0x56, 
	/* 0x3a8 */ 0x5D, 0x7A, 0x79, 0xF5, 0xF9, 0x1D, 0x85, 0xE3, 
	/* 0x3b0 */ 0x2D, 0x95, 0xBE, 0xF5, 0x71, 0x90, 0x43, 0xCC, 
	/* 0x3b8 */ 0x8D, 0x1F, 0x9A, 0x00, 0x0A, 0x87, 0x29, 0xE9, 
	/* 0x3c0 */ 0x55, 0x22, 0x58, 0x00, 0x23, 0xEA, 0xE3, 0x12, 
	/* 0x3c8 */ 0x43, 0x29, 0x5B, 0x47, 0x08, 0xDD, 0x8C, 0x41, 
	/* 0x3d0 */ 0x6A, 0x65, 0x06, 0xA8, 0xE5, 0x21, 0xAA, 0x41, 
	/* 0x3d8 */ 0xB4, 0x95, 0x21, 0x95, 0xB9, 0x7D, 0xD1, 0x34, 
	/* 0x3e0 */ 0xAB, 0x13, 0xD6, 0xAD, 0xBC, 0xDC, 0xE2, 0x3D, 
	/* 0x3e8 */ 0x39, 0xCD, 0xBD, 0x3E, 0x75, 0x70, 0xA1, 0x18, 
	/* 0x3f0 */ 0x59, 0x03, 0xC9, 0x22, 0xB4, 0x8F, 0x9C, 0xD5, 
	/* 0x3f8 */ 0x5E, 0x2A, 0xD7, 0xA5, 0xB6, 0xD4, 0x0A, 0x6D, 
	/* 0x400 */ 0xF8, 0xB7, 0x40, 0x11, 0x46, 0x9A, 0x1F, 0x79, 
	/* 0x408 */ 0x0E, 0x62, 0xBF, 0x0F, 0x97, 0xEC, 0xE0, 0x2F, 
	/* 0x410 */ 0x1F, 0x17, 0x94, 
};
static const lws_ss_x509_t _ss_x509_starfield_class_2_ca = {
	.vhost_name = "starfield_class_2_ca",
	.ca_der = _ss_der_starfield_class_2_ca,
	.ca_der_len = 1043,
};
static const uint8_t _ss_der_starfield_services_root_ca[] = {
	/* 0x  0 */ 0x30, 0x82, 0x03, 0xEF, 0x30, 0x82, 0x02, 0xD7, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x01, 0x00, 
	/* 0x 10 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x 18 */ 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 
	/* 0x 20 */ 0x81, 0x98, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 
	/* 0x 28 */ 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 
	/* 0x 30 */ 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x08, 
	/* 0x 38 */ 0x13, 0x07, 0x41, 0x72, 0x69, 0x7A, 0x6F, 0x6E, 
	/* 0x 40 */ 0x61, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 
	/* 0x 48 */ 0x04, 0x07, 0x13, 0x0A, 0x53, 0x63, 0x6F, 0x74, 
	/* 0x 50 */ 0x74, 0x73, 0x64, 0x61, 0x6C, 0x65, 0x31, 0x25, 
	/* 0x 58 */ 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 
	/* 0x 60 */ 0x1C, 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 
	/* 0x 68 */ 0x6C, 0x64, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6E, 
	/* 0x 70 */ 0x6F, 0x6C, 0x6F, 0x67, 0x69, 0x65, 0x73, 0x2C, 
	/* 0x 78 */ 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x3B, 0x30, 
	/* 0x 80 */ 0x39, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x32, 
	/* 0x 88 */ 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 0x6C, 
	/* 0x 90 */ 0x64, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 
	/* 0x 98 */ 0x65, 0x73, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 
	/* 0x a0 */ 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 
	/* 0x a8 */ 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74, 0x68, 
	/* 0x b0 */ 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 
	/* 0x b8 */ 0x47, 0x32, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x39, 
	/* 0x c0 */ 0x30, 0x39, 0x30, 0x31, 0x30, 0x30, 0x30, 0x30, 
	/* 0x c8 */ 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x33, 0x37, 0x31, 
	/* 0x d0 */ 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 
	/* 0x d8 */ 0x39, 0x5A, 0x30, 0x81, 0x98, 0x31, 0x0B, 0x30, 
	/* 0x e0 */ 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 
	/* 0x e8 */ 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 
	/* 0x f0 */ 0x55, 0x04, 0x08, 0x13, 0x07, 0x41, 0x72, 0x69, 
	/* 0x f8 */ 0x7A, 0x6F, 0x6E, 0x61, 0x31, 0x13, 0x30, 0x11, 
	/* 0x100 */ 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x0A, 0x53, 
	/* 0x108 */ 0x63, 0x6F, 0x74, 0x74, 0x73, 0x64, 0x61, 0x6C, 
	/* 0x110 */ 0x65, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 
	/* 0x118 */ 0x04, 0x0A, 0x13, 0x1C, 0x53, 0x74, 0x61, 0x72, 
	/* 0x120 */ 0x66, 0x69, 0x65, 0x6C, 0x64, 0x20, 0x54, 0x65, 
	/* 0x128 */ 0x63, 0x68, 0x6E, 0x6F, 0x6C, 0x6F, 0x67, 0x69, 
	/* 0x130 */ 0x65, 0x73, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 
	/* 0x138 */ 0x31, 0x3B, 0x30, 0x39, 0x06, 0x03, 0x55, 0x04, 
	/* 0x140 */ 0x03, 0x13, 0x32, 0x53, 0x74, 0x61, 0x72, 0x66, 
	/* 0x148 */ 0x69, 0x65, 0x6C, 0x64, 0x20, 0x53, 0x65, 0x72, 
	/* 0x150 */ 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x52, 0x6F, 
	/* 0x158 */ 0x6F, 0x74, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 
	/* 0x160 */ 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 
	/* 0x168 */ 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 
	/* 0x170 */ 0x20, 0x2D, 0x20, 0x47, 0x32, 0x30, 0x82, 0x01, 
	/* 0x178 */ 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 
	/* 0x180 */ 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 
	/* 0x188 */ 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82, 0x01, 
	/* 0x190 */ 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xD5, 0x0C, 
	/* 0x198 */ 0x3A, 0xC4, 0x2A, 0xF9, 0x4E, 0xE2, 0xF5, 0xBE, 
	/* 0x1a0 */ 0x19, 0x97, 0x5F, 0x8E, 0x88, 0x53, 0xB1, 0x1F, 
	/* 0x1a8 */ 0x3F, 0xCB, 0xCF, 0x9F, 0x20, 0x13, 0x6D, 0x29, 
	/* 0x1b0 */ 0x3A, 0xC8, 0x0F, 0x7D, 0x3C, 0xF7, 0x6B, 0x76, 
	/* 0x1b8 */ 0x38, 0x63, 0xD9, 0x36, 0x60, 0xA8, 0x9B, 0x5E, 
	/* 0x1c0 */ 0x5C, 0x00, 0x80, 0xB2, 0x2F, 0x59, 0x7F, 0xF6, 
	/* 0x1c8 */ 0x87, 0xF9, 0x25, 0x43, 0x86, 0xE7, 0x69, 0x1B, 
	/* 0x1d0 */ 0x52, 0x9A, 0x90, 0xE1, 0x71, 0xE3, 0xD8, 0x2D, 
	/* 0x1d8 */ 0x0D, 0x4E, 0x6F, 0xF6, 0xC8, 0x49, 0xD9, 0xB6, 
	/* 0x1e0 */ 0xF3, 0x1A, 0x56, 0xAE, 0x2B, 0xB6, 0x74, 0x14, 
	/* 0x1e8 */ 0xEB, 0xCF, 0xFB, 0x26, 0xE3, 0x1A, 0xBA, 0x1D, 
	/* 0x1f0 */ 0x96, 0x2E, 0x6A, 0x3B, 0x58, 0x94, 0x89, 0x47, 
	/* 0x1f8 */ 0x56, 0xFF, 0x25, 0xA0, 0x93, 0x70, 0x53, 0x83, 
	/* 0x200 */ 0xDA, 0x84, 0x74, 0x14, 0xC3, 0x67, 0x9E, 0x04, 
	/* 0x208 */ 0x68, 0x3A, 0xDF, 0x8E, 0x40, 0x5A, 0x1D, 0x4A, 
	/* 0x210 */ 0x4E, 0xCF, 0x43, 0x91, 0x3B, 0xE7, 0x56, 0xD6, 
	/* 0x218 */ 0x00, 0x70, 0xCB, 0x52, 0xEE, 0x7B, 0x7D, 0xAE, 
	/* 0x220 */ 0x3A, 0xE7, 0xBC, 0x31, 0xF9, 0x45, 0xF6, 0xC2, 
	/* 0x228 */ 0x60, 0xCF, 0x13, 0x59, 0x02, 0x2B, 0x80, 0xCC, 
	/* 0x230 */ 0x34, 0x47, 0xDF, 0xB9, 0xDE, 0x90, 0x65, 0x6D, 
	/* 0x238 */ 0x02, 0xCF, 0x2C, 0x91, 0xA6, 0xA6, 0xE7, 0xDE, 
	/* 0x240 */ 0x85, 0x18, 0x49, 0x7C, 0x66, 0x4E, 0xA3, 0x3A, 
	/* 0x248 */ 0x6D, 0xA9, 0xB5, 0xEE, 0x34, 0x2E, 0xBA, 0x0D, 
	/* 0x250 */ 0x03, 0xB8, 0x33, 0xDF, 0x47, 0xEB, 0xB1, 0x6B, 
	/* 0x258 */ 0x8D, 0x25, 0xD9, 0x9B, 0xCE, 0x81, 0xD1, 0x45, 
	/* 0x260 */ 0x46, 0x32, 0x96, 0x70, 0x87, 0xDE, 0x02, 0x0E, 
	/* 0x268 */ 0x49, 0x43, 0x85, 0xB6, 0x6C, 0x73, 0xBB, 0x64, 
	/* 0x270 */ 0xEA, 0x61, 0x41, 0xAC, 0xC9, 0xD4, 0x54, 0xDF, 
	/* 0x278 */ 0x87, 0x2F, 0xC7, 0x22, 0xB2, 0x26, 0xCC, 0x9F, 
	/* 0x280 */ 0x59, 0x54, 0x68, 0x9F, 0xFC, 0xBE, 0x2A, 0x2F, 
	/* 0x288 */ 0xC4, 0x55, 0x1C, 0x75, 0x40, 0x60, 0x17, 0x85, 
	/* 0x290 */ 0x02, 0x55, 0x39, 0x8B, 0x7F, 0x05, 0x02, 0x03, 
	/* 0x298 */ 0x01, 0x00, 0x01, 0xA3, 0x42, 0x30, 0x40, 0x30, 
	/* 0x2a0 */ 0x0F, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x01, 0x01, 
	/* 0x2a8 */ 0xFF, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xFF, 
	/* 0x2b0 */ 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x01, 
	/* 0x2b8 */ 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 
	/* 0x2c0 */ 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04, 
	/* 0x2c8 */ 0x16, 0x04, 0x14, 0x9C, 0x5F, 0x00, 0xDF, 0xAA, 
	/* 0x2d0 */ 0x01, 0xD7, 0x30, 0x2B, 0x38, 0x88, 0xA2, 0xB8, 
	/* 0x2d8 */ 0x6D, 0x4A, 0x9C, 0xF2, 0x11, 0x91, 0x83, 0x30, 
	/* 0x2e0 */ 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
	/* 0x2e8 */ 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 
	/* 0x2f0 */ 0x01, 0x01, 0x00, 0x4B, 0x36, 0xA6, 0x84, 0x77, 
	/* 0x2f8 */ 0x69, 0xDD, 0x3B, 0x19, 0x9F, 0x67, 0x23, 0x08, 
	/* 0x300 */ 0x6F, 0x0E, 0x61, 0xC9, 0xFD, 0x84, 0xDC, 0x5F, 
	/* 0x308 */ 0xD8, 0x36, 0x81, 0xCD, 0xD8, 0x1B, 0x41, 0x2D, 
	/* 0x310 */ 0x9F, 0x60, 0xDD, 0xC7, 0x1A, 0x68, 0xD9, 0xD1, 
	/* 0x318 */ 0x6E, 0x86, 0xE1, 0x88, 0x23, 0xCF, 0x13, 0xDE, 
	/* 0x320 */ 0x43, 0xCF, 0xE2, 0x34, 0xB3, 0x04, 0x9D, 0x1F, 
	/* 0x328 */ 0x29, 0xD5, 0xBF, 0xF8, 0x5E, 0xC8, 0xD5, 0xC1, 
	/* 0x330 */ 0xBD, 0xEE, 0x92, 0x6F, 0x32, 0x74, 0xF2, 0x91, 
	/* 0x338 */ 0x82, 0x2F, 0xBD, 0x82, 0x42, 0x7A, 0xAD, 0x2A, 
	/* 0x340 */ 0xB7, 0x20, 0x7D, 0x4D, 0xBC, 0x7A, 0x55, 0x12, 
	/* 0x348 */ 0xC2, 0x15, 0xEA, 0xBD, 0xF7, 0x6A, 0x95, 0x2E, 
	/* 0x350 */ 0x6C, 0x74, 0x9F, 0xCF, 0x1C, 0xB4, 0xF2, 0xC5, 
	/* 0x358 */ 0x01, 0xA3, 0x85, 0xD0, 0x72, 0x3E, 0xAD, 0x73, 
	/* 0x360 */ 0xAB, 0x0B, 0x9B, 0x75, 0x0C, 0x6D, 0x45, 0xB7, 
	/* 0x368 */ 0x8E, 0x94, 0xAC, 0x96, 0x37, 0xB5, 0xA0, 0xD0, 
	/* 0x370 */ 0x8F, 0x15, 0x47, 0x0E, 0xE3, 0xE8, 0x83, 0xDD, 
	/* 0x378 */ 0x8F, 0xFD, 0xEF, 0x41, 0x01, 0x77, 0xCC, 0x27, 
	/* 0x380 */ 0xA9, 0x62, 0x85, 0x33, 0xF2, 0x37, 0x08, 0xEF, 
	/* 0x388 */ 0x71, 0xCF, 0x77, 0x06, 0xDE, 0xC8, 0x19, 0x1D, 
	/* 0x390 */ 0x88, 0x40, 0xCF, 0x7D, 0x46, 0x1D, 0xFF, 0x1E, 
	/* 0x398 */ 0xC7, 0xE1, 0xCE, 0xFF, 0x23, 0xDB, 0xC6, 0xFA, 
	/* 0x3a0 */ 0x8D, 0x55, 0x4E, 0xA9, 0x02, 0xE7, 0x47, 0x11, 
	/* 0x3a8 */ 0x46, 0x3E, 0xF4, 0xFD, 0xBD, 0x7B, 0x29, 0x26, 
	/* 0x3b0 */ 0xBB, 0xA9, 0x61, 0x62, 0x37, 0x28, 0xB6, 0x2D, 
	/* 0x3b8 */ 0x2A, 0xF6, 0x10, 0x86, 0x64, 0xC9, 0x70, 0xA7, 
	/* 0x3c0 */ 0xD2, 0xAD, 0xB7, 0x29, 0x70, 0x79, 0xEA, 0x3C, 
	/* 0x3c8 */ 0xDA, 0x63, 0x25, 0x9F, 0xFD, 0x68, 0xB7, 0x30, 
	/* 0x3d0 */ 0xEC, 0x70, 0xFB, 0x75, 0x8A, 0xB7, 0x6D, 0x60, 
	/* 0x3d8 */ 0x67, 0xB2, 0x1E, 0xC8, 0xB9, 0xE9, 0xD8, 0xA8, 
	/* 0x3e0 */ 0x6F, 0x02, 0x8B, 0x67, 0x0D, 0x4D, 0x26, 0x57, 
	/* 0x3e8 */ 0x71, 0xDA, 0x20, 0xFC, 0xC1, 0x4A, 0x50, 0x8D, 
	/* 0x3f0 */ 0xB1, 0x28, 0xBA, 
};
static const lws_ss_x509_t _ss_x509_starfield_services_root_ca = {
	.vhost_name = "starfield_services_root_ca",
	.ca_der = _ss_der_starfield_services_root_ca,
	.ca_der_len = 1011,
};
static const lws_ss_trust_store_t _ss_ts_mqtt_amz_iot = {
	.name = "mqtt_amz_iot",
	.ssx509 = {
		&_ss_x509_starfield_services_root_ca,
		&_ss_x509_starfield_class_2_ca,
		&_ss_x509_amazon_root_ca_1,
	}
};
static const uint8_t _ss_der_isrg_root_x1[] = {
	/* 0x  0 */ 0x30, 0x82, 0x05, 0x6B, 0x30, 0x82, 0x03, 0x53, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x11, 0x00, 
	/* 0x 10 */ 0x82, 0x10, 0xCF, 0xB0, 0xD2, 0x40, 0xE3, 0x59, 
	/* 0x 18 */ 0x44, 0x63, 0xE0, 0xBB, 0x63, 0x82, 0x8B, 0x00, 
	/* 0x 20 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x 28 */ 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 
	/* 0x 30 */ 0x4F, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 
	/* 0x 38 */ 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x29, 
	/* 0x 40 */ 0x30, 0x27, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 
	/* 0x 48 */ 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 0x65, 
	/* 0x 50 */ 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 
	/* 0x 58 */ 0x74, 0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 0x61, 
	/* 0x 60 */ 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F, 0x75, 
	/* 0x 68 */ 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 
	/* 0x 70 */ 0x04, 0x03, 0x13, 0x0C, 0x49, 0x53, 0x52, 0x47, 
	/* 0x 78 */ 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x58, 0x31, 
	/* 0x 80 */ 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x35, 0x30, 0x36, 
	/* 0x 88 */ 0x30, 0x34, 0x31, 0x31, 0x30, 0x34, 0x33, 0x38, 
	/* 0x 90 */ 0x5A, 0x17, 0x0D, 0x33, 0x35, 0x30, 0x36, 0x30, 
	/* 0x 98 */ 0x34, 0x31, 0x31, 0x30, 0x34, 0x33, 0x38, 0x5A, 
	/* 0x a0 */ 0x30, 0x4F, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 
	/* 0x a8 */ 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 
	/* 0x b0 */ 0x29, 0x30, 0x27, 0x06, 0x03, 0x55, 0x04, 0x0A, 
	/* 0x b8 */ 0x13, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 
	/* 0x c0 */ 0x65, 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 
	/* 0x c8 */ 0x69, 0x74, 0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 
	/* 0x d0 */ 0x61, 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F, 
	/* 0x d8 */ 0x75, 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 
	/* 0x e0 */ 0x55, 0x04, 0x03, 0x13, 0x0C, 0x49, 0x53, 0x52, 
	/* 0x e8 */ 0x47, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x58, 
	/* 0x f0 */ 0x31, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0D, 0x06, 
	/* 0x f8 */ 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 
	/* 0x100 */ 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0F, 
	/* 0x108 */ 0x00, 0x30, 0x82, 0x02, 0x0A, 0x02, 0x82, 0x02, 
	/* 0x110 */ 0x01, 0x00, 0xAD, 0xE8, 0x24, 0x73, 0xF4, 0x14, 
	/* 0x118 */ 0x37, 0xF3, 0x9B, 0x9E, 0x2B, 0x57, 0x28, 0x1C, 
	/* 0x120 */ 0x87, 0xBE, 0xDC, 0xB7, 0xDF, 0x38, 0x90, 0x8C, 
	/* 0x128 */ 0x6E, 0x3C, 0xE6, 0x57, 0xA0, 0x78, 0xF7, 0x75, 
	/* 0x130 */ 0xC2, 0xA2, 0xFE, 0xF5, 0x6A, 0x6E, 0xF6, 0x00, 
	/* 0x138 */ 0x4F, 0x28, 0xDB, 0xDE, 0x68, 0x86, 0x6C, 0x44, 
	/* 0x140 */ 0x93, 0xB6, 0xB1, 0x63, 0xFD, 0x14, 0x12, 0x6B, 
	/* 0x148 */ 0xBF, 0x1F, 0xD2, 0xEA, 0x31, 0x9B, 0x21, 0x7E, 
	/* 0x150 */ 0xD1, 0x33, 0x3C, 0xBA, 0x48, 0xF5, 0xDD, 0x79, 
	/* 0x158 */ 0xDF, 0xB3, 0xB8, 0xFF, 0x12, 0xF1, 0x21, 0x9A, 
	/* 0x160 */ 0x4B, 0xC1, 0x8A, 0x86, 0x71, 0x69, 0x4A, 0x66, 
	/* 0x168 */ 0x66, 0x6C, 0x8F, 0x7E, 0x3C, 0x70, 0xBF, 0xAD, 
	/* 0x170 */ 0x29, 0x22, 0x06, 0xF3, 0xE4, 0xC0, 0xE6, 0x80, 
	/* 0x178 */ 0xAE, 0xE2, 0x4B, 0x8F, 0xB7, 0x99, 0x7E, 0x94, 
	/* 0x180 */ 0x03, 0x9F, 0xD3, 0x47, 0x97, 0x7C, 0x99, 0x48, 
	/* 0x188 */ 0x23, 0x53, 0xE8, 0x38, 0xAE, 0x4F, 0x0A, 0x6F, 
	/* 0x190 */ 0x83, 0x2E, 0xD1, 0x49, 0x57, 0x8C, 0x80, 0x74, 
	/* 0x198 */ 0xB6, 0xDA, 0x2F, 0xD0, 0x38, 0x8D, 0x7B, 0x03, 
	/* 0x1a0 */ 0x70, 0x21, 0x1B, 0x75, 0xF2, 0x30, 0x3C, 0xFA, 
	/* 0x1a8 */ 0x8F, 0xAE, 0xDD, 0xDA, 0x63, 0xAB, 0xEB, 0x16, 
	/* 0x1b0 */ 0x4F, 0xC2, 0x8E, 0x11, 0x4B, 0x7E, 0xCF, 0x0B, 
	/* 0x1b8 */ 0xE8, 0xFF, 0xB5, 0x77, 0x2E, 0xF4, 0xB2, 0x7B, 
	/* 0x1c0 */ 0x4A, 0xE0, 0x4C, 0x12, 0x25, 0x0C, 0x70, 0x8D, 
	/* 0x1c8 */ 0x03, 0x29, 0xA0, 0xE1, 0x53, 0x24, 0xEC, 0x13, 
	/* 0x1d0 */ 0xD9, 0xEE, 0x19, 0xBF, 0x10, 0xB3, 0x4A, 0x8C, 
	/* 0x1d8 */ 0x3F, 0x89, 0xA3, 0x61, 0x51, 0xDE, 0xAC, 0x87, 
	/* 0x1e0 */ 0x07, 0x94, 0xF4, 0x63, 0x71, 0xEC, 0x2E, 0xE2, 
	/* 0x1e8 */ 0x6F, 0x5B, 0x98, 0x81, 0xE1, 0x89, 0x5C, 0x34, 
	/* 0x1f0 */ 0x79, 0x6C, 0x76, 0xEF, 0x3B, 0x90, 0x62, 0x79, 
	/* 0x1f8 */ 0xE6, 0xDB, 0xA4, 0x9A, 0x2F, 0x26, 0xC5, 0xD0, 
	/* 0x200 */ 0x10, 0xE1, 0x0E, 0xDE, 0xD9, 0x10, 0x8E, 0x16, 
	/* 0x208 */ 0xFB, 0xB7, 0xF7, 0xA8, 0xF7, 0xC7, 0xE5, 0x02, 
	/* 0x210 */ 0x07, 0x98, 0x8F, 0x36, 0x08, 0x95, 0xE7, 0xE2, 
	/* 0x218 */ 0x37, 0x96, 0x0D, 0x36, 0x75, 0x9E, 0xFB, 0x0E, 
	/* 0x220 */ 0x72, 0xB1, 0x1D, 0x9B, 0xBC, 0x03, 0xF9, 0x49, 
	/* 0x228 */ 0x05, 0xD8, 0x81, 0xDD, 0x05, 0xB4, 0x2A, 0xD6, 
	/* 0x230 */ 0x41, 0xE9, 0xAC, 0x01, 0x76, 0x95, 0x0A, 0x0F, 
	/* 0x238 */ 0xD8, 0xDF, 0xD5, 0xBD, 0x12, 0x1F, 0x35, 0x2F, 
	/* 0x240 */ 0x28, 0x17, 0x6C, 0xD2, 0x98, 0xC1, 0xA8, 0x09, 
	/* 0x248 */ 0x64, 0x77, 0x6E, 0x47, 0x37, 0xBA, 0xCE, 0xAC, 
	/* 0x250 */ 0x59, 0x5E, 0x68, 0x9D, 0x7F, 0x72, 0xD6, 0x89, 
	/* 0x258 */ 0xC5, 0x06, 0x41, 0x29, 0x3E, 0x59, 0x3E, 0xDD, 
	/* 0x260 */ 0x26, 0xF5, 0x24, 0xC9, 0x11, 0xA7, 0x5A, 0xA3, 
	/* 0x268 */ 0x4C, 0x40, 0x1F, 0x46, 0xA1, 0x99, 0xB5, 0xA7, 
	/* 0x270 */ 0x3A, 0x51, 0x6E, 0x86, 0x3B, 0x9E, 0x7D, 0x72, 
	/* 0x278 */ 0xA7, 0x12, 0x05, 0x78, 0x59, 0xED, 0x3E, 0x51, 
	/* 0x280 */ 0x78, 0x15, 0x0B, 0x03, 0x8F, 0x8D, 0xD0, 0x2F, 
	/* 0x288 */ 0x05, 0xB2, 0x3E, 0x7B, 0x4A, 0x1C, 0x4B, 0x73, 
	/* 0x290 */ 0x05, 0x12, 0xFC, 0xC6, 0xEA, 0xE0, 0x50, 0x13, 
	/* 0x298 */ 0x7C, 0x43, 0x93, 0x74, 0xB3, 0xCA, 0x74, 0xE7, 
	/* 0x2a0 */ 0x8E, 0x1F, 0x01, 0x08, 0xD0, 0x30, 0xD4, 0x5B, 
	/* 0x2a8 */ 0x71, 0x36, 0xB4, 0x07, 0xBA, 0xC1, 0x30, 0x30, 
	/* 0x2b0 */ 0x5C, 0x48, 0xB7, 0x82, 0x3B, 0x98, 0xA6, 0x7D, 
	/* 0x2b8 */ 0x60, 0x8A, 0xA2, 0xA3, 0x29, 0x82, 0xCC, 0xBA, 
	/* 0x2c0 */ 0xBD, 0x83, 0x04, 0x1B, 0xA2, 0x83, 0x03, 0x41, 
	/* 0x2c8 */ 0xA1, 0xD6, 0x05, 0xF1, 0x1B, 0xC2, 0xB6, 0xF0, 
	/* 0x2d0 */ 0xA8, 0x7C, 0x86, 0x3B, 0x46, 0xA8, 0x48, 0x2A, 
	/* 0x2d8 */ 0x88, 0xDC, 0x76, 0x9A, 0x76, 0xBF, 0x1F, 0x6A, 
	/* 0x2e0 */ 0xA5, 0x3D, 0x19, 0x8F, 0xEB, 0x38, 0xF3, 0x64, 
	/* 0x2e8 */ 0xDE, 0xC8, 0x2B, 0x0D, 0x0A, 0x28, 0xFF, 0xF7, 
	/* 0x2f0 */ 0xDB, 0xE2, 0x15, 0x42, 0xD4, 0x22, 0xD0, 0x27, 
	/* 0x2f8 */ 0x5D, 0xE1, 0x79, 0xFE, 0x18, 0xE7, 0x70, 0x88, 
	/* 0x300 */ 0xAD, 0x4E, 0xE6, 0xD9, 0x8B, 0x3A, 0xC6, 0xDD, 
	/* 0x308 */ 0x27, 0x51, 0x6E, 0xFF, 0xBC, 0x64, 0xF5, 0x33, 
	/* 0x310 */ 0x43, 0x4F, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 
	/* 0x318 */ 0x42, 0x30, 0x40, 0x30, 0x0E, 0x06, 0x03, 0x55, 
	/* 0x320 */ 0x1D, 0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 
	/* 0x328 */ 0x02, 0x01, 0x06, 0x30, 0x0F, 0x06, 0x03, 0x55, 
	/* 0x330 */ 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x05, 0x30, 
	/* 0x338 */ 0x03, 0x01, 0x01, 0xFF, 0x30, 0x1D, 0x06, 0x03, 
	/* 0x340 */ 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x79, 
	/* 0x348 */ 0xB4, 0x59, 0xE6, 0x7B, 0xB6, 0xE5, 0xE4, 0x01, 
	/* 0x350 */ 0x73, 0x80, 0x08, 0x88, 0xC8, 0x1A, 0x58, 0xF6, 
	/* 0x358 */ 0xE9, 0x9B, 0x6E, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
	/* 0x360 */ 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 
	/* 0x368 */ 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x55, 
	/* 0x370 */ 0x1F, 0x58, 0xA9, 0xBC, 0xB2, 0xA8, 0x50, 0xD0, 
	/* 0x378 */ 0x0C, 0xB1, 0xD8, 0x1A, 0x69, 0x20, 0x27, 0x29, 
	/* 0x380 */ 0x08, 0xAC, 0x61, 0x75, 0x5C, 0x8A, 0x6E, 0xF8, 
	/* 0x388 */ 0x82, 0xE5, 0x69, 0x2F, 0xD5, 0xF6, 0x56, 0x4B, 
	/* 0x390 */ 0xB9, 0xB8, 0x73, 0x10, 0x59, 0xD3, 0x21, 0x97, 
	/* 0x398 */ 0x7E, 0xE7, 0x4C, 0x71, 0xFB, 0xB2, 0xD2, 0x60, 
	/* 0x3a0 */ 0xAD, 0x39, 0xA8, 0x0B, 0xEA, 0x17, 0x21, 0x56, 
	/* 0x3a8 */ 0x85, 0xF1, 0x50, 0x0E, 0x59, 0xEB, 0xCE, 0xE0, 
	/* 0x3b0 */ 0x59, 0xE9, 0xBA, 0xC9, 0x15, 0xEF, 0x86, 0x9D, 
	/* 0x3b8 */ 0x8F, 0x84, 0x80, 0xF6, 0xE4, 0xE9, 0x91, 0x90, 
	/* 0x3c0 */ 0xDC, 0x17, 0x9B, 0x62, 0x1B, 0x45, 0xF0, 0x66, 
	/* 0x3c8 */ 0x95, 0xD2, 0x7C, 0x6F, 0xC2, 0xEA, 0x3B, 0xEF, 
	/* 0x3d0 */ 0x1F, 0xCF, 0xCB, 0xD6, 0xAE, 0x27, 0xF1, 0xA9, 
	/* 0x3d8 */ 0xB0, 0xC8, 0xAE, 0xFD, 0x7D, 0x7E, 0x9A, 0xFA, 
	/* 0x3e0 */ 0x22, 0x04, 0xEB, 0xFF, 0xD9, 0x7F, 0xEA, 0x91, 
	/* 0x3e8 */ 0x2B, 0x22, 0xB1, 0x17, 0x0E, 0x8F, 0xF2, 0x8A, 
	/* 0x3f0 */ 0x34, 0x5B, 0x58, 0xD8, 0xFC, 0x01, 0xC9, 0x54, 
	/* 0x3f8 */ 0xB9, 0xB8, 0x26, 0xCC, 0x8A, 0x88, 0x33, 0x89, 
	/* 0x400 */ 0x4C, 0x2D, 0x84, 0x3C, 0x82, 0xDF, 0xEE, 0x96, 
	/* 0x408 */ 0x57, 0x05, 0xBA, 0x2C, 0xBB, 0xF7, 0xC4, 0xB7, 
	/* 0x410 */ 0xC7, 0x4E, 0x3B, 0x82, 0xBE, 0x31, 0xC8, 0x22, 
	/* 0x418 */ 0x73, 0x73, 0x92, 0xD1, 0xC2, 0x80, 0xA4, 0x39, 
	/* 0x420 */ 0x39, 0x10, 0x33, 0x23, 0x82, 0x4C, 0x3C, 0x9F, 
	/* 0x428 */ 0x86, 0xB2, 0x55, 0x98, 0x1D, 0xBE, 0x29, 0x86, 
	/* 0x430 */ 0x8C, 0x22, 0x9B, 0x9E, 0xE2, 0x6B, 0x3B, 0x57, 
	/* 0x438 */ 0x3A, 0x82, 0x70, 0x4D, 0xDC, 0x09, 0xC7, 0x89, 
	/* 0x440 */ 0xCB, 0x0A, 0x07, 0x4D, 0x6C, 0xE8, 0x5D, 0x8E, 
	/* 0x448 */ 0xC9, 0xEF, 0xCE, 0xAB, 0xC7, 0xBB, 0xB5, 0x2B, 
	/* 0x450 */ 0x4E, 0x45, 0xD6, 0x4A, 0xD0, 0x26, 0xCC, 0xE5, 
	/* 0x458 */ 0x72, 0xCA, 0x08, 0x6A, 0xA5, 0x95, 0xE3, 0x15, 
	/* 0x460 */ 0xA1, 0xF7, 0xA4, 0xED, 0xC9, 0x2C, 0x5F, 0xA5, 
	/* 0x468 */ 0xFB, 0xFF, 0xAC, 0x28, 0x02, 0x2E, 0xBE, 0xD7, 
	/* 0x470 */ 0x7B, 0xBB, 0xE3, 0x71, 0x7B, 0x90, 0x16, 0xD3, 
	/* 0x478 */ 0x07, 0x5E, 0x46, 0x53, 0x7C, 0x37, 0x07, 0x42, 
	/* 0x480 */ 0x8C, 0xD3, 0xC4, 0x96, 0x9C, 0xD5, 0x99, 0xB5, 
	/* 0x488 */ 0x2A, 0xE0, 0x95, 0x1A, 0x80, 0x48, 0xAE, 0x4C, 
	/* 0x490 */ 0x39, 0x07, 0xCE, 0xCC, 0x47, 0xA4, 0x52, 0x95, 
	/* 0x498 */ 0x2B, 0xBA, 0xB8, 0xFB, 0xAD, 0xD2, 0x33, 0x53, 
	/* 0x4a0 */ 0x7D, 0xE5, 0x1D, 0x4D, 0x6D, 0xD5, 0xA1, 0xB1, 
	/* 0x4a8 */ 0xC7, 0x42, 0x6F, 0xE6, 0x40, 0x27, 0x35, 0x5C, 
	/* 0x4b0 */ 0xA3, 0x28, 0xB7, 0x07, 0x8D, 0xE7, 0x8D, 0x33, 
	/* 0x4b8 */ 0x90, 0xE7, 0x23, 0x9F, 0xFB, 0x50, 0x9C, 0x79, 
	/* 0x4c0 */ 0x6C, 0x46, 0xD5, 0xB4, 0x15, 0xB3, 0x96, 0x6E, 
	/* 0x4c8 */ 0x7E, 0x9B, 0x0C, 0x96, 0x3A, 0xB8, 0x52, 0x2D, 
	/* 0x4d0 */ 0x3F, 0xD6, 0x5B, 0xE1, 0xFB, 0x08, 0xC2, 0x84, 
	/* 0x4d8 */ 0xFE, 0x24, 0xA8, 0xA3, 0x89, 0xDA, 0xAC, 0x6A, 
	/* 0x4e0 */ 0xE1, 0x18, 0x2A, 0xB1, 0xA8, 0x43, 0x61, 0x5B, 
	/* 0x4e8 */ 0xD3, 0x1F, 0xDC, 0x3B, 0x8D, 0x76, 0xF2, 0x2D, 
	/* 0x4f0 */ 0xE8, 0x8D, 0x75, 0xDF, 0x17, 0x33, 0x6C, 0x3D, 
	/* 0x4f8 */ 0x53, 0xFB, 0x7B, 0xCB, 0x41, 0x5F, 0xFF, 0xDC, 
	/* 0x500 */ 0xA2, 0xD0, 0x61, 0x38, 0xE1, 0x96, 0xB8, 0xAC, 
	/* 0x508 */ 0x5D, 0x8B, 0x37, 0xD7, 0x75, 0xD5, 0x33, 0xC0, 
	/* 0x510 */ 0x99, 0x11, 0xAE, 0x9D, 0x41, 0xC1, 0x72, 0x75, 
	/* 0x518 */ 0x84, 0xBE, 0x02, 0x41, 0x42, 0x5F, 0x67, 0x24, 
	/* 0x520 */ 0x48, 0x94, 0xD1, 0x9B, 0x27, 0xBE, 0x07, 0x3F, 
	/* 0x528 */ 0xB9, 0xB8, 0x4F, 0x81, 0x74, 0x51, 0xE1, 0x7A, 
	/* 0x530 */ 0xB7, 0xED, 0x9D, 0x23, 0xE2, 0xBE, 0xE0, 0xD5, 
	/* 0x538 */ 0x28, 0x04, 0x13, 0x3C, 0x31, 0x03, 0x9E, 0xDD, 
	/* 0x540 */ 0x7A, 0x6C, 0x8F, 0xC6, 0x07, 0x18, 0xC6, 0x7F, 
	/* 0x548 */ 0xDE, 0x47, 0x8E, 0x3F, 0x28, 0x9E, 0x04, 0x06, 
	/* 0x550 */ 0xCF, 0xA5, 0x54, 0x34, 0x77, 0xBD, 0xEC, 0x89, 
	/* 0x558 */ 0x9B, 0xE9, 0x17, 0x43, 0xDF, 0x5B, 0xDB, 0x5F, 
	/* 0x560 */ 0xFE, 0x8E, 0x1E, 0x57, 0xA2, 0xCD, 0x40, 0x9D, 
	/* 0x568 */ 0x7E, 0x62, 0x22, 0xDA, 0xDE, 0x18, 0x27, 
};
static const lws_ss_x509_t _ss_x509_isrg_root_x1 = {
	.vhost_name = "isrg_root_x1",
	.ca_der = _ss_der_isrg_root_x1,
	.ca_der_len = 1391,
};
static const uint8_t _ss_der_LEX3_isrg_root_x1[] = {
	/* 0x  0 */ 0x30, 0x82, 0x05, 0x8D, 0x30, 0x82, 0x03, 0x75, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x11, 0x00, 
	/* 0x 10 */ 0xD3, 0xB1, 0x72, 0x26, 0x34, 0x23, 0x32, 0xDC, 
	/* 0x 18 */ 0xF4, 0x05, 0x28, 0x51, 0x2A, 0xEC, 0x9C, 0x6A, 
	/* 0x 20 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x 28 */ 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 
	/* 0x 30 */ 0x4F, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 
	/* 0x 38 */ 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x29, 
	/* 0x 40 */ 0x30, 0x27, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 
	/* 0x 48 */ 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 0x65, 
	/* 0x 50 */ 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 
	/* 0x 58 */ 0x74, 0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 0x61, 
	/* 0x 60 */ 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F, 0x75, 
	/* 0x 68 */ 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 
	/* 0x 70 */ 0x04, 0x03, 0x13, 0x0C, 0x49, 0x53, 0x52, 0x47, 
	/* 0x 78 */ 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x58, 0x31, 
	/* 0x 80 */ 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x36, 0x31, 0x30, 
	/* 0x 88 */ 0x30, 0x36, 0x31, 0x35, 0x34, 0x33, 0x35, 0x35, 
	/* 0x 90 */ 0x5A, 0x17, 0x0D, 0x32, 0x31, 0x31, 0x30, 0x30, 
	/* 0x 98 */ 0x36, 0x31, 0x35, 0x34, 0x33, 0x35, 0x35, 0x5A, 
	/* 0x a0 */ 0x30, 0x4A, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 
	/* 0x a8 */ 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 
	/* 0x b0 */ 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 
	/* 0x b8 */ 0x13, 0x0D, 0x4C, 0x65, 0x74, 0x27, 0x73, 0x20, 
	/* 0x c0 */ 0x45, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 0x31, 
	/* 0x c8 */ 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 
	/* 0x d0 */ 0x13, 0x1A, 0x4C, 0x65, 0x74, 0x27, 0x73, 0x20, 
	/* 0x d8 */ 0x45, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 0x20, 
	/* 0x e0 */ 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 
	/* 0x e8 */ 0x79, 0x20, 0x58, 0x33, 0x30, 0x82, 0x01, 0x22, 
	/* 0x f0 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x f8 */ 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 
	/* 0x100 */ 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82, 0x01, 0x0A, 
	/* 0x108 */ 0x02, 0x82, 0x01, 0x01, 0x00, 0x9C, 0xD3, 0x0C, 
	/* 0x110 */ 0xF0, 0x5A, 0xE5, 0x2E, 0x47, 0xB7, 0x72, 0x5D, 
	/* 0x118 */ 0x37, 0x83, 0xB3, 0x68, 0x63, 0x30, 0xEA, 0xD7, 
	/* 0x120 */ 0x35, 0x26, 0x19, 0x25, 0xE1, 0xBD, 0xBE, 0x35, 
	/* 0x128 */ 0xF1, 0x70, 0x92, 0x2F, 0xB7, 0xB8, 0x4B, 0x41, 
	/* 0x130 */ 0x05, 0xAB, 0xA9, 0x9E, 0x35, 0x08, 0x58, 0xEC, 
	/* 0x138 */ 0xB1, 0x2A, 0xC4, 0x68, 0x87, 0x0B, 0xA3, 0xE3, 
	/* 0x140 */ 0x75, 0xE4, 0xE6, 0xF3, 0xA7, 0x62, 0x71, 0xBA, 
	/* 0x148 */ 0x79, 0x81, 0x60, 0x1F, 0xD7, 0x91, 0x9A, 0x9F, 
	/* 0x150 */ 0xF3, 0xD0, 0x78, 0x67, 0x71, 0xC8, 0x69, 0x0E, 
	/* 0x158 */ 0x95, 0x91, 0xCF, 0xFE, 0xE6, 0x99, 0xE9, 0x60, 
	/* 0x160 */ 0x3C, 0x48, 0xCC, 0x7E, 0xCA, 0x4D, 0x77, 0x12, 
	/* 0x168 */ 0x24, 0x9D, 0x47, 0x1B, 0x5A, 0xEB, 0xB9, 0xEC, 
	/* 0x170 */ 0x1E, 0x37, 0x00, 0x1C, 0x9C, 0xAC, 0x7B, 0xA7, 
	/* 0x178 */ 0x05, 0xEA, 0xCE, 0x4A, 0xEB, 0xBD, 0x41, 0xE5, 
	/* 0x180 */ 0x36, 0x98, 0xB9, 0xCB, 0xFD, 0x6D, 0x3C, 0x96, 
	/* 0x188 */ 0x68, 0xDF, 0x23, 0x2A, 0x42, 0x90, 0x0C, 0x86, 
	/* 0x190 */ 0x74, 0x67, 0xC8, 0x7F, 0xA5, 0x9A, 0xB8, 0x52, 
	/* 0x198 */ 0x61, 0x14, 0x13, 0x3F, 0x65, 0xE9, 0x82, 0x87, 
	/* 0x1a0 */ 0xCB, 0xDB, 0xFA, 0x0E, 0x56, 0xF6, 0x86, 0x89, 
	/* 0x1a8 */ 0xF3, 0x85, 0x3F, 0x97, 0x86, 0xAF, 0xB0, 0xDC, 
	/* 0x1b0 */ 0x1A, 0xEF, 0x6B, 0x0D, 0x95, 0x16, 0x7D, 0xC4, 
	/* 0x1b8 */ 0x2B, 0xA0, 0x65, 0xB2, 0x99, 0x04, 0x36, 0x75, 
	/* 0x1c0 */ 0x80, 0x6B, 0xAC, 0x4A, 0xF3, 0x1B, 0x90, 0x49, 
	/* 0x1c8 */ 0x78, 0x2F, 0xA2, 0x96, 0x4F, 0x2A, 0x20, 0x25, 
	/* 0x1d0 */ 0x29, 0x04, 0xC6, 0x74, 0xC0, 0xD0, 0x31, 0xCD, 
	/* 0x1d8 */ 0x8F, 0x31, 0x38, 0x95, 0x16, 0xBA, 0xA8, 0x33, 
	/* 0x1e0 */ 0xB8, 0x43, 0xF1, 0xB1, 0x1F, 0xC3, 0x30, 0x7F, 
	/* 0x1e8 */ 0xA2, 0x79, 0x31, 0x13, 0x3D, 0x2D, 0x36, 0xF8, 
	/* 0x1f0 */ 0xE3, 0xFC, 0xF2, 0x33, 0x6A, 0xB9, 0x39, 0x31, 
	/* 0x1f8 */ 0xC5, 0xAF, 0xC4, 0x8D, 0x0D, 0x1D, 0x64, 0x16, 
	/* 0x200 */ 0x33, 0xAA, 0xFA, 0x84, 0x29, 0xB6, 0xD4, 0x0B, 
	/* 0x208 */ 0xC0, 0xD8, 0x7D, 0xC3, 0x93, 0x02, 0x03, 0x01, 
	/* 0x210 */ 0x00, 0x01, 0xA3, 0x82, 0x01, 0x67, 0x30, 0x82, 
	/* 0x218 */ 0x01, 0x63, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x220 */ 0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 
	/* 0x228 */ 0x01, 0x86, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x230 */ 0x13, 0x01, 0x01, 0xFF, 0x04, 0x08, 0x30, 0x06, 
	/* 0x238 */ 0x01, 0x01, 0xFF, 0x02, 0x01, 0x00, 0x30, 0x54, 
	/* 0x240 */ 0x06, 0x03, 0x55, 0x1D, 0x20, 0x04, 0x4D, 0x30, 
	/* 0x248 */ 0x4B, 0x30, 0x08, 0x06, 0x06, 0x67, 0x81, 0x0C, 
	/* 0x250 */ 0x01, 0x02, 0x01, 0x30, 0x3F, 0x06, 0x0B, 0x2B, 
	/* 0x258 */ 0x06, 0x01, 0x04, 0x01, 0x82, 0xDF, 0x13, 0x01, 
	/* 0x260 */ 0x01, 0x01, 0x30, 0x30, 0x30, 0x2E, 0x06, 0x08, 
	/* 0x268 */ 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x02, 0x01, 
	/* 0x270 */ 0x16, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 
	/* 0x278 */ 0x2F, 0x63, 0x70, 0x73, 0x2E, 0x72, 0x6F, 0x6F, 
	/* 0x280 */ 0x74, 0x2D, 0x78, 0x31, 0x2E, 0x6C, 0x65, 0x74, 
	/* 0x288 */ 0x73, 0x65, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 
	/* 0x290 */ 0x2E, 0x6F, 0x72, 0x67, 0x30, 0x1D, 0x06, 0x03, 
	/* 0x298 */ 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0xA8, 
	/* 0x2a0 */ 0x4A, 0x6A, 0x63, 0x04, 0x7D, 0xDD, 0xBA, 0xE6, 
	/* 0x2a8 */ 0xD1, 0x39, 0xB7, 0xA6, 0x45, 0x65, 0xEF, 0xF3, 
	/* 0x2b0 */ 0xA8, 0xEC, 0xA1, 0x30, 0x33, 0x06, 0x03, 0x55, 
	/* 0x2b8 */ 0x1D, 0x1F, 0x04, 0x2C, 0x30, 0x2A, 0x30, 0x28, 
	/* 0x2c0 */ 0xA0, 0x26, 0xA0, 0x24, 0x86, 0x22, 0x68, 0x74, 
	/* 0x2c8 */ 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x63, 0x72, 0x6C, 
	/* 0x2d0 */ 0x2E, 0x72, 0x6F, 0x6F, 0x74, 0x2D, 0x78, 0x31, 
	/* 0x2d8 */ 0x2E, 0x6C, 0x65, 0x74, 0x73, 0x65, 0x6E, 0x63, 
	/* 0x2e0 */ 0x72, 0x79, 0x70, 0x74, 0x2E, 0x6F, 0x72, 0x67, 
	/* 0x2e8 */ 0x30, 0x72, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 
	/* 0x2f0 */ 0x05, 0x07, 0x01, 0x01, 0x04, 0x66, 0x30, 0x64, 
	/* 0x2f8 */ 0x30, 0x30, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 
	/* 0x300 */ 0x05, 0x07, 0x30, 0x01, 0x86, 0x24, 0x68, 0x74, 
	/* 0x308 */ 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6F, 0x63, 0x73, 
	/* 0x310 */ 0x70, 0x2E, 0x72, 0x6F, 0x6F, 0x74, 0x2D, 0x78, 
	/* 0x318 */ 0x31, 0x2E, 0x6C, 0x65, 0x74, 0x73, 0x65, 0x6E, 
	/* 0x320 */ 0x63, 0x72, 0x79, 0x70, 0x74, 0x2E, 0x6F, 0x72, 
	/* 0x328 */ 0x67, 0x2F, 0x30, 0x30, 0x06, 0x08, 0x2B, 0x06, 
	/* 0x330 */ 0x01, 0x05, 0x05, 0x07, 0x30, 0x02, 0x86, 0x24, 
	/* 0x338 */ 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x63, 
	/* 0x340 */ 0x65, 0x72, 0x74, 0x2E, 0x72, 0x6F, 0x6F, 0x74, 
	/* 0x348 */ 0x2D, 0x78, 0x31, 0x2E, 0x6C, 0x65, 0x74, 0x73, 
	/* 0x350 */ 0x65, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 0x2E, 
	/* 0x358 */ 0x6F, 0x72, 0x67, 0x2F, 0x30, 0x1F, 0x06, 0x03, 
	/* 0x360 */ 0x55, 0x1D, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 
	/* 0x368 */ 0x14, 0x79, 0xB4, 0x59, 0xE6, 0x7B, 0xB6, 0xE5, 
	/* 0x370 */ 0xE4, 0x01, 0x73, 0x80, 0x08, 0x88, 0xC8, 0x1A, 
	/* 0x378 */ 0x58, 0xF6, 0xE9, 0x9B, 0x6E, 0x30, 0x0D, 0x06, 
	/* 0x380 */ 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 
	/* 0x388 */ 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 
	/* 0x390 */ 0x00, 0x19, 0xCF, 0x75, 0x20, 0x34, 0x2D, 0x3A, 
	/* 0x398 */ 0xA6, 0x45, 0xFF, 0xD0, 0xD5, 0xE6, 0x8C, 0xDA, 
	/* 0x3a0 */ 0x32, 0xE8, 0x9C, 0x6E, 0x1B, 0x41, 0xD1, 0x27, 
	/* 0x3a8 */ 0xA8, 0xE2, 0x50, 0xF2, 0x70, 0xAA, 0xC4, 0xE7, 
	/* 0x3b0 */ 0x93, 0x46, 0xB4, 0xE8, 0x10, 0xAB, 0x70, 0x4F, 
	/* 0x3b8 */ 0xEF, 0xB7, 0xEA, 0x04, 0xD2, 0x94, 0x11, 0xB1, 
	/* 0x3c0 */ 0x03, 0xFE, 0x5D, 0xBA, 0xDF, 0x36, 0x8C, 0x94, 
	/* 0x3c8 */ 0x36, 0x8F, 0x13, 0x7C, 0x44, 0x8F, 0x0B, 0xF5, 
	/* 0x3d0 */ 0x01, 0x57, 0xAD, 0x68, 0xB8, 0xC5, 0x79, 0xC0, 
	/* 0x3d8 */ 0xD8, 0x4A, 0x80, 0xD7, 0x4C, 0xA3, 0x1E, 0x24, 
	/* 0x3e0 */ 0x7A, 0x1F, 0xD7, 0x23, 0xE8, 0xC1, 0x62, 0x3A, 
	/* 0x3e8 */ 0x76, 0xF9, 0x22, 0x7D, 0x5E, 0x5A, 0xC4, 0x4C, 
	/* 0x3f0 */ 0x50, 0xCD, 0xAF, 0xDD, 0xEF, 0x6D, 0x36, 0xC0, 
	/* 0x3f8 */ 0x80, 0x80, 0x1B, 0xA4, 0x3C, 0x70, 0x20, 0xD6, 
	/* 0x400 */ 0x54, 0x21, 0xD3, 0xBA, 0xEF, 0x14, 0xA9, 0xBF, 
	/* 0x408 */ 0x07, 0x3F, 0x41, 0x0A, 0x36, 0xB1, 0xA2, 0xB0, 
	/* 0x410 */ 0x0B, 0x20, 0xD5, 0x1F, 0x67, 0xD0, 0xC3, 0xEB, 
	/* 0x418 */ 0x88, 0xF6, 0x8A, 0x02, 0xC8, 0xC6, 0x57, 0xB6, 
	/* 0x420 */ 0x0C, 0xFC, 0x56, 0xF1, 0xD2, 0x3F, 0x17, 0x69, 
	/* 0x428 */ 0x68, 0x1C, 0xC8, 0xD7, 0x66, 0x3A, 0x86, 0xF1, 
	/* 0x430 */ 0x19, 0x2A, 0x65, 0x47, 0x68, 0xC6, 0xD2, 0x03, 
	/* 0x438 */ 0xE7, 0xEF, 0x74, 0x16, 0x0B, 0x06, 0x21, 0xF9, 
	/* 0x440 */ 0x0C, 0xA6, 0xA8, 0x11, 0x4B, 0x4E, 0x5F, 0xE3, 
	/* 0x448 */ 0x33, 0xDB, 0x08, 0x41, 0xEA, 0x09, 0x79, 0x75, 
	/* 0x450 */ 0x78, 0xEE, 0x47, 0xC8, 0x42, 0xD3, 0x81, 0xC5, 
	/* 0x458 */ 0x65, 0x2D, 0x75, 0xD0, 0x0E, 0x00, 0x16, 0x9D, 
	/* 0x460 */ 0x1C, 0xEE, 0xB7, 0x58, 0x45, 0x25, 0xE7, 0x33, 
	/* 0x468 */ 0x63, 0x5B, 0x63, 0x41, 0x09, 0xE8, 0xE9, 0xFE, 
	/* 0x470 */ 0xAC, 0xFA, 0x73, 0x32, 0x74, 0xB3, 0x76, 0xE9, 
	/* 0x478 */ 0x6B, 0x94, 0xE2, 0xCD, 0xD4, 0x62, 0xF3, 0xAE, 
	/* 0x480 */ 0x3A, 0xC5, 0x31, 0x46, 0x52, 0x6E, 0xED, 0x34, 
	/* 0x488 */ 0x91, 0x1E, 0xA0, 0xC2, 0xDE, 0x54, 0x84, 0xE5, 
	/* 0x490 */ 0x78, 0x20, 0x56, 0x4C, 0xDD, 0x68, 0xF9, 0x2E, 
	/* 0x498 */ 0x28, 0x64, 0x1B, 0x1A, 0x99, 0xF2, 0xFB, 0x4D, 
	/* 0x4a0 */ 0x7F, 0xE3, 0xB8, 0x5F, 0x5D, 0x73, 0x41, 0xEC, 
	/* 0x4a8 */ 0x79, 0xED, 0x58, 0xD6, 0x7A, 0x37, 0x65, 0x70, 
	/* 0x4b0 */ 0xA7, 0xB1, 0xBA, 0x39, 0xF6, 0x3E, 0x61, 0x0A, 
	/* 0x4b8 */ 0xD9, 0xC0, 0x86, 0x90, 0x9A, 0x1A, 0xC8, 0xA8, 
	/* 0x4c0 */ 0x96, 0x6E, 0x8A, 0x0B, 0x2B, 0x6D, 0xED, 0xD6, 
	/* 0x4c8 */ 0xFA, 0x07, 0x67, 0xE7, 0x29, 0x04, 0xF7, 0xE2, 
	/* 0x4d0 */ 0xB2, 0xD1, 0x58, 0x15, 0x52, 0xC7, 0xF1, 0xA3, 
	/* 0x4d8 */ 0x9D, 0xA6, 0xC0, 0x56, 0x2C, 0xD4, 0x92, 0x98, 
	/* 0x4e0 */ 0xD8, 0xF1, 0x83, 0xB9, 0x6C, 0x7C, 0x33, 0xA0, 
	/* 0x4e8 */ 0xE5, 0x4B, 0xAA, 0x90, 0x92, 0xF1, 0xDA, 0x45, 
	/* 0x4f0 */ 0x4A, 0x34, 0x14, 0xC7, 0x7C, 0x4E, 0xC4, 0xA5, 
	/* 0x4f8 */ 0x6C, 0x5D, 0x3F, 0xBF, 0xDE, 0xB9, 0xA8, 0x61, 
	/* 0x500 */ 0x4A, 0x85, 0x20, 0xDE, 0x42, 0x83, 0x29, 0x62, 
	/* 0x508 */ 0x7C, 0x1C, 0x99, 0x08, 0xA5, 0x46, 0x1F, 0xF4, 
	/* 0x510 */ 0x6B, 0x22, 0xD3, 0x86, 0x51, 0xCB, 0x37, 0xCD, 
	/* 0x518 */ 0x60, 0x4A, 0x42, 0x63, 0x56, 0xB3, 0xC8, 0xD1, 
	/* 0x520 */ 0x8F, 0x31, 0x09, 0x53, 0xC1, 0xE2, 0xDC, 0x1B, 
	/* 0x528 */ 0xD4, 0xF1, 0x54, 0x77, 0x67, 0xCF, 0x33, 0x7B, 
	/* 0x530 */ 0x00, 0xD6, 0xD2, 0x7C, 0xDE, 0xC6, 0x79, 0xBF, 
	/* 0x538 */ 0xCB, 0xE0, 0x16, 0xFD, 0xB2, 0xA1, 0xF2, 0x91, 
	/* 0x540 */ 0x3C, 0x1D, 0x2D, 0xE8, 0x9C, 0xD4, 0x03, 0xCD, 
	/* 0x548 */ 0x66, 0x4A, 0xA3, 0x37, 0x93, 0x19, 0x79, 0x7B, 
	/* 0x550 */ 0xE2, 0x19, 0xC2, 0x16, 0x00, 0xC8, 0xED, 0x0E, 
	/* 0x558 */ 0x4E, 0x0D, 0xFF, 0x7E, 0xCF, 0x07, 0xA8, 0x64, 
	/* 0x560 */ 0xCD, 0x29, 0xDF, 0x41, 0xAA, 0x85, 0x30, 0x49, 
	/* 0x568 */ 0x10, 0x73, 0xA7, 0x4E, 0x89, 0x32, 0x0E, 0x5B, 
	/* 0x570 */ 0xAD, 0x40, 0x86, 0xC1, 0xB0, 0x94, 0x0C, 0x8D, 
	/* 0x578 */ 0x26, 0xC5, 0xA7, 0x49, 0xDC, 0x1C, 0xF8, 0x5B, 
	/* 0x580 */ 0x14, 0x7A, 0x7F, 0x23, 0x69, 0x04, 0xAD, 0xB2, 
	/* 0x588 */ 0x02, 0x29, 0xD6, 0x12, 0xC8, 0xA4, 0xC6, 0xA1, 
	/* 0x590 */ 0x2D, 
};
static const lws_ss_x509_t _ss_x509_LEX3_isrg_root_x1 = {
	.vhost_name = "LEX3_isrg_root_x1",
	.ca_der = _ss_der_LEX3_isrg_root_x1,
	.ca_der_len = 1425,
};
static const lws_ss_trust_store_t _ss_ts_le_via_isrg = {
	.name = "le_via_isrg",
	.ssx509 = {
		&_ss_x509_LEX3_isrg_root_x1,
		&_ss_x509_isrg_root_x1,
	}
};

static const lws_ss_metadata_t _md_mintest_xctype = {
	.name = "xctype",
	.value__may_own_heap = (void *)"X-Content-Type:",
	.length = 0,
},
_md_mintest_ctype = {
	.next = (void *)&_md_mintest_xctype, 
	.name = "ctype",
	.value__may_own_heap = (void *)"Content-Type:",
	.length = 1,
},
_md_mintest_uptag = {
	.next = (void *)&_md_mintest_ctype, 
	.name = "uptag",
	.value__may_own_heap = (void *)"X-Upload-Tag:",
	.length = 2,
};

static const lws_ss_trust_store_t _ss_ts_avs_via_starfield = {
	.name = "avs_via_starfield",
	.ssx509 = {
		&_ss_x509_starfield_services_root_ca,
		&_ss_x509_starfield_class_2_ca,
	}
};
static const uint8_t _ss_der_digicert_global_ca_g2[] = {
	/* 0x  0 */ 0x30, 0x82, 0x04, 0x8B, 0x30, 0x82, 0x03, 0x73, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0x0C, 
	/* 0x 10 */ 0x8E, 0xE0, 0xC9, 0x0D, 0x6A, 0x89, 0x15, 0x88, 
	/* 0x 18 */ 0x04, 0x06, 0x1E, 0xE2, 0x41, 0xF9, 0xAF, 0x30, 
	/* 0x 20 */ 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
	/* 0x 28 */ 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 0x61, 
	/* 0x 30 */ 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 
	/* 0x 38 */ 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x15, 0x30, 
	/* 0x 40 */ 0x13, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0C, 
	/* 0x 48 */ 0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 0x72, 0x74, 
	/* 0x 50 */ 0x20, 0x49, 0x6E, 0x63, 0x31, 0x19, 0x30, 0x17, 
	/* 0x 58 */ 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x10, 0x77, 
	/* 0x 60 */ 0x77, 0x77, 0x2E, 0x64, 0x69, 0x67, 0x69, 0x63, 
	/* 0x 68 */ 0x65, 0x72, 0x74, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 
	/* 0x 70 */ 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55, 0x04, 0x03, 
	/* 0x 78 */ 0x13, 0x17, 0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 
	/* 0x 80 */ 0x72, 0x74, 0x20, 0x47, 0x6C, 0x6F, 0x62, 0x61, 
	/* 0x 88 */ 0x6C, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x47, 
	/* 0x 90 */ 0x32, 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x33, 0x30, 
	/* 0x 98 */ 0x38, 0x30, 0x31, 0x31, 0x32, 0x30, 0x30, 0x30, 
	/* 0x a0 */ 0x30, 0x5A, 0x17, 0x0D, 0x32, 0x38, 0x30, 0x38, 
	/* 0x a8 */ 0x30, 0x31, 0x31, 0x32, 0x30, 0x30, 0x30, 0x30, 
	/* 0x b0 */ 0x5A, 0x30, 0x44, 0x31, 0x0B, 0x30, 0x09, 0x06, 
	/* 0x b8 */ 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 
	/* 0x c0 */ 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 
	/* 0x c8 */ 0x0A, 0x13, 0x0C, 0x44, 0x69, 0x67, 0x69, 0x43, 
	/* 0x d0 */ 0x65, 0x72, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x31, 
	/* 0x d8 */ 0x1E, 0x30, 0x1C, 0x06, 0x03, 0x55, 0x04, 0x03, 
	/* 0x e0 */ 0x13, 0x15, 0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 
	/* 0x e8 */ 0x72, 0x74, 0x20, 0x47, 0x6C, 0x6F, 0x62, 0x61, 
	/* 0x f0 */ 0x6C, 0x20, 0x43, 0x41, 0x20, 0x47, 0x32, 0x30, 
	/* 0x f8 */ 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
	/* 0x100 */ 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 
	/* 0x108 */ 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 
	/* 0x110 */ 0x82, 0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 
	/* 0x118 */ 0xD3, 0x48, 0x7C, 0xBE, 0xF3, 0x05, 0x86, 0x5D, 
	/* 0x120 */ 0x5B, 0xD5, 0x2F, 0x85, 0x4E, 0x4B, 0xE0, 0x86, 
	/* 0x128 */ 0xAD, 0x15, 0xAC, 0x61, 0xCF, 0x5B, 0xAF, 0x3E, 
	/* 0x130 */ 0x6A, 0x0A, 0x47, 0xFB, 0x9A, 0x76, 0x91, 0x60, 
	/* 0x138 */ 0x0B, 0x8A, 0x6B, 0xCD, 0xCF, 0xDC, 0x57, 0x7E, 
	/* 0x140 */ 0x60, 0x98, 0x0B, 0xE4, 0x54, 0xD9, 0x56, 0xED, 
	/* 0x148 */ 0x21, 0xCC, 0x02, 0xB6, 0x5A, 0x81, 0x5F, 0x97, 
	/* 0x150 */ 0x6A, 0xEE, 0x02, 0x2F, 0x23, 0x27, 0xB8, 0x6D, 
	/* 0x158 */ 0xD4, 0xB0, 0xE7, 0x06, 0x02, 0x78, 0x0B, 0x1F, 
	/* 0x160 */ 0x5C, 0xA9, 0x99, 0x36, 0xFE, 0xBB, 0xAC, 0x1B, 
	/* 0x168 */ 0x05, 0xFA, 0x57, 0xCD, 0x81, 0x10, 0x40, 0x67, 
	/* 0x170 */ 0xD6, 0x30, 0x8B, 0x58, 0x35, 0xD4, 0x96, 0x61, 
	/* 0x178 */ 0xBE, 0xD0, 0x8C, 0x7A, 0x97, 0x9F, 0x1A, 0xF9, 
	/* 0x180 */ 0x22, 0xE6, 0x14, 0x2F, 0xA9, 0xC6, 0xE8, 0x01, 
	/* 0x188 */ 0x1F, 0xAB, 0xF8, 0x26, 0x0F, 0xAC, 0x8E, 0x4D, 
	/* 0x190 */ 0x2C, 0x32, 0x39, 0x1D, 0x81, 0x9B, 0x8D, 0x1C, 
	/* 0x198 */ 0x65, 0xB2, 0x1C, 0xDB, 0x61, 0xA8, 0x89, 0x2F, 
	/* 0x1a0 */ 0x60, 0xE7, 0xEB, 0xC2, 0x4A, 0x18, 0xC4, 0x6F, 
	/* 0x1a8 */ 0x2A, 0xE9, 0x10, 0x92, 0x09, 0xED, 0x17, 0xD1, 
	/* 0x1b0 */ 0x00, 0x2B, 0xE6, 0x7D, 0xEF, 0x04, 0x89, 0x14, 
	/* 0x1b8 */ 0x4E, 0x33, 0xA1, 0xB2, 0x0F, 0x97, 0x87, 0x9F, 
	/* 0x1c0 */ 0xB3, 0xA0, 0xCD, 0x2F, 0xBC, 0x2C, 0xEC, 0xB8, 
	/* 0x1c8 */ 0x83, 0x68, 0x31, 0x3D, 0x1F, 0xD5, 0x4A, 0x90, 
	/* 0x1d0 */ 0x10, 0x19, 0x0B, 0x81, 0x95, 0xD6, 0x29, 0x76, 
	/* 0x1d8 */ 0x51, 0xF9, 0x36, 0x76, 0xD0, 0xB7, 0x09, 0x7A, 
	/* 0x1e0 */ 0x38, 0x4A, 0xD7, 0x6F, 0x8C, 0xBF, 0x13, 0x7C, 
	/* 0x1e8 */ 0x39, 0xED, 0xBA, 0xAE, 0x90, 0xFC, 0x95, 0xF7, 
	/* 0x1f0 */ 0x7B, 0x78, 0x09, 0x36, 0x5E, 0x74, 0x93, 0x1E, 
	/* 0x1f8 */ 0x25, 0xF0, 0xFF, 0xD4, 0xAD, 0xAE, 0x68, 0x6B, 
	/* 0x200 */ 0xC6, 0xFF, 0x0F, 0xD5, 0x35, 0xF1, 0x55, 0x6E, 
	/* 0x208 */ 0x48, 0x49, 0xF8, 0xF8, 0xB8, 0xEF, 0x88, 0xF8, 
	/* 0x210 */ 0xF1, 0x5E, 0x11, 0x77, 0xAA, 0xDF, 0x02, 0xB3, 
	/* 0x218 */ 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x82, 0x01, 
	/* 0x220 */ 0x5A, 0x30, 0x82, 0x01, 0x56, 0x30, 0x12, 0x06, 
	/* 0x228 */ 0x03, 0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 
	/* 0x230 */ 0x08, 0x30, 0x06, 0x01, 0x01, 0xFF, 0x02, 0x01, 
	/* 0x238 */ 0x00, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 
	/* 0x240 */ 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 0x01, 
	/* 0x248 */ 0x86, 0x30, 0x34, 0x06, 0x08, 0x2B, 0x06, 0x01, 
	/* 0x250 */ 0x05, 0x05, 0x07, 0x01, 0x01, 0x04, 0x28, 0x30, 
	/* 0x258 */ 0x26, 0x30, 0x24, 0x06, 0x08, 0x2B, 0x06, 0x01, 
	/* 0x260 */ 0x05, 0x05, 0x07, 0x30, 0x01, 0x86, 0x18, 0x68, 
	/* 0x268 */ 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6F, 0x63, 
	/* 0x270 */ 0x73, 0x70, 0x2E, 0x64, 0x69, 0x67, 0x69, 0x63, 
	/* 0x278 */ 0x65, 0x72, 0x74, 0x2E, 0x63, 0x6F, 0x6D, 0x30, 
	/* 0x280 */ 0x7B, 0x06, 0x03, 0x55, 0x1D, 0x1F, 0x04, 0x74, 
	/* 0x288 */ 0x30, 0x72, 0x30, 0x37, 0xA0, 0x35, 0xA0, 0x33, 
	/* 0x290 */ 0x86, 0x31, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 
	/* 0x298 */ 0x2F, 0x63, 0x72, 0x6C, 0x34, 0x2E, 0x64, 0x69, 
	/* 0x2a0 */ 0x67, 0x69, 0x63, 0x65, 0x72, 0x74, 0x2E, 0x63, 
	/* 0x2a8 */ 0x6F, 0x6D, 0x2F, 0x44, 0x69, 0x67, 0x69, 0x43, 
	/* 0x2b0 */ 0x65, 0x72, 0x74, 0x47, 0x6C, 0x6F, 0x62, 0x61, 
	/* 0x2b8 */ 0x6C, 0x52, 0x6F, 0x6F, 0x74, 0x47, 0x32, 0x2E, 
	/* 0x2c0 */ 0x63, 0x72, 0x6C, 0x30, 0x37, 0xA0, 0x35, 0xA0, 
	/* 0x2c8 */ 0x33, 0x86, 0x31, 0x68, 0x74, 0x74, 0x70, 0x3A, 
	/* 0x2d0 */ 0x2F, 0x2F, 0x63, 0x72, 0x6C, 0x33, 0x2E, 0x64, 
	/* 0x2d8 */ 0x69, 0x67, 0x69, 0x63, 0x65, 0x72, 0x74, 0x2E, 
	/* 0x2e0 */ 0x63, 0x6F, 0x6D, 0x2F, 0x44, 0x69, 0x67, 0x69, 
	/* 0x2e8 */ 0x43, 0x65, 0x72, 0x74, 0x47, 0x6C, 0x6F, 0x62, 
	/* 0x2f0 */ 0x61, 0x6C, 0x52, 0x6F, 0x6F, 0x74, 0x47, 0x32, 
	/* 0x2f8 */ 0x2E, 0x63, 0x72, 0x6C, 0x30, 0x3D, 0x06, 0x03, 
	/* 0x300 */ 0x55, 0x1D, 0x20, 0x04, 0x36, 0x30, 0x34, 0x30, 
	/* 0x308 */ 0x32, 0x06, 0x04, 0x55, 0x1D, 0x20, 0x00, 0x30, 
	/* 0x310 */ 0x2A, 0x30, 0x28, 0x06, 0x08, 0x2B, 0x06, 0x01, 
	/* 0x318 */ 0x05, 0x05, 0x07, 0x02, 0x01, 0x16, 0x1C, 0x68, 
	/* 0x320 */ 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x77, 
	/* 0x328 */ 0x77, 0x77, 0x2E, 0x64, 0x69, 0x67, 0x69, 0x63, 
	/* 0x330 */ 0x65, 0x72, 0x74, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 
	/* 0x338 */ 0x43, 0x50, 0x53, 0x30, 0x1D, 0x06, 0x03, 0x55, 
	/* 0x340 */ 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x24, 0x6E, 
	/* 0x348 */ 0x2B, 0x2D, 0xD0, 0x6A, 0x92, 0x51, 0x51, 0x25, 
	/* 0x350 */ 0x69, 0x01, 0xAA, 0x9A, 0x47, 0xA6, 0x89, 0xE7, 
	/* 0x358 */ 0x40, 0x20, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x360 */ 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x4E, 
	/* 0x368 */ 0x22, 0x54, 0x20, 0x18, 0x95, 0xE6, 0xE3, 0x6E, 
	/* 0x370 */ 0xE6, 0x0F, 0xFA, 0xFA, 0xB9, 0x12, 0xED, 0x06, 
	/* 0x378 */ 0x17, 0x8F, 0x39, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
	/* 0x380 */ 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 
	/* 0x388 */ 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x0B, 
	/* 0x390 */ 0x39, 0x84, 0x91, 0xF9, 0x97, 0xEB, 0xAA, 0x81, 
	/* 0x398 */ 0xAF, 0x84, 0xE9, 0x5A, 0x38, 0x92, 0xFC, 0xE2, 
	/* 0x3a0 */ 0x6C, 0x59, 0xBF, 0x36, 0xC8, 0x45, 0xA7, 0x31, 
	/* 0x3a8 */ 0x03, 0x11, 0xE1, 0x06, 0xC0, 0xAC, 0x32, 0xC7, 
	/* 0x3b0 */ 0x5A, 0x55, 0x29, 0xDA, 0x4F, 0x40, 0x02, 0xF5, 
	/* 0x3b8 */ 0xA1, 0xDE, 0xB0, 0xED, 0xDE, 0xC0, 0xF8, 0xF6, 
	/* 0x3c0 */ 0x75, 0x9D, 0x76, 0xB9, 0x87, 0xFE, 0x41, 0x80, 
	/* 0x3c8 */ 0x7A, 0xCF, 0x5D, 0xE3, 0x00, 0xC6, 0x5B, 0x02, 
	/* 0x3d0 */ 0xE6, 0x9B, 0x78, 0x62, 0xC9, 0xDC, 0xB8, 0x62, 
	/* 0x3d8 */ 0x9A, 0x77, 0xED, 0x89, 0x08, 0xD7, 0x4B, 0xC5, 
	/* 0x3e0 */ 0xFD, 0x43, 0xD5, 0x62, 0x23, 0x27, 0xC4, 0x04, 
	/* 0x3e8 */ 0x59, 0x6D, 0x71, 0x3F, 0x23, 0x5B, 0xEA, 0xD9, 
	/* 0x3f0 */ 0xF2, 0xE7, 0x24, 0x27, 0x6F, 0xF4, 0x95, 0x80, 
	/* 0x3f8 */ 0xDB, 0x96, 0x2C, 0xE4, 0x54, 0x8B, 0xCF, 0xEA, 
	/* 0x400 */ 0x19, 0xD9, 0x7F, 0x55, 0x99, 0x51, 0x7A, 0x0E, 
	/* 0x408 */ 0x2D, 0x18, 0x3D, 0x78, 0x58, 0x52, 0xBC, 0x63, 
	/* 0x410 */ 0x68, 0x57, 0x0B, 0xDD, 0x44, 0xB3, 0x57, 0x4A, 
	/* 0x418 */ 0x60, 0xE6, 0xC8, 0x70, 0x70, 0x5B, 0x87, 0x28, 
	/* 0x420 */ 0x6A, 0xD7, 0x3B, 0x4E, 0x52, 0x45, 0x19, 0xAF, 
	/* 0x428 */ 0x24, 0x06, 0x92, 0x48, 0x11, 0x1A, 0x8B, 0xAE, 
	/* 0x430 */ 0xAC, 0x18, 0x12, 0x57, 0xAC, 0x03, 0xCB, 0xB8, 
	/* 0x438 */ 0xF4, 0xBD, 0xCA, 0x26, 0x0E, 0xA7, 0xC1, 0xDD, 
	/* 0x440 */ 0xE3, 0x33, 0xEF, 0xC0, 0x55, 0x30, 0x0D, 0x95, 
	/* 0x448 */ 0x59, 0x4E, 0x9C, 0x03, 0x36, 0x06, 0xF8, 0xC0, 
	/* 0x450 */ 0x8F, 0x14, 0x99, 0x9C, 0x4D, 0x2A, 0x9E, 0xC1, 
	/* 0x458 */ 0xE1, 0x7D, 0x3B, 0xAF, 0x72, 0xA7, 0x45, 0xBA, 
	/* 0x460 */ 0x13, 0x96, 0x29, 0x4E, 0x19, 0xD0, 0x1A, 0x98, 
	/* 0x468 */ 0x06, 0xF4, 0x37, 0x94, 0x17, 0xAD, 0xA3, 0x18, 
	/* 0x470 */ 0xBA, 0x3E, 0xB0, 0x01, 0x0C, 0x95, 0xD6, 0x29, 
	/* 0x478 */ 0x35, 0x20, 0x35, 0x7D, 0xF5, 0x10, 0x60, 0xE4, 
	/* 0x480 */ 0xF7, 0x68, 0x62, 0x1E, 0xEC, 0x19, 0xE1, 0x24, 
	/* 0x488 */ 0xF2, 0x87, 0x11, 0xAC, 0xE9, 0x08, 0x80, 
};
static const lws_ss_x509_t _ss_x509_digicert_global_ca_g2 = {
	.vhost_name = "digicert_global_ca_g2",
	.ca_der = _ss_der_digicert_global_ca_g2,
	.ca_der_len = 1167,
};
static const uint8_t _ss_der_digicert_global_root_g2[] = {
	/* 0x  0 */ 0x30, 0x82, 0x03, 0x8E, 0x30, 0x82, 0x02, 0x76, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0x03, 
	/* 0x 10 */ 0x3A, 0xF1, 0xE6, 0xA7, 0x11, 0xA9, 0xA0, 0xBB, 
	/* 0x 18 */ 0x28, 0x64, 0xB1, 0x1D, 0x09, 0xFA, 0xE5, 0x30, 
	/* 0x 20 */ 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
	/* 0x 28 */ 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 0x61, 
	/* 0x 30 */ 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 
	/* 0x 38 */ 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x15, 0x30, 
	/* 0x 40 */ 0x13, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0C, 
	/* 0x 48 */ 0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 0x72, 0x74, 
	/* 0x 50 */ 0x20, 0x49, 0x6E, 0x63, 0x31, 0x19, 0x30, 0x17, 
	/* 0x 58 */ 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x10, 0x77, 
	/* 0x 60 */ 0x77, 0x77, 0x2E, 0x64, 0x69, 0x67, 0x69, 0x63, 
	/* 0x 68 */ 0x65, 0x72, 0x74, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 
	/* 0x 70 */ 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55, 0x04, 0x03, 
	/* 0x 78 */ 0x13, 0x17, 0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 
	/* 0x 80 */ 0x72, 0x74, 0x20, 0x47, 0x6C, 0x6F, 0x62, 0x61, 
	/* 0x 88 */ 0x6C, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x47, 
	/* 0x 90 */ 0x32, 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x33, 0x30, 
	/* 0x 98 */ 0x38, 0x30, 0x31, 0x31, 0x32, 0x30, 0x30, 0x30, 
	/* 0x a0 */ 0x30, 0x5A, 0x17, 0x0D, 0x33, 0x38, 0x30, 0x31, 
	/* 0x a8 */ 0x31, 0x35, 0x31, 0x32, 0x30, 0x30, 0x30, 0x30, 
	/* 0x b0 */ 0x5A, 0x30, 0x61, 0x31, 0x0B, 0x30, 0x09, 0x06, 
	/* 0x b8 */ 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 
	/* 0x c0 */ 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 
	/* 0x c8 */ 0x0A, 0x13, 0x0C, 0x44, 0x69, 0x67, 0x69, 0x43, 
	/* 0x d0 */ 0x65, 0x72, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x31, 
	/* 0x d8 */ 0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x0B, 
	/* 0x e0 */ 0x13, 0x10, 0x77, 0x77, 0x77, 0x2E, 0x64, 0x69, 
	/* 0x e8 */ 0x67, 0x69, 0x63, 0x65, 0x72, 0x74, 0x2E, 0x63, 
	/* 0x f0 */ 0x6F, 0x6D, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 
	/* 0x f8 */ 0x55, 0x04, 0x03, 0x13, 0x17, 0x44, 0x69, 0x67, 
	/* 0x100 */ 0x69, 0x43, 0x65, 0x72, 0x74, 0x20, 0x47, 0x6C, 
	/* 0x108 */ 0x6F, 0x62, 0x61, 0x6C, 0x20, 0x52, 0x6F, 0x6F, 
	/* 0x110 */ 0x74, 0x20, 0x47, 0x32, 0x30, 0x82, 0x01, 0x22, 
	/* 0x118 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x120 */ 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 
	/* 0x128 */ 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82, 0x01, 0x0A, 
	/* 0x130 */ 0x02, 0x82, 0x01, 0x01, 0x00, 0xBB, 0x37, 0xCD, 
	/* 0x138 */ 0x34, 0xDC, 0x7B, 0x6B, 0xC9, 0xB2, 0x68, 0x90, 
	/* 0x140 */ 0xAD, 0x4A, 0x75, 0xFF, 0x46, 0xBA, 0x21, 0x0A, 
	/* 0x148 */ 0x08, 0x8D, 0xF5, 0x19, 0x54, 0xC9, 0xFB, 0x88, 
	/* 0x150 */ 0xDB, 0xF3, 0xAE, 0xF2, 0x3A, 0x89, 0x91, 0x3C, 
	/* 0x158 */ 0x7A, 0xE6, 0xAB, 0x06, 0x1A, 0x6B, 0xCF, 0xAC, 
	/* 0x160 */ 0x2D, 0xE8, 0x5E, 0x09, 0x24, 0x44, 0xBA, 0x62, 
	/* 0x168 */ 0x9A, 0x7E, 0xD6, 0xA3, 0xA8, 0x7E, 0xE0, 0x54, 
	/* 0x170 */ 0x75, 0x20, 0x05, 0xAC, 0x50, 0xB7, 0x9C, 0x63, 
	/* 0x178 */ 0x1A, 0x6C, 0x30, 0xDC, 0xDA, 0x1F, 0x19, 0xB1, 
	/* 0x180 */ 0xD7, 0x1E, 0xDE, 0xFD, 0xD7, 0xE0, 0xCB, 0x94, 
	/* 0x188 */ 0x83, 0x37, 0xAE, 0xEC, 0x1F, 0x43, 0x4E, 0xDD, 
	/* 0x190 */ 0x7B, 0x2C, 0xD2, 0xBD, 0x2E, 0xA5, 0x2F, 0xE4, 
	/* 0x198 */ 0xA9, 0xB8, 0xAD, 0x3A, 0xD4, 0x99, 0xA4, 0xB6, 
	/* 0x1a0 */ 0x25, 0xE9, 0x9B, 0x6B, 0x00, 0x60, 0x92, 0x60, 
	/* 0x1a8 */ 0xFF, 0x4F, 0x21, 0x49, 0x18, 0xF7, 0x67, 0x90, 
	/* 0x1b0 */ 0xAB, 0x61, 0x06, 0x9C, 0x8F, 0xF2, 0xBA, 0xE9, 
	/* 0x1b8 */ 0xB4, 0xE9, 0x92, 0x32, 0x6B, 0xB5, 0xF3, 0x57, 
	/* 0x1c0 */ 0xE8, 0x5D, 0x1B, 0xCD, 0x8C, 0x1D, 0xAB, 0x95, 
	/* 0x1c8 */ 0x04, 0x95, 0x49, 0xF3, 0x35, 0x2D, 0x96, 0xE3, 
	/* 0x1d0 */ 0x49, 0x6D, 0xDD, 0x77, 0xE3, 0xFB, 0x49, 0x4B, 
	/* 0x1d8 */ 0xB4, 0xAC, 0x55, 0x07, 0xA9, 0x8F, 0x95, 0xB3, 
	/* 0x1e0 */ 0xB4, 0x23, 0xBB, 0x4C, 0x6D, 0x45, 0xF0, 0xF6, 
	/* 0x1e8 */ 0xA9, 0xB2, 0x95, 0x30, 0xB4, 0xFD, 0x4C, 0x55, 
	/* 0x1f0 */ 0x8C, 0x27, 0x4A, 0x57, 0x14, 0x7C, 0x82, 0x9D, 
	/* 0x1f8 */ 0xCD, 0x73, 0x92, 0xD3, 0x16, 0x4A, 0x06, 0x0C, 
	/* 0x200 */ 0x8C, 0x50, 0xD1, 0x8F, 0x1E, 0x09, 0xBE, 0x17, 
	/* 0x208 */ 0xA1, 0xE6, 0x21, 0xCA, 0xFD, 0x83, 0xE5, 0x10, 
	/* 0x210 */ 0xBC, 0x83, 0xA5, 0x0A, 0xC4, 0x67, 0x28, 0xF6, 
	/* 0x218 */ 0x73, 0x14, 0x14, 0x3D, 0x46, 0x76, 0xC3, 0x87, 
	/* 0x220 */ 0x14, 0x89, 0x21, 0x34, 0x4D, 0xAF, 0x0F, 0x45, 
	/* 0x228 */ 0x0C, 0xA6, 0x49, 0xA1, 0xBA, 0xBB, 0x9C, 0xC5, 
	/* 0x230 */ 0xB1, 0x33, 0x83, 0x29, 0x85, 0x02, 0x03, 0x01, 
	/* 0x238 */ 0x00, 0x01, 0xA3, 0x42, 0x30, 0x40, 0x30, 0x0F, 
	/* 0x240 */ 0x06, 0x03, 0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 
	/* 0x248 */ 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xFF, 0x30, 
	/* 0x250 */ 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x01, 0x01, 
	/* 0x258 */ 0xFF, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86, 0x30, 
	/* 0x260 */ 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 
	/* 0x268 */ 0x04, 0x14, 0x4E, 0x22, 0x54, 0x20, 0x18, 0x95, 
	/* 0x270 */ 0xE6, 0xE3, 0x6E, 0xE6, 0x0F, 0xFA, 0xFA, 0xB9, 
	/* 0x278 */ 0x12, 0xED, 0x06, 0x17, 0x8F, 0x39, 0x30, 0x0D, 
	/* 0x280 */ 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
	/* 0x288 */ 0x01, 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 0x01, 
	/* 0x290 */ 0x01, 0x00, 0x60, 0x67, 0x28, 0x94, 0x6F, 0x0E, 
	/* 0x298 */ 0x48, 0x63, 0xEB, 0x31, 0xDD, 0xEA, 0x67, 0x18, 
	/* 0x2a0 */ 0xD5, 0x89, 0x7D, 0x3C, 0xC5, 0x8B, 0x4A, 0x7F, 
	/* 0x2a8 */ 0xE9, 0xBE, 0xDB, 0x2B, 0x17, 0xDF, 0xB0, 0x5F, 
	/* 0x2b0 */ 0x73, 0x77, 0x2A, 0x32, 0x13, 0x39, 0x81, 0x67, 
	/* 0x2b8 */ 0x42, 0x84, 0x23, 0xF2, 0x45, 0x67, 0x35, 0xEC, 
	/* 0x2c0 */ 0x88, 0xBF, 0xF8, 0x8F, 0xB0, 0x61, 0x0C, 0x34, 
	/* 0x2c8 */ 0xA4, 0xAE, 0x20, 0x4C, 0x84, 0xC6, 0xDB, 0xF8, 
	/* 0x2d0 */ 0x35, 0xE1, 0x76, 0xD9, 0xDF, 0xA6, 0x42, 0xBB, 
	/* 0x2d8 */ 0xC7, 0x44, 0x08, 0x86, 0x7F, 0x36, 0x74, 0x24, 
	/* 0x2e0 */ 0x5A, 0xDA, 0x6C, 0x0D, 0x14, 0x59, 0x35, 0xBD, 
	/* 0x2e8 */ 0xF2, 0x49, 0xDD, 0xB6, 0x1F, 0xC9, 0xB3, 0x0D, 
	/* 0x2f0 */ 0x47, 0x2A, 0x3D, 0x99, 0x2F, 0xBB, 0x5C, 0xBB, 
	/* 0x2f8 */ 0xB5, 0xD4, 0x20, 0xE1, 0x99, 0x5F, 0x53, 0x46, 
	/* 0x300 */ 0x15, 0xDB, 0x68, 0x9B, 0xF0, 0xF3, 0x30, 0xD5, 
	/* 0x308 */ 0x3E, 0x31, 0xE2, 0x8D, 0x84, 0x9E, 0xE3, 0x8A, 
	/* 0x310 */ 0xDA, 0xDA, 0x96, 0x3E, 0x35, 0x13, 0xA5, 0x5F, 
	/* 0x318 */ 0xF0, 0xF9, 0x70, 0x50, 0x70, 0x47, 0x41, 0x11, 
	/* 0x320 */ 0x57, 0x19, 0x4E, 0xC0, 0x8F, 0xAE, 0x06, 0xC4, 
	/* 0x328 */ 0x95, 0x13, 0x17, 0x2F, 0x1B, 0x25, 0x9F, 0x75, 
	/* 0x330 */ 0xF2, 0xB1, 0x8E, 0x99, 0xA1, 0x6F, 0x13, 0xB1, 
	/* 0x338 */ 0x41, 0x71, 0xFE, 0x88, 0x2A, 0xC8, 0x4F, 0x10, 
	/* 0x340 */ 0x20, 0x55, 0xD7, 0xF3, 0x14, 0x45, 0xE5, 0xE0, 
	/* 0x348 */ 0x44, 0xF4, 0xEA, 0x87, 0x95, 0x32, 0x93, 0x0E, 
	/* 0x350 */ 0xFE, 0x53, 0x46, 0xFA, 0x2C, 0x9D, 0xFF, 0x8B, 
	/* 0x358 */ 0x22, 0xB9, 0x4B, 0xD9, 0x09, 0x45, 0xA4, 0xDE, 
	/* 0x360 */ 0xA4, 0xB8, 0x9A, 0x58, 0xDD, 0x1B, 0x7D, 0x52, 
	/* 0x368 */ 0x9F, 0x8E, 0x59, 0x43, 0x88, 0x81, 0xA4, 0x9E, 
	/* 0x370 */ 0x26, 0xD5, 0x6F, 0xAD, 0xDD, 0x0D, 0xC6, 0x37, 
	/* 0x378 */ 0x7D, 0xED, 0x03, 0x92, 0x1B, 0xE5, 0x77, 0x5F, 
	/* 0x380 */ 0x76, 0xEE, 0x3C, 0x8D, 0xC4, 0x5D, 0x56, 0x5B, 
	/* 0x388 */ 0xA2, 0xD9, 0x66, 0x6E, 0xB3, 0x35, 0x37, 0xE5, 
	/* 0x390 */ 0x32, 0xB6, 
};
static const lws_ss_x509_t _ss_x509_digicert_global_root_g2 = {
	.vhost_name = "digicert_global_root_g2",
	.ca_der = _ss_der_digicert_global_root_g2,
	.ca_der_len = 914,
};
static const lws_ss_trust_store_t _ss_ts_api_amazon_com = {
	.name = "api_amazon_com",
	.ssx509 = {
		&_ss_x509_digicert_global_root_g2,
		&_ss_x509_digicert_global_ca_g2,
	}
};

static const lws_ss_policy_t _ssp_captive_portal_detect = {
	.streamtype = "captive_portal_detect",
	.endpoint = "connectivitycheck.android.com",
	.u = {
		.http = {
			.method = "GET",
			.url = "generate_204",
			.resp_expect = 204,
			.fail_redirect = 1,
		}
	},
	.flags = 0x1,
	.port = 80,
	.protocol = 0,
},
_ssp_mqtt_test1 = {
	.next = (void *)&_ssp_captive_portal_detect,
	.streamtype = "mqtt_test1",
	.endpoint = "a1ygonr3im5cv2-ats.iot.us-west-2.amazonaws.com",
	.u = {
		.mqtt = {
			.topic = "test/topic1",
			.subscribe = "test/topic1",
			.qos = 1,
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x10,
	.port = 443,
	.protocol = 3,
	.client_cert = 1,
	.trust = {.store = &_ss_ts_mqtt_amz_iot},
},
_ssp_mqtt_test = {
	.next = (void *)&_ssp_mqtt_test1,
	.streamtype = "mqtt_test",
	.endpoint = "a1ygonr3im5cv2-ats.iot.us-west-2.amazonaws.com",
	.u = {
		.mqtt = {
			.topic = "test/topic0",
			.subscribe = "test/topic0",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x10,
	.port = 443,
	.protocol = 3,
	.client_cert = 1,
	.trust = {.store = &_ss_ts_mqtt_amz_iot},
},
_ssp_minpost = {
	.next = (void *)&_ssp_mqtt_test,
	.streamtype = "minpost",
	.endpoint = "warmcat.com",
	.u = {
		.http = {
			.method = "POST",
			.url = "testserver/formtest",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x11,
	.port = 443,
	.protocol = 0,
	.trust = {.store = &_ss_ts_le_via_isrg},
},
_ssp_mintest_fail = {
	.next = (void *)&_ssp_minpost,
	.streamtype = "mintest-fail",
	.endpoint = "warmcat.com",
	.u = {
		.http = {
			.method = "GET",
			.url = "index.html",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x11,
	.port = 22,
	.protocol = 0,
	.trust = {.store = &_ss_ts_le_via_isrg},
},
_ssp_h2longpolltest = {
	.next = (void *)&_ssp_mintest_fail,
	.streamtype = "h2longpolltest",
	.endpoint = "warmcat.com",
	.u = {
		.http = {
			.method = "GET",
			.url = "index.html",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x32,
	.port = 443,
	.protocol = 1,
	.trust = {.store = &_ss_ts_le_via_isrg},
},
_ssp_mintest = {
	.next = (void *)&_ssp_h2longpolltest,
	.streamtype = "mintest",
	.endpoint = "warmcat.com",
	.metadata = (void *)&_md_mintest_uptag,
	.u = {
		.http = {
			.method = "GET",
			.url = "index.html?uptag=${uptag}",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x11,
	.port = 443,
	.metadata_count = 3,
	.protocol = 0,
	.trust = {.store = &_ss_ts_le_via_isrg},
},
_ssp_avs_audio = {
	.next = (void *)&_ssp_mintest,
	.streamtype = "avs_audio",
	.endpoint = "alexa.na.gateway.devices.a2z.com",
	.u = {
		.http = {
			.method = "POST",
			.url = "v20160207/events",
			.multipart_name = "audio",
			.multipart_content_type = "application/octet-stream",
			.auth_preamble = "Bearer ",
			.blob_header = {
				"authorization:",
			},
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0xa90,
	.port = 443,
	.protocol = 1,
	.trust = {.store = &_ss_ts_avs_via_starfield},
},
_ssp_avs_metadata = {
	.next = (void *)&_ssp_avs_audio,
	.streamtype = "avs_metadata",
	.endpoint = "alexa.na.gateway.devices.a2z.com",
	.rideshare_streamtype = "avs_audio",
	.u = {
		.http = {
			.method = "POST",
			.url = "v20160207/events",
			.multipart_name = "metadata",
			.multipart_content_type = "application/json; charset=UTF-8",
			.auth_preamble = "Bearer ",
			.blob_header = {
				"authorization:",
			},
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0xa91,
	.port = 443,
	.protocol = 1,
	.trust = {.store = &_ss_ts_avs_via_starfield},
},
_ssp_avs_event = {
	.next = (void *)&_ssp_avs_metadata,
	.streamtype = "avs_event",
	.endpoint = "alexa.na.gateway.devices.a2z.com",
	.u = {
		.http = {
			.method = "GET",
			.url = "v20160207/directives",
			.auth_preamble = "Bearer ",
			.blob_header = {
				"authorization:",
			},
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x2b2,
	.port = 443,
	.protocol = 1,
	.trust = {.store = &_ss_ts_avs_via_starfield},
},
_ssp_api_amazon_com_auth = {
	.next = (void *)&_ssp_avs_event,
	.streamtype = "api_amazon_com_auth",
	.endpoint = "api.amazon.com",
	.u = {
		.http = {
			.method = "POST",
			.url = "auth/o2/token",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x1291,
	.port = 443,
	.protocol = 0,
	.trust = {.store = &_ss_ts_api_amazon_com},
};
#define _ss_static_policy_entry _ssp_api_amazon_com_auth
/* estimated footprint 10720 (when sizeof void * = 8) */
