/**
 * linglong仓库
 * 玲珑仓库接口
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: wurongjie@deepin.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * Based on http://www.creativepulse.gr/en/blog/2014/restful-api-requests-using-qt-cpp-for-linux-mac-osx-ms-windows
 * By Alex Stylianos
 *
 **/

#ifndef _HTTPREQUESTWORKER_H
#define _HTTPREQUESTWORKER_H

#include <QMap>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QObject>
#include <QString>
#include <QTimer>
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    #include <QRandomGenerator>
#endif

#include "HttpFileElement.h"

namespace linglong {
namespace api {
namespace client {

enum HttpRequestVarLayout {
    NOT_SET,
    ADDRESS,
    URL_ENCODED,
    MULTIPART
};

class HttpRequestInput {

public:
    QString url_str;
    QString http_method;
    HttpRequestVarLayout var_layout;
    QMap<QString, QString> vars;
    QMap<QString, QString> headers;
    QList<HttpFileElement> files;
    QByteArray request_body;

    HttpRequestInput();
    HttpRequestInput(QString v_url_str, QString v_http_method);
    void initialize();
    void add_var(QString key, QString value);
    void add_file(QString variable_name, QString local_filename, QString request_filename, QString mime_type);
};

class HttpRequestWorker : public QObject {
    Q_OBJECT

public:
    explicit HttpRequestWorker(QObject *parent = nullptr, QNetworkAccessManager *manager = nullptr);
    virtual ~HttpRequestWorker();

    QByteArray response;
    QNetworkReply::NetworkError error_type;
    QString error_str;

    QMap<QString, QString> getResponseHeaders() const;
    QString http_attribute_encode(QString attribute_name, QString input);
    void execute(HttpRequestInput *input);
    static QSslConfiguration *sslDefaultConfiguration;
    void setTimeOut(int timeOutMs);
    void setWorkingDirectory(const QString &path);
    HttpFileElement getHttpFileElement(const QString &fieldname = QString());
    QByteArray *getMultiPartField(const QString &fieldname = QString());
    void setResponseCompressionEnabled(bool enable);
    void setRequestCompressionEnabled(bool enable);
    int  getHttpResponseCode() const;

Q_SIGNALS:
    void on_execution_finished(HttpRequestWorker *worker);

private:
    enum CompressionType{
        Zlib,
        Gzip
    };
    QNetworkAccessManager *manager;
    QMap<QString, QString> headers;
    QMap<QString, HttpFileElement> files;
    QMap<QString, QByteArray *> multiPartFields;
    QString workingDirectory;
    QTimer timeOutTimer;
    bool isResponseCompressionEnabled;
    bool isRequestCompressionEnabled;
    int  httpResponseCode;
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    QRandomGenerator randomGenerator;
#endif

    void on_reply_timeout(QNetworkReply *reply);
    void on_reply_finished(QNetworkReply *reply);
    void process_response(QNetworkReply *reply);
    QByteArray decompress(const QByteArray& data);
    QByteArray compress(const QByteArray& input, int level, CompressionType compressType);
};

} // namespace linglong
} // namespace api
} // namespace client

#endif // _HTTPREQUESTWORKER_H
