// Code generated by "./generator ./org.freedesktop.upower"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package upower

import "errors"
import "fmt"
import "github.com/godbus/dbus/v5"

import "github.com/linuxdeepin/go-lib/dbusutil"
import "github.com/linuxdeepin/go-lib/dbusutil/proxy"
import "unsafe"

type UPower interface {
	upower // interface org.freedesktop.UPower
	proxy.Object
}

type objectUPower struct {
	interfaceUpower // interface org.freedesktop.UPower
	proxy.ImplObject
}

func NewUPower(conn *dbus.Conn) UPower {
	obj := new(objectUPower)
	obj.ImplObject.Init_(conn, "org.freedesktop.UPower", "/org/freedesktop/UPower")
	return obj
}

type upower interface {
	GoEnumerateDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	EnumerateDevices(flags dbus.Flags) ([]dbus.ObjectPath, error)
	GoGetDisplayDevice(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetDisplayDevice(flags dbus.Flags) (dbus.ObjectPath, error)
	GoGetCriticalAction(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetCriticalAction(flags dbus.Flags) (string, error)
	ConnectDeviceAdded(cb func(device dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectDeviceRemoved(cb func(device dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	DaemonVersion() proxy.PropString
	OnBattery() proxy.PropBool
	LidIsClosed() proxy.PropBool
	LidIsPresent() proxy.PropBool
}

type interfaceUpower struct{}

func (v *interfaceUpower) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceUpower) GetInterfaceName_() string {
	return "org.freedesktop.UPower"
}

// method EnumerateDevices

func (v *interfaceUpower) GoEnumerateDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EnumerateDevices", flags, ch)
}

func (*interfaceUpower) StoreEnumerateDevices(call *dbus.Call) (devices []dbus.ObjectPath, err error) {
	err = call.Store(&devices)
	return
}

func (v *interfaceUpower) EnumerateDevices(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	return v.StoreEnumerateDevices(
		<-v.GoEnumerateDevices(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetDisplayDevice

func (v *interfaceUpower) GoGetDisplayDevice(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetDisplayDevice", flags, ch)
}

func (*interfaceUpower) StoreGetDisplayDevice(call *dbus.Call) (device dbus.ObjectPath, err error) {
	err = call.Store(&device)
	return
}

func (v *interfaceUpower) GetDisplayDevice(flags dbus.Flags) (dbus.ObjectPath, error) {
	return v.StoreGetDisplayDevice(
		<-v.GoGetDisplayDevice(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetCriticalAction

func (v *interfaceUpower) GoGetCriticalAction(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetCriticalAction", flags, ch)
}

func (*interfaceUpower) StoreGetCriticalAction(call *dbus.Call) (action string, err error) {
	err = call.Store(&action)
	return
}

func (v *interfaceUpower) GetCriticalAction(flags dbus.Flags) (string, error) {
	return v.StoreGetCriticalAction(
		<-v.GoGetCriticalAction(flags, make(chan *dbus.Call, 1)).Done)
}

// signal DeviceAdded

func (v *interfaceUpower) ConnectDeviceAdded(cb func(device dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var device dbus.ObjectPath
		err := dbus.Store(sig.Body, &device)
		if err == nil {
			cb(device)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DeviceRemoved

func (v *interfaceUpower) ConnectDeviceRemoved(cb func(device dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DeviceRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DeviceRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var device dbus.ObjectPath
		err := dbus.Store(sig.Body, &device)
		if err == nil {
			cb(device)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property DaemonVersion s

func (v *interfaceUpower) DaemonVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DaemonVersion",
	}
}

// property OnBattery b

func (v *interfaceUpower) OnBattery() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "OnBattery",
	}
}

// property LidIsClosed b

func (v *interfaceUpower) LidIsClosed() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "LidIsClosed",
	}
}

// property LidIsPresent b

func (v *interfaceUpower) LidIsPresent() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "LidIsPresent",
	}
}
